/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginecontextmenudata_wrapper.h"

// inner classes

// Extra includes
#include <QtWebEngineWidgets/qwebenginecontextmenudata.h>
#include <qobject.h>
#include <qpoint.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineContextMenuData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineContextMenuData >()))
        return -1;

    ::QWebEngineContextMenuData *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QWebEngineContextMenuData", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineContextMenuData::QWebEngineContextMenuData()
    // 1: QWebEngineContextMenuData::QWebEngineContextMenuData(QWebEngineContextMenuData)
    if (numArgs == 0) {
        overloadId = 0; // QWebEngineContextMenuData()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QWebEngineContextMenuData(QWebEngineContextMenuData)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineContextMenuData_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineContextMenuData()
        {

            if (!PyErr_Occurred()) {
                // QWebEngineContextMenuData()
                cptr = new ::QWebEngineContextMenuData();
            }
            break;
        }
        case 1: // QWebEngineContextMenuData(const QWebEngineContextMenuData & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineContextMenuData cppArg0_local;
            ::QWebEngineContextMenuData *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QWebEngineContextMenuData(QWebEngineContextMenuData)
                cptr = new ::QWebEngineContextMenuData(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineContextMenuData >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineContextMenuData_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebEngineContextMenuData_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_editFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.editFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // editFlags()const
            QFlags<QWebEngineContextMenuData::EditFlag> cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->editFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_isContentEditable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.isContentEditable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContentEditable()const
            bool cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->isContentEditable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_linkText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.linkText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linkText()const
            QString cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->linkText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_linkUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.linkUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linkUrl()const
            QUrl cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->linkUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_mediaFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaFlags()const
            QFlags<QWebEngineContextMenuData::MediaFlag> cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->mediaFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_mediaType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaType()const
            QWebEngineContextMenuData::MediaType cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->mediaType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_mediaUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaUrl()const
            QUrl cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->mediaUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_misspelledWord(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.misspelledWord";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // misspelledWord()const
            QString cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->misspelledWord();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QPoint cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_selectedText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.selectedText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedText()const
            QString cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->selectedText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuDataFunc_spellCheckerSuggestions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.spellCheckerSuggestions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spellCheckerSuggestions()const
            QStringList cppResult = const_cast<const ::QWebEngineContextMenuData *>(cppSelf)->spellCheckerSuggestions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineContextMenuData___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineContextMenuData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineContextMenuData_methods[] = {
    {"editFlags", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_editFlags), METH_NOARGS},
    {"isContentEditable", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_isContentEditable), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_isValid), METH_NOARGS},
    {"linkText", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_linkText), METH_NOARGS},
    {"linkUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_linkUrl), METH_NOARGS},
    {"mediaFlags", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_mediaFlags), METH_NOARGS},
    {"mediaType", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_mediaType), METH_NOARGS},
    {"mediaUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_mediaUrl), METH_NOARGS},
    {"misspelledWord", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_misspelledWord), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_position), METH_NOARGS},
    {"selectedText", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_selectedText), METH_NOARGS},
    {"spellCheckerSuggestions", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuDataFunc_spellCheckerSuggestions), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QWebEngineContextMenuData___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebEngineContextMenuData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineContextMenuData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineContextMenuData_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineContextMenuData_TypeF(void)
{
    return _Sbk_QWebEngineContextMenuData_Type;
}

static PyType_Slot Sbk_QWebEngineContextMenuData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineContextMenuData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineContextMenuData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineContextMenuData_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineContextMenuData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineContextMenuData_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineContextMenuData_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::MediaFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::MediaFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::MediaFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::MediaFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::MediaFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, self, &cppSelf);
    ::QWebEngineContextMenuData::MediaFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::EditFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::EditFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::EditFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEngineContextMenuData::EditFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QWebEngineContextMenuData::EditFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, self, &cppSelf);
    ::QWebEngineContextMenuData::EditFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineContextMenuData_MediaType_PythonToCpp_QWebEngineContextMenuData_MediaType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineContextMenuData::MediaType *>(cppOut) =
        static_cast<::QWebEngineContextMenuData::MediaType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineContextMenuData_MediaType_PythonToCpp_QWebEngineContextMenuData_MediaType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX]))
        return QWebEngineContextMenuData_MediaType_PythonToCpp_QWebEngineContextMenuData_MediaType;
    return {};
}
static PyObject *QWebEngineContextMenuData_MediaType_CppToPython_QWebEngineContextMenuData_MediaType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineContextMenuData::MediaType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX], castCppIn);

}

static void QWebEngineContextMenuData_MediaFlag_PythonToCpp_QWebEngineContextMenuData_MediaFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineContextMenuData::MediaFlag *>(cppOut) =
        static_cast<::QWebEngineContextMenuData::MediaFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineContextMenuData_MediaFlag_PythonToCpp_QWebEngineContextMenuData_MediaFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]))
        return QWebEngineContextMenuData_MediaFlag_PythonToCpp_QWebEngineContextMenuData_MediaFlag;
    return {};
}
static PyObject *QWebEngineContextMenuData_MediaFlag_CppToPython_QWebEngineContextMenuData_MediaFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineContextMenuData::MediaFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX], castCppIn);

}

static void QFlags_QWebEngineContextMenuData_MediaFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::MediaFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::MediaFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QWebEngineContextMenuData_MediaFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]))
        return QFlags_QWebEngineContextMenuData_MediaFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_;
    return {};
}
static PyObject *QFlags_QWebEngineContextMenuData_MediaFlag__CppToPython_QFlags_QWebEngineContextMenuData_MediaFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QWebEngineContextMenuData::MediaFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]));

}

static void QWebEngineContextMenuData_MediaFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::MediaFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::MediaFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QWebEngineContextMenuData_MediaFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]))
        return QWebEngineContextMenuData_MediaFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::MediaFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::MediaFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]))
        return number_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_;
    return {};
}
static void QWebEngineContextMenuData_EditFlag_PythonToCpp_QWebEngineContextMenuData_EditFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineContextMenuData::EditFlag *>(cppOut) =
        static_cast<::QWebEngineContextMenuData::EditFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineContextMenuData_EditFlag_PythonToCpp_QWebEngineContextMenuData_EditFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]))
        return QWebEngineContextMenuData_EditFlag_PythonToCpp_QWebEngineContextMenuData_EditFlag;
    return {};
}
static PyObject *QWebEngineContextMenuData_EditFlag_CppToPython_QWebEngineContextMenuData_EditFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineContextMenuData::EditFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX], castCppIn);

}

static void QFlags_QWebEngineContextMenuData_EditFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::EditFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::EditFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QWebEngineContextMenuData_EditFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]))
        return QFlags_QWebEngineContextMenuData_EditFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_;
    return {};
}
static PyObject *QFlags_QWebEngineContextMenuData_EditFlag__CppToPython_QFlags_QWebEngineContextMenuData_EditFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QWebEngineContextMenuData::EditFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]));

}

static void QWebEngineContextMenuData_EditFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::EditFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::EditFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QWebEngineContextMenuData_EditFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]))
        return QWebEngineContextMenuData_EditFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QWebEngineContextMenuData::EditFlag> *>(cppOut) =
        ::QFlags<QWebEngineContextMenuData::EditFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]))
        return number_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineContextMenuData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineContextMenuData_TypeF())))
        return QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineContextMenuData_PTR_CppToPython_QWebEngineContextMenuData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineContextMenuData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineContextMenuData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QWebEngineContextMenuData_COPY_CppToPython_QWebEngineContextMenuData(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QWebEngineContextMenuData_TypeF(), new ::QWebEngineContextMenuData(*reinterpret_cast<const ::QWebEngineContextMenuData *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineContextMenuData *>(cppOut) = *reinterpret_cast< ::QWebEngineContextMenuData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineContextMenuData_TypeF())))
        return QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineContextMenuData_SignatureStrings[] = {
    "1:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData(self)",
    "0:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData(self,other:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData)",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.editFlags(self)->PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.EditFlags",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.isContentEditable(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.isValid(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.linkText(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.linkUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaFlags(self)->PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.MediaFlags",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaType(self)->PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.MediaType",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.mediaUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.misspelledWord(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.position(self)->PySide2.QtCore.QPoint",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.selectedText(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.spellCheckerSuggestions(self)->QStringList",
    "PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.__copy__()",
    nullptr}; // Sentinel

void init_QWebEngineContextMenuData(PyObject *module)
{
    _Sbk_QWebEngineContextMenuData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineContextMenuData",
        "QWebEngineContextMenuData",
        &Sbk_QWebEngineContextMenuData_spec,
        &Shiboken::callCppDestructor< ::QWebEngineContextMenuData >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineContextMenuData_Type);
    InitSignatureStrings(pyType, QWebEngineContextMenuData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineContextMenuData_Type), Sbk_QWebEngineContextMenuData_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineContextMenuData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineContextMenuData_TypeF(),
        QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_PTR,
        is_QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_PTR_Convertible,
        QWebEngineContextMenuData_PTR_CppToPython_QWebEngineContextMenuData,
        QWebEngineContextMenuData_COPY_CppToPython_QWebEngineContextMenuData);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineContextMenuData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_COPY,
        is_QWebEngineContextMenuData_PythonToCpp_QWebEngineContextMenuData_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'MediaType'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineContextMenuData_TypeF(),
        "MediaType",
        "2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.MediaType",
        "QWebEngineContextMenuData::MediaType");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeNone", (long) QWebEngineContextMenuData::MediaType::MediaTypeNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeImage", (long) QWebEngineContextMenuData::MediaType::MediaTypeImage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeVideo", (long) QWebEngineContextMenuData::MediaType::MediaTypeVideo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeAudio", (long) QWebEngineContextMenuData::MediaType::MediaTypeAudio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeCanvas", (long) QWebEngineContextMenuData::MediaType::MediaTypeCanvas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypeFile", (long) QWebEngineContextMenuData::MediaType::MediaTypeFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaTypePlugin", (long) QWebEngineContextMenuData::MediaType::MediaTypePlugin))
        return;
    // Register converter for enum 'QWebEngineContextMenuData::MediaType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX],
            QWebEngineContextMenuData_MediaType_CppToPython_QWebEngineContextMenuData_MediaType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineContextMenuData_MediaType_PythonToCpp_QWebEngineContextMenuData_MediaType,
            is_QWebEngineContextMenuData_MediaType_PythonToCpp_QWebEngineContextMenuData_MediaType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIATYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData::MediaType");
        Shiboken::Conversions::registerConverterName(converter, "MediaType");
    }
    // End of 'MediaType' enum.

    // Initialization of enum 'MediaFlag'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.MediaFlags", SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_MediaFlag_number_slots);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineContextMenuData_TypeF(),
        "MediaFlag",
        "2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.MediaFlag",
        "QWebEngineContextMenuData::MediaFlag",
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX]);
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaInError", (long) QWebEngineContextMenuData::MediaFlag::MediaInError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaPaused", (long) QWebEngineContextMenuData::MediaFlag::MediaPaused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaMuted", (long) QWebEngineContextMenuData::MediaFlag::MediaMuted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaLoop", (long) QWebEngineContextMenuData::MediaFlag::MediaLoop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaCanSave", (long) QWebEngineContextMenuData::MediaFlag::MediaCanSave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaHasAudio", (long) QWebEngineContextMenuData::MediaFlag::MediaHasAudio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaCanToggleControls", (long) QWebEngineContextMenuData::MediaFlag::MediaCanToggleControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaControls", (long) QWebEngineContextMenuData::MediaFlag::MediaControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaCanPrint", (long) QWebEngineContextMenuData::MediaFlag::MediaCanPrint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "MediaCanRotate", (long) QWebEngineContextMenuData::MediaFlag::MediaCanRotate))
        return;
    // Register converter for enum 'QWebEngineContextMenuData::MediaFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
            QWebEngineContextMenuData_MediaFlag_CppToPython_QWebEngineContextMenuData_MediaFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineContextMenuData_MediaFlag_PythonToCpp_QWebEngineContextMenuData_MediaFlag,
            is_QWebEngineContextMenuData_MediaFlag_PythonToCpp_QWebEngineContextMenuData_MediaFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData::MediaFlag");
        Shiboken::Conversions::registerConverterName(converter, "MediaFlag");
    }
    // Register converter for flag 'QFlags<QWebEngineContextMenuData::MediaFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX],
            QFlags_QWebEngineContextMenuData_MediaFlag__CppToPython_QFlags_QWebEngineContextMenuData_MediaFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineContextMenuData_MediaFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_,
            is_QWebEngineContextMenuData_MediaFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QWebEngineContextMenuData_MediaFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_,
            is_QFlags_QWebEngineContextMenuData_MediaFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag_,
            is_number_PythonToCpp_QFlags_QWebEngineContextMenuData_MediaFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_MEDIAFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData::MediaFlags");
        Shiboken::Conversions::registerConverterName(converter, "MediaFlags");
    }
    // End of 'MediaFlag' enum/flags.

    // Initialization of enum 'EditFlag'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.EditFlags", SbkPySide2_QtWebEngineWidgets_QWebEngineContextMenuData_EditFlag_number_slots);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineContextMenuData_TypeF(),
        "EditFlag",
        "2:PySide2.QtWebEngineWidgets.QWebEngineContextMenuData.EditFlag",
        "QWebEngineContextMenuData::EditFlag",
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX]);
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanUndo", (long) QWebEngineContextMenuData::EditFlag::CanUndo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanRedo", (long) QWebEngineContextMenuData::EditFlag::CanRedo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanCut", (long) QWebEngineContextMenuData::EditFlag::CanCut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanCopy", (long) QWebEngineContextMenuData::EditFlag::CanCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanPaste", (long) QWebEngineContextMenuData::EditFlag::CanPaste))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanDelete", (long) QWebEngineContextMenuData::EditFlag::CanDelete))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanSelectAll", (long) QWebEngineContextMenuData::EditFlag::CanSelectAll))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanTranslate", (long) QWebEngineContextMenuData::EditFlag::CanTranslate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
        Sbk_QWebEngineContextMenuData_TypeF(), "CanEditRichly", (long) QWebEngineContextMenuData::EditFlag::CanEditRichly))
        return;
    // Register converter for enum 'QWebEngineContextMenuData::EditFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
            QWebEngineContextMenuData_EditFlag_CppToPython_QWebEngineContextMenuData_EditFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineContextMenuData_EditFlag_PythonToCpp_QWebEngineContextMenuData_EditFlag,
            is_QWebEngineContextMenuData_EditFlag_PythonToCpp_QWebEngineContextMenuData_EditFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData::EditFlag");
        Shiboken::Conversions::registerConverterName(converter, "EditFlag");
    }
    // Register converter for flag 'QFlags<QWebEngineContextMenuData::EditFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX],
            QFlags_QWebEngineContextMenuData_EditFlag__CppToPython_QFlags_QWebEngineContextMenuData_EditFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineContextMenuData_EditFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_,
            is_QWebEngineContextMenuData_EditFlag_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QWebEngineContextMenuData_EditFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_,
            is_QFlags_QWebEngineContextMenuData_EditFlag__PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag_,
            is_number_PythonToCpp_QFlags_QWebEngineContextMenuData_EditFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINECONTEXTMENUDATA_EDITFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineContextMenuData::EditFlags");
        Shiboken::Conversions::registerConverterName(converter, "EditFlags");
    }
    // End of 'EditFlag' enum/flags.

    qRegisterMetaType< ::QWebEngineContextMenuData >("QWebEngineContextMenuData");
    qRegisterMetaType< ::QWebEngineContextMenuData::MediaType >("QWebEngineContextMenuData::MediaType");
    qRegisterMetaType< ::QWebEngineContextMenuData::MediaFlag >("QWebEngineContextMenuData::MediaFlag");
    qRegisterMetaType< ::QWebEngineContextMenuData::MediaFlags >("QWebEngineContextMenuData::MediaFlags");
    qRegisterMetaType< ::QWebEngineContextMenuData::EditFlag >("QWebEngineContextMenuData::EditFlag");
    qRegisterMetaType< ::QWebEngineContextMenuData::EditFlags >("QWebEngineContextMenuData::EditFlags");
}
