/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qttest_python.h"

// main header
#include "qtest_wrapper.h"

// inner classes
#include "qtest_pysideqtoucheventsequence_wrapper.h"

// Extra includes
#include <QtGui/qkeysequence.h>
#include <QtGui/qtouchdevice.h>
#include <QtGui/qwindow.h>
#include <QtTest>
#include <QtWidgets/qwidget.h>
#include <pysideqtesttouch.h>
#include <qobject.h>
#include <qpoint.h>
#include <qregularexpression.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QTestFunc_addColumnInternal(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.addColumnInternal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addColumnInternal", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::addColumnInternal(int,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // addColumnInternal(int,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_addColumnInternal_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addColumnInternal(int,const char*)
            ::QTest::addColumnInternal(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_addColumnInternal_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_asciiToKey(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.asciiToKey";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTest::asciiToKey(char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArg)))) {
        overloadId = 0; // asciiToKey(char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_asciiToKey_TypeError;

    // Call function/method
    {
        char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // asciiToKey(char)
            Qt::Key cppResult = ::QTest::asciiToKey(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_asciiToKey_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_compare_ptr_helper(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.compare_ptr_helper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compare_ptr_helper", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::compare_ptr_helper(const volatile void*,const volatile void*,const char*,const char*,const char*,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))
        && Shiboken::String::check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // compare_ptr_helper(const volatile void*,const volatile void*,const char*,const char*,const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_compare_ptr_helper_TypeError;

    // Call function/method
    {
        void* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        const char* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // compare_ptr_helper(const volatile void*,const volatile void*,const char*,const char*,const char*,int)
            bool cppResult = ::QTest::compare_ptr_helper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_compare_ptr_helper_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_compare_string_helper(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.compare_string_helper";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "compare_string_helper", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::compare_string_helper(const char*,const char*,const char*,const char*,const char*,int)
    if (numArgs == 6
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))
        && Shiboken::String::check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // compare_string_helper(const char*,const char*,const char*,const char*,const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_compare_string_helper_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        const char* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // compare_string_helper(const char*,const char*,const char*,const char*,const char*,int)
            bool cppResult = ::QTest::compare_string_helper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_compare_string_helper_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_createTouchDevice(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.createTouchDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_createTouchDevice_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:createTouchDevice", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::createTouchDevice(QTouchDevice::DeviceType)
    if (numArgs == 0) {
        overloadId = 0; // createTouchDevice(QTouchDevice::DeviceType)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // createTouchDevice(QTouchDevice::DeviceType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_createTouchDevice_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_devType = Shiboken::String::createStaticString("devType");
            if (PyDict_Contains(kwds, key_devType)) {
                value = PyDict_GetItem(kwds, key_devType);
                if (value && pyArgs[0]) {
                    errInfo = key_devType;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_createTouchDevice_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTestFunc_createTouchDevice_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_devType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTestFunc_createTouchDevice_TypeError;
            }
        }
        ::QTouchDevice::DeviceType cppArg0 = QTouchDevice::TouchScreen;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // createTouchDevice(QTouchDevice::DeviceType)
            QTouchDevice * cppResult = ::QTest::createTouchDevice(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_createTouchDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_currentAppName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.currentAppName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentAppName()
            const char * cppResult = ::QTest::currentAppName();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_currentDataTag(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.currentDataTag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentDataTag()
            const char * cppResult = ::QTest::currentDataTag();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_currentTestFailed(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.currentTestFailed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTestFailed()
            bool cppResult = ::QTest::currentTestFailed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_currentTestFunction(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.currentTestFunction";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTestFunction()
            const char * cppResult = ::QTest::currentTestFunction();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_ignoreMessage(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.ignoreMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ignoreMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::ignoreMessage(QtMsgType,QRegularExpression)
    // 1: static QTest::ignoreMessage(QtMsgType,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QTMSGTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 1; // ignoreMessage(QtMsgType,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[1])))) {
            overloadId = 0; // ignoreMessage(QtMsgType,QRegularExpression)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_ignoreMessage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ignoreMessage(QtMsgType type, const QRegularExpression & messagePattern)
        {
            ::QtMsgType cppArg0{QtDebugMsg};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRegularExpression cppArg1_local;
            ::QRegularExpression *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // ignoreMessage(QtMsgType,QRegularExpression)
                ::QTest::ignoreMessage(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // ignoreMessage(QtMsgType type, const char * message)
        {
            ::QtMsgType cppArg0{QtDebugMsg};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // ignoreMessage(QtMsgType,const char*)
                ::QTest::ignoreMessage(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_ignoreMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyClick(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyClick";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyClick_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyClick_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:keyClick", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 1: static QTest::keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
    // 2: static QTest::keyClick(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 3: static QTest::keyClick(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // keyClick(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // keyClick(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 2; // keyClick(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // keyClick(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // keyClick(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 3; // keyClick(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 0; // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 1; // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyClick_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // keyClick(QWidget * widget, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyClick(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyClick(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // keyClick(QWidget * widget, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyClick(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyClick(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // keyClick(QWindow * window, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyClick(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyClick(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // keyClick(QWindow * window, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyClick(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyClick(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keyClick_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyClicks(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyClicks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyClicks_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyClicks_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:keyClicks", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyClicks_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
            if (PyDict_Contains(kwds, key_modifier)) {
                value = PyDict_GetItem(kwds, key_modifier);
                if (value && pyArgs[2]) {
                    errInfo = key_modifier;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_keyClicks_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QTestFunc_keyClicks_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_modifier);
            }
            static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
            if (PyDict_Contains(kwds, key_delay)) {
                value = PyDict_GetItem(kwds, key_delay);
                if (value && pyArgs[3]) {
                    errInfo = key_delay;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_keyClicks_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QTestFunc_keyClicks_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_delay);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTestFunc_keyClicks_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // keyClicks(QWidget*,QString,QFlags<Qt::KeyboardModifier>,int)
            ::QTest::keyClicks(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keyClicks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyEvent_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:keyEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 1: static QTest::keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
    // 2: static QTest::keyEvent(QTest::KeyAction,QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 3: static QTest::keyEvent(QTest::KeyAction,QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[1])))) {
            if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // keyEvent(QTest::KeyAction,QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // keyEvent(QTest::KeyAction,QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 2; // keyEvent(QTest::KeyAction,QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    }
                }
            } else if (numArgs >= 3
                && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // keyEvent(QTest::KeyAction,QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 3; // keyEvent(QTest::KeyAction,QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 3; // keyEvent(QTest::KeyAction,QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                    }
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 0; // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                    }
                }
            } else if (numArgs >= 3
                && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        overloadId = 1; // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyEvent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // keyEvent(QTest::KeyAction action, QWidget * widget, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[3]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = Qt::NoModifier;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // keyEvent(QTest::KeyAction,QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // keyEvent(QTest::KeyAction action, QWidget * widget, char ascii, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[3]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            char cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = Qt::NoModifier;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // keyEvent(QTest::KeyAction,QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 2: // keyEvent(QTest::KeyAction action, QWindow * window, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[3]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWindow *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = Qt::NoModifier;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // keyEvent(QTest::KeyAction,QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 3: // keyEvent(QTest::KeyAction action, QWindow * window, char ascii, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[3]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_keyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWindow *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            char cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = Qt::NoModifier;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // keyEvent(QTest::KeyAction,QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keyEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyPress(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyPress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyPress_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyPress_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:keyPress", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 1: static QTest::keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
    // 2: static QTest::keyPress(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 3: static QTest::keyPress(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // keyPress(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // keyPress(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 2; // keyPress(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // keyPress(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // keyPress(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 3; // keyPress(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 0; // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 1; // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyPress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // keyPress(QWidget * widget, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyPress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyPress(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyPress(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // keyPress(QWidget * widget, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyPress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyPress(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyPress(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // keyPress(QWindow * window, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyPress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyPress(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyPress(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // keyPress(QWindow * window, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyPress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyPress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyPress(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyPress(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keyPress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyRelease(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyRelease";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyRelease_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_keyRelease_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:keyRelease", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 1: static QTest::keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
    // 2: static QTest::keyRelease(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
    // 3: static QTest::keyRelease(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // keyRelease(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // keyRelease(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 2; // keyRelease(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // keyRelease(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // keyRelease(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 3; // keyRelease(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 0; // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 2
            && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    overloadId = 1; // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyRelease_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // keyRelease(QWidget * widget, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyRelease(QWidget*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyRelease(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 1: // keyRelease(QWidget * widget, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyRelease(QWidget*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyRelease(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // keyRelease(QWindow * window, Qt::Key key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::Key cppArg1 = static_cast< ::Qt::Key>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyRelease(QWindow*,Qt::Key,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyRelease(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // keyRelease(QWindow * window, char key, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_modifier = Shiboken::String::createStaticString("modifier");
                if (PyDict_Contains(kwds, key_modifier)) {
                    value = PyDict_GetItem(kwds, key_modifier);
                    if (value && pyArgs[2]) {
                        errInfo = key_modifier;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_modifier);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[3]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_keyRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_keyRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            char cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::NoModifier;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3 = -1;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // keyRelease(QWindow*,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::keyRelease(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keyRelease_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keySequence(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keySequence";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "keySequence", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::keySequence(QWidget*,QKeySequence)
    // 1: static QTest::keySequence(QWindow*,QKeySequence)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[1])))) {
        overloadId = 1; // keySequence(QWindow*,QKeySequence)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // keySequence(QWidget*,QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keySequence_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // keySequence(QWidget * widget, const QKeySequence & keySequence)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QKeySequence cppArg1_local;
            ::QKeySequence *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // keySequence(QWidget*,QKeySequence)
                ::QTest::keySequence(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // keySequence(QWindow * window, const QKeySequence & keySequence)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QKeySequence cppArg1_local;
            ::QKeySequence *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // keySequence(QWindow*,QKeySequence)
                ::QTest::keySequence(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_keySequence_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_keyToAscii(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.keyToAscii";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTest::keyToAscii(Qt::Key)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // keyToAscii(Qt::Key)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_keyToAscii_TypeError;

    // Call function/method
    {
        ::Qt::Key cppArg0 = static_cast< ::Qt::Key>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyToAscii(Qt::Key)
            char cppResult = ::QTest::keyToAscii(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_keyToAscii_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mouseClick(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mouseClick";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseClick_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseClick_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:mouseClick", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    // 1: static QTest::mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 1; // mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 0; // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mouseClick_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mouseClick(QWidget * widget, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseClick(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // mouseClick(QWindow * window, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseClick(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mouseClick_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mouseDClick(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mouseDClick";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseDClick_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseDClick_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:mouseDClick", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    // 1: static QTest::mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 1; // mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 0; // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mouseDClick_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mouseDClick(QWidget * widget, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseDClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseDClick(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseDClick(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // mouseDClick(QWindow * window, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseDClick_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseDClick_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseDClick(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseDClick(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mouseDClick_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mouseEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mouseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseEvent_TypeError;
    } else if (numArgs < 5) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:mouseEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    // 1: static QTest::mouseEvent(QTest::MouseAction,QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs >= 5
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 1; // mouseEvent(QTest::MouseAction,QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                overloadId = 1; // mouseEvent(QTest::MouseAction,QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            }
        } else if (numArgs >= 5
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[4])))) {
            if (numArgs == 5) {
                overloadId = 0; // mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 6
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                overloadId = 0; // mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mouseEvent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mouseEvent(QTest::MouseAction action, QWidget * widget, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_mouseEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseEvent_TypeError;
                }
            }
            ::QTest::MouseAction cppArg0{QTest::MousePress};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::MouseButton cppArg2{Qt::NoButton};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPoint cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // mouseEvent(QTest::MouseAction,QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 1: // mouseEvent(QTest::MouseAction action, QWindow * window, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_mouseEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseEvent_TypeError;
                }
            }
            ::QTest::MouseAction cppArg0{QTest::MousePress};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWindow *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::MouseButton cppArg2{Qt::NoButton};
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QPoint cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // mouseEvent(QTest::MouseAction,QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mouseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mouseMove(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mouseMove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseMove_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseMove_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:mouseMove", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mouseMove(QWidget*,QPoint,int)
    // 1: static QTest::mouseMove(QWindow*,QPoint,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // mouseMove(QWindow*,QPoint,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // mouseMove(QWindow*,QPoint,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 1; // mouseMove(QWindow*,QPoint,int)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // mouseMove(QWidget*,QPoint,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // mouseMove(QWidget*,QPoint,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // mouseMove(QWidget*,QPoint,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mouseMove_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mouseMove(QWidget * widget, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[1]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1]))))
                            goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[2]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseMove_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1 = QPoint();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // mouseMove(QWidget*,QPoint,int)
                ::QTest::mouseMove(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // mouseMove(QWindow * window, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[1]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1]))))
                            goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[2]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseMove_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseMove_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1 = QPoint();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // mouseMove(QWindow*,QPoint,int)
                ::QTest::mouseMove(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mouseMove_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mousePress(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mousePress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mousePress_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mousePress_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:mousePress", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    // 1: static QTest::mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 1; // mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 0; // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mousePress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mousePress(QWidget * widget, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mousePress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mousePress(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mousePress(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // mousePress(QWindow * window, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mousePress_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mousePress_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mousePress(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mousePress(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mousePress_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_mouseRelease(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.mouseRelease";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseRelease_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_mouseRelease_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:mouseRelease", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    // 1: static QTest::mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 1; // mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                    overloadId = 0; // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_mouseRelease_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // mouseRelease(QWidget * widget, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseRelease(QWidget*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseRelease(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // mouseRelease(QWindow * window, Qt::MouseButton button, QFlags<Qt::KeyboardModifier> stateKey, QPoint pos, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stateKey = Shiboken::String::createStaticString("stateKey");
                if (PyDict_Contains(kwds, key_stateKey)) {
                    value = PyDict_GetItem(kwds, key_stateKey);
                    if (value && pyArgs[2]) {
                        errInfo = key_stateKey;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stateKey);
                }
                static PyObject *const key_pos = Shiboken::String::createStaticString("pos");
                if (PyDict_Contains(kwds, key_pos)) {
                    value = PyDict_GetItem(kwds, key_pos);
                    if (value && pyArgs[3]) {
                        errInfo = key_pos;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[3]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_pos);
                }
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[4]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QTestFunc_mouseRelease_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_mouseRelease_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::MouseButton cppArg1{Qt::NoButton};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::KeyboardModifier> cppArg2 = Qt::KeyboardModifiers();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return {};
            ::QPoint cppArg3 = QPoint();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = -1;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // mouseRelease(QWindow*,Qt::MouseButton,QFlags<Qt::KeyboardModifier>,QPoint,int)
                ::QTest::mouseRelease(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_mouseRelease_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qCleanup(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qCleanup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qCleanup()
            ::QTest::qCleanup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTestFunc_qElementData(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qElementData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qElementData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qElementData(const char*,int)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // qElementData(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qElementData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qElementData(const char*,int)
            void * cppResult = ::QTest::qElementData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qElementData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qExpectFail(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qExpectFail";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qExpectFail", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qExpectFail(const char*,const char*,QTest::TestFailMode,const char*,int)
    if (numArgs == 5
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX])->converter, (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // qExpectFail(const char*,const char*,QTest::TestFailMode,const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qExpectFail_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QTest::TestFailMode cppArg2 = static_cast< ::QTest::TestFailMode>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // qExpectFail(const char*,const char*,QTest::TestFailMode,const char*,int)
            bool cppResult = ::QTest::qExpectFail(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qExpectFail_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qFindTestData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qFindTestData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qFindTestData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qFindTestData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:qFindTestData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qFindTestData(QString,const char*,int,const char*)
    // 1: static QTest::qFindTestData(const char*,const char*,int,const char*)
    if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // qFindTestData(const char*,const char*,int,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // qFindTestData(const char*,const char*,int,const char*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // qFindTestData(const char*,const char*,int,const char*)
                } else if (numArgs >= 4
                    && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
                    overloadId = 1; // qFindTestData(const char*,const char*,int,const char*)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qFindTestData(QString,const char*,int,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // qFindTestData(QString,const char*,int,const char*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // qFindTestData(QString,const char*,int,const char*)
                } else if (numArgs >= 4
                    && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
                    overloadId = 0; // qFindTestData(QString,const char*,int,const char*)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qFindTestData_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // qFindTestData(const QString & basepath, const char * file, int line, const char * builddir)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_file = Shiboken::String::createStaticString("file");
                if (PyDict_Contains(kwds, key_file)) {
                    value = PyDict_GetItem(kwds, key_file);
                    if (value && pyArgs[1]) {
                        errInfo = key_file;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_file);
                }
                static PyObject *const key_line = Shiboken::String::createStaticString("line");
                if (PyDict_Contains(kwds, key_line)) {
                    value = PyDict_GetItem(kwds, key_line);
                    if (value && pyArgs[2]) {
                        errInfo = key_line;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_line);
                }
                static PyObject *const key_builddir = Shiboken::String::createStaticString("builddir");
                if (PyDict_Contains(kwds, key_builddir)) {
                    value = PyDict_GetItem(kwds, key_builddir);
                    if (value && pyArgs[3]) {
                        errInfo = key_builddir;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_builddir);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_qFindTestData_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            const char* cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // qFindTestData(QString,const char*,int,const char*)
                QString cppResult = ::QTest::qFindTestData(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // qFindTestData(const char * basepath, const char * file, int line, const char * builddir)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_file = Shiboken::String::createStaticString("file");
                if (PyDict_Contains(kwds, key_file)) {
                    value = PyDict_GetItem(kwds, key_file);
                    if (value && pyArgs[1]) {
                        errInfo = key_file;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_file);
                }
                static PyObject *const key_line = Shiboken::String::createStaticString("line");
                if (PyDict_Contains(kwds, key_line)) {
                    value = PyDict_GetItem(kwds, key_line);
                    if (value && pyArgs[2]) {
                        errInfo = key_line;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_line);
                }
                static PyObject *const key_builddir = Shiboken::String::createStaticString("builddir");
                if (PyDict_Contains(kwds, key_builddir)) {
                    value = PyDict_GetItem(kwds, key_builddir);
                    if (value && pyArgs[3]) {
                        errInfo = key_builddir;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3]))))
                            goto Sbk_QTestFunc_qFindTestData_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_builddir);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_qFindTestData_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            const char* cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // qFindTestData(const char*,const char*,int,const char*)
                QString cppResult = ::QTest::qFindTestData(cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qFindTestData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qGlobalData(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qGlobalData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qGlobalData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qGlobalData(const char*,int)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // qGlobalData(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qGlobalData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qGlobalData(const char*,int)
            void * cppResult = ::QTest::qGlobalData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qGlobalData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qRun(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qRun";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // qRun()
            int cppResult = ::QTest::qRun();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_qSkip(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qSkip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qSkip", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qSkip(const char*,const char*,int)
    if (numArgs == 3
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // qSkip(const char*,const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qSkip_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // qSkip(const char*,const char*,int)
            ::QTest::qSkip(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_qSkip_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qWaitForWindowActive(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qWaitForWindowActive";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:qWaitForWindowActive", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qWaitForWindowActive(QWidget*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qWaitForWindowActive(QWidget*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // qWaitForWindowActive(QWidget*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[1]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTestFunc_qWaitForWindowActive_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 5000;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qWaitForWindowActive(QWidget*,int)
            bool cppResult = ::QTest::qWaitForWindowActive(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qWaitForWindowActive_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_qWaitForWindowExposed(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.qWaitForWindowExposed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:qWaitForWindowExposed", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::qWaitForWindowExposed(QWidget*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // qWaitForWindowExposed(QWidget*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // qWaitForWindowExposed(QWidget*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[1]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTestFunc_qWaitForWindowExposed_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 5000;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // qWaitForWindowExposed(QWidget*,int)
            bool cppResult = ::QTest::qWaitForWindowExposed(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_qWaitForWindowExposed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_sendKeyEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.sendKeyEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
    } else if (numArgs < 5) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:sendKeyEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
    // 1: static QTest::sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
    // 2: static QTest::sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
    // 3: static QTest::sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[2])))) {
            if (numArgs >= 5
                && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 3; // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    overloadId = 3; // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                }
            } else if (numArgs >= 5
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 2; // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    overloadId = 2; // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_KEY_IDX])->converter, (pyArgs[2])))) {
            if (numArgs >= 5
                && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    overloadId = 1; // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                }
            } else if (numArgs >= 5
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 0; // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
                    overloadId = 0; // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_sendKeyEvent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // sendKeyEvent(QTest::KeyAction action, QWidget * widget, Qt::Key code, QString text, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::KeyboardModifier> cppArg4 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::sendKeyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 1: // sendKeyEvent(QTest::KeyAction action, QWidget * widget, Qt::Key code, char ascii, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWidget *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            char cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::KeyboardModifier> cppArg4 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // sendKeyEvent(QTest::KeyAction,QWidget*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::sendKeyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 2: // sendKeyEvent(QTest::KeyAction action, QWindow * window, Qt::Key code, QString text, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWindow *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::KeyboardModifier> cppArg4 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,QString,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::sendKeyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
        case 3: // sendKeyEvent(QTest::KeyAction action, QWindow * window, Qt::Key code, char ascii, QFlags<Qt::KeyboardModifier> modifier, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[5]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[5] = value;
                        if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5]))))
                            goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_sendKeyEvent_TypeError;
                }
            }
            ::QTest::KeyAction cppArg0{QTest::Press};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QWindow *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::Key cppArg2 = static_cast< ::Qt::Key>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);
            char cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QFlags<Qt::KeyboardModifier> cppArg4 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[4](pyArgs[4], &cppArg4);
            int cppArg5 = -1;
            if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!PyErr_Occurred()) {
                // sendKeyEvent(QTest::KeyAction,QWindow*,Qt::Key,char,QFlags<Qt::KeyboardModifier>,int)
                ::QTest::sendKeyEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_sendKeyEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_setBenchmarkResult(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.setBenchmarkResult";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setBenchmarkResult", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::setBenchmarkResult(qreal,QTest::QBenchmarkMetric)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setBenchmarkResult(qreal,QTest::QBenchmarkMetric)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_setBenchmarkResult_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QTest::QBenchmarkMetric cppArg1{QTest::FramesPerSecond};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setBenchmarkResult(qreal,QTest::QBenchmarkMetric)
            ::QTest::setBenchmarkResult(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_setBenchmarkResult_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_setMainSourcePath(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.setMainSourcePath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_setMainSourcePath_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_setMainSourcePath_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setMainSourcePath", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::setMainSourcePath(const char*,const char*)
    if (numArgs >= 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMainSourcePath(const char*,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // setMainSourcePath(const char*,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_setMainSourcePath_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_builddir = Shiboken::String::createStaticString("builddir");
            if (PyDict_Contains(kwds, key_builddir)) {
                value = PyDict_GetItem(kwds, key_builddir);
                if (value && pyArgs[1]) {
                    errInfo = key_builddir;
                    Py_INCREF(errInfo);
                    goto Sbk_QTestFunc_setMainSourcePath_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                        goto Sbk_QTestFunc_setMainSourcePath_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_builddir);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTestFunc_setMainSourcePath_TypeError;
            }
        }
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMainSourcePath(const char*,const char*)
            ::QTest::setMainSourcePath(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_setMainSourcePath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_simulateEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.simulateEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_simulateEvent_TypeError;
    } else if (numArgs < 6) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_simulateEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:simulateEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
    // 1: static QTest::simulateEvent(QWindow*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 1; // simulateEvent(QWindow*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
            overloadId = 1; // simulateEvent(QWindow*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
        }
    } else if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
            overloadId = 0; // simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_simulateEvent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // simulateEvent(QWidget * widget, bool press, int code, QFlags<Qt::KeyboardModifier> modifier, QString text, bool repeat, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[6]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_simulateEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6]))))
                            goto Sbk_QTestFunc_simulateEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_simulateEvent_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            bool cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6 = -1;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // simulateEvent(QWidget*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
                ::QTest::simulateEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
        case 1: // simulateEvent(QWindow * window, bool press, int code, QFlags<Qt::KeyboardModifier> modifier, QString text, bool repeat, int delay)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delay = Shiboken::String::createStaticString("delay");
                if (PyDict_Contains(kwds, key_delay)) {
                    value = PyDict_GetItem(kwds, key_delay);
                    if (value && pyArgs[6]) {
                        errInfo = key_delay;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_simulateEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[6] = value;
                        if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6]))))
                            goto Sbk_QTestFunc_simulateEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delay);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_simulateEvent_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<Qt::KeyboardModifier> cppArg3 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            bool cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6 = -1;
            if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!PyErr_Occurred()) {
                // simulateEvent(QWindow*,bool,int,QFlags<Qt::KeyboardModifier>,QString,bool,int)
                ::QTest::simulateEvent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTestFunc_simulateEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_testObject(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.testObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // testObject()
            QObject * cppResult = ::QTest::testObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTestFunc_toPrettyCString(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.toPrettyCString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toPrettyCString", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::toPrettyCString(const char*,int)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // toPrettyCString(const char*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_toPrettyCString_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // toPrettyCString(const char*,int)
            char * cppResult = ::QTest::toPrettyCString(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_toPrettyCString_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTestFunc_touchEvent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QTest.touchEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_touchEvent_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTestFunc_touchEvent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:touchEvent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QTest::generateTouchEvent(QWidget*,QTouchDevice*,bool)
    // 1: static QTest::generateTouchEvent(QWindow*,QTouchDevice*,bool)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // generateTouchEvent(QWindow*,QTouchDevice*,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 1; // generateTouchEvent(QWindow*,QTouchDevice*,bool)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // generateTouchEvent(QWidget*,QTouchDevice*,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // generateTouchEvent(QWidget*,QTouchDevice*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTestFunc_touchEvent_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // generateTouchEvent(QWidget * widget, QTouchDevice * device, bool autoCommit)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_autoCommit = Shiboken::String::createStaticString("autoCommit");
                if (PyDict_Contains(kwds, key_autoCommit)) {
                    value = PyDict_GetItem(kwds, key_autoCommit);
                    if (value && pyArgs[2]) {
                        errInfo = key_autoCommit;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_touchEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_touchEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_autoCommit);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_touchEvent_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTouchDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            bool cppArg2 = true;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // generateTouchEvent(QWidget*,QTouchDevice*,bool)
                QTest::PySideQTouchEventSequence * cppResult = ::QTest::generateTouchEvent(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTestTypes[SBK_QTEST_PYSIDEQTOUCHEVENTSEQUENCE_IDX]), cppResult);

                // Ownership transferences.
                Shiboken::Object::getOwnership(pyResult);
            }
            break;
        }
        case 1: // generateTouchEvent(QWindow * window, QTouchDevice * device, bool autoCommit)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_autoCommit = Shiboken::String::createStaticString("autoCommit");
                if (PyDict_Contains(kwds, key_autoCommit)) {
                    value = PyDict_GetItem(kwds, key_autoCommit);
                    if (value && pyArgs[2]) {
                        errInfo = key_autoCommit;
                        Py_INCREF(errInfo);
                        goto Sbk_QTestFunc_touchEvent_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                            goto Sbk_QTestFunc_touchEvent_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_autoCommit);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTestFunc_touchEvent_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTouchDevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            bool cppArg2 = true;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // generateTouchEvent(QWindow*,QTouchDevice*,bool)
                QTest::PySideQTouchEventSequence * cppResult = ::QTest::generateTouchEvent(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTestTypes[SBK_QTEST_PYSIDEQTOUCHEVENTSEQUENCE_IDX]), cppResult);

                // Ownership transferences.
                Shiboken::Object::getOwnership(pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTestFunc_touchEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QTest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTest_methods[] = {
    {"addColumnInternal", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_addColumnInternal), METH_VARARGS|METH_STATIC},
    {"asciiToKey", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_asciiToKey), METH_O|METH_STATIC},
    {"compare_ptr_helper", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_compare_ptr_helper), METH_VARARGS|METH_STATIC},
    {"compare_string_helper", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_compare_string_helper), METH_VARARGS|METH_STATIC},
    {"createTouchDevice", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_createTouchDevice), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"currentAppName", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_currentAppName), METH_NOARGS|METH_STATIC},
    {"currentDataTag", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_currentDataTag), METH_NOARGS|METH_STATIC},
    {"currentTestFailed", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_currentTestFailed), METH_NOARGS|METH_STATIC},
    {"currentTestFunction", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_currentTestFunction), METH_NOARGS|METH_STATIC},
    {"ignoreMessage", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_ignoreMessage), METH_VARARGS|METH_STATIC},
    {"keyClick", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyClick), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"keyClicks", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyClicks), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"keyEvent", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"keyPress", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyPress), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"keyRelease", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyRelease), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"keySequence", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keySequence), METH_VARARGS|METH_STATIC},
    {"keyToAscii", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_keyToAscii), METH_O|METH_STATIC},
    {"mouseClick", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mouseClick), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mouseDClick", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mouseDClick), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mouseEvent", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mouseEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mouseMove", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mouseMove), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mousePress", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mousePress), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mouseRelease", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_mouseRelease), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"qCleanup", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qCleanup), METH_NOARGS|METH_STATIC},
    {"qElementData", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qElementData), METH_VARARGS|METH_STATIC},
    {"qExpectFail", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qExpectFail), METH_VARARGS|METH_STATIC},
    {"qFindTestData", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qFindTestData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"qGlobalData", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qGlobalData), METH_VARARGS|METH_STATIC},
    {"qRun", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qRun), METH_NOARGS|METH_STATIC},
    {"qSkip", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qSkip), METH_VARARGS|METH_STATIC},
    {"qWaitForWindowActive", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qWaitForWindowActive), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"qWaitForWindowExposed", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_qWaitForWindowExposed), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"sendKeyEvent", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_sendKeyEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setBenchmarkResult", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_setBenchmarkResult), METH_VARARGS|METH_STATIC},
    {"setMainSourcePath", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_setMainSourcePath), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"simulateEvent", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_simulateEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"testObject", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_testObject), METH_NOARGS|METH_STATIC},
    {"toPrettyCString", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_toPrettyCString), METH_VARARGS|METH_STATIC},
    {"touchEvent", reinterpret_cast<PyCFunction>(Sbk_QTestFunc_touchEvent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTest_Type = nullptr;
static SbkObjectType *Sbk_QTest_TypeF(void)
{
    return _Sbk_QTest_Type;
}

static PyType_Slot Sbk_QTest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTest_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTest_spec = {
    "2:PySide2.QtTest.QTest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTest_TestFailMode_PythonToCpp_QTest_TestFailMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTest::TestFailMode *>(cppOut) =
        static_cast<::QTest::TestFailMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTest_TestFailMode_PythonToCpp_QTest_TestFailMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX]))
        return QTest_TestFailMode_PythonToCpp_QTest_TestFailMode;
    return {};
}
static PyObject *QTest_TestFailMode_CppToPython_QTest_TestFailMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTest::TestFailMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX], castCppIn);

}

static void QTest_QBenchmarkMetric_PythonToCpp_QTest_QBenchmarkMetric(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTest::QBenchmarkMetric *>(cppOut) =
        static_cast<::QTest::QBenchmarkMetric>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTest_QBenchmarkMetric_PythonToCpp_QTest_QBenchmarkMetric_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX]))
        return QTest_QBenchmarkMetric_PythonToCpp_QTest_QBenchmarkMetric;
    return {};
}
static PyObject *QTest_QBenchmarkMetric_CppToPython_QTest_QBenchmarkMetric(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTest::QBenchmarkMetric *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX], castCppIn);

}

static void QTest_KeyAction_PythonToCpp_QTest_KeyAction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTest::KeyAction *>(cppOut) =
        static_cast<::QTest::KeyAction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTest_KeyAction_PythonToCpp_QTest_KeyAction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX]))
        return QTest_KeyAction_PythonToCpp_QTest_KeyAction;
    return {};
}
static PyObject *QTest_KeyAction_CppToPython_QTest_KeyAction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTest::KeyAction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX], castCppIn);

}

static void QTest_MouseAction_PythonToCpp_QTest_MouseAction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTest::MouseAction *>(cppOut) =
        static_cast<::QTest::MouseAction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTest_MouseAction_PythonToCpp_QTest_MouseAction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX]))
        return QTest_MouseAction_PythonToCpp_QTest_MouseAction;
    return {};
}
static PyObject *QTest_MouseAction_CppToPython_QTest_MouseAction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTest::MouseAction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtTestQTest_SignatureStrings[] = {
    "PySide2.QtTest.QTest.addColumnInternal(id:int,name:char*)",
    "PySide2.QtTest.QTest.asciiToKey(ascii:char)->PySide2.QtCore.Qt.Key",
    "PySide2.QtTest.QTest.compare_ptr_helper(t1:void,t2:void,actual:char*,expected:char*,file:char*,line:int)->bool",
    "PySide2.QtTest.QTest.compare_string_helper(t1:char*,t2:char*,actual:char*,expected:char*,file:char*,line:int)->bool",
    "PySide2.QtTest.QTest.createTouchDevice(devType:PySide2.QtGui.QTouchDevice.DeviceType=QTouchDevice.TouchScreen)->PySide2.QtGui.QTouchDevice",
    "PySide2.QtTest.QTest.currentAppName()->char*",
    "PySide2.QtTest.QTest.currentDataTag()->char*",
    "PySide2.QtTest.QTest.currentTestFailed()->bool",
    "PySide2.QtTest.QTest.currentTestFunction()->char*",
    "1:PySide2.QtTest.QTest.ignoreMessage(type:PySide2.QtCore.QtMsgType,messagePattern:PySide2.QtCore.QRegularExpression)",
    "0:PySide2.QtTest.QTest.ignoreMessage(type:PySide2.QtCore.QtMsgType,message:char*)",
    "3:PySide2.QtTest.QTest.keyClick(widget:PySide2.QtWidgets.QWidget,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "2:PySide2.QtTest.QTest.keyClick(widget:PySide2.QtWidgets.QWidget,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "1:PySide2.QtTest.QTest.keyClick(window:PySide2.QtGui.QWindow,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "0:PySide2.QtTest.QTest.keyClick(window:PySide2.QtGui.QWindow,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "PySide2.QtTest.QTest.keyClicks(widget:PySide2.QtWidgets.QWidget,sequence:QString,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "3:PySide2.QtTest.QTest.keyEvent(action:PySide2.QtTest.QTest.KeyAction,widget:PySide2.QtWidgets.QWidget,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "2:PySide2.QtTest.QTest.keyEvent(action:PySide2.QtTest.QTest.KeyAction,widget:PySide2.QtWidgets.QWidget,ascii:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "1:PySide2.QtTest.QTest.keyEvent(action:PySide2.QtTest.QTest.KeyAction,window:PySide2.QtGui.QWindow,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "0:PySide2.QtTest.QTest.keyEvent(action:PySide2.QtTest.QTest.KeyAction,window:PySide2.QtGui.QWindow,ascii:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "3:PySide2.QtTest.QTest.keyPress(widget:PySide2.QtWidgets.QWidget,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "2:PySide2.QtTest.QTest.keyPress(widget:PySide2.QtWidgets.QWidget,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "1:PySide2.QtTest.QTest.keyPress(window:PySide2.QtGui.QWindow,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "0:PySide2.QtTest.QTest.keyPress(window:PySide2.QtGui.QWindow,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "3:PySide2.QtTest.QTest.keyRelease(widget:PySide2.QtWidgets.QWidget,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "2:PySide2.QtTest.QTest.keyRelease(widget:PySide2.QtWidgets.QWidget,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "1:PySide2.QtTest.QTest.keyRelease(window:PySide2.QtGui.QWindow,key:PySide2.QtCore.Qt.Key,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "0:PySide2.QtTest.QTest.keyRelease(window:PySide2.QtGui.QWindow,key:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers=Qt.NoModifier,delay:int=-1)",
    "1:PySide2.QtTest.QTest.keySequence(widget:PySide2.QtWidgets.QWidget,keySequence:PySide2.QtGui.QKeySequence)",
    "0:PySide2.QtTest.QTest.keySequence(window:PySide2.QtGui.QWindow,keySequence:PySide2.QtGui.QKeySequence)",
    "PySide2.QtTest.QTest.keyToAscii(key:PySide2.QtCore.Qt.Key)->char",
    "1:PySide2.QtTest.QTest.mouseClick(widget:PySide2.QtWidgets.QWidget,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "0:PySide2.QtTest.QTest.mouseClick(window:PySide2.QtGui.QWindow,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "1:PySide2.QtTest.QTest.mouseDClick(widget:PySide2.QtWidgets.QWidget,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "0:PySide2.QtTest.QTest.mouseDClick(window:PySide2.QtGui.QWindow,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "1:PySide2.QtTest.QTest.mouseEvent(action:PySide2.QtTest.QTest.MouseAction,widget:PySide2.QtWidgets.QWidget,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers,pos:PySide2.QtCore.QPoint,delay:int=-1)",
    "0:PySide2.QtTest.QTest.mouseEvent(action:PySide2.QtTest.QTest.MouseAction,window:PySide2.QtGui.QWindow,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers,pos:PySide2.QtCore.QPoint,delay:int=-1)",
    "1:PySide2.QtTest.QTest.mouseMove(widget:PySide2.QtWidgets.QWidget,pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "0:PySide2.QtTest.QTest.mouseMove(window:PySide2.QtGui.QWindow,pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "1:PySide2.QtTest.QTest.mousePress(widget:PySide2.QtWidgets.QWidget,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "0:PySide2.QtTest.QTest.mousePress(window:PySide2.QtGui.QWindow,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "1:PySide2.QtTest.QTest.mouseRelease(widget:PySide2.QtWidgets.QWidget,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "0:PySide2.QtTest.QTest.mouseRelease(window:PySide2.QtGui.QWindow,button:PySide2.QtCore.Qt.MouseButton,stateKey:PySide2.QtCore.Qt.KeyboardModifiers=Qt.KeyboardModifiers(),pos:PySide2.QtCore.QPoint=QPoint(),delay:int=-1)",
    "PySide2.QtTest.QTest.qCleanup()",
    "PySide2.QtTest.QTest.qElementData(elementName:char*,metaTypeId:int)->void",
    "PySide2.QtTest.QTest.qExpectFail(dataIndex:char*,comment:char*,mode:PySide2.QtTest.QTest.TestFailMode,file:char*,line:int)->bool",
    "1:PySide2.QtTest.QTest.qFindTestData(basepath:QString,file:char*=nullptr,line:int=0,builddir:char*=nullptr)->QString",
    "0:PySide2.QtTest.QTest.qFindTestData(basepath:char*,file:char*=nullptr,line:int=0,builddir:char*=nullptr)->QString",
    "PySide2.QtTest.QTest.qGlobalData(tagName:char*,typeId:int)->void",
    "PySide2.QtTest.QTest.qRun()->int",
    "PySide2.QtTest.QTest.qSkip(message:char*,file:char*,line:int)",
    "PySide2.QtTest.QTest.qWaitForWindowActive(widget:PySide2.QtWidgets.QWidget,timeout:int=5000)->bool",
    "PySide2.QtTest.QTest.qWaitForWindowExposed(widget:PySide2.QtWidgets.QWidget,timeout:int=5000)->bool",
    "3:PySide2.QtTest.QTest.sendKeyEvent(action:PySide2.QtTest.QTest.KeyAction,widget:PySide2.QtWidgets.QWidget,code:PySide2.QtCore.Qt.Key,text:QString,modifier:PySide2.QtCore.Qt.KeyboardModifiers,delay:int=-1)",
    "2:PySide2.QtTest.QTest.sendKeyEvent(action:PySide2.QtTest.QTest.KeyAction,widget:PySide2.QtWidgets.QWidget,code:PySide2.QtCore.Qt.Key,ascii:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers,delay:int=-1)",
    "1:PySide2.QtTest.QTest.sendKeyEvent(action:PySide2.QtTest.QTest.KeyAction,window:PySide2.QtGui.QWindow,code:PySide2.QtCore.Qt.Key,text:QString,modifier:PySide2.QtCore.Qt.KeyboardModifiers,delay:int=-1)",
    "0:PySide2.QtTest.QTest.sendKeyEvent(action:PySide2.QtTest.QTest.KeyAction,window:PySide2.QtGui.QWindow,code:PySide2.QtCore.Qt.Key,ascii:char,modifier:PySide2.QtCore.Qt.KeyboardModifiers,delay:int=-1)",
    "PySide2.QtTest.QTest.setBenchmarkResult(result:qreal,metric:PySide2.QtTest.QTest.QBenchmarkMetric)",
    "PySide2.QtTest.QTest.setMainSourcePath(file:char*,builddir:char*=nullptr)",
    "1:PySide2.QtTest.QTest.simulateEvent(widget:PySide2.QtWidgets.QWidget,press:bool,code:int,modifier:PySide2.QtCore.Qt.KeyboardModifiers,text:QString,repeat:bool,delay:int=-1)",
    "0:PySide2.QtTest.QTest.simulateEvent(window:PySide2.QtGui.QWindow,press:bool,code:int,modifier:PySide2.QtCore.Qt.KeyboardModifiers,text:QString,repeat:bool,delay:int=-1)",
    "PySide2.QtTest.QTest.testObject()->PySide2.QtCore.QObject",
    "PySide2.QtTest.QTest.toPrettyCString(unicode:char*,length:int)->char*",
    "1:PySide2.QtTest.QTest.touchEvent(widget:PySide2.QtWidgets.QWidget,device:PySide2.QtGui.QTouchDevice,autoCommit:bool=true)->PySide2.QtTest.QTouchEventSequence",
    "0:PySide2.QtTest.QTest.touchEvent(window:PySide2.QtGui.QWindow,device:PySide2.QtGui.QTouchDevice,autoCommit:bool=true)->PySide2.QtTest.QTouchEventSequence",
    nullptr}; // Sentinel

void init_QtTestQTest(PyObject *module)
{
    _Sbk_QTest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTest",
        "QTest",
        &Sbk_QTest_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTest_Type);
    InitSignatureStrings(pyType, QtTestQTest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTest_Type), Sbk_QTest_PropertyStrings);
    SbkPySide2_QtTestTypes[SBK_QtTestQTEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTest_TypeF());


    // Initialization of enums.

    // Initialization of enum 'TestFailMode'.
    SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTest_TypeF(),
        "TestFailMode",
        "2:PySide2.QtTest.QTest.TestFailMode",
        "QTest::TestFailMode");
    if (!SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX],
        Sbk_QTest_TypeF(), "Abort", (long) QTest::TestFailMode::Abort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX],
        Sbk_QTest_TypeF(), "Continue", (long) QTest::TestFailMode::Continue))
        return;
    // Register converter for enum 'QTest::TestFailMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX],
            QTest_TestFailMode_CppToPython_QTest_TestFailMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTest_TestFailMode_PythonToCpp_QTest_TestFailMode,
            is_QTest_TestFailMode_PythonToCpp_QTest_TestFailMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTestTypes[SBK_QTEST_TESTFAILMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTest::TestFailMode");
        Shiboken::Conversions::registerConverterName(converter, "TestFailMode");
    }
    // End of 'TestFailMode' enum.

    // Initialization of enum 'QBenchmarkMetric'.
    SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTest_TypeF(),
        "QBenchmarkMetric",
        "2:PySide2.QtTest.QTest.QBenchmarkMetric",
        "QTest::QBenchmarkMetric");
    if (!SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "FramesPerSecond", (long) QTest::QBenchmarkMetric::FramesPerSecond))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BitsPerSecond", (long) QTest::QBenchmarkMetric::BitsPerSecond))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BytesPerSecond", (long) QTest::QBenchmarkMetric::BytesPerSecond))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "WalltimeMilliseconds", (long) QTest::QBenchmarkMetric::WalltimeMilliseconds))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CPUTicks", (long) QTest::QBenchmarkMetric::CPUTicks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "InstructionReads", (long) QTest::QBenchmarkMetric::InstructionReads))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "Events", (long) QTest::QBenchmarkMetric::Events))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "WalltimeNanoseconds", (long) QTest::QBenchmarkMetric::WalltimeNanoseconds))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BytesAllocated", (long) QTest::QBenchmarkMetric::BytesAllocated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CPUMigrations", (long) QTest::QBenchmarkMetric::CPUMigrations))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CPUCycles", (long) QTest::QBenchmarkMetric::CPUCycles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BusCycles", (long) QTest::QBenchmarkMetric::BusCycles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "StalledCycles", (long) QTest::QBenchmarkMetric::StalledCycles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "Instructions", (long) QTest::QBenchmarkMetric::Instructions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BranchInstructions", (long) QTest::QBenchmarkMetric::BranchInstructions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "BranchMisses", (long) QTest::QBenchmarkMetric::BranchMisses))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheReferences", (long) QTest::QBenchmarkMetric::CacheReferences))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheReads", (long) QTest::QBenchmarkMetric::CacheReads))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheWrites", (long) QTest::QBenchmarkMetric::CacheWrites))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CachePrefetches", (long) QTest::QBenchmarkMetric::CachePrefetches))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheMisses", (long) QTest::QBenchmarkMetric::CacheMisses))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheReadMisses", (long) QTest::QBenchmarkMetric::CacheReadMisses))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CacheWriteMisses", (long) QTest::QBenchmarkMetric::CacheWriteMisses))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "CachePrefetchMisses", (long) QTest::QBenchmarkMetric::CachePrefetchMisses))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "ContextSwitches", (long) QTest::QBenchmarkMetric::ContextSwitches))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "PageFaults", (long) QTest::QBenchmarkMetric::PageFaults))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "MinorPageFaults", (long) QTest::QBenchmarkMetric::MinorPageFaults))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "MajorPageFaults", (long) QTest::QBenchmarkMetric::MajorPageFaults))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "AlignmentFaults", (long) QTest::QBenchmarkMetric::AlignmentFaults))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "EmulationFaults", (long) QTest::QBenchmarkMetric::EmulationFaults))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
        Sbk_QTest_TypeF(), "RefCPUCycles", (long) QTest::QBenchmarkMetric::RefCPUCycles))
        return;
    // Register converter for enum 'QTest::QBenchmarkMetric'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX],
            QTest_QBenchmarkMetric_CppToPython_QTest_QBenchmarkMetric);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTest_QBenchmarkMetric_PythonToCpp_QTest_QBenchmarkMetric,
            is_QTest_QBenchmarkMetric_PythonToCpp_QTest_QBenchmarkMetric_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTestTypes[SBK_QTEST_QBENCHMARKMETRIC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTest::QBenchmarkMetric");
        Shiboken::Conversions::registerConverterName(converter, "QBenchmarkMetric");
    }
    // End of 'QBenchmarkMetric' enum.

    // Initialization of enum 'KeyAction'.
    SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTest_TypeF(),
        "KeyAction",
        "2:PySide2.QtTest.QTest.KeyAction",
        "QTest::KeyAction");
    if (!SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX],
        Sbk_QTest_TypeF(), "Press", (long) QTest::KeyAction::Press))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX],
        Sbk_QTest_TypeF(), "Release", (long) QTest::KeyAction::Release))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX],
        Sbk_QTest_TypeF(), "Click", (long) QTest::KeyAction::Click))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX],
        Sbk_QTest_TypeF(), "Shortcut", (long) QTest::KeyAction::Shortcut))
        return;
    // Register converter for enum 'QTest::KeyAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX],
            QTest_KeyAction_CppToPython_QTest_KeyAction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTest_KeyAction_PythonToCpp_QTest_KeyAction,
            is_QTest_KeyAction_PythonToCpp_QTest_KeyAction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTestTypes[SBK_QTEST_KEYACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTest::KeyAction");
        Shiboken::Conversions::registerConverterName(converter, "KeyAction");
    }
    // End of 'KeyAction' enum.

    // Initialization of enum 'MouseAction'.
    SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTest_TypeF(),
        "MouseAction",
        "2:PySide2.QtTest.QTest.MouseAction",
        "QTest::MouseAction");
    if (!SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
        Sbk_QTest_TypeF(), "MousePress", (long) QTest::MouseAction::MousePress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
        Sbk_QTest_TypeF(), "MouseRelease", (long) QTest::MouseAction::MouseRelease))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
        Sbk_QTest_TypeF(), "MouseClick", (long) QTest::MouseAction::MouseClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
        Sbk_QTest_TypeF(), "MouseDClick", (long) QTest::MouseAction::MouseDClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
        Sbk_QTest_TypeF(), "MouseMove", (long) QTest::MouseAction::MouseMove))
        return;
    // Register converter for enum 'QTest::MouseAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX],
            QTest_MouseAction_CppToPython_QTest_MouseAction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTest_MouseAction_PythonToCpp_QTest_MouseAction,
            is_QTest_MouseAction_PythonToCpp_QTest_MouseAction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTestTypes[SBK_QTEST_MOUSEACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTest::MouseAction");
        Shiboken::Conversions::registerConverterName(converter, "MouseAction");
    }
    // End of 'MouseAction' enum.

    qRegisterMetaType< ::QTest::TestFailMode >("QTest::TestFailMode");
    qRegisterMetaType< ::QTest::QBenchmarkMetric >("QTest::QBenchmarkMetric");
    qRegisterMetaType< ::QTest::KeyAction >("QTest::KeyAction");
    qRegisterMetaType< ::QTest::MouseAction >("QTest::MouseAction");
}

void init_QtTestQTestStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QTest_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "mouseDoubleClickInterval",
                         Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &QTest::mouseDoubleClickInterval));

}
