/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qttest_python.h"

// main header
#include "qabstractitemmodeltester_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractItemModelTesterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractItemModelTesterWrapper::QAbstractItemModelTesterWrapper(::QAbstractItemModel * model, ::QAbstractItemModelTester::FailureReportingMode mode, ::QObject * parent) : QAbstractItemModelTester(model, mode, parent)
{
    resetPyMethodCache();
    // ... middle
}

QAbstractItemModelTesterWrapper::QAbstractItemModelTesterWrapper(::QAbstractItemModel * model, ::QObject * parent) : QAbstractItemModelTester(model, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractItemModelTesterWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemModelTesterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractItemModelTesterWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractItemModelTesterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAbstractItemModelTesterWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModelTester.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractItemModelTesterWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractItemModelTester.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractItemModelTesterWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractItemModelTesterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractItemModelTester::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractItemModelTesterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractItemModelTester::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractItemModelTesterWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractItemModelTesterWrapper *>(this));
        return QAbstractItemModelTester::qt_metacast(_clname);
}

QAbstractItemModelTesterWrapper::~QAbstractItemModelTesterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractItemModelTester_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractItemModelTester >()))
        return -1;

    ::QAbstractItemModelTesterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QAbstractItemModelTester.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractItemModelTester_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QAbstractItemModelTester", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractItemModelTester::QAbstractItemModelTester(QAbstractItemModel*,QAbstractItemModelTester::FailureReportingMode,QObject*)
    // 1: QAbstractItemModelTester::QAbstractItemModelTester(QAbstractItemModel*,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QAbstractItemModelTester(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QAbstractItemModelTester(QAbstractItemModel*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QAbstractItemModelTester(QAbstractItemModel*,QAbstractItemModelTester::FailureReportingMode,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 0; // QAbstractItemModelTester(QAbstractItemModel*,QAbstractItemModelTester::FailureReportingMode,QObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractItemModelTester_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAbstractItemModelTester(QAbstractItemModel * model, QAbstractItemModelTester::FailureReportingMode mode, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractItemModelTester_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QAbstractItemModelTester_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QAbstractItemModelTester::FailureReportingMode cppArg1{QAbstractItemModelTester::FailureReportingMode::QtTest};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAbstractItemModelTester(QAbstractItemModel*,QAbstractItemModelTester::FailureReportingMode,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAbstractItemModelTesterWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAbstractItemModelTesterWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 1: // QAbstractItemModelTester(QAbstractItemModel * model, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QAbstractItemModelTester_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QAbstractItemModelTester_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractItemModel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAbstractItemModelTester(QAbstractItemModel*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QAbstractItemModelTesterWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QAbstractItemModelTesterWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractItemModelTester >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractItemModelTester_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractItemModelTester_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractItemModelTester_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractItemModelTesterFunc_failureReportingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemModelTester *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QAbstractItemModelTester.failureReportingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // failureReportingMode()const
            QAbstractItemModelTester::FailureReportingMode cppResult = const_cast<const ::QAbstractItemModelTester *>(cppSelf)->failureReportingMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractItemModelTesterFunc_model(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractItemModelTester *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTest.QAbstractItemModelTester.model";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // model()const
            QAbstractItemModel * cppResult = const_cast<const ::QAbstractItemModelTester *>(cppSelf)->model();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractItemModelTester_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractItemModelTester_methods[] = {
    {"failureReportingMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemModelTesterFunc_failureReportingMode), METH_NOARGS},
    {"model", reinterpret_cast<PyCFunction>(Sbk_QAbstractItemModelTesterFunc_model), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractItemModelTester_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractItemModelTester *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractItemModelTesterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractItemModelTester_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractItemModelTester_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractItemModelTester_Type = nullptr;
static SbkObjectType *Sbk_QAbstractItemModelTester_TypeF(void)
{
    return _Sbk_QAbstractItemModelTester_Type;
}

static PyType_Slot Sbk_QAbstractItemModelTester_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractItemModelTester_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractItemModelTester_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractItemModelTester_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractItemModelTester_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractItemModelTester_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractItemModelTester_spec = {
    "2:PySide2.QtTest.QAbstractItemModelTester",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractItemModelTester_slots
};

} //extern "C"

static void *Sbk_QAbstractItemModelTester_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractItemModelTester *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractItemModelTester_FailureReportingMode_PythonToCpp_QAbstractItemModelTester_FailureReportingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractItemModelTester::FailureReportingMode *>(cppOut) =
        static_cast<::QAbstractItemModelTester::FailureReportingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractItemModelTester_FailureReportingMode_PythonToCpp_QAbstractItemModelTester_FailureReportingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX]))
        return QAbstractItemModelTester_FailureReportingMode_PythonToCpp_QAbstractItemModelTester_FailureReportingMode;
    return {};
}
static PyObject *QAbstractItemModelTester_FailureReportingMode_CppToPython_QAbstractItemModelTester_FailureReportingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractItemModelTester::FailureReportingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractItemModelTester_PythonToCpp_QAbstractItemModelTester_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractItemModelTester_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractItemModelTester_PythonToCpp_QAbstractItemModelTester_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractItemModelTester_TypeF())))
        return QAbstractItemModelTester_PythonToCpp_QAbstractItemModelTester_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractItemModelTester_PTR_CppToPython_QAbstractItemModelTester(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractItemModelTester *>(const_cast<void *>(cppIn)), Sbk_QAbstractItemModelTester_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractItemModelTester_SignatureStrings[] = {
    "1:PySide2.QtTest.QAbstractItemModelTester(self,model:PySide2.QtCore.QAbstractItemModel,mode:PySide2.QtTest.QAbstractItemModelTester.FailureReportingMode,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtTest.QAbstractItemModelTester(self,model:PySide2.QtCore.QAbstractItemModel,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtTest.QAbstractItemModelTester.failureReportingMode(self)->PySide2.QtTest.QAbstractItemModelTester.FailureReportingMode",
    "PySide2.QtTest.QAbstractItemModelTester.model(self)->PySide2.QtCore.QAbstractItemModel",
    nullptr}; // Sentinel

void init_QAbstractItemModelTester(PyObject *module)
{
    _Sbk_QAbstractItemModelTester_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractItemModelTester",
        "QAbstractItemModelTester*",
        &Sbk_QAbstractItemModelTester_spec,
        &Shiboken::callCppDestructor< ::QAbstractItemModelTester >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractItemModelTester_Type);
    InitSignatureStrings(pyType, QAbstractItemModelTester_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractItemModelTester_Type), Sbk_QAbstractItemModelTester_PropertyStrings);
    SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractItemModelTester_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractItemModelTester_TypeF(),
        QAbstractItemModelTester_PythonToCpp_QAbstractItemModelTester_PTR,
        is_QAbstractItemModelTester_PythonToCpp_QAbstractItemModelTester_PTR_Convertible,
        QAbstractItemModelTester_PTR_CppToPython_QAbstractItemModelTester);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemModelTester");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemModelTester*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractItemModelTester&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractItemModelTester).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractItemModelTesterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractItemModelTester_TypeF(), &Sbk_QAbstractItemModelTester_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'FailureReportingMode'.
    SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractItemModelTester_TypeF(),
        "FailureReportingMode",
        "2:PySide2.QtTest.QAbstractItemModelTester.FailureReportingMode",
        "QAbstractItemModelTester::FailureReportingMode");
    if (!SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX],
        SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX], "QtTest", (long) QAbstractItemModelTester::FailureReportingMode::QtTest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX],
        SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX], "Warning", (long) QAbstractItemModelTester::FailureReportingMode::Warning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX],
        SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX], "Fatal", (long) QAbstractItemModelTester::FailureReportingMode::Fatal))
        return;
    // Register converter for enum 'QAbstractItemModelTester::FailureReportingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX],
            QAbstractItemModelTester_FailureReportingMode_CppToPython_QAbstractItemModelTester_FailureReportingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractItemModelTester_FailureReportingMode_PythonToCpp_QAbstractItemModelTester_FailureReportingMode,
            is_QAbstractItemModelTester_FailureReportingMode_PythonToCpp_QAbstractItemModelTester_FailureReportingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTestTypes[SBK_QABSTRACTITEMMODELTESTER_FAILUREREPORTINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractItemModelTester::FailureReportingMode");
        Shiboken::Conversions::registerConverterName(converter, "FailureReportingMode");
    }
    // End of 'FailureReportingMode' enum.

    PySide::Signal::registerSignals(Sbk_QAbstractItemModelTester_TypeF(), &::QAbstractItemModelTester::staticMetaObject);
    qRegisterMetaType< ::QAbstractItemModelTester::FailureReportingMode >("QAbstractItemModelTester::FailureReportingMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractItemModelTester_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractItemModelTester_TypeF(), &::QAbstractItemModelTester::staticMetaObject, sizeof(QAbstractItemModelTesterWrapper));
}
