/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSQLRESULTWRAPPER_H
#define SBK_QSQLRESULTWRAPPER_H

#define protected public

#include <QtSql/qsqlresult.h>


// Extra includes
#include <QSqlError>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QStringList>
#include <QSize>
#include <QtSql/qsqldriver.h>
#include <QtSql/qsqlerror.h>
#include <QVector>
#include <QtSql/qsqlrecord.h>
class QSqlResultWrapper : public QSqlResult
{
public:
    QSqlResultWrapper(const ::QSqlDriver * db);
    void bindValue(const ::QString & placeholder, const ::QVariant & val, ::QFlags<QSql::ParamTypeFlag> type) override;
    void bindValue(int pos, const ::QVariant & val, ::QFlags<QSql::ParamTypeFlag> type) override;
    ::QVariant data(int i) override;
    void detachFromResultSet() override;
    bool exec() override;
    bool execBatch(bool arrayBind = false) override;
    bool fetch(int i) override;
    bool fetchFirst() override;
    bool fetchLast() override;
    bool fetchNext() override;
    bool fetchPrevious() override;
    ::QVariant handle() const override;
    bool isNull(int i) override;
    ::QVariant lastInsertId() const override;
    bool nextResult() override;
    int numRowsAffected() override;
    bool prepare(const ::QString & query) override;
    ::QSqlRecord record() const override;
    bool reset(const ::QString & sqlquery) override;
    bool savePrepare(const ::QString & sqlquery) override;
    void setActive(bool a) override;
    void setAt(int at) override;
    void setForwardOnly(bool forward) override;
    void setLastError(const ::QSqlError & e) override;
    void setNumericalPrecisionPolicy(::QSql::NumericalPrecisionPolicy policy) override;
    void setQuery(const ::QString & query) override;
    void setSelect(bool s) override;
    int size() override;
    ~QSqlResultWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[28];
};

#endif // SBK_QSQLRESULTWRAPPER_H

