/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSQLDRIVERWRAPPER_H
#define SBK_QSQLDRIVERWRAPPER_H

#define protected public

#include <QtSql/qsqldriver.h>


// Extra includes
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlRecord>
#include <QStringList>
#include <QSize>
#include <qobject.h>
#include <QtSql/qsqlindex.h>
#include <QtSql/qsqlrecord.h>
#include <QtSql/qsqlfield.h>
#include <QtSql/qsqlerror.h>
#include <QtSql/qsqlresult.h>
#include <qmetaobject.h>
#include <qcoreevent.h>
#include <qobjectdefs.h>
#include <QList>
#include <qbytearray.h>
#include <qthread.h>
namespace PySide { class DynamicQMetaObject; }

class QSqlDriverWrapper : public QSqlDriver
{
public:
    QSqlDriverWrapper(::QObject * parent = nullptr);
    bool beginTransaction() override;
    bool cancelQuery() override;
    void childEvent(::QChildEvent * event) override;
    void close() override;
    bool commitTransaction() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QSqlResult * createResult() const override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    ::QString escapeIdentifier(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QString formatValue(const ::QSqlField & field, bool trimStrings = false) const override;
    bool hasFeature(::QSqlDriver::DriverFeature f) const override;
    bool isIdentifierEscaped(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const override;
    bool isOpen() const override;
    const ::QMetaObject * metaObject() const override;
    bool open(const ::QString & db, const ::QString & user = QString(), const ::QString & password = QString(), const ::QString & host = QString(), int port = -1, const ::QString & connOpts = QString()) override;
    ::QSqlIndex primaryIndex(const ::QString & tableName) const override;
    ::QSqlRecord record(const ::QString & tableName) const override;
    bool rollbackTransaction() override;
    void setLastError(const ::QSqlError & e) override;
    void setOpen(bool o) override;
    void setOpenError(bool e) override;
    ::QString sqlStatement(::QSqlDriver::StatementType type, const ::QString & tableName, const ::QSqlRecord & rec, bool preparedStatement) const override;
    ::QString stripDelimiters(const ::QString & identifier, ::QSqlDriver::IdentifierType type) const override;
    bool subscribeToNotification(const ::QString & name) override;
    ::QStringList subscribedToNotifications() const override;
    ::QStringList tables(::QSql::TableType tableType) const override;
    void timerEvent(::QTimerEvent * event) override;
    bool unsubscribeFromNotification(const ::QString & name) override;
    ~QSqlDriverWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[31];
};

#endif // SBK_QSQLDRIVERWRAPPER_H

