/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtserialport_python.h"

// main header
#include "qserialportinfo_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtSerialPort/qserialport.h>
#include <QtSerialPort/qserialportinfo.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSerialPortInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSerialPortInfo >()))
        return -1;

    ::QSerialPortInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSerialPortInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSerialPortInfo::QSerialPortInfo()
    // 1: QSerialPortInfo::QSerialPortInfo(QSerialPort)
    // 2: QSerialPortInfo::QSerialPortInfo(QSerialPortInfo)
    // 3: QSerialPortInfo::QSerialPortInfo(QString)
    if (numArgs == 0) {
        overloadId = 0; // QSerialPortInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QSerialPortInfo(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QSerialPortInfo(QSerialPortInfo)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSerialPortInfo(QSerialPort)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSerialPortInfo()
        {

            if (!PyErr_Occurred()) {
                // QSerialPortInfo()
                cptr = new ::QSerialPortInfo();
            }
            break;
        }
        case 1: // QSerialPortInfo(const QSerialPort & port)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSerialPort *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSerialPortInfo(QSerialPort)
                cptr = new ::QSerialPortInfo(*cppArg0);
            }
            break;
        }
        case 2: // QSerialPortInfo(const QSerialPortInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSerialPortInfo cppArg0_local;
            ::QSerialPortInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSerialPortInfo(QSerialPortInfo)
                cptr = new ::QSerialPortInfo(*cppArg0);
            }
            break;
        }
        case 3: // QSerialPortInfo(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSerialPortInfo(QString)
                cptr = new ::QSerialPortInfo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSerialPortInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSerialPortInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSerialPortInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSerialPortInfoFunc_availablePorts(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.availablePorts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availablePorts()
            QList<QSerialPortInfo > cppResult = ::QSerialPortInfo::availablePorts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSerialPortTypeConverters[SBK_QTSERIALPORT_QLIST_QSERIALPORTINFO_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_hasProductIdentifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.hasProductIdentifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasProductIdentifier()const
            bool cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->hasProductIdentifier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_hasVendorIdentifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.hasVendorIdentifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasVendorIdentifier()const
            bool cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->hasVendorIdentifier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_isBusy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.isBusy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBusy()const
            bool cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->isBusy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_manufacturer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.manufacturer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // manufacturer()const
            QString cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->manufacturer();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_portName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.portName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // portName()const
            QString cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->portName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_productIdentifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.productIdentifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // productIdentifier()const
            quint16 cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->productIdentifier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_serialNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.serialNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serialNumber()const
            QString cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->serialNumber();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_standardBaudRates(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.standardBaudRates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // standardBaudRates()
            QList<qint32 > cppResult = ::QSerialPortInfo::standardBaudRates();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSerialPortTypeConverters[SBK_QTSERIALPORT_QLIST_QINT32_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPortInfo::swap(QSerialPortInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSerialPortInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSerialPortInfo cppArg0_local;
        ::QSerialPortInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSerialPortInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSerialPortInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortInfoFunc_systemLocation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.systemLocation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemLocation()const
            QString cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->systemLocation();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfoFunc_vendorIdentifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPortInfo.vendorIdentifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vendorIdentifier()const
            quint16 cppResult = const_cast<const ::QSerialPortInfo *>(cppSelf)->vendorIdentifier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSerialPortInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSerialPortInfo_methods[] = {
    {"availablePorts", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_availablePorts), METH_NOARGS|METH_STATIC},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_description), METH_NOARGS},
    {"hasProductIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_hasProductIdentifier), METH_NOARGS},
    {"hasVendorIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_hasVendorIdentifier), METH_NOARGS},
    {"isBusy", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_isBusy), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_isNull), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_isValid), METH_NOARGS},
    {"manufacturer", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_manufacturer), METH_NOARGS},
    {"portName", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_portName), METH_NOARGS},
    {"productIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_productIdentifier), METH_NOARGS},
    {"serialNumber", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_serialNumber), METH_NOARGS},
    {"standardBaudRates", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_standardBaudRates), METH_NOARGS|METH_STATIC},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_swap), METH_O},
    {"systemLocation", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_systemLocation), METH_NOARGS},
    {"vendorIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfoFunc_vendorIdentifier), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSerialPortInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSerialPortInfo___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QSerialPortInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSerialPortInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSerialPortInfo_Type = nullptr;
static SbkObjectType *Sbk_QSerialPortInfo_TypeF(void)
{
    return _Sbk_QSerialPortInfo_Type;
}

static PyType_Slot Sbk_QSerialPortInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSerialPortInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSerialPortInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSerialPortInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSerialPortInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QSerialPortInfo___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QSerialPortInfo___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QSerialPortInfo_spec = {
    "2:PySide2.QtSerialPort.QSerialPortInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSerialPortInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSerialPortInfo_PythonToCpp_QSerialPortInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSerialPortInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSerialPortInfo_PythonToCpp_QSerialPortInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSerialPortInfo_TypeF())))
        return QSerialPortInfo_PythonToCpp_QSerialPortInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSerialPortInfo_PTR_CppToPython_QSerialPortInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSerialPortInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSerialPortInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSerialPortInfo_COPY_CppToPython_QSerialPortInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSerialPortInfo_TypeF(), new ::QSerialPortInfo(*reinterpret_cast<const ::QSerialPortInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSerialPortInfo_PythonToCpp_QSerialPortInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPortInfo *>(cppOut) = *reinterpret_cast< ::QSerialPortInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSerialPortInfo_PythonToCpp_QSerialPortInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSerialPortInfo_TypeF())))
        return QSerialPortInfo_PythonToCpp_QSerialPortInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSerialPortInfo_SignatureStrings[] = {
    "3:PySide2.QtSerialPort.QSerialPortInfo(self)",
    "2:PySide2.QtSerialPort.QSerialPortInfo(self,port:PySide2.QtSerialPort.QSerialPort)",
    "1:PySide2.QtSerialPort.QSerialPortInfo(self,other:PySide2.QtSerialPort.QSerialPortInfo)",
    "0:PySide2.QtSerialPort.QSerialPortInfo(self,name:QString)",
    "PySide2.QtSerialPort.QSerialPortInfo.availablePorts()->QList[PySide2.QtSerialPort.QSerialPortInfo]",
    "PySide2.QtSerialPort.QSerialPortInfo.description(self)->QString",
    "PySide2.QtSerialPort.QSerialPortInfo.hasProductIdentifier(self)->bool",
    "PySide2.QtSerialPort.QSerialPortInfo.hasVendorIdentifier(self)->bool",
    "PySide2.QtSerialPort.QSerialPortInfo.isBusy(self)->bool",
    "PySide2.QtSerialPort.QSerialPortInfo.isNull(self)->bool",
    "PySide2.QtSerialPort.QSerialPortInfo.isValid(self)->bool",
    "PySide2.QtSerialPort.QSerialPortInfo.manufacturer(self)->QString",
    "PySide2.QtSerialPort.QSerialPortInfo.portName(self)->QString",
    "PySide2.QtSerialPort.QSerialPortInfo.productIdentifier(self)->quint16",
    "PySide2.QtSerialPort.QSerialPortInfo.serialNumber(self)->QString",
    "PySide2.QtSerialPort.QSerialPortInfo.standardBaudRates()->QList[qint32]",
    "PySide2.QtSerialPort.QSerialPortInfo.swap(self,other:PySide2.QtSerialPort.QSerialPortInfo)",
    "PySide2.QtSerialPort.QSerialPortInfo.systemLocation(self)->QString",
    "PySide2.QtSerialPort.QSerialPortInfo.vendorIdentifier(self)->quint16",
    "PySide2.QtSerialPort.QSerialPortInfo.__copy__()",
    nullptr}; // Sentinel

void init_QSerialPortInfo(PyObject *module)
{
    _Sbk_QSerialPortInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSerialPortInfo",
        "QSerialPortInfo",
        &Sbk_QSerialPortInfo_spec,
        &Shiboken::callCppDestructor< ::QSerialPortInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSerialPortInfo_Type);
    InitSignatureStrings(pyType, QSerialPortInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSerialPortInfo_Type), Sbk_QSerialPortInfo_PropertyStrings);
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSerialPortInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSerialPortInfo_TypeF(),
        QSerialPortInfo_PythonToCpp_QSerialPortInfo_PTR,
        is_QSerialPortInfo_PythonToCpp_QSerialPortInfo_PTR_Convertible,
        QSerialPortInfo_PTR_CppToPython_QSerialPortInfo,
        QSerialPortInfo_COPY_CppToPython_QSerialPortInfo);

    Shiboken::Conversions::registerConverterName(converter, "QSerialPortInfo");
    Shiboken::Conversions::registerConverterName(converter, "QSerialPortInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QSerialPortInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSerialPortInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSerialPortInfo_PythonToCpp_QSerialPortInfo_COPY,
        is_QSerialPortInfo_PythonToCpp_QSerialPortInfo_COPY_Convertible);

    qRegisterMetaType< ::QSerialPortInfo >("QSerialPortInfo");
}
