/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtsensors_python.h"

// main header
#include "qsensor_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSensorWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSensorWrapper::QSensorWrapper(const ::QByteArray & type, ::QObject * parent) : QSensor(type, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSensorWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSensorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSensorWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSensorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSensorWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSensor.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSensorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSensor.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSensorWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSensorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSensor::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSensorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSensor::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSensorWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSensorWrapper *>(this));
        return QSensor::qt_metacast(_clname);
}

QSensorWrapper::~QSensorWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSensor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSensor >()))
        return -1;

    ::QSensorWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSensor_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QSensor", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSensor::QSensor(QByteArray,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QSensor(QByteArray,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QSensor(QByteArray,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensor_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QSensor_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QSensor_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = Q_NULLPTR;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QSensor(QByteArray,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QSensorWrapper(*cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QSensorWrapper(*cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSensor >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSensor_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSensor_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSensor_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSensorFunc_addFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.addFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::addFilter(QSensorFilter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]), (pyArg)))) {
        overloadId = 0; // addFilter(QSensorFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_addFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSensorFilter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addFilter(QSensorFilter*)
            cppSelf->addFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_addFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_availableDataRates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.availableDataRates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableDataRates()const
            QList<QPair< int,int > > cppResult = const_cast<const ::QSensor *>(cppSelf)->availableDataRates();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_axesOrientationMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.axesOrientationMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // axesOrientationMode()const
            QSensor::AxesOrientationMode cppResult = const_cast<const ::QSensor *>(cppSelf)->axesOrientationMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_backend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.backend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backend()const
            QSensorBackend * cppResult = const_cast<const ::QSensor *>(cppSelf)->backend();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORBACKEND_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_bufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.bufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferSize()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->bufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_connectToBackend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.connectToBackend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // connectToBackend()
            bool cppResult = cppSelf->connectToBackend();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_currentOrientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.currentOrientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentOrientation()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->currentOrientation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_dataRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.dataRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dataRate()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->dataRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_defaultSensorForType(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.defaultSensorForType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSensor::defaultSensorForType(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // defaultSensorForType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_defaultSensorForType_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // defaultSensorForType(QByteArray)
            QByteArray cppResult = ::QSensor::defaultSensorForType(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSensorFunc_defaultSensorForType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.description";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // description()const
            QString cppResult = const_cast<const ::QSensor *>(cppSelf)->description();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_efficientBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.efficientBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // efficientBufferSize()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->efficientBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_filters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.filters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filters()const
            QList<QSensorFilter* > cppResult = const_cast<const ::QSensor *>(cppSelf)->filters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORFILTERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_identifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.identifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // identifier()const
            QByteArray cppResult = const_cast<const ::QSensor *>(cppSelf)->identifier();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.isActive";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isActive()const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->isActive();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_isAlwaysOn(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.isAlwaysOn";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAlwaysOn()const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->isAlwaysOn();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_isBusy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.isBusy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBusy()const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->isBusy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_isConnectedToBackend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.isConnectedToBackend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isConnectedToBackend()const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->isConnectedToBackend();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_isFeatureSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.isFeatureSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::isFeatureSupported(QSensor::Feature)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isFeatureSupported(QSensor::Feature)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_isFeatureSupported_TypeError;

    // Call function/method
    {
        ::QSensor::Feature cppArg0{QSensor::Buffering};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isFeatureSupported(QSensor::Feature)const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->isFeatureSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSensorFunc_isFeatureSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_maxBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.maxBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxBufferSize()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->maxBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_outputRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.outputRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outputRange()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->outputRange();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_outputRanges(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.outputRanges";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outputRanges()const
            QList<qoutputrange > cppResult = const_cast<const ::QSensor *>(cppSelf)->outputRanges();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOUTPUTRANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_reading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.reading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reading()const
            QSensorReading * cppResult = const_cast<const ::QSensor *>(cppSelf)->reading();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_removeFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.removeFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::removeFilter(QSensorFilter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]), (pyArg)))) {
        overloadId = 0; // removeFilter(QSensorFilter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_removeFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSensorFilter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeFilter(QSensorFilter*)
            cppSelf->removeFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_removeFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_sensorTypes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.sensorTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sensorTypes()
            QList<QByteArray > cppResult = ::QSensor::sensorTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_sensorsForType(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.sensorsForType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSensor::sensorsForType(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // sensorsForType(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_sensorsForType_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // sensorsForType(QByteArray)
            QList<QByteArray > cppResult = ::QSensor::sensorsForType(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSensorFunc_sensorsForType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setActive";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setActive_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActive(bool)
            cppSelf->setActive(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setActive_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setAlwaysOn(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setAlwaysOn";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setAlwaysOn(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAlwaysOn(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setAlwaysOn_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlwaysOn(bool)
            cppSelf->setAlwaysOn(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setAlwaysOn_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setAxesOrientationMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setAxesOrientationMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setAxesOrientationMode(QSensor::AxesOrientationMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAxesOrientationMode(QSensor::AxesOrientationMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setAxesOrientationMode_TypeError;

    // Call function/method
    {
        ::QSensor::AxesOrientationMode cppArg0{QSensor::FixedOrientation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAxesOrientationMode(QSensor::AxesOrientationMode)
            cppSelf->setAxesOrientationMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setAxesOrientationMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBufferSize(int)
            cppSelf->setBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setCurrentOrientation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setCurrentOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setCurrentOrientation(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentOrientation(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setCurrentOrientation_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentOrientation(int)
            cppSelf->setCurrentOrientation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setCurrentOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setDataRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setDataRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setDataRate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDataRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setDataRate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataRate(int)
            cppSelf->setDataRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setDataRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setEfficientBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setEfficientBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setEfficientBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setEfficientBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setEfficientBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEfficientBufferSize(int)
            cppSelf->setEfficientBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setEfficientBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setIdentifier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setIdentifier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setIdentifier(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setIdentifier(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setIdentifier_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIdentifier(QByteArray)
            cppSelf->setIdentifier(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setIdentifier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setMaxBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setMaxBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setMaxBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setMaxBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxBufferSize(int)
            cppSelf->setMaxBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setMaxBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setOutputRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setOutputRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setOutputRange(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setOutputRange(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setOutputRange_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOutputRange(int)
            cppSelf->setOutputRange(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setOutputRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setSkipDuplicates(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setSkipDuplicates";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setSkipDuplicates(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSkipDuplicates(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setSkipDuplicates_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSkipDuplicates(bool)
            cppSelf->setSkipDuplicates(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setSkipDuplicates_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_setUserOrientation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.setUserOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensor::setUserOrientation(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUserOrientation(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSensorFunc_setUserOrientation_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserOrientation(int)
            cppSelf->setUserOrientation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSensorFunc_setUserOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSensorFunc_skipDuplicates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.skipDuplicates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // skipDuplicates()const
            bool cppResult = const_cast<const ::QSensor *>(cppSelf)->skipDuplicates();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            bool cppResult = cppSelf->start();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSensorFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QByteArray cppResult = const_cast<const ::QSensor *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSensorFunc_userOrientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QSensor.userOrientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userOrientation()const
            int cppResult = const_cast<const ::QSensor *>(cppSelf)->userOrientation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSensor_PropertyStrings[] = {
    "active:isActive:",
    "alwaysOn:isAlwaysOn:",
    "availableDataRates:",
    "axesOrientationMode::",
    "bufferSize::",
    "busy:isBusy",
    "connectedToBackend:isConnectedToBackend",
    "currentOrientation:",
    "dataRate::",
    "description:",
    "efficientBufferSize:",
    "error:",
    "identifier::",
    "maxBufferSize:",
    "outputRange::",
    "outputRanges:",
    "reading:",
    "skipDuplicates::",
    "type:",
    "userOrientation::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSensor_methods[] = {
    {"addFilter", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_addFilter), METH_O},
    {"availableDataRates", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_availableDataRates), METH_NOARGS},
    {"axesOrientationMode", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_axesOrientationMode), METH_NOARGS},
    {"backend", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_backend), METH_NOARGS},
    {"bufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_bufferSize), METH_NOARGS},
    {"connectToBackend", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_connectToBackend), METH_NOARGS},
    {"currentOrientation", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_currentOrientation), METH_NOARGS},
    {"dataRate", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_dataRate), METH_NOARGS},
    {"defaultSensorForType", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_defaultSensorForType), METH_O|METH_STATIC},
    {"description", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_description), METH_NOARGS},
    {"efficientBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_efficientBufferSize), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_error), METH_NOARGS},
    {"filters", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_filters), METH_NOARGS},
    {"identifier", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_identifier), METH_NOARGS},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_isActive), METH_NOARGS},
    {"isAlwaysOn", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_isAlwaysOn), METH_NOARGS},
    {"isBusy", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_isBusy), METH_NOARGS},
    {"isConnectedToBackend", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_isConnectedToBackend), METH_NOARGS},
    {"isFeatureSupported", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_isFeatureSupported), METH_O},
    {"maxBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_maxBufferSize), METH_NOARGS},
    {"outputRange", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_outputRange), METH_NOARGS},
    {"outputRanges", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_outputRanges), METH_NOARGS},
    {"reading", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_reading), METH_NOARGS},
    {"removeFilter", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_removeFilter), METH_O},
    {"sensorTypes", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_sensorTypes), METH_NOARGS|METH_STATIC},
    {"sensorsForType", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_sensorsForType), METH_O|METH_STATIC},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setActive), METH_O},
    {"setAlwaysOn", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setAlwaysOn), METH_O},
    {"setAxesOrientationMode", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setAxesOrientationMode), METH_O},
    {"setBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setBufferSize), METH_O},
    {"setCurrentOrientation", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setCurrentOrientation), METH_O},
    {"setDataRate", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setDataRate), METH_O},
    {"setEfficientBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setEfficientBufferSize), METH_O},
    {"setIdentifier", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setIdentifier), METH_O},
    {"setMaxBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setMaxBufferSize), METH_O},
    {"setOutputRange", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setOutputRange), METH_O},
    {"setSkipDuplicates", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setSkipDuplicates), METH_O},
    {"setUserOrientation", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_setUserOrientation), METH_O},
    {"skipDuplicates", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_skipDuplicates), METH_NOARGS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_start), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_stop), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_type), METH_NOARGS},
    {"userOrientation", reinterpret_cast<PyCFunction>(Sbk_QSensorFunc_userOrientation), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSensor_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSensor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSensorWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSensor_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSensor_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSensor_Type = nullptr;
static SbkObjectType *Sbk_QSensor_TypeF(void)
{
    return _Sbk_QSensor_Type;
}

static PyType_Slot Sbk_QSensor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSensor_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSensor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSensor_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSensor_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSensor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSensor_spec = {
    "2:PySide2.QtSensors.QSensor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSensor_slots
};

} //extern "C"

static void *Sbk_QSensor_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSensor *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSensor_Feature_PythonToCpp_QSensor_Feature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSensor::Feature *>(cppOut) =
        static_cast<::QSensor::Feature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSensor_Feature_PythonToCpp_QSensor_Feature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX]))
        return QSensor_Feature_PythonToCpp_QSensor_Feature;
    return {};
}
static PyObject *QSensor_Feature_CppToPython_QSensor_Feature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSensor::Feature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX], castCppIn);

}

static void QSensor_AxesOrientationMode_PythonToCpp_QSensor_AxesOrientationMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSensor::AxesOrientationMode *>(cppOut) =
        static_cast<::QSensor::AxesOrientationMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSensor_AxesOrientationMode_PythonToCpp_QSensor_AxesOrientationMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX]))
        return QSensor_AxesOrientationMode_PythonToCpp_QSensor_AxesOrientationMode;
    return {};
}
static PyObject *QSensor_AxesOrientationMode_CppToPython_QSensor_AxesOrientationMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSensor::AxesOrientationMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSensor_PythonToCpp_QSensor_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSensor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSensor_PythonToCpp_QSensor_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSensor_TypeF())))
        return QSensor_PythonToCpp_QSensor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSensor_PTR_CppToPython_QSensor(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSensor *>(const_cast<void *>(cppIn)), Sbk_QSensor_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSensor_SignatureStrings[] = {
    "PySide2.QtSensors.QSensor(self,type:PySide2.QtCore.QByteArray,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "PySide2.QtSensors.QSensor.addFilter(self,filter:PySide2.QtSensors.QSensorFilter)",
    "PySide2.QtSensors.QSensor.availableDataRates(self)->QList[QPair[int, int]]",
    "PySide2.QtSensors.QSensor.axesOrientationMode(self)->PySide2.QtSensors.QSensor.AxesOrientationMode",
    "PySide2.QtSensors.QSensor.backend(self)->PySide2.QtSensors.QSensorBackend",
    "PySide2.QtSensors.QSensor.bufferSize(self)->int",
    "PySide2.QtSensors.QSensor.connectToBackend(self)->bool",
    "PySide2.QtSensors.QSensor.currentOrientation(self)->int",
    "PySide2.QtSensors.QSensor.dataRate(self)->int",
    "PySide2.QtSensors.QSensor.defaultSensorForType(type:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtSensors.QSensor.description(self)->QString",
    "PySide2.QtSensors.QSensor.efficientBufferSize(self)->int",
    "PySide2.QtSensors.QSensor.error(self)->int",
    "PySide2.QtSensors.QSensor.filters(self)->QList[PySide2.QtSensors.QSensorFilter]",
    "PySide2.QtSensors.QSensor.identifier(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtSensors.QSensor.isActive(self)->bool",
    "PySide2.QtSensors.QSensor.isAlwaysOn(self)->bool",
    "PySide2.QtSensors.QSensor.isBusy(self)->bool",
    "PySide2.QtSensors.QSensor.isConnectedToBackend(self)->bool",
    "PySide2.QtSensors.QSensor.isFeatureSupported(self,feature:PySide2.QtSensors.QSensor.Feature)->bool",
    "PySide2.QtSensors.QSensor.maxBufferSize(self)->int",
    "PySide2.QtSensors.QSensor.outputRange(self)->int",
    "PySide2.QtSensors.QSensor.outputRanges(self)->QList[PySide2.QtSensors.qoutputrange]",
    "PySide2.QtSensors.QSensor.reading(self)->PySide2.QtSensors.QSensorReading",
    "PySide2.QtSensors.QSensor.removeFilter(self,filter:PySide2.QtSensors.QSensorFilter)",
    "PySide2.QtSensors.QSensor.sensorTypes()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtSensors.QSensor.sensorsForType(type:PySide2.QtCore.QByteArray)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtSensors.QSensor.setActive(self,active:bool)",
    "PySide2.QtSensors.QSensor.setAlwaysOn(self,alwaysOn:bool)",
    "PySide2.QtSensors.QSensor.setAxesOrientationMode(self,axesOrientationMode:PySide2.QtSensors.QSensor.AxesOrientationMode)",
    "PySide2.QtSensors.QSensor.setBufferSize(self,bufferSize:int)",
    "PySide2.QtSensors.QSensor.setCurrentOrientation(self,currentOrientation:int)",
    "PySide2.QtSensors.QSensor.setDataRate(self,rate:int)",
    "PySide2.QtSensors.QSensor.setEfficientBufferSize(self,efficientBufferSize:int)",
    "PySide2.QtSensors.QSensor.setIdentifier(self,identifier:PySide2.QtCore.QByteArray)",
    "PySide2.QtSensors.QSensor.setMaxBufferSize(self,maxBufferSize:int)",
    "PySide2.QtSensors.QSensor.setOutputRange(self,index:int)",
    "PySide2.QtSensors.QSensor.setSkipDuplicates(self,skipDuplicates:bool)",
    "PySide2.QtSensors.QSensor.setUserOrientation(self,userOrientation:int)",
    "PySide2.QtSensors.QSensor.skipDuplicates(self)->bool",
    "PySide2.QtSensors.QSensor.start(self)->bool",
    "PySide2.QtSensors.QSensor.stop(self)",
    "PySide2.QtSensors.QSensor.type(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtSensors.QSensor.userOrientation(self)->int",
    nullptr}; // Sentinel

void init_QSensor(PyObject *module)
{
    _Sbk_QSensor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSensor",
        "QSensor*",
        &Sbk_QSensor_spec,
        &Shiboken::callCppDestructor< ::QSensor >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSensor_Type);
    InitSignatureStrings(pyType, QSensor_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSensor_Type), Sbk_QSensor_PropertyStrings);
    SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSensor_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSensor_TypeF(),
        QSensor_PythonToCpp_QSensor_PTR,
        is_QSensor_PythonToCpp_QSensor_PTR_Convertible,
        QSensor_PTR_CppToPython_QSensor);

    Shiboken::Conversions::registerConverterName(converter, "QSensor");
    Shiboken::Conversions::registerConverterName(converter, "QSensor*");
    Shiboken::Conversions::registerConverterName(converter, "QSensor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSensor).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSensorWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSensor_TypeF(), &Sbk_QSensor_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Feature'.
    SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSensor_TypeF(),
        "Feature",
        "2:PySide2.QtSensors.QSensor.Feature",
        "QSensor::Feature");
    if (!SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "Buffering", (long) QSensor::Feature::Buffering))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "AlwaysOn", (long) QSensor::Feature::AlwaysOn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "GeoValues", (long) QSensor::Feature::GeoValues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "FieldOfView", (long) QSensor::Feature::FieldOfView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "AccelerationMode", (long) QSensor::Feature::AccelerationMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "SkipDuplicates", (long) QSensor::Feature::SkipDuplicates))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "AxesOrientation", (long) QSensor::Feature::AxesOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "PressureSensorTemperature", (long) QSensor::Feature::PressureSensorTemperature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
        Sbk_QSensor_TypeF(), "Reserved", (long) QSensor::Feature::Reserved))
        return;
    // Register converter for enum 'QSensor::Feature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX],
            QSensor_Feature_CppToPython_QSensor_Feature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSensor_Feature_PythonToCpp_QSensor_Feature,
            is_QSensor_Feature_PythonToCpp_QSensor_Feature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSensor::Feature");
        Shiboken::Conversions::registerConverterName(converter, "Feature");
    }
    // End of 'Feature' enum.

    // Initialization of enum 'AxesOrientationMode'.
    SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSensor_TypeF(),
        "AxesOrientationMode",
        "2:PySide2.QtSensors.QSensor.AxesOrientationMode",
        "QSensor::AxesOrientationMode");
    if (!SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX],
        Sbk_QSensor_TypeF(), "FixedOrientation", (long) QSensor::AxesOrientationMode::FixedOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX],
        Sbk_QSensor_TypeF(), "AutomaticOrientation", (long) QSensor::AxesOrientationMode::AutomaticOrientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX],
        Sbk_QSensor_TypeF(), "UserOrientation", (long) QSensor::AxesOrientationMode::UserOrientation))
        return;
    // Register converter for enum 'QSensor::AxesOrientationMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX],
            QSensor_AxesOrientationMode_CppToPython_QSensor_AxesOrientationMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSensor_AxesOrientationMode_PythonToCpp_QSensor_AxesOrientationMode,
            is_QSensor_AxesOrientationMode_PythonToCpp_QSensor_AxesOrientationMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_AXESORIENTATIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSensor::AxesOrientationMode");
        Shiboken::Conversions::registerConverterName(converter, "AxesOrientationMode");
    }
    // End of 'AxesOrientationMode' enum.

    PySide::Signal::registerSignals(Sbk_QSensor_TypeF(), &::QSensor::staticMetaObject);
    qRegisterMetaType< ::QSensor::Feature >("QSensor::Feature");
    qRegisterMetaType< ::QSensor::AxesOrientationMode >("QSensor::AxesOrientationMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSensor_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSensor_TypeF(), &::QSensor::staticMetaObject, sizeof(QSensorWrapper));
}
