/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsensors_python.h"

// main header
#include "qambientlightfilter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAmbientLightFilterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAmbientLightFilterWrapper::QAmbientLightFilterWrapper() : QAmbientLightFilter()
{
    resetPyMethodCache();
    // ... middle
}

bool QAmbientLightFilterWrapper::filter(::QAmbientLightReading * reading)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAmbientLightFilter.filter()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "filter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAmbientLightFilter.filter()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTREADING_IDX]), reading)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAmbientLightFilter.filter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAmbientLightFilterWrapper::setSensor(::QSensor * sensor)
{
    if (m_PyMethodCache[1]) {
        return this->::QSensorFilter::setSensor(sensor);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setSensor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSensorFilter::setSensor(sensor);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSOR_IDX]), sensor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QAmbientLightFilterWrapper::~QAmbientLightFilterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAmbientLightFilter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTFILTER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAmbientLightFilter' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAmbientLightFilter >()))
        return -1;

    ::QAmbientLightFilterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QAmbientLightFilter.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QAmbientLightFilter()
            cptr = new ::QAmbientLightFilterWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAmbientLightFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QAmbientLightFilterFunc_filter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAmbientLightFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QAmbientLightFilter.filter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensorFilter::filter(QSensorReading*)
    // 1: QAmbientLightFilter::filter(QAmbientLightReading*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTREADING_IDX]), (pyArg)))) {
        overloadId = 1; // filter(QAmbientLightReading*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]), (pyArg)))) {
        overloadId = 0; // filter(QSensorReading*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAmbientLightFilterFunc_filter_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // filter(QSensorReading * reading)
        {
            PyErr_Format(PyExc_TypeError, "%s is a private method.", "filter(QSensorReading * reading)");
            return {};
            break;
        }
        case 1: // filter(QAmbientLightReading * reading)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QAmbientLightReading *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // filter(QAmbientLightReading*)
                if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                    PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAmbientLightFilter.filter()' not implemented.");
                    return {};
                }
                bool cppResult = cppSelf->filter(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAmbientLightFilterFunc_filter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QAmbientLightFilter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAmbientLightFilter_methods[] = {
    {"filter", reinterpret_cast<PyCFunction>(Sbk_QAmbientLightFilterFunc_filter), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAmbientLightFilter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAmbientLightFilter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTFILTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAmbientLightFilterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAmbientLightFilter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAmbientLightFilter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAmbientLightFilter_Type = nullptr;
static SbkObjectType *Sbk_QAmbientLightFilter_TypeF(void)
{
    return _Sbk_QAmbientLightFilter_Type;
}

static PyType_Slot Sbk_QAmbientLightFilter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAmbientLightFilter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAmbientLightFilter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAmbientLightFilter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAmbientLightFilter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAmbientLightFilter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAmbientLightFilter_spec = {
    "2:PySide2.QtSensors.QAmbientLightFilter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAmbientLightFilter_slots
};

} //extern "C"

static void *Sbk_QAmbientLightFilter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QSensorFilter >()))
        return dynamic_cast< ::QAmbientLightFilter *>(reinterpret_cast< ::QSensorFilter *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAmbientLightFilter_PythonToCpp_QAmbientLightFilter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAmbientLightFilter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAmbientLightFilter_PythonToCpp_QAmbientLightFilter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAmbientLightFilter_TypeF())))
        return QAmbientLightFilter_PythonToCpp_QAmbientLightFilter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAmbientLightFilter_PTR_CppToPython_QAmbientLightFilter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAmbientLightFilter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAmbientLightFilter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAmbientLightFilter_SignatureStrings[] = {
    "PySide2.QtSensors.QAmbientLightFilter(self)",
    "1:PySide2.QtSensors.QAmbientLightFilter.filter(self,reading:PySide2.QtSensors.QSensorReading)->bool",
    "0:PySide2.QtSensors.QAmbientLightFilter.filter(self,reading:PySide2.QtSensors.QAmbientLightReading)->bool",
    nullptr}; // Sentinel

void init_QAmbientLightFilter(PyObject *module)
{
    _Sbk_QAmbientLightFilter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAmbientLightFilter",
        "QAmbientLightFilter*",
        &Sbk_QAmbientLightFilter_spec,
        &Shiboken::callCppDestructor< ::QAmbientLightFilter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAmbientLightFilter_Type);
    InitSignatureStrings(pyType, QAmbientLightFilter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAmbientLightFilter_Type), Sbk_QAmbientLightFilter_PropertyStrings);
    SbkPySide2_QtSensorsTypes[SBK_QAMBIENTLIGHTFILTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAmbientLightFilter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAmbientLightFilter_TypeF(),
        QAmbientLightFilter_PythonToCpp_QAmbientLightFilter_PTR,
        is_QAmbientLightFilter_PythonToCpp_QAmbientLightFilter_PTR_Convertible,
        QAmbientLightFilter_PTR_CppToPython_QAmbientLightFilter);

    Shiboken::Conversions::registerConverterName(converter, "QAmbientLightFilter");
    Shiboken::Conversions::registerConverterName(converter, "QAmbientLightFilter*");
    Shiboken::Conversions::registerConverterName(converter, "QAmbientLightFilter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAmbientLightFilter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAmbientLightFilterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAmbientLightFilter_TypeF(), &Sbk_QAmbientLightFilter_typeDiscovery);

}
