/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptcontext_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtScript/qscriptcontext.h>
#include <QtScript/qscriptengine.h>
#include <QtScript/qscriptvalue.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QScriptContextFunc_activationObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.activationObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activationObject()const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->activationObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_argument(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.argument";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::argument(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // argument(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_argument_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // argument(int)const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->argument(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptContextFunc_argument_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_argumentCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.argumentCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // argumentCount()const
            int cppResult = const_cast<const ::QScriptContext *>(cppSelf)->argumentCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_argumentsObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.argumentsObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // argumentsObject()const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->argumentsObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_backtrace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.backtrace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backtrace()const
            QStringList cppResult = const_cast<const ::QScriptContext *>(cppSelf)->backtrace();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_callee(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.callee";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // callee()const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->callee();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QScriptEngine * cppResult = const_cast<const ::QScriptContext *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_isCalledAsConstructor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.isCalledAsConstructor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCalledAsConstructor()const
            bool cppResult = const_cast<const ::QScriptContext *>(cppSelf)->isCalledAsConstructor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_parentContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.parentContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentContext()const
            QScriptContext * cppResult = const_cast<const ::QScriptContext *>(cppSelf)->parentContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_popScope(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.popScope";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // popScope()
            QScriptValue cppResult = cppSelf->popScope();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_pushScope(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.pushScope";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::pushScope(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // pushScope(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_pushScope_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pushScope(QScriptValue)
            cppSelf->pushScope(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptContextFunc_pushScope_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_returnValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.returnValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // returnValue()const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->returnValue();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_scopeChain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.scopeChain";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scopeChain()const
            QList<QScriptValue > cppResult = const_cast<const ::QScriptContext *>(cppSelf)->scopeChain();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtScriptTypeConverters[SBK_QTSCRIPT_QLIST_QSCRIPTVALUE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_setActivationObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.setActivationObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::setActivationObject(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setActivationObject(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_setActivationObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setActivationObject(QScriptValue)
            cppSelf->setActivationObject(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptContextFunc_setActivationObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_setReturnValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.setReturnValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::setReturnValue(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setReturnValue(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_setReturnValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setReturnValue(QScriptValue)
            cppSelf->setReturnValue(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptContextFunc_setReturnValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_setThisObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.setThisObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::setThisObject(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setThisObject(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_setThisObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setThisObject(QScriptValue)
            cppSelf->setThisObject(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptContextFunc_setThisObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QScriptContext::ExecutionState cppResult = const_cast<const ::QScriptContext *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_thisObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.thisObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // thisObject()const
            QScriptValue cppResult = const_cast<const ::QScriptContext *>(cppSelf)->thisObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextFunc_throwError(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.throwError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "throwError", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptContext::throwError(QScriptContext::Error,QString)
    // 1: QScriptContext::throwError(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // throwError(QString)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // throwError(QScriptContext::Error,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_throwError_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // throwError(QScriptContext::Error error, const QString & text)
        {
            ::QScriptContext::Error cppArg0{QScriptContext::UnknownError};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // throwError(QScriptContext::Error,QString)
                QScriptValue cppResult = cppSelf->throwError(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // throwError(const QString & text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // throwError(QString)
                QScriptValue cppResult = cppSelf->throwError(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptContextFunc_throwError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_throwValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.throwValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptContext::throwValue(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // throwValue(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextFunc_throwValue_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // throwValue(QScriptValue)
            QScriptValue cppResult = cppSelf->throwValue(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptContextFunc_throwValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContext.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QScriptContext *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScriptContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptContext_methods[] = {
    {"activationObject", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_activationObject), METH_NOARGS},
    {"argument", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_argument), METH_O},
    {"argumentCount", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_argumentCount), METH_NOARGS},
    {"argumentsObject", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_argumentsObject), METH_NOARGS},
    {"backtrace", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_backtrace), METH_NOARGS},
    {"callee", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_callee), METH_NOARGS},
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_engine), METH_NOARGS},
    {"isCalledAsConstructor", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_isCalledAsConstructor), METH_NOARGS},
    {"parentContext", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_parentContext), METH_NOARGS},
    {"popScope", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_popScope), METH_NOARGS},
    {"pushScope", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_pushScope), METH_O},
    {"returnValue", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_returnValue), METH_NOARGS},
    {"scopeChain", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_scopeChain), METH_NOARGS},
    {"setActivationObject", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_setActivationObject), METH_O},
    {"setReturnValue", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_setReturnValue), METH_O},
    {"setThisObject", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_setThisObject), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_state), METH_NOARGS},
    {"thisObject", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_thisObject), METH_NOARGS},
    {"throwError", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_throwError), METH_VARARGS},
    {"throwValue", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_throwValue), METH_O},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QScriptContextFunc_toString), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QScriptContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptContext_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptContext_Type = nullptr;
static SbkObjectType *Sbk_QScriptContext_TypeF(void)
{
    return _Sbk_QScriptContext_Type;
}

static PyType_Slot Sbk_QScriptContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptContext_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptContext_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptContext_spec = {
    "2:PySide2.QtScript.QScriptContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptContext_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptContext_ExecutionState_PythonToCpp_QScriptContext_ExecutionState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptContext::ExecutionState *>(cppOut) =
        static_cast<::QScriptContext::ExecutionState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptContext_ExecutionState_PythonToCpp_QScriptContext_ExecutionState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX]))
        return QScriptContext_ExecutionState_PythonToCpp_QScriptContext_ExecutionState;
    return {};
}
static PyObject *QScriptContext_ExecutionState_CppToPython_QScriptContext_ExecutionState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptContext::ExecutionState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX], castCppIn);

}

static void QScriptContext_Error_PythonToCpp_QScriptContext_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptContext::Error *>(cppOut) =
        static_cast<::QScriptContext::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptContext_Error_PythonToCpp_QScriptContext_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX]))
        return QScriptContext_Error_PythonToCpp_QScriptContext_Error;
    return {};
}
static PyObject *QScriptContext_Error_CppToPython_QScriptContext_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptContext::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptContext_PythonToCpp_QScriptContext_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptContext_PythonToCpp_QScriptContext_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptContext_TypeF())))
        return QScriptContext_PythonToCpp_QScriptContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptContext_PTR_CppToPython_QScriptContext(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptContext *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptContext_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptContext_SignatureStrings[] = {
    "PySide2.QtScript.QScriptContext.activationObject(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.argument(self,index:int)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.argumentCount(self)->int",
    "PySide2.QtScript.QScriptContext.argumentsObject(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.backtrace(self)->QStringList",
    "PySide2.QtScript.QScriptContext.callee(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.engine(self)->PySide2.QtScript.QScriptEngine",
    "PySide2.QtScript.QScriptContext.isCalledAsConstructor(self)->bool",
    "PySide2.QtScript.QScriptContext.parentContext(self)->PySide2.QtScript.QScriptContext",
    "PySide2.QtScript.QScriptContext.popScope(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.pushScope(self,object:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptContext.returnValue(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.scopeChain(self)->QList[PySide2.QtScript.QScriptValue]",
    "PySide2.QtScript.QScriptContext.setActivationObject(self,activation:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptContext.setReturnValue(self,result:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptContext.setThisObject(self,thisObject:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptContext.state(self)->PySide2.QtScript.QScriptContext.ExecutionState",
    "PySide2.QtScript.QScriptContext.thisObject(self)->PySide2.QtScript.QScriptValue",
    "1:PySide2.QtScript.QScriptContext.throwError(self,error:PySide2.QtScript.QScriptContext.Error,text:QString)->PySide2.QtScript.QScriptValue",
    "0:PySide2.QtScript.QScriptContext.throwError(self,text:QString)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.throwValue(self,value:PySide2.QtScript.QScriptValue)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptContext.toString(self)->QString",
    nullptr}; // Sentinel

void init_QScriptContext(PyObject *module)
{
    _Sbk_QScriptContext_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptContext",
        "QScriptContext*",
        &Sbk_QScriptContext_spec,
        &Shiboken::callCppDestructor< ::QScriptContext >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptContext_Type);
    InitSignatureStrings(pyType, QScriptContext_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptContext_Type), Sbk_QScriptContext_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptContext_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptContext_TypeF(),
        QScriptContext_PythonToCpp_QScriptContext_PTR,
        is_QScriptContext_PythonToCpp_QScriptContext_PTR_Convertible,
        QScriptContext_PTR_CppToPython_QScriptContext);

    Shiboken::Conversions::registerConverterName(converter, "QScriptContext");
    Shiboken::Conversions::registerConverterName(converter, "QScriptContext*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptContext).name());


    // Initialization of enums.

    // Initialization of enum 'ExecutionState'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptContext_TypeF(),
        "ExecutionState",
        "2:PySide2.QtScript.QScriptContext.ExecutionState",
        "QScriptContext::ExecutionState");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX],
        Sbk_QScriptContext_TypeF(), "NormalState", (long) QScriptContext::ExecutionState::NormalState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX],
        Sbk_QScriptContext_TypeF(), "ExceptionState", (long) QScriptContext::ExecutionState::ExceptionState))
        return;
    // Register converter for enum 'QScriptContext::ExecutionState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX],
            QScriptContext_ExecutionState_CppToPython_QScriptContext_ExecutionState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptContext_ExecutionState_PythonToCpp_QScriptContext_ExecutionState,
            is_QScriptContext_ExecutionState_PythonToCpp_QScriptContext_ExecutionState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_EXECUTIONSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptContext::ExecutionState");
        Shiboken::Conversions::registerConverterName(converter, "ExecutionState");
    }
    // End of 'ExecutionState' enum.

    // Initialization of enum 'Error'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptContext_TypeF(),
        "Error",
        "2:PySide2.QtScript.QScriptContext.Error",
        "QScriptContext::Error");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "UnknownError", (long) QScriptContext::Error::UnknownError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "ReferenceError", (long) QScriptContext::Error::ReferenceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "SyntaxError", (long) QScriptContext::Error::SyntaxError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "TypeError", (long) QScriptContext::Error::TypeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "RangeError", (long) QScriptContext::Error::RangeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
        Sbk_QScriptContext_TypeF(), "URIError", (long) QScriptContext::Error::URIError))
        return;
    // Register converter for enum 'QScriptContext::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX],
            QScriptContext_Error_CppToPython_QScriptContext_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptContext_Error_PythonToCpp_QScriptContext_Error,
            is_QScriptContext_Error_PythonToCpp_QScriptContext_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptContext::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::QScriptContext::ExecutionState >("QScriptContext::ExecutionState");
    qRegisterMetaType< ::QScriptContext::Error >("QScriptContext::Error");
}
