/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtremoteobjects_python.h"

// main header
#include "qremoteobjecthost_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRemoteObjectHostWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QRemoteObjectHostWrapper::QRemoteObjectHostWrapper(::QObject * parent) : QRemoteObjectHost(parent)
{
    resetPyMethodCache();
    // ... middle
}

QRemoteObjectHostWrapper::QRemoteObjectHostWrapper(const ::QUrl & address, ::QObject * parent) : QRemoteObjectHost(address, parent)
{
    resetPyMethodCache();
    // ... middle
}

QRemoteObjectHostWrapper::QRemoteObjectHostWrapper(const ::QUrl & address, const ::QUrl & registryAddress, ::QRemoteObjectHostBase::AllowedSchemas allowedSchemas, ::QObject * parent) : QRemoteObjectHost(address, registryAddress, allowedSchemas, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QRemoteObjectHostWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectHostWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRemoteObjectHostWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectHostWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRemoteObjectHostWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHost.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRemoteObjectHostWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHost.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QUrl QRemoteObjectHostWrapper::hostUrl() const
{
    if (m_PyMethodCache[6])
        return this->::QRemoteObjectHost::hostUrl();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "1:hostUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QRemoteObjectHost::hostUrl();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHost.hostUrl", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QUrl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QUrl cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QRemoteObjectHostWrapper::setHostUrl(const ::QUrl & hostAddress, ::QRemoteObjectHostBase::AllowedSchemas allowedSchemas)
{
    if (m_PyMethodCache[8])
        return this->::QRemoteObjectHost::setHostUrl(hostAddress, allowedSchemas);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setHostUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QRemoteObjectHost::setHostUrl(hostAddress, allowedSchemas);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &hostAddress),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, &allowedSchemas)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHost.setHostUrl", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRemoteObjectHostWrapper::setName(const ::QString & name)
{
    if (m_PyMethodCache[9]) {
        return this->::QRemoteObjectHostBase::setName(name);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setName";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QRemoteObjectHostBase::setName(name);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &name)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRemoteObjectHostWrapper::setRegistryUrl(const ::QUrl & registryAddress)
{
    if (m_PyMethodCache[10])
        return this->::QRemoteObjectNode::setRegistryUrl(registryAddress);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setRegistryUrl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QRemoteObjectNode::setRegistryUrl(registryAddress);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &registryAddress)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectHost.setRegistryUrl", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRemoteObjectHostWrapper::timerEvent(::QTimerEvent * arg__1)
{
    if (m_PyMethodCache[11]) {
        return this->::QRemoteObjectNode::timerEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QRemoteObjectNode::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QRemoteObjectHostWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QRemoteObjectHost::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRemoteObjectHostWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QRemoteObjectHost::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRemoteObjectHostWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRemoteObjectHostWrapper *>(this));
        return QRemoteObjectHost::qt_metacast(_clname);
}

QRemoteObjectHostWrapper::~QRemoteObjectHostWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRemoteObjectHost_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRemoteObjectHost >()))
        return -1;

    ::QRemoteObjectHostWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHost.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOO:QRemoteObjectHost", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QRemoteObjectHost::QRemoteObjectHost(QObject*)
    // 1: QRemoteObjectHost::QRemoteObjectHost(QUrl,QObject*)
    // 2: QRemoteObjectHost::QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QRemoteObjectHost(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3])))) {
                    overloadId = 2; // QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QRemoteObjectHost(QUrl,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QRemoteObjectHost(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHost_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRemoteObjectHost(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRemoteObjectHost(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QRemoteObjectHostWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QRemoteObjectHostWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QRemoteObjectHost(const QUrl & address, QObject * parent)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRemoteObjectHost_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QRemoteObjectHost(QUrl,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QRemoteObjectHostWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QRemoteObjectHostWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 2: // QRemoteObjectHost(const QUrl & address, const QUrl & registryAddress, QRemoteObjectHostBase::AllowedSchemas allowedSchemas, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_registryAddress = Shiboken::String::createStaticString("registryAddress");
                if (PyDict_Contains(kwds, key_registryAddress)) {
                    value = PyDict_GetItem(kwds, key_registryAddress);
                    if (value && pyArgs[1]) {
                        errInfo = key_registryAddress;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_registryAddress);
                }
                static PyObject *const key_allowedSchemas = Shiboken::String::createStaticString("allowedSchemas");
                if (PyDict_Contains(kwds, key_allowedSchemas)) {
                    value = PyDict_GetItem(kwds, key_allowedSchemas);
                    if (value && pyArgs[2]) {
                        errInfo = key_allowedSchemas;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_allowedSchemas);
                }
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[3]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3]))))
                            goto Sbk_QRemoteObjectHost_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }
            ::QRemoteObjectHostBase::AllowedSchemas cppArg2 = QRemoteObjectHostBase::AllowedSchemas::BuiltInSchemasOnly;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QObject *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QRemoteObjectHost(QUrl,QUrl,QRemoteObjectHostBase::AllowedSchemas,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QRemoteObjectHostWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QRemoteObjectHostWrapper(*cppArg0, *cppArg1, cppArg2, cppArg3);
                }

                Shiboken::Object::setParent(pyArgs[3], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRemoteObjectHost >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRemoteObjectHost_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QRemoteObjectHost_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QRemoteObjectHost_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRemoteObjectHostFunc_hostUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHost *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHost.hostUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostUrl()const
            QUrl cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QRemoteObjectHost *>(cppSelf)->::QRemoteObjectHost::hostUrl()
                : const_cast<const ::QRemoteObjectHost *>(cppSelf)->hostUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectHostFunc_setHostUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectHost *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectHost.setHostUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setHostUrl", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectHostBase::setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_allowedSchemas = Shiboken::String::createStaticString("allowedSchemas");
            if (PyDict_Contains(kwds, key_allowedSchemas)) {
                value = PyDict_GetItem(kwds, key_allowedSchemas);
                if (value && pyArgs[1]) {
                    errInfo = key_allowedSchemas;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_ALLOWEDSCHEMAS_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_allowedSchemas);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QRemoteObjectHostBase::AllowedSchemas cppArg1 = QRemoteObjectHostBase::AllowedSchemas::BuiltInSchemasOnly;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHostUrl(QUrl,QRemoteObjectHostBase::AllowedSchemas)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRemoteObjectHost::setHostUrl(*cppArg0, cppArg1)
                : cppSelf->setHostUrl(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectHostFunc_setHostUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QRemoteObjectHost_PropertyStrings[] = {
    "hostUrl::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRemoteObjectHost_methods[] = {
    {"hostUrl", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostFunc_hostUrl), METH_NOARGS},
    {"setHostUrl", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectHostFunc_setHostUrl), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QRemoteObjectHost_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QRemoteObjectHost *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOST_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRemoteObjectHostWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QRemoteObjectHost_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRemoteObjectHost_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRemoteObjectHost_Type = nullptr;
static SbkObjectType *Sbk_QRemoteObjectHost_TypeF(void)
{
    return _Sbk_QRemoteObjectHost_Type;
}

static PyType_Slot Sbk_QRemoteObjectHost_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QRemoteObjectHost_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRemoteObjectHost_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRemoteObjectHost_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRemoteObjectHost_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRemoteObjectHost_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRemoteObjectHost_spec = {
    "2:PySide2.QtRemoteObjects.QRemoteObjectHost",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRemoteObjectHost_slots
};

} //extern "C"

static void *Sbk_QRemoteObjectHost_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QRemoteObjectHost *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRemoteObjectHost_PythonToCpp_QRemoteObjectHost_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRemoteObjectHost_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRemoteObjectHost_PythonToCpp_QRemoteObjectHost_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectHost_TypeF())))
        return QRemoteObjectHost_PythonToCpp_QRemoteObjectHost_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRemoteObjectHost_PTR_CppToPython_QRemoteObjectHost(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QRemoteObjectHost *>(const_cast<void *>(cppIn)), Sbk_QRemoteObjectHost_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRemoteObjectHost_SignatureStrings[] = {
    "2:PySide2.QtRemoteObjects.QRemoteObjectHost(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtRemoteObjects.QRemoteObjectHost(self,address:PySide2.QtCore.QUrl,parent:PySide2.QtCore.QObject)",
    "0:PySide2.QtRemoteObjects.QRemoteObjectHost(self,address:PySide2.QtCore.QUrl,registryAddress:PySide2.QtCore.QUrl=QUrl(),allowedSchemas:PySide2.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas=BuiltInSchemasOnly,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtRemoteObjects.QRemoteObjectHost.hostUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtRemoteObjects.QRemoteObjectHost.setHostUrl(self,hostAddress:PySide2.QtCore.QUrl,allowedSchemas:PySide2.QtRemoteObjects.QRemoteObjectHostBase.AllowedSchemas=BuiltInSchemasOnly)->bool",
    nullptr}; // Sentinel

void init_QRemoteObjectHost(PyObject *module)
{
    _Sbk_QRemoteObjectHost_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRemoteObjectHost",
        "QRemoteObjectHost*",
        &Sbk_QRemoteObjectHost_spec,
        &Shiboken::callCppDestructor< ::QRemoteObjectHost >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOSTBASE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectHost_Type);
    InitSignatureStrings(pyType, QRemoteObjectHost_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectHost_Type), Sbk_QRemoteObjectHost_PropertyStrings);
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTHOST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectHost_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRemoteObjectHost_TypeF(),
        QRemoteObjectHost_PythonToCpp_QRemoteObjectHost_PTR,
        is_QRemoteObjectHost_PythonToCpp_QRemoteObjectHost_PTR_Convertible,
        QRemoteObjectHost_PTR_CppToPython_QRemoteObjectHost);

    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHost");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHost*");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectHost&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectHost).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectHostWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QRemoteObjectHost_TypeF(), &Sbk_QRemoteObjectHost_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QRemoteObjectHost_TypeF(), &::QRemoteObjectHost::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QRemoteObjectHost_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QRemoteObjectHost_TypeF(), &::QRemoteObjectHost::staticMetaObject, sizeof(QRemoteObjectHostWrapper));
}
