/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgtexture_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGTextureWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGTextureWrapper::QSGTextureWrapper() : QSGTexture()
{
    resetPyMethodCache();
    // ... middle
}

void QSGTextureWrapper::bind()
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.bind()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.bind()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGTextureWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGTextureWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGTextureWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGTextureWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSGTextureWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSGTextureWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QSGTextureWrapper::hasAlphaChannel() const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasAlphaChannel()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasAlphaChannel";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasAlphaChannel()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.hasAlphaChannel", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSGTextureWrapper::hasMipmaps() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasMipmaps()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasMipmaps";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasMipmaps()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.hasMipmaps", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSGTextureWrapper::isAtlasTexture() const
{
    if (m_PyMethodCache[9])
        return this->::QSGTexture::isAtlasTexture();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isAtlasTexture";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QSGTexture::isAtlasTexture();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.isAtlasTexture", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRectF QSGTextureWrapper::normalizedTextureSubRect() const
{
    if (m_PyMethodCache[11])
        return this->::QSGTexture::normalizedTextureSubRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "normalizedTextureSubRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QSGTexture::normalizedTextureSubRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.normalizedTextureSubRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSGTexture * QSGTextureWrapper::removedFromAtlas() const
{
    if (m_PyMethodCache[12])
        return this->::QSGTexture::removedFromAtlas();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "removedFromAtlas";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QSGTexture::removedFromAtlas();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.removedFromAtlas", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGTexture >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSGTexture *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QSGTextureWrapper::textureId() const
{
    if (m_PyMethodCache[13]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureId()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "textureId";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureId()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.textureId", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QSGTextureWrapper::textureSize() const
{
    if (m_PyMethodCache[14]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureSize()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "textureSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureSize()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGTexture.textureSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSGTextureWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSGTextureWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSGTexture::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSGTextureWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSGTexture::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSGTextureWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSGTextureWrapper *>(this));
        return QSGTexture::qt_metacast(_clname);
}

QSGTextureWrapper::~QSGTextureWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGTexture_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSGTexture' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGTexture >()))
        return -1;

    ::QSGTextureWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSGTexture()
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QSGTextureWrapper();
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QSGTextureWrapper();
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGTexture >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSGTexture_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSGTexture_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGTextureFunc_anisotropyLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.anisotropyLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anisotropyLevel()const
            QSGTexture::AnisotropyLevel cppResult = const_cast<const ::QSGTexture *>(cppSelf)->anisotropyLevel();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.bind()' not implemented.");
                return {};
            }
            cppSelf->bind();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGTextureFunc_comparisonKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.comparisonKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // comparisonKey()const
            int cppResult = const_cast<const ::QSGTexture *>(cppSelf)->comparisonKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_convertToNormalizedSourceRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.convertToNormalizedSourceRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::convertToNormalizedSourceRect(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // convertToNormalizedSourceRect(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_convertToNormalizedSourceRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // convertToNormalizedSourceRect(QRectF)const
            QRectF cppResult = const_cast<const ::QSGTexture *>(cppSelf)->convertToNormalizedSourceRect(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGTextureFunc_convertToNormalizedSourceRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_filtering(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.filtering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filtering()const
            QSGTexture::Filtering cppResult = const_cast<const ::QSGTexture *>(cppSelf)->filtering();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_hasAlphaChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.hasAlphaChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAlphaChannel()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasAlphaChannel()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QSGTexture *>(cppSelf)->hasAlphaChannel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_hasMipmaps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.hasMipmaps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasMipmaps()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.hasMipmaps()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QSGTexture *>(cppSelf)->hasMipmaps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_horizontalWrapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.horizontalWrapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // horizontalWrapMode()const
            QSGTexture::WrapMode cppResult = const_cast<const ::QSGTexture *>(cppSelf)->horizontalWrapMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_isAtlasTexture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.isAtlasTexture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAtlasTexture()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSGTexture *>(cppSelf)->::QSGTexture::isAtlasTexture()
                : const_cast<const ::QSGTexture *>(cppSelf)->isAtlasTexture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_mipmapFiltering(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.mipmapFiltering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipmapFiltering()const
            QSGTexture::Filtering cppResult = const_cast<const ::QSGTexture *>(cppSelf)->mipmapFiltering();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_normalizedTextureSubRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.normalizedTextureSubRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalizedTextureSubRect()const
            QRectF cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSGTexture *>(cppSelf)->::QSGTexture::normalizedTextureSubRect()
                : const_cast<const ::QSGTexture *>(cppSelf)->normalizedTextureSubRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_removedFromAtlas(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.removedFromAtlas";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removedFromAtlas()const
            QSGTexture * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSGTexture *>(cppSelf)->::QSGTexture::removedFromAtlas()
                : const_cast<const ::QSGTexture *>(cppSelf)->removedFromAtlas();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_setAnisotropyLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.setAnisotropyLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::setAnisotropyLevel(QSGTexture::AnisotropyLevel)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAnisotropyLevel(QSGTexture::AnisotropyLevel)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_setAnisotropyLevel_TypeError;

    // Call function/method
    {
        ::QSGTexture::AnisotropyLevel cppArg0{QSGTexture::AnisotropyNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnisotropyLevel(QSGTexture::AnisotropyLevel)
            cppSelf->setAnisotropyLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_setAnisotropyLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_setFiltering(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.setFiltering";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::setFiltering(QSGTexture::Filtering)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFiltering(QSGTexture::Filtering)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_setFiltering_TypeError;

    // Call function/method
    {
        ::QSGTexture::Filtering cppArg0{QSGTexture::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFiltering(QSGTexture::Filtering)
            cppSelf->setFiltering(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_setFiltering_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_setHorizontalWrapMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.setHorizontalWrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::setHorizontalWrapMode(QSGTexture::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setHorizontalWrapMode(QSGTexture::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_setHorizontalWrapMode_TypeError;

    // Call function/method
    {
        ::QSGTexture::WrapMode cppArg0{QSGTexture::Repeat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHorizontalWrapMode(QSGTexture::WrapMode)
            cppSelf->setHorizontalWrapMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_setHorizontalWrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_setMipmapFiltering(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.setMipmapFiltering";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::setMipmapFiltering(QSGTexture::Filtering)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMipmapFiltering(QSGTexture::Filtering)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_setMipmapFiltering_TypeError;

    // Call function/method
    {
        ::QSGTexture::Filtering cppArg0{QSGTexture::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipmapFiltering(QSGTexture::Filtering)
            cppSelf->setMipmapFiltering(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_setMipmapFiltering_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_setVerticalWrapMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.setVerticalWrapMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGTexture::setVerticalWrapMode(QSGTexture::WrapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVerticalWrapMode(QSGTexture::WrapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_setVerticalWrapMode_TypeError;

    // Call function/method
    {
        ::QSGTexture::WrapMode cppArg0{QSGTexture::Repeat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalWrapMode(QSGTexture::WrapMode)
            cppSelf->setVerticalWrapMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_setVerticalWrapMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_textureId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.textureId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureId()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureId()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QSGTexture *>(cppSelf)->textureId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_textureSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.textureSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGTexture.textureSize()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QSGTexture *>(cppSelf)->textureSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGTextureFunc_updateBindOptions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.updateBindOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGTextureFunc_updateBindOptions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:updateBindOptions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSGTexture::updateBindOptions(bool)
    if (numArgs == 0) {
        overloadId = 0; // updateBindOptions(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // updateBindOptions(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGTextureFunc_updateBindOptions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_force = Shiboken::String::createStaticString("force");
            if (PyDict_Contains(kwds, key_force)) {
                value = PyDict_GetItem(kwds, key_force);
                if (value && pyArgs[0]) {
                    errInfo = key_force;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGTextureFunc_updateBindOptions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QSGTextureFunc_updateBindOptions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_force);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGTextureFunc_updateBindOptions_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // updateBindOptions(bool)
            cppSelf->updateBindOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGTextureFunc_updateBindOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGTextureFunc_verticalWrapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGTexture.verticalWrapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalWrapMode()const
            QSGTexture::WrapMode cppResult = const_cast<const ::QSGTexture *>(cppSelf)->verticalWrapMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGTexture_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGTexture_methods[] = {
    {"anisotropyLevel", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_anisotropyLevel), METH_NOARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_bind), METH_NOARGS},
    {"comparisonKey", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_comparisonKey), METH_NOARGS},
    {"convertToNormalizedSourceRect", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_convertToNormalizedSourceRect), METH_O},
    {"filtering", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_filtering), METH_NOARGS},
    {"hasAlphaChannel", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_hasAlphaChannel), METH_NOARGS},
    {"hasMipmaps", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_hasMipmaps), METH_NOARGS},
    {"horizontalWrapMode", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_horizontalWrapMode), METH_NOARGS},
    {"isAtlasTexture", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_isAtlasTexture), METH_NOARGS},
    {"mipmapFiltering", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_mipmapFiltering), METH_NOARGS},
    {"normalizedTextureSubRect", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_normalizedTextureSubRect), METH_NOARGS},
    {"removedFromAtlas", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_removedFromAtlas), METH_NOARGS},
    {"setAnisotropyLevel", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_setAnisotropyLevel), METH_O},
    {"setFiltering", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_setFiltering), METH_O},
    {"setHorizontalWrapMode", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_setHorizontalWrapMode), METH_O},
    {"setMipmapFiltering", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_setMipmapFiltering), METH_O},
    {"setVerticalWrapMode", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_setVerticalWrapMode), METH_O},
    {"textureId", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_textureId), METH_NOARGS},
    {"textureSize", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_textureSize), METH_NOARGS},
    {"updateBindOptions", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_updateBindOptions), METH_VARARGS|METH_KEYWORDS},
    {"verticalWrapMode", reinterpret_cast<PyCFunction>(Sbk_QSGTextureFunc_verticalWrapMode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGTexture_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGTexture *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGTextureWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGTexture_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGTexture_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGTexture_Type = nullptr;
static SbkObjectType *Sbk_QSGTexture_TypeF(void)
{
    return _Sbk_QSGTexture_Type;
}

static PyType_Slot Sbk_QSGTexture_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGTexture_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGTexture_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGTexture_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGTexture_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGTexture_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGTexture_spec = {
    "2:PySide2.QtQuick.QSGTexture",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGTexture_slots
};

} //extern "C"

static void *Sbk_QSGTexture_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSGTexture *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSGTexture_WrapMode_PythonToCpp_QSGTexture_WrapMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGTexture::WrapMode *>(cppOut) =
        static_cast<::QSGTexture::WrapMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGTexture_WrapMode_PythonToCpp_QSGTexture_WrapMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX]))
        return QSGTexture_WrapMode_PythonToCpp_QSGTexture_WrapMode;
    return {};
}
static PyObject *QSGTexture_WrapMode_CppToPython_QSGTexture_WrapMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGTexture::WrapMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX], castCppIn);

}

static void QSGTexture_Filtering_PythonToCpp_QSGTexture_Filtering(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGTexture::Filtering *>(cppOut) =
        static_cast<::QSGTexture::Filtering>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGTexture_Filtering_PythonToCpp_QSGTexture_Filtering_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX]))
        return QSGTexture_Filtering_PythonToCpp_QSGTexture_Filtering;
    return {};
}
static PyObject *QSGTexture_Filtering_CppToPython_QSGTexture_Filtering(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGTexture::Filtering *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX], castCppIn);

}

static void QSGTexture_AnisotropyLevel_PythonToCpp_QSGTexture_AnisotropyLevel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGTexture::AnisotropyLevel *>(cppOut) =
        static_cast<::QSGTexture::AnisotropyLevel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGTexture_AnisotropyLevel_PythonToCpp_QSGTexture_AnisotropyLevel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX]))
        return QSGTexture_AnisotropyLevel_PythonToCpp_QSGTexture_AnisotropyLevel;
    return {};
}
static PyObject *QSGTexture_AnisotropyLevel_CppToPython_QSGTexture_AnisotropyLevel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGTexture::AnisotropyLevel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGTexture_PythonToCpp_QSGTexture_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGTexture_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGTexture_PythonToCpp_QSGTexture_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGTexture_TypeF())))
        return QSGTexture_PythonToCpp_QSGTexture_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGTexture_PTR_CppToPython_QSGTexture(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSGTexture *>(const_cast<void *>(cppIn)), Sbk_QSGTexture_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGTexture_SignatureStrings[] = {
    "PySide2.QtQuick.QSGTexture(self)",
    "PySide2.QtQuick.QSGTexture.anisotropyLevel(self)->PySide2.QtQuick.QSGTexture.AnisotropyLevel",
    "PySide2.QtQuick.QSGTexture.bind(self)",
    "PySide2.QtQuick.QSGTexture.comparisonKey(self)->int",
    "PySide2.QtQuick.QSGTexture.convertToNormalizedSourceRect(self,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QSGTexture.filtering(self)->PySide2.QtQuick.QSGTexture.Filtering",
    "PySide2.QtQuick.QSGTexture.hasAlphaChannel(self)->bool",
    "PySide2.QtQuick.QSGTexture.hasMipmaps(self)->bool",
    "PySide2.QtQuick.QSGTexture.horizontalWrapMode(self)->PySide2.QtQuick.QSGTexture.WrapMode",
    "PySide2.QtQuick.QSGTexture.isAtlasTexture(self)->bool",
    "PySide2.QtQuick.QSGTexture.mipmapFiltering(self)->PySide2.QtQuick.QSGTexture.Filtering",
    "PySide2.QtQuick.QSGTexture.normalizedTextureSubRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QSGTexture.removedFromAtlas(self)->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QSGTexture.setAnisotropyLevel(self,level:PySide2.QtQuick.QSGTexture.AnisotropyLevel)",
    "PySide2.QtQuick.QSGTexture.setFiltering(self,filter:PySide2.QtQuick.QSGTexture.Filtering)",
    "PySide2.QtQuick.QSGTexture.setHorizontalWrapMode(self,hwrap:PySide2.QtQuick.QSGTexture.WrapMode)",
    "PySide2.QtQuick.QSGTexture.setMipmapFiltering(self,filter:PySide2.QtQuick.QSGTexture.Filtering)",
    "PySide2.QtQuick.QSGTexture.setVerticalWrapMode(self,vwrap:PySide2.QtQuick.QSGTexture.WrapMode)",
    "PySide2.QtQuick.QSGTexture.textureId(self)->int",
    "PySide2.QtQuick.QSGTexture.textureSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtQuick.QSGTexture.updateBindOptions(self,force:bool=false)",
    "PySide2.QtQuick.QSGTexture.verticalWrapMode(self)->PySide2.QtQuick.QSGTexture.WrapMode",
    nullptr}; // Sentinel

void init_QSGTexture(PyObject *module)
{
    _Sbk_QSGTexture_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGTexture",
        "QSGTexture*",
        &Sbk_QSGTexture_spec,
        &Shiboken::callCppDestructor< ::QSGTexture >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGTexture_Type);
    InitSignatureStrings(pyType, QSGTexture_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGTexture_Type), Sbk_QSGTexture_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGTexture_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGTexture_TypeF(),
        QSGTexture_PythonToCpp_QSGTexture_PTR,
        is_QSGTexture_PythonToCpp_QSGTexture_PTR_Convertible,
        QSGTexture_PTR_CppToPython_QSGTexture);

    Shiboken::Conversions::registerConverterName(converter, "QSGTexture");
    Shiboken::Conversions::registerConverterName(converter, "QSGTexture*");
    Shiboken::Conversions::registerConverterName(converter, "QSGTexture&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGTexture).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGTextureWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGTexture_TypeF(), &Sbk_QSGTexture_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'WrapMode'.
    SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGTexture_TypeF(),
        "WrapMode",
        "2:PySide2.QtQuick.QSGTexture.WrapMode",
        "QSGTexture::WrapMode");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX],
        Sbk_QSGTexture_TypeF(), "Repeat", (long) QSGTexture::WrapMode::Repeat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX],
        Sbk_QSGTexture_TypeF(), "ClampToEdge", (long) QSGTexture::WrapMode::ClampToEdge))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX],
        Sbk_QSGTexture_TypeF(), "MirroredRepeat", (long) QSGTexture::WrapMode::MirroredRepeat))
        return;
    // Register converter for enum 'QSGTexture::WrapMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX],
            QSGTexture_WrapMode_CppToPython_QSGTexture_WrapMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGTexture_WrapMode_PythonToCpp_QSGTexture_WrapMode,
            is_QSGTexture_WrapMode_PythonToCpp_QSGTexture_WrapMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_WRAPMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGTexture::WrapMode");
        Shiboken::Conversions::registerConverterName(converter, "WrapMode");
    }
    // End of 'WrapMode' enum.

    // Initialization of enum 'Filtering'.
    SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGTexture_TypeF(),
        "Filtering",
        "2:PySide2.QtQuick.QSGTexture.Filtering",
        "QSGTexture::Filtering");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX],
        Sbk_QSGTexture_TypeF(), "None_", (long) QSGTexture::Filtering::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX],
        Sbk_QSGTexture_TypeF(), "Nearest", (long) QSGTexture::Filtering::Nearest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX],
        Sbk_QSGTexture_TypeF(), "Linear", (long) QSGTexture::Filtering::Linear))
        return;
    // Register converter for enum 'QSGTexture::Filtering'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX],
            QSGTexture_Filtering_CppToPython_QSGTexture_Filtering);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGTexture_Filtering_PythonToCpp_QSGTexture_Filtering,
            is_QSGTexture_Filtering_PythonToCpp_QSGTexture_Filtering_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_FILTERING_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGTexture::Filtering");
        Shiboken::Conversions::registerConverterName(converter, "Filtering");
    }
    // End of 'Filtering' enum.

    // Initialization of enum 'AnisotropyLevel'.
    SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGTexture_TypeF(),
        "AnisotropyLevel",
        "2:PySide2.QtQuick.QSGTexture.AnisotropyLevel",
        "QSGTexture::AnisotropyLevel");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
        Sbk_QSGTexture_TypeF(), "AnisotropyNone", (long) QSGTexture::AnisotropyLevel::AnisotropyNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
        Sbk_QSGTexture_TypeF(), "Anisotropy2x", (long) QSGTexture::AnisotropyLevel::Anisotropy2x))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
        Sbk_QSGTexture_TypeF(), "Anisotropy4x", (long) QSGTexture::AnisotropyLevel::Anisotropy4x))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
        Sbk_QSGTexture_TypeF(), "Anisotropy8x", (long) QSGTexture::AnisotropyLevel::Anisotropy8x))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
        Sbk_QSGTexture_TypeF(), "Anisotropy16x", (long) QSGTexture::AnisotropyLevel::Anisotropy16x))
        return;
    // Register converter for enum 'QSGTexture::AnisotropyLevel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX],
            QSGTexture_AnisotropyLevel_CppToPython_QSGTexture_AnisotropyLevel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGTexture_AnisotropyLevel_PythonToCpp_QSGTexture_AnisotropyLevel,
            is_QSGTexture_AnisotropyLevel_PythonToCpp_QSGTexture_AnisotropyLevel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_ANISOTROPYLEVEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGTexture::AnisotropyLevel");
        Shiboken::Conversions::registerConverterName(converter, "AnisotropyLevel");
    }
    // End of 'AnisotropyLevel' enum.

    PySide::Signal::registerSignals(Sbk_QSGTexture_TypeF(), &::QSGTexture::staticMetaObject);
    qRegisterMetaType< ::QSGTexture::WrapMode >("QSGTexture::WrapMode");
    qRegisterMetaType< ::QSGTexture::Filtering >("QSGTexture::Filtering");
    qRegisterMetaType< ::QSGTexture::AnisotropyLevel >("QSGTexture::AnisotropyLevel");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSGTexture_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSGTexture_TypeF(), &::QSGTexture::staticMetaObject, sizeof(QSGTextureWrapper));
}
