/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qquickpainteditem_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQuickPaintedItemWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQuickPaintedItemWrapper::QQuickPaintedItemWrapper(::QQuickItem * parent) : QQuickPaintedItem(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QRectF QQuickPaintedItemWrapper::boundingRect() const
{
    if (m_PyMethodCache[0])
        return this->::QQuickItem::boundingRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "boundingRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQuickItem::boundingRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.boundingRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QQuickPaintedItemWrapper::childMouseEventFilter(::QQuickItem * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[2])
        return this->::QQuickItem::childMouseEventFilter(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childMouseEventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QQuickItem::childMouseEventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.childMouseEventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::classBegin()
{
    if (m_PyMethodCache[3]) {
        return this->::QQuickItem::classBegin();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "classBegin";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QQuickItem::classBegin();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QRectF QQuickPaintedItemWrapper::clipRect() const
{
    if (m_PyMethodCache[4])
        return this->::QQuickItem::clipRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "clipRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QQuickItem::clipRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.clipRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::componentComplete()
{
    if (m_PyMethodCache[5]) {
        return this->::QQuickItem::componentComplete();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "componentComplete";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QQuickItem::componentComplete();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickPaintedItemWrapper::contains(const ::QPointF & point) const
{
    if (m_PyMethodCache[7])
        return this->::QQuickItem::contains(point);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contains";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QQuickItem::contains(point);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &point)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.contains", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickPaintedItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::dragEnterEvent(::QDragEnterEvent * arg__1)
{
    if (m_PyMethodCache[10]) {
        return this->::QQuickItem::dragEnterEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QQuickItem::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::dragLeaveEvent(::QDragLeaveEvent * arg__1)
{
    if (m_PyMethodCache[11]) {
        return this->::QQuickItem::dragLeaveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QQuickItem::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::dragMoveEvent(::QDragMoveEvent * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QQuickItem::dragMoveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QQuickItem::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::dropEvent(::QDropEvent * arg__1)
{
    if (m_PyMethodCache[13]) {
        return this->::QQuickItem::dropEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QQuickItem::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickPaintedItemWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[14])
        return this->::QQuickItem::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QQuickItem::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QQuickPaintedItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[15])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QQuickPaintedItemWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[16]) {
        return this->::QQuickItem::focusInEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QQuickItem::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[17]) {
        return this->::QQuickItem::focusOutEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QQuickItem::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::geometryChanged(const ::QRectF & newGeometry, const ::QRectF & oldGeometry)
{
    if (m_PyMethodCache[18]) {
        return this->::QQuickItem::geometryChanged(newGeometry, oldGeometry);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "geometryChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QQuickItem::geometryChanged(newGeometry, oldGeometry);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &newGeometry),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &oldGeometry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::hoverEnterEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QQuickItem::hoverEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QQuickItem::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::hoverLeaveEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QQuickItem::hoverLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QQuickItem::hoverLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::hoverMoveEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QQuickItem::hoverMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QQuickItem::hoverMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QQuickItem::inputMethodEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QQuickItem::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QVariant QQuickPaintedItemWrapper::inputMethodQuery(::Qt::InputMethodQuery query) const
{
    if (m_PyMethodCache[23])
        return this->::QQuickItem::inputMethodQuery(query);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QQuickItem::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QQuickPaintedItemWrapper::isTextureProvider() const
{
    if (m_PyMethodCache[24])
        return this->::QQuickPaintedItem::isTextureProvider();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isTextureProvider";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QQuickPaintedItem::isTextureProvider();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.isTextureProvider", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QQuickItem::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QQuickItem::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QQuickItem::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QQuickItem::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QQuickItem::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QQuickItem::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QQuickItem::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QQuickItem::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QQuickItem::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QQuickItem::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[31]) {
        return this->::QQuickItem::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QQuickItem::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::mouseUngrabEvent()
{
    if (m_PyMethodCache[32]) {
        return this->::QQuickItem::mouseUngrabEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseUngrabEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QQuickItem::mouseUngrabEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::paint(::QPainter * painter)
{
    if (m_PyMethodCache[33]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickPaintedItem.paint()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickPaintedItem.paint()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::releaseResources()
{
    if (m_PyMethodCache[34]) {
        return this->::QQuickPaintedItem::releaseResources();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "releaseResources";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QQuickPaintedItem::releaseResources();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSGTextureProvider * QQuickPaintedItemWrapper::textureProvider() const
{
    if (m_PyMethodCache[35])
        return this->::QQuickPaintedItem::textureProvider();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "textureProvider";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QQuickPaintedItem::textureProvider();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTUREPROVIDER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.textureProvider", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGTextureProvider >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSGTextureProvider *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[36]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickPaintedItemWrapper::touchEvent(::QTouchEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QQuickItem::touchEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QQuickItem::touchEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::touchUngrabEvent()
{
    if (m_PyMethodCache[38]) {
        return this->::QQuickItem::touchUngrabEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchUngrabEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QQuickItem::touchUngrabEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSGNode * QQuickPaintedItemWrapper::updatePaintNode(::QSGNode * arg__1, ::QQuickItem::UpdatePaintNodeData * arg__2)
{
    if (m_PyMethodCache[39])
        return this->::QQuickPaintedItem::updatePaintNode(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updatePaintNode";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QQuickPaintedItem::updatePaintNode(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickPaintedItem.updatePaintNode", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGNode >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSGNode *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickPaintedItemWrapper::updatePolish()
{
    if (m_PyMethodCache[40]) {
        return this->::QQuickItem::updatePolish();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updatePolish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QQuickItem::updatePolish();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[41]) {
        return this->::QQuickItem::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QQuickItem::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickPaintedItemWrapper::windowDeactivateEvent()
{
    if (m_PyMethodCache[42]) {
        return this->::QQuickItem::windowDeactivateEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "windowDeactivateEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QQuickItem::windowDeactivateEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QQuickPaintedItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QQuickPaintedItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QQuickPaintedItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QQuickPaintedItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QQuickPaintedItemWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QQuickPaintedItemWrapper *>(this));
        return QQuickPaintedItem::qt_metacast(_clname);
}

QQuickPaintedItemWrapper::~QQuickPaintedItemWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQuickPaintedItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QQuickPaintedItem' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQuickPaintedItem >()))
        return -1;

    ::QQuickPaintedItemWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QQuickPaintedItem", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QQuickPaintedItem::QQuickPaintedItem(QQuickItem*)
    if (numArgs == 0) {
        overloadId = 0; // QQuickPaintedItem(QQuickItem*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QQuickPaintedItem(QQuickItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickPaintedItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0]))))
                        goto Sbk_QQuickPaintedItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QQuickItem *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QQuickPaintedItem(QQuickItem*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QQuickPaintedItemWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QQuickPaintedItemWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQuickPaintedItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQuickPaintedItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QQuickPaintedItem_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QQuickPaintedItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQuickPaintedItemFunc_antialiasing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.antialiasing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // antialiasing()const
            bool cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->antialiasing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_contentsBoundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.contentsBoundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsBoundingRect()const
            QRectF cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->contentsBoundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_contentsScale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.contentsScale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsScale()const
            qreal cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->contentsScale();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_contentsSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.contentsSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsSize()const
            QSize cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->contentsSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_fillColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.fillColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fillColor()const
            QColor cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->fillColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_isTextureProvider(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.isTextureProvider";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTextureProvider()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickPaintedItem *>(cppSelf)->::QQuickPaintedItem::isTextureProvider()
                : const_cast<const ::QQuickPaintedItem *>(cppSelf)->isTextureProvider();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_mipmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.mipmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipmap()const
            bool cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->mipmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_opaquePainting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.opaquePainting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // opaquePainting()const
            bool cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->opaquePainting();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_paint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.paint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::paint(QPainter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArg)))) {
        overloadId = 0; // paint(QPainter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_paint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // paint(QPainter*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQuickPaintedItem.paint()' not implemented.");
                return {};
            }
            cppSelf->paint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_paint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_performanceHints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.performanceHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // performanceHints()const
            QFlags<QQuickPaintedItem::PerformanceHint> cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->performanceHints();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_releaseResources(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.releaseResources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // releaseResources()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickPaintedItem::releaseResources()
                : cppSelf->releaseResources();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickPaintedItemFunc_renderTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.renderTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderTarget()const
            QQuickPaintedItem::RenderTarget cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->renderTarget();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_resetContentsSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.resetContentsSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetContentsSize()
            cppSelf->resetContentsSize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickPaintedItemFunc_setAntialiasing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setAntialiasing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setAntialiasing(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAntialiasing(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setAntialiasing_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAntialiasing(bool)
            cppSelf->setAntialiasing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setAntialiasing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setContentsScale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setContentsScale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setContentsScale(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setContentsScale(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setContentsScale_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContentsScale(qreal)
            cppSelf->setContentsScale(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setContentsScale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setContentsSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setContentsSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setContentsSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setContentsSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setContentsSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setContentsSize(QSize)
            cppSelf->setContentsSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setContentsSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setFillColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setFillColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setFillColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setFillColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setFillColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFillColor(QColor)
            cppSelf->setFillColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setFillColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setMipmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setMipmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setMipmap(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMipmap(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setMipmap_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipmap(bool)
            cppSelf->setMipmap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setMipmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setOpaquePainting(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setOpaquePainting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setOpaquePainting(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOpaquePainting(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setOpaquePainting_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpaquePainting(bool)
            cppSelf->setOpaquePainting(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setOpaquePainting_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setPerformanceHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setPerformanceHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPerformanceHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickPaintedItem::setPerformanceHint(QQuickPaintedItem::PerformanceHint,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPerformanceHint(QQuickPaintedItem::PerformanceHint,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setPerformanceHint(QQuickPaintedItem::PerformanceHint,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_enabled = Shiboken::String::createStaticString("enabled");
            if (PyDict_Contains(kwds, key_enabled)) {
                value = PyDict_GetItem(kwds, key_enabled);
                if (value && pyArgs[1]) {
                    errInfo = key_enabled;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_enabled);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError;
            }
        }
        ::QQuickPaintedItem::PerformanceHint cppArg0 = static_cast< ::QQuickPaintedItem::PerformanceHint>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPerformanceHint(QQuickPaintedItem::PerformanceHint,bool)
            cppSelf->setPerformanceHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setPerformanceHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setPerformanceHints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setPerformanceHints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setPerformanceHints(QFlags<QQuickPaintedItem::PerformanceHint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPerformanceHints(QFlags<QQuickPaintedItem::PerformanceHint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setPerformanceHints_TypeError;

    // Call function/method
    {
        ::QFlags<QQuickPaintedItem::PerformanceHint> cppArg0 = QFlags<QQuickPaintedItem::PerformanceHint>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPerformanceHints(QFlags<QQuickPaintedItem::PerformanceHint>)
            cppSelf->setPerformanceHints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setPerformanceHints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setRenderTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setRenderTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setRenderTarget(QQuickPaintedItem::RenderTarget)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRenderTarget(QQuickPaintedItem::RenderTarget)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setRenderTarget_TypeError;

    // Call function/method
    {
        ::QQuickPaintedItem::RenderTarget cppArg0{QQuickPaintedItem::Image};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRenderTarget(QQuickPaintedItem::RenderTarget)
            cppSelf->setRenderTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setRenderTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_setTextureSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.setTextureSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickPaintedItem::setTextureSize(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setTextureSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_setTextureSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTextureSize(QSize)
            cppSelf->setTextureSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_setTextureSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_textureProvider(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.textureProvider";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureProvider()const
            QSGTextureProvider * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickPaintedItem *>(cppSelf)->::QQuickPaintedItem::textureProvider()
                : const_cast<const ::QQuickPaintedItem *>(cppSelf)->textureProvider();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTUREPROVIDER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_textureSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.textureSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureSize()const
            QSize cppResult = const_cast<const ::QQuickPaintedItem *>(cppSelf)->textureSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickPaintedItemFunc_update(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.update";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickPaintedItemFunc_update_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:update", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QQuickPaintedItem::update(QRect)
    // 1: QQuickItem::update()
    if (numArgs == 0) {
        overloadId = 0; // update(QRect)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // update(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_update_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // update(const QRect & rect)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
                if (PyDict_Contains(kwds, key_rect)) {
                    value = PyDict_GetItem(kwds, key_rect);
                    if (value && pyArgs[0]) {
                        errInfo = key_rect;
                        Py_INCREF(errInfo);
                        goto Sbk_QQuickPaintedItemFunc_update_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QQuickPaintedItemFunc_update_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rect);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QQuickPaintedItemFunc_update_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRect cppArg0_local = QRect();
            ::QRect *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // update(QRect)
                cppSelf->update(*cppArg0);
            }
            break;
        }
        case 1: // update()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QQuickPaintedItemFunc_update_TypeError;
            }

            if (!PyErr_Occurred()) {
                // update()
                reinterpret_cast<QQuickItem *>(cppSelf)->update();
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickPaintedItemFunc_update_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickPaintedItemFunc_updatePaintNode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickPaintedItem.updatePaintNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updatePaintNode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickPaintedItemFunc_updatePaintNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QQuickItem::UpdatePaintNodeData *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
            QSGNode * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickPaintedItem::updatePaintNode(cppArg0, cppArg1)
                : cppSelf->updatePaintNode(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickPaintedItemFunc_updatePaintNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQuickPaintedItem_PropertyStrings[] = {
    "contentsScale::",
    "contentsSize::",
    "fillColor::",
    "renderTarget::",
    "textureSize::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQuickPaintedItem_methods[] = {
    {"antialiasing", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_antialiasing), METH_NOARGS},
    {"contentsBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_contentsBoundingRect), METH_NOARGS},
    {"contentsScale", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_contentsScale), METH_NOARGS},
    {"contentsSize", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_contentsSize), METH_NOARGS},
    {"fillColor", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_fillColor), METH_NOARGS},
    {"isTextureProvider", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_isTextureProvider), METH_NOARGS},
    {"mipmap", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_mipmap), METH_NOARGS},
    {"opaquePainting", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_opaquePainting), METH_NOARGS},
    {"paint", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_paint), METH_O},
    {"performanceHints", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_performanceHints), METH_NOARGS},
    {"releaseResources", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_releaseResources), METH_NOARGS},
    {"renderTarget", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_renderTarget), METH_NOARGS},
    {"resetContentsSize", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_resetContentsSize), METH_NOARGS},
    {"setAntialiasing", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setAntialiasing), METH_O},
    {"setContentsScale", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setContentsScale), METH_O},
    {"setContentsSize", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setContentsSize), METH_O},
    {"setFillColor", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setFillColor), METH_O},
    {"setMipmap", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setMipmap), METH_O},
    {"setOpaquePainting", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setOpaquePainting), METH_O},
    {"setPerformanceHint", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setPerformanceHint), METH_VARARGS|METH_KEYWORDS},
    {"setPerformanceHints", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setPerformanceHints), METH_O},
    {"setRenderTarget", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setRenderTarget), METH_O},
    {"setTextureSize", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_setTextureSize), METH_O},
    {"textureProvider", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_textureProvider), METH_NOARGS},
    {"textureSize", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_textureSize), METH_NOARGS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_update), METH_VARARGS|METH_KEYWORDS},
    {"updatePaintNode", reinterpret_cast<PyCFunction>(Sbk_QQuickPaintedItemFunc_updatePaintNode), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQuickPaintedItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQuickPaintedItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQuickPaintedItemWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQuickPaintedItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQuickPaintedItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QQuickPaintedItemSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QQuickPaintedItem *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]))
        return static_cast< ::QQuickItem *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPARSERSTATUS_IDX]))
        return static_cast< ::QQmlParserStatus *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQuickPaintedItem_Type = nullptr;
static SbkObjectType *Sbk_QQuickPaintedItem_TypeF(void)
{
    return _Sbk_QQuickPaintedItem_Type;
}

static PyType_Slot Sbk_QQuickPaintedItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQuickPaintedItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQuickPaintedItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQuickPaintedItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQuickPaintedItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQuickPaintedItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQuickPaintedItem_spec = {
    "2:PySide2.QtQuick.QQuickPaintedItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQuickPaintedItem_slots
};

} //extern "C"

static void *Sbk_QQuickPaintedItem_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QQuickPaintedItem *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QQmlParserStatus >()))
        return dynamic_cast< ::QQuickPaintedItem *>(reinterpret_cast< ::QQmlParserStatus *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___and__(PyObject *self, PyObject *pyArg)
{
    ::QQuickPaintedItem::PerformanceHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___or__(PyObject *self, PyObject *pyArg)
{
    ::QQuickPaintedItem::PerformanceHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::QQuickPaintedItem::PerformanceHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickPaintedItem::PerformanceHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::QQuickPaintedItem::PerformanceHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, self, &cppSelf);
    ::QQuickPaintedItem::PerformanceHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QQuickPaintedItem_RenderTarget_PythonToCpp_QQuickPaintedItem_RenderTarget(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickPaintedItem::RenderTarget *>(cppOut) =
        static_cast<::QQuickPaintedItem::RenderTarget>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickPaintedItem_RenderTarget_PythonToCpp_QQuickPaintedItem_RenderTarget_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX]))
        return QQuickPaintedItem_RenderTarget_PythonToCpp_QQuickPaintedItem_RenderTarget;
    return {};
}
static PyObject *QQuickPaintedItem_RenderTarget_CppToPython_QQuickPaintedItem_RenderTarget(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickPaintedItem::RenderTarget *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX], castCppIn);

}

static void QQuickPaintedItem_PerformanceHint_PythonToCpp_QQuickPaintedItem_PerformanceHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickPaintedItem::PerformanceHint *>(cppOut) =
        static_cast<::QQuickPaintedItem::PerformanceHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickPaintedItem_PerformanceHint_PythonToCpp_QQuickPaintedItem_PerformanceHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]))
        return QQuickPaintedItem_PerformanceHint_PythonToCpp_QQuickPaintedItem_PerformanceHint;
    return {};
}
static PyObject *QQuickPaintedItem_PerformanceHint_CppToPython_QQuickPaintedItem_PerformanceHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickPaintedItem::PerformanceHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX], castCppIn);

}

static void QFlags_QQuickPaintedItem_PerformanceHint__PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickPaintedItem::PerformanceHint> *>(cppOut) =
        ::QFlags<QQuickPaintedItem::PerformanceHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QQuickPaintedItem_PerformanceHint__PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]))
        return QFlags_QQuickPaintedItem_PerformanceHint__PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_;
    return {};
}
static PyObject *QFlags_QQuickPaintedItem_PerformanceHint__CppToPython_QFlags_QQuickPaintedItem_PerformanceHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QQuickPaintedItem::PerformanceHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]));

}

static void QQuickPaintedItem_PerformanceHint_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickPaintedItem::PerformanceHint> *>(cppOut) =
        ::QFlags<QQuickPaintedItem::PerformanceHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QQuickPaintedItem_PerformanceHint_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]))
        return QQuickPaintedItem_PerformanceHint_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_;
    return {};
}
static void number_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QQuickPaintedItem::PerformanceHint> *>(cppOut) =
        ::QFlags<QQuickPaintedItem::PerformanceHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]))
        return number_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQuickPaintedItem_PythonToCpp_QQuickPaintedItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQuickPaintedItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQuickPaintedItem_PythonToCpp_QQuickPaintedItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickPaintedItem_TypeF())))
        return QQuickPaintedItem_PythonToCpp_QQuickPaintedItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQuickPaintedItem_PTR_CppToPython_QQuickPaintedItem(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QQuickPaintedItem *>(const_cast<void *>(cppIn)), Sbk_QQuickPaintedItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQuickPaintedItem_SignatureStrings[] = {
    "PySide2.QtQuick.QQuickPaintedItem(self,parent:PySide2.QtQuick.QQuickItem=nullptr)",
    "PySide2.QtQuick.QQuickPaintedItem.antialiasing(self)->bool",
    "PySide2.QtQuick.QQuickPaintedItem.contentsBoundingRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickPaintedItem.contentsScale(self)->qreal",
    "PySide2.QtQuick.QQuickPaintedItem.contentsSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtQuick.QQuickPaintedItem.fillColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtQuick.QQuickPaintedItem.isTextureProvider(self)->bool",
    "PySide2.QtQuick.QQuickPaintedItem.mipmap(self)->bool",
    "PySide2.QtQuick.QQuickPaintedItem.opaquePainting(self)->bool",
    "PySide2.QtQuick.QQuickPaintedItem.paint(self,painter:PySide2.QtGui.QPainter)",
    "PySide2.QtQuick.QQuickPaintedItem.performanceHints(self)->PySide2.QtQuick.QQuickPaintedItem.PerformanceHints",
    "PySide2.QtQuick.QQuickPaintedItem.releaseResources(self)",
    "PySide2.QtQuick.QQuickPaintedItem.renderTarget(self)->PySide2.QtQuick.QQuickPaintedItem.RenderTarget",
    "PySide2.QtQuick.QQuickPaintedItem.resetContentsSize(self)",
    "PySide2.QtQuick.QQuickPaintedItem.setAntialiasing(self,enable:bool)",
    "PySide2.QtQuick.QQuickPaintedItem.setContentsScale(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickPaintedItem.setContentsSize(self,arg__1:PySide2.QtCore.QSize)",
    "PySide2.QtQuick.QQuickPaintedItem.setFillColor(self,arg__1:PySide2.QtGui.QColor)",
    "PySide2.QtQuick.QQuickPaintedItem.setMipmap(self,enable:bool)",
    "PySide2.QtQuick.QQuickPaintedItem.setOpaquePainting(self,opaque:bool)",
    "PySide2.QtQuick.QQuickPaintedItem.setPerformanceHint(self,hint:PySide2.QtQuick.QQuickPaintedItem.PerformanceHint,enabled:bool=true)",
    "PySide2.QtQuick.QQuickPaintedItem.setPerformanceHints(self,hints:PySide2.QtQuick.QQuickPaintedItem.PerformanceHints)",
    "PySide2.QtQuick.QQuickPaintedItem.setRenderTarget(self,target:PySide2.QtQuick.QQuickPaintedItem.RenderTarget)",
    "PySide2.QtQuick.QQuickPaintedItem.setTextureSize(self,size:PySide2.QtCore.QSize)",
    "PySide2.QtQuick.QQuickPaintedItem.textureProvider(self)->PySide2.QtQuick.QSGTextureProvider",
    "PySide2.QtQuick.QQuickPaintedItem.textureSize(self)->PySide2.QtCore.QSize",
    "1:PySide2.QtQuick.QQuickPaintedItem.update(self,rect:PySide2.QtCore.QRect=QRect())",
    "0:PySide2.QtQuick.QQuickPaintedItem.update(self)",
    "PySide2.QtQuick.QQuickPaintedItem.updatePaintNode(self,arg__1:PySide2.QtQuick.QSGNode,arg__2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData)->PySide2.QtQuick.QSGNode",
    nullptr}; // Sentinel

void init_QQuickPaintedItem(PyObject *module)
{
    _Sbk_QQuickPaintedItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQuickPaintedItem",
        "QQuickPaintedItem*",
        &Sbk_QQuickPaintedItem_spec,
        &Shiboken::callCppDestructor< ::QQuickPaintedItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQuickPaintedItem_Type);
    InitSignatureStrings(pyType, QQuickPaintedItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQuickPaintedItem_Type), Sbk_QQuickPaintedItem_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQuickPaintedItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQuickPaintedItem_TypeF(),
        QQuickPaintedItem_PythonToCpp_QQuickPaintedItem_PTR,
        is_QQuickPaintedItem_PythonToCpp_QQuickPaintedItem_PTR_Convertible,
        QQuickPaintedItem_PTR_CppToPython_QQuickPaintedItem);

    Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem");
    Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickPaintedItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickPaintedItemWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QQuickPaintedItem_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QQuickPaintedItem_TypeF(), &Sbk_QQuickPaintedItemSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QQuickPaintedItem_TypeF(), &Sbk_QQuickPaintedItem_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'RenderTarget'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickPaintedItem_TypeF(),
        "RenderTarget",
        "2:PySide2.QtQuick.QQuickPaintedItem.RenderTarget",
        "QQuickPaintedItem::RenderTarget");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX],
        Sbk_QQuickPaintedItem_TypeF(), "Image", (long) QQuickPaintedItem::RenderTarget::Image))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX],
        Sbk_QQuickPaintedItem_TypeF(), "FramebufferObject", (long) QQuickPaintedItem::RenderTarget::FramebufferObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX],
        Sbk_QQuickPaintedItem_TypeF(), "InvertedYFramebufferObject", (long) QQuickPaintedItem::RenderTarget::InvertedYFramebufferObject))
        return;
    // Register converter for enum 'QQuickPaintedItem::RenderTarget'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX],
            QQuickPaintedItem_RenderTarget_CppToPython_QQuickPaintedItem_RenderTarget);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickPaintedItem_RenderTarget_PythonToCpp_QQuickPaintedItem_RenderTarget,
            is_QQuickPaintedItem_RenderTarget_PythonToCpp_QQuickPaintedItem_RenderTarget_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_RENDERTARGET_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem::RenderTarget");
        Shiboken::Conversions::registerConverterName(converter, "RenderTarget");
    }
    // End of 'RenderTarget' enum.

    // Initialization of enum 'PerformanceHint'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QQuickPaintedItem.PerformanceHints", SbkPySide2_QtQuick_QQuickPaintedItem_PerformanceHint_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickPaintedItem_TypeF(),
        "PerformanceHint",
        "2:PySide2.QtQuick.QQuickPaintedItem.PerformanceHint",
        "QQuickPaintedItem::PerformanceHint",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX],
        Sbk_QQuickPaintedItem_TypeF(), "FastFBOResizing", (long) QQuickPaintedItem::PerformanceHint::FastFBOResizing))
        return;
    // Register converter for enum 'QQuickPaintedItem::PerformanceHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX],
            QQuickPaintedItem_PerformanceHint_CppToPython_QQuickPaintedItem_PerformanceHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickPaintedItem_PerformanceHint_PythonToCpp_QQuickPaintedItem_PerformanceHint,
            is_QQuickPaintedItem_PerformanceHint_PythonToCpp_QQuickPaintedItem_PerformanceHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem::PerformanceHint");
        Shiboken::Conversions::registerConverterName(converter, "PerformanceHint");
    }
    // Register converter for flag 'QFlags<QQuickPaintedItem::PerformanceHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX],
            QFlags_QQuickPaintedItem_PerformanceHint__CppToPython_QFlags_QQuickPaintedItem_PerformanceHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickPaintedItem_PerformanceHint_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_,
            is_QQuickPaintedItem_PerformanceHint_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QQuickPaintedItem_PerformanceHint__PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_,
            is_QFlags_QQuickPaintedItem_PerformanceHint__PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint_,
            is_number_PythonToCpp_QFlags_QQuickPaintedItem_PerformanceHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKPAINTEDITEM_PERFORMANCEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickPaintedItem::PerformanceHints");
        Shiboken::Conversions::registerConverterName(converter, "PerformanceHints");
    }
    // End of 'PerformanceHint' enum/flags.

    PySide::Signal::registerSignals(Sbk_QQuickPaintedItem_TypeF(), &::QQuickPaintedItem::staticMetaObject);
    qRegisterMetaType< ::QQuickPaintedItem::RenderTarget >("QQuickPaintedItem::RenderTarget");
    qRegisterMetaType< ::QQuickPaintedItem::PerformanceHint >("QQuickPaintedItem::PerformanceHint");
    qRegisterMetaType< ::QQuickPaintedItem::PerformanceHints >("QQuickPaintedItem::PerformanceHints");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QQuickPaintedItem_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QQuickPaintedItem_TypeF(), &::QQuickPaintedItem::staticMetaObject, sizeof(QQuickPaintedItemWrapper));
}
