/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmldebuggingenabler_wrapper.h"

// inner classes

// Extra includes
#include <pysideqflags.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlDebuggingEnabler_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlDebuggingEnabler >()))
        return -1;

    ::QQmlDebuggingEnabler *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnabler_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QQmlDebuggingEnabler", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QQmlDebuggingEnabler::QQmlDebuggingEnabler(bool)
    if (numArgs == 0) {
        overloadId = 0; // QQmlDebuggingEnabler(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // QQmlDebuggingEnabler(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlDebuggingEnabler_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_printWarning = Shiboken::String::createStaticString("printWarning");
            if (PyDict_Contains(kwds, key_printWarning)) {
                value = PyDict_GetItem(kwds, key_printWarning);
                if (value && pyArgs[0]) {
                    errInfo = key_printWarning;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlDebuggingEnabler_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QQmlDebuggingEnabler_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_printWarning);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlDebuggingEnabler_Init_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QQmlDebuggingEnabler(bool)
            cptr = new ::QQmlDebuggingEnabler(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlDebuggingEnabler >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQmlDebuggingEnabler_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QQmlDebuggingEnabler_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.connectToLocalDebugger";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:connectToLocalDebugger", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QQmlDebuggingEnabler::connectToLocalDebugger(QString,QQmlDebuggingEnabler::StartMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // connectToLocalDebugger(QString,QQmlDebuggingEnabler::StartMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // connectToLocalDebugger(QString,QQmlDebuggingEnabler::StartMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QQmlDebuggingEnabler::StartMode cppArg1 = QQmlDebuggingEnabler::StartMode::DoNotWaitForClient;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // connectToLocalDebugger(QString,QQmlDebuggingEnabler::StartMode)
            bool cppResult = ::QQmlDebuggingEnabler::connectToLocalDebugger(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_debuggerServices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.debuggerServices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // debuggerServices()
            QStringList cppResult = ::QQmlDebuggingEnabler::debuggerServices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_inspectorServices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.inspectorServices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inspectorServices()
            QStringList cppResult = ::QQmlDebuggingEnabler::inspectorServices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_nativeDebuggerServices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.nativeDebuggerServices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeDebuggerServices()
            QStringList cppResult = ::QQmlDebuggingEnabler::nativeDebuggerServices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_profilerServices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.profilerServices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profilerServices()
            QStringList cppResult = ::QQmlDebuggingEnabler::profilerServices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_setServices(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.setServices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QQmlDebuggingEnabler::setServices(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setServices(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlDebuggingEnablerFunc_setServices_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setServices(QStringList)
            ::QQmlDebuggingEnabler::setServices(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlDebuggingEnablerFunc_setServices_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_startDebugConnector(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.startDebugConnector";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:startDebugConnector", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QQmlDebuggingEnabler::startDebugConnector(QString,QHash<QString,QVariant>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startDebugConnector(QString,QHash<QString,QVariant>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX], (pyArgs[1])))) {
            overloadId = 0; // startDebugConnector(QString,QHash<QString,QVariant>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_configuration = Shiboken::String::createStaticString("configuration");
            if (PyDict_Contains(kwds, key_configuration)) {
                value = PyDict_GetItem(kwds, key_configuration);
                if (value && pyArgs[1]) {
                    errInfo = key_configuration;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QHASH_QSTRING_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_configuration);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QHash<QString,QVariant > cppArg1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // startDebugConnector(QString,QHash<QString,QVariant>)
            bool cppResult = ::QQmlDebuggingEnabler::startDebugConnector(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlDebuggingEnablerFunc_startDebugConnector_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlDebuggingEnabler.startTcpDebugServer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:startTcpDebugServer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QQmlDebuggingEnabler::startTcpDebugServer(int,QQmlDebuggingEnabler::StartMode,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // startTcpDebugServer(int,QQmlDebuggingEnabler::StartMode,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // startTcpDebugServer(int,QQmlDebuggingEnabler::StartMode,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                overloadId = 0; // startTcpDebugServer(int,QQmlDebuggingEnabler::StartMode,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            static PyObject *const key_hostName = Shiboken::String::createStaticString("hostName");
            if (PyDict_Contains(kwds, key_hostName)) {
                value = PyDict_GetItem(kwds, key_hostName);
                if (value && pyArgs[2]) {
                    errInfo = key_hostName;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hostName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QQmlDebuggingEnabler::StartMode cppArg1 = QQmlDebuggingEnabler::StartMode::DoNotWaitForClient;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // startTcpDebugServer(int,QQmlDebuggingEnabler::StartMode,QString)
            bool cppResult = ::QQmlDebuggingEnabler::startTcpDebugServer(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlDebuggingEnabler_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlDebuggingEnabler_methods[] = {
    {"connectToLocalDebugger", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_connectToLocalDebugger), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"debuggerServices", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_debuggerServices), METH_NOARGS|METH_STATIC},
    {"inspectorServices", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_inspectorServices), METH_NOARGS|METH_STATIC},
    {"nativeDebuggerServices", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_nativeDebuggerServices), METH_NOARGS|METH_STATIC},
    {"profilerServices", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_profilerServices), METH_NOARGS|METH_STATIC},
    {"setServices", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_setServices), METH_O|METH_STATIC},
    {"startDebugConnector", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_startDebugConnector), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"startTcpDebugServer", reinterpret_cast<PyCFunction>(Sbk_QQmlDebuggingEnablerFunc_startTcpDebugServer), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QQmlDebuggingEnabler_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlDebuggingEnabler_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlDebuggingEnabler_Type = nullptr;
static SbkObjectType *Sbk_QQmlDebuggingEnabler_TypeF(void)
{
    return _Sbk_QQmlDebuggingEnabler_Type;
}

static PyType_Slot Sbk_QQmlDebuggingEnabler_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlDebuggingEnabler_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlDebuggingEnabler_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlDebuggingEnabler_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlDebuggingEnabler_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlDebuggingEnabler_spec = {
    "2:PySide2.QtQml.QQmlDebuggingEnabler",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlDebuggingEnabler_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlDebuggingEnabler_StartMode_PythonToCpp_QQmlDebuggingEnabler_StartMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlDebuggingEnabler::StartMode *>(cppOut) =
        static_cast<::QQmlDebuggingEnabler::StartMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlDebuggingEnabler_StartMode_PythonToCpp_QQmlDebuggingEnabler_StartMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX]))
        return QQmlDebuggingEnabler_StartMode_PythonToCpp_QQmlDebuggingEnabler_StartMode;
    return {};
}
static PyObject *QQmlDebuggingEnabler_StartMode_CppToPython_QQmlDebuggingEnabler_StartMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlDebuggingEnabler::StartMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlDebuggingEnabler_PythonToCpp_QQmlDebuggingEnabler_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlDebuggingEnabler_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlDebuggingEnabler_PythonToCpp_QQmlDebuggingEnabler_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlDebuggingEnabler_TypeF())))
        return QQmlDebuggingEnabler_PythonToCpp_QQmlDebuggingEnabler_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlDebuggingEnabler_PTR_CppToPython_QQmlDebuggingEnabler(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlDebuggingEnabler *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlDebuggingEnabler_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlDebuggingEnabler_SignatureStrings[] = {
    "PySide2.QtQml.QQmlDebuggingEnabler(self,printWarning:bool=true)",
    "PySide2.QtQml.QQmlDebuggingEnabler.connectToLocalDebugger(socketFileName:QString,mode:PySide2.QtQml.QQmlDebuggingEnabler.StartMode=DoNotWaitForClient)->bool",
    "PySide2.QtQml.QQmlDebuggingEnabler.debuggerServices()->QStringList",
    "PySide2.QtQml.QQmlDebuggingEnabler.inspectorServices()->QStringList",
    "PySide2.QtQml.QQmlDebuggingEnabler.nativeDebuggerServices()->QStringList",
    "PySide2.QtQml.QQmlDebuggingEnabler.profilerServices()->QStringList",
    "PySide2.QtQml.QQmlDebuggingEnabler.setServices(services:QStringList)",
    "PySide2.QtQml.QQmlDebuggingEnabler.startDebugConnector(pluginName:QString,configuration:QHash[QString, QVariant]=QVariantHash())->bool",
    "PySide2.QtQml.QQmlDebuggingEnabler.startTcpDebugServer(port:int,mode:PySide2.QtQml.QQmlDebuggingEnabler.StartMode=DoNotWaitForClient,hostName:QString=QString())->bool",
    nullptr}; // Sentinel

void init_QQmlDebuggingEnabler(PyObject *module)
{
    _Sbk_QQmlDebuggingEnabler_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlDebuggingEnabler",
        "QQmlDebuggingEnabler*",
        &Sbk_QQmlDebuggingEnabler_spec,
        &Shiboken::callCppDestructor< ::QQmlDebuggingEnabler >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlDebuggingEnabler_Type);
    InitSignatureStrings(pyType, QQmlDebuggingEnabler_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlDebuggingEnabler_Type), Sbk_QQmlDebuggingEnabler_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlDebuggingEnabler_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlDebuggingEnabler_TypeF(),
        QQmlDebuggingEnabler_PythonToCpp_QQmlDebuggingEnabler_PTR,
        is_QQmlDebuggingEnabler_PythonToCpp_QQmlDebuggingEnabler_PTR_Convertible,
        QQmlDebuggingEnabler_PTR_CppToPython_QQmlDebuggingEnabler);

    Shiboken::Conversions::registerConverterName(converter, "QQmlDebuggingEnabler");
    Shiboken::Conversions::registerConverterName(converter, "QQmlDebuggingEnabler*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlDebuggingEnabler&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlDebuggingEnabler).name());


    // Initialization of enums.

    // Initialization of enum 'StartMode'.
    SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlDebuggingEnabler_TypeF(),
        "StartMode",
        "2:PySide2.QtQml.QQmlDebuggingEnabler.StartMode",
        "QQmlDebuggingEnabler::StartMode");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX],
        Sbk_QQmlDebuggingEnabler_TypeF(), "DoNotWaitForClient", (long) QQmlDebuggingEnabler::StartMode::DoNotWaitForClient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX],
        Sbk_QQmlDebuggingEnabler_TypeF(), "WaitForClient", (long) QQmlDebuggingEnabler::StartMode::WaitForClient))
        return;
    // Register converter for enum 'QQmlDebuggingEnabler::StartMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX],
            QQmlDebuggingEnabler_StartMode_CppToPython_QQmlDebuggingEnabler_StartMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlDebuggingEnabler_StartMode_PythonToCpp_QQmlDebuggingEnabler_StartMode,
            is_QQmlDebuggingEnabler_StartMode_PythonToCpp_QQmlDebuggingEnabler_StartMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLDEBUGGINGENABLER_STARTMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlDebuggingEnabler::StartMode");
        Shiboken::Conversions::registerConverterName(converter, "StartMode");
    }
    // End of 'StartMode' enum.

    qRegisterMetaType< ::QQmlDebuggingEnabler::StartMode >("QQmlDebuggingEnabler::StartMode");
}
