/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qjsengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QJSEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QJSEngineWrapper::QJSEngineWrapper() : QJSEngine()
{
    resetPyMethodCache();
    // ... middle
}

QJSEngineWrapper::QJSEngineWrapper(::QObject * parent) : QJSEngine(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QJSEngineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QJSEngineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QJSEngineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QJSEngineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QJSEngineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QJSEngine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QJSEngineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QJSEngine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QJSEngineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QJSEngineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QJSEngine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QJSEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QJSEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QJSEngineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QJSEngineWrapper *>(this));
        return QJSEngine::qt_metacast(_clname);
}

QJSEngineWrapper::~QJSEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QJSEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QJSEngine >()))
        return -1;

    ::QJSEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QJSEngine", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QJSEngine::QJSEngine()
    // 1: QJSEngine::QJSEngine(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QJSEngine()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QJSEngine(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngine_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QJSEngine()
        {

            if (!PyErr_Occurred()) {
                // QJSEngine()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QJSEngineWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QJSEngineWrapper();
                }

            }
            break;
        }
        case 1: // QJSEngine(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSEngine(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QJSEngineWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QJSEngineWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QJSEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QJSEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QJSEngine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QJSEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QJSEngineFunc_collectGarbage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.collectGarbage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // collectGarbage()
            cppSelf->collectGarbage();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QJSEngineFunc_evaluate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.evaluate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_evaluate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_evaluate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:evaluate", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::evaluate(QString,QString,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // evaluate(QString,QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // evaluate(QString,QString,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // evaluate(QString,QString,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_evaluate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fileName = Shiboken::String::createStaticString("fileName");
            if (PyDict_Contains(kwds, key_fileName)) {
                value = PyDict_GetItem(kwds, key_fileName);
                if (value && pyArgs[1]) {
                    errInfo = key_fileName;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_evaluate_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QJSEngineFunc_evaluate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fileName);
            }
            static PyObject *const key_lineNumber = Shiboken::String::createStaticString("lineNumber");
            if (PyDict_Contains(kwds, key_lineNumber)) {
                value = PyDict_GetItem(kwds, key_lineNumber);
                if (value && pyArgs[2]) {
                    errInfo = key_lineNumber;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_evaluate_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QJSEngineFunc_evaluate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_lineNumber);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSEngineFunc_evaluate_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // evaluate(QString,QString,int)
            QJSValue cppResult = cppSelf->evaluate(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_evaluate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_globalObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.globalObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalObject()const
            QJSValue cppResult = const_cast<const ::QJSEngine *>(cppSelf)->globalObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSEngineFunc_importModule(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.importModule";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::importModule(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // importModule(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_importModule_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // importModule(QString)
            QJSValue cppResult = cppSelf->importModule(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_importModule_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_installExtensions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.installExtensions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_installExtensions_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_installExtensions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:installExtensions", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::installExtensions(QFlags<QJSEngine::Extension>,QJSValue)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // installExtensions(QFlags<QJSEngine::Extension>,QJSValue)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // installExtensions(QFlags<QJSEngine::Extension>,QJSValue)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_installExtensions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_object = Shiboken::String::createStaticString("object");
            if (PyDict_Contains(kwds, key_object)) {
                value = PyDict_GetItem(kwds, key_object);
                if (value && pyArgs[1]) {
                    errInfo = key_object;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_installExtensions_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[1]))))
                        goto Sbk_QJSEngineFunc_installExtensions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_object);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSEngineFunc_installExtensions_TypeError;
            }
        }
        ::QFlags<QJSEngine::Extension> cppArg0 = QFlags<QJSEngine::Extension>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QJSValue cppArg1_local = QJSValue();
        ::QJSValue *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // installExtensions(QFlags<QJSEngine::Extension>,QJSValue)
            cppSelf->installExtensions(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSEngineFunc_installExtensions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_installTranslatorFunctions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.installTranslatorFunctions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:installTranslatorFunctions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::installTranslatorFunctions(QJSValue)
    if (numArgs == 0) {
        overloadId = 0; // installTranslatorFunctions(QJSValue)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // installTranslatorFunctions(QJSValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_object = Shiboken::String::createStaticString("object");
            if (PyDict_Contains(kwds, key_object)) {
                value = PyDict_GetItem(kwds, key_object);
                if (value && pyArgs[0]) {
                    errInfo = key_object;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[0]))))
                        goto Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_object);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QJSValue cppArg0_local = QJSValue();
        ::QJSValue *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // installTranslatorFunctions(QJSValue)
            cppSelf->installTranslatorFunctions(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSEngineFunc_installTranslatorFunctions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_isInterrupted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.isInterrupted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInterrupted()const
            bool cppResult = const_cast<const ::QJSEngine *>(cppSelf)->isInterrupted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSEngineFunc_newArray(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.newArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_newArray_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:newArray", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::newArray(uint)
    if (numArgs == 0) {
        overloadId = 0; // newArray(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // newArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_newArray_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_length = Shiboken::String::createStaticString("length");
            if (PyDict_Contains(kwds, key_length)) {
                value = PyDict_GetItem(kwds, key_length);
                if (value && pyArgs[0]) {
                    errInfo = key_length;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_newArray_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))
                        goto Sbk_QJSEngineFunc_newArray_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_length);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSEngineFunc_newArray_TypeError;
            }
        }
        uint cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // newArray(uint)
            QJSValue cppResult = cppSelf->newArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_newArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_newErrorObject(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.newErrorObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_newErrorObject_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_newErrorObject_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:newErrorObject", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::newErrorObject(QJSValue::ErrorType,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // newErrorObject(QJSValue::ErrorType,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // newErrorObject(QJSValue::ErrorType,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_newErrorObject_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_message = Shiboken::String::createStaticString("message");
            if (PyDict_Contains(kwds, key_message)) {
                value = PyDict_GetItem(kwds, key_message);
                if (value && pyArgs[1]) {
                    errInfo = key_message;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSEngineFunc_newErrorObject_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QJSEngineFunc_newErrorObject_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_message);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSEngineFunc_newErrorObject_TypeError;
            }
        }
        ::QJSValue::ErrorType cppArg0{QJSValue::NoError};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // newErrorObject(QJSValue::ErrorType,QString)
            QJSValue cppResult = cppSelf->newErrorObject(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_newErrorObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_newObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.newObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // newObject()
            QJSValue cppResult = cppSelf->newObject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSEngineFunc_newQMetaObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.newQMetaObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::newQMetaObject(const QMetaObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // newQMetaObject(const QMetaObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_newQMetaObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMetaObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // newQMetaObject(const QMetaObject*)
            QJSValue cppResult = cppSelf->newQMetaObject(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_newQMetaObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_newQObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.newQObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::newQObject(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // newQObject(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_newQObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // newQObject(QObject*)
            QJSValue cppResult = cppSelf->newQObject(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_newQObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_setInterrupted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.setInterrupted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::setInterrupted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setInterrupted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_setInterrupted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInterrupted(bool)
            cppSelf->setInterrupted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSEngineFunc_setInterrupted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_setUiLanguage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.setUiLanguage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::setUiLanguage(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setUiLanguage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_setUiLanguage_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUiLanguage(QString)
            cppSelf->setUiLanguage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSEngineFunc_setUiLanguage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_throwError(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.throwError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_throwError_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJSEngineFunc_throwError_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:throwError", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QJSEngine::throwError(QJSValue::ErrorType,QString)
    // 1: QJSEngine::throwError(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // throwError(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // throwError(QJSValue::ErrorType,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // throwError(QJSValue::ErrorType,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_throwError_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // throwError(QJSValue::ErrorType errorType, const QString & message)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_message = Shiboken::String::createStaticString("message");
                if (PyDict_Contains(kwds, key_message)) {
                    value = PyDict_GetItem(kwds, key_message);
                    if (value && pyArgs[1]) {
                        errInfo = key_message;
                        Py_INCREF(errInfo);
                        goto Sbk_QJSEngineFunc_throwError_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QJSEngineFunc_throwError_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_message);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QJSEngineFunc_throwError_TypeError;
                }
            }
            ::QJSValue::ErrorType cppArg0{QJSValue::NoError};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // throwError(QJSValue::ErrorType,QString)
                cppSelf->throwError(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // throwError(const QString & message)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSEngineFunc_throwError_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // throwError(QString)
                cppSelf->throwError(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSEngineFunc_throwError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_toScriptValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.toScriptValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSEngine::toScriptValue(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // toScriptValue(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSEngineFunc_toScriptValue_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // toScriptValue(QVariant)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtqml.cpp (qjsengine-toscriptvalue)]
            ::QJSValue retval = cppSelf->toScriptValue(cppArg0);
            return Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &retval);
            // END of custom code block [file: ../glue/qtqml.cpp (qjsengine-toscriptvalue)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSEngineFunc_toScriptValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSEngineFunc_uiLanguage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSEngine.uiLanguage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uiLanguage()const
            QString cppResult = const_cast<const ::QJSEngine *>(cppSelf)->uiLanguage();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QJSEngine_PropertyStrings[] = {
    "uiLanguage::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QJSEngine_methods[] = {
    {"collectGarbage", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_collectGarbage), METH_NOARGS},
    {"evaluate", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_evaluate), METH_VARARGS|METH_KEYWORDS},
    {"globalObject", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_globalObject), METH_NOARGS},
    {"importModule", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_importModule), METH_O},
    {"installExtensions", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_installExtensions), METH_VARARGS|METH_KEYWORDS},
    {"installTranslatorFunctions", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_installTranslatorFunctions), METH_VARARGS|METH_KEYWORDS},
    {"isInterrupted", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_isInterrupted), METH_NOARGS},
    {"newArray", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_newArray), METH_VARARGS|METH_KEYWORDS},
    {"newErrorObject", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_newErrorObject), METH_VARARGS|METH_KEYWORDS},
    {"newObject", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_newObject), METH_NOARGS},
    {"newQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_newQMetaObject), METH_O},
    {"newQObject", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_newQObject), METH_O},
    {"setInterrupted", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_setInterrupted), METH_O},
    {"setUiLanguage", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_setUiLanguage), METH_O},
    {"throwError", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_throwError), METH_VARARGS|METH_KEYWORDS},
    {"toScriptValue", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_toScriptValue), METH_O},
    {"uiLanguage", reinterpret_cast<PyCFunction>(Sbk_QJSEngineFunc_uiLanguage), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QJSEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QJSEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QJSEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QJSEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QJSEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QJSEngine_Type = nullptr;
static SbkObjectType *Sbk_QJSEngine_TypeF(void)
{
    return _Sbk_QJSEngine_Type;
}

static PyType_Slot Sbk_QJSEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QJSEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QJSEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QJSEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QJSEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QJSEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QJSEngine_spec = {
    "2:PySide2.QtQml.QJSEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QJSEngine_slots
};

} //extern "C"

static void *Sbk_QJSEngine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QJSEngine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQml_QJSEngine_Extension___and__(PyObject *self, PyObject *pyArg)
{
    ::QJSEngine::Extensions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QJSEngine_Extension___or__(PyObject *self, PyObject *pyArg)
{
    ::QJSEngine::Extensions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QJSEngine_Extension___xor__(PyObject *self, PyObject *pyArg)
{
    ::QJSEngine::Extensions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QJSEngine::Extensions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QJSEngine::Extensions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQml_QJSEngine_Extension___invert__(PyObject *self, PyObject *pyArg)
{
    ::QJSEngine::Extensions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, self, &cppSelf);
    ::QJSEngine::Extensions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQml_QJSEngine_Extension_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQml_QJSEngine_Extension__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQml_QJSEngine_Extension_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQml_QJSEngine_Extension_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QJSEngine_Extension_PythonToCpp_QJSEngine_Extension(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJSEngine::Extension *>(cppOut) =
        static_cast<::QJSEngine::Extension>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJSEngine_Extension_PythonToCpp_QJSEngine_Extension_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX]))
        return QJSEngine_Extension_PythonToCpp_QJSEngine_Extension;
    return {};
}
static PyObject *QJSEngine_Extension_CppToPython_QJSEngine_Extension(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJSEngine::Extension *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX], castCppIn);

}

static void QFlags_QJSEngine_Extension__PythonToCpp_QFlags_QJSEngine_Extension_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QJSEngine::Extension> *>(cppOut) =
        ::QFlags<QJSEngine::Extension>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QJSEngine_Extension__PythonToCpp_QFlags_QJSEngine_Extension__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX]))
        return QFlags_QJSEngine_Extension__PythonToCpp_QFlags_QJSEngine_Extension_;
    return {};
}
static PyObject *QFlags_QJSEngine_Extension__CppToPython_QFlags_QJSEngine_Extension_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QJSEngine::Extension> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX]));

}

static void QJSEngine_Extension_PythonToCpp_QFlags_QJSEngine_Extension_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QJSEngine::Extension> *>(cppOut) =
        ::QFlags<QJSEngine::Extension>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QJSEngine_Extension_PythonToCpp_QFlags_QJSEngine_Extension__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX]))
        return QJSEngine_Extension_PythonToCpp_QFlags_QJSEngine_Extension_;
    return {};
}
static void number_PythonToCpp_QFlags_QJSEngine_Extension_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QJSEngine::Extension> *>(cppOut) =
        ::QFlags<QJSEngine::Extension>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QJSEngine_Extension__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX]))
        return number_PythonToCpp_QFlags_QJSEngine_Extension_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QJSEngine_PythonToCpp_QJSEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QJSEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QJSEngine_PythonToCpp_QJSEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJSEngine_TypeF())))
        return QJSEngine_PythonToCpp_QJSEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QJSEngine_PTR_CppToPython_QJSEngine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QJSEngine *>(const_cast<void *>(cppIn)), Sbk_QJSEngine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QJSEngine_SignatureStrings[] = {
    "1:PySide2.QtQml.QJSEngine(self)",
    "0:PySide2.QtQml.QJSEngine(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtQml.QJSEngine.collectGarbage(self)",
    "PySide2.QtQml.QJSEngine.evaluate(self,program:QString,fileName:QString=QString(),lineNumber:int=1)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.globalObject(self)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.importModule(self,fileName:QString)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.installExtensions(self,extensions:PySide2.QtQml.QJSEngine.Extensions,object:PySide2.QtQml.QJSValue=QJSValue())",
    "PySide2.QtQml.QJSEngine.installTranslatorFunctions(self,object:PySide2.QtQml.QJSValue=QJSValue())",
    "PySide2.QtQml.QJSEngine.isInterrupted(self)->bool",
    "PySide2.QtQml.QJSEngine.newArray(self,length:uint=0)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.newErrorObject(self,errorType:PySide2.QtQml.QJSValue.ErrorType,message:QString=QString())->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.newObject(self)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.newQMetaObject(self,metaObject:PySide2.QtCore.QMetaObject)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.newQObject(self,object:PySide2.QtCore.QObject)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.setInterrupted(self,interrupted:bool)",
    "PySide2.QtQml.QJSEngine.setUiLanguage(self,language:QString)",
    "1:PySide2.QtQml.QJSEngine.throwError(self,errorType:PySide2.QtQml.QJSValue.ErrorType,message:QString=QString())",
    "0:PySide2.QtQml.QJSEngine.throwError(self,message:QString)",
    "PySide2.QtQml.QJSEngine.toScriptValue(self,arg__1:QVariant)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSEngine.uiLanguage(self)->QString",
    nullptr}; // Sentinel

void init_QJSEngine(PyObject *module)
{
    _Sbk_QJSEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QJSEngine",
        "QJSEngine*",
        &Sbk_QJSEngine_spec,
        &Shiboken::callCppDestructor< ::QJSEngine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QJSEngine_Type);
    InitSignatureStrings(pyType, QJSEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QJSEngine_Type), Sbk_QJSEngine_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QJSEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QJSEngine_TypeF(),
        QJSEngine_PythonToCpp_QJSEngine_PTR,
        is_QJSEngine_PythonToCpp_QJSEngine_PTR_Convertible,
        QJSEngine_PTR_CppToPython_QJSEngine);

    Shiboken::Conversions::registerConverterName(converter, "QJSEngine");
    Shiboken::Conversions::registerConverterName(converter, "QJSEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QJSEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJSEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJSEngineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QJSEngine_TypeF(), &Sbk_QJSEngine_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Extension'.
    SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX] = PySide::QFlags::create("2:PySide2.QtQml.QJSEngine.Extensions", SbkPySide2_QtQml_QJSEngine_Extension_number_slots);
    SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJSEngine_TypeF(),
        "Extension",
        "2:PySide2.QtQml.QJSEngine.Extension",
        "QJSEngine::Extension",
        SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX]);
    if (!SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX],
        Sbk_QJSEngine_TypeF(), "TranslationExtension", (long) QJSEngine::Extension::TranslationExtension))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX],
        Sbk_QJSEngine_TypeF(), "ConsoleExtension", (long) QJSEngine::Extension::ConsoleExtension))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX],
        Sbk_QJSEngine_TypeF(), "GarbageCollectionExtension", (long) QJSEngine::Extension::GarbageCollectionExtension))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX],
        Sbk_QJSEngine_TypeF(), "AllExtensions", (long) QJSEngine::Extension::AllExtensions))
        return;
    // Register converter for enum 'QJSEngine::Extension'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX],
            QJSEngine_Extension_CppToPython_QJSEngine_Extension);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJSEngine_Extension_PythonToCpp_QJSEngine_Extension,
            is_QJSEngine_Extension_PythonToCpp_QJSEngine_Extension_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_EXTENSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJSEngine::Extension");
        Shiboken::Conversions::registerConverterName(converter, "Extension");
    }
    // Register converter for flag 'QFlags<QJSEngine::Extension>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX],
            QFlags_QJSEngine_Extension__CppToPython_QFlags_QJSEngine_Extension_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJSEngine_Extension_PythonToCpp_QFlags_QJSEngine_Extension_,
            is_QJSEngine_Extension_PythonToCpp_QFlags_QJSEngine_Extension__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QJSEngine_Extension__PythonToCpp_QFlags_QJSEngine_Extension_,
            is_QFlags_QJSEngine_Extension__PythonToCpp_QFlags_QJSEngine_Extension__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QJSEngine_Extension_,
            is_number_PythonToCpp_QFlags_QJSEngine_Extension__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QFLAGS_QJSENGINE_EXTENSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJSEngine::Extensions");
        Shiboken::Conversions::registerConverterName(converter, "Extensions");
    }
    // End of 'Extension' enum/flags.

    PySide::Signal::registerSignals(Sbk_QJSEngine_TypeF(), &::QJSEngine::staticMetaObject);
    qRegisterMetaType< ::QJSEngine::Extension >("QJSEngine::Extension");
    qRegisterMetaType< ::QJSEngine::Extensions >("QJSEngine::Extensions");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QJSEngine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QJSEngine_TypeF(), &::QJSEngine::staticMetaObject, sizeof(QJSEngineWrapper));
}
