/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qnmeapositioninfosource_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNmeaPositionInfoSourceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNmeaPositionInfoSourceWrapper::QNmeaPositionInfoSourceWrapper(::QNmeaPositionInfoSource::UpdateMode updateMode, ::QObject * parent) : QNmeaPositionInfoSource(updateMode, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QNmeaPositionInfoSourceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNmeaPositionInfoSourceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNmeaPositionInfoSourceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNmeaPositionInfoSourceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QGeoPositionInfoSource::Error QNmeaPositionInfoSourceWrapper::error() const
{
    if (m_PyMethodCache[4])
        return this->::QNmeaPositionInfoSource::error();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QGeoPositionInfoSource::AccessError;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "error";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QNmeaPositionInfoSource::error();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QGeoPositionInfoSource::AccessError;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.error", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfoSource::Error >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QGeoPositionInfoSource::AccessError;
    }
    ::QGeoPositionInfoSource::Error cppResult{QGeoPositionInfoSource::AccessError};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QNmeaPositionInfoSourceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QNmeaPositionInfoSourceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QGeoPositionInfo QNmeaPositionInfoSourceWrapper::lastKnownPosition(bool fromSatellitePositioningMethodsOnly) const
{
    if (m_PyMethodCache[7])
        return this->::QNmeaPositionInfoSource::lastKnownPosition(fromSatellitePositioningMethodsOnly);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "lastKnownPosition";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QNmeaPositionInfoSource::lastKnownPosition(fromSatellitePositioningMethodsOnly);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &fromSatellitePositioningMethodsOnly)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.lastKnownPosition", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfo >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QGeoPositionInfo cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QNmeaPositionInfoSourceWrapper::minimumUpdateInterval() const
{
    if (m_PyMethodCache[9])
        return this->::QNmeaPositionInfoSource::minimumUpdateInterval();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QNmeaPositionInfoSource::minimumUpdateInterval();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.minimumUpdateInterval", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QNmeaPositionInfoSourceWrapper::parsePosInfoFromNmeaData(const char * data, int size, ::QGeoPositionInfo * posInfo, bool * hasFix)
{
    if (m_PyMethodCache[10])
        return this->::QNmeaPositionInfoSource::parsePosInfoFromNmeaData(data, size, posInfo, hasFix);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "parsePosInfoFromNmeaData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QNmeaPositionInfoSource::parsePosInfoFromNmeaData(data, size, posInfo, hasFix);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiNN)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    size,
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), posInfo),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &hasFix)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.parsePosInfoFromNmeaData", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QNmeaPositionInfoSourceWrapper::requestUpdate(int timeout)
{
    if (m_PyMethodCache[11]) {
        return this->::QNmeaPositionInfoSource::requestUpdate(timeout);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestUpdate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QNmeaPositionInfoSource::requestUpdate(timeout);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNmeaPositionInfoSourceWrapper::setPreferredPositioningMethods(::QFlags<QGeoPositionInfoSource::PositioningMethod> methods)
{
    if (m_PyMethodCache[12]) {
        return this->::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPreferredPositioningMethods";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QGeoPositionInfoSource::setPreferredPositioningMethods(methods);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &methods)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNmeaPositionInfoSourceWrapper::setUpdateInterval(int msec)
{
    if (m_PyMethodCache[13]) {
        return this->::QNmeaPositionInfoSource::setUpdateInterval(msec);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QNmeaPositionInfoSource::setUpdateInterval(msec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNmeaPositionInfoSourceWrapper::startUpdates()
{
    if (m_PyMethodCache[14]) {
        return this->::QNmeaPositionInfoSource::startUpdates();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "startUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QNmeaPositionInfoSource::startUpdates();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNmeaPositionInfoSourceWrapper::stopUpdates()
{
    if (m_PyMethodCache[15]) {
        return this->::QNmeaPositionInfoSource::stopUpdates();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stopUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QNmeaPositionInfoSource::stopUpdates();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QGeoPositionInfoSource::PositioningMethod> QNmeaPositionInfoSourceWrapper::supportedPositioningMethods() const
{
    if (m_PyMethodCache[16])
        return this->::QNmeaPositionInfoSource::supportedPositioningMethods();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedPositioningMethods";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QNmeaPositionInfoSource::supportedPositioningMethods();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNmeaPositionInfoSource.supportedPositioningMethods", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QGeoPositionInfoSource::PositioningMethod> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    }
    ::QFlags<QGeoPositionInfoSource::PositioningMethod> cppResult = QFlags<QGeoPositionInfoSource::PositioningMethod>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QNmeaPositionInfoSourceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[17]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QNmeaPositionInfoSourceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QNmeaPositionInfoSource::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QNmeaPositionInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QNmeaPositionInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QNmeaPositionInfoSourceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QNmeaPositionInfoSourceWrapper *>(this));
        return QNmeaPositionInfoSource::qt_metacast(_clname);
}

QNmeaPositionInfoSourceWrapper::~QNmeaPositionInfoSourceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNmeaPositionInfoSource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNmeaPositionInfoSource >()))
        return -1;

    ::QNmeaPositionInfoSourceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNmeaPositionInfoSource_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QNmeaPositionInfoSource", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QNmeaPositionInfoSource::QNmeaPositionInfoSource(QNmeaPositionInfoSource::UpdateMode,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QNmeaPositionInfoSource(QNmeaPositionInfoSource::UpdateMode,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QNmeaPositionInfoSource(QNmeaPositionInfoSource::UpdateMode,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSource_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QNmeaPositionInfoSource_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QNmeaPositionInfoSource_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QNmeaPositionInfoSource::UpdateMode cppArg0 = static_cast< ::QNmeaPositionInfoSource::UpdateMode>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QNmeaPositionInfoSource(QNmeaPositionInfoSource::UpdateMode,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QNmeaPositionInfoSourceWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QNmeaPositionInfoSourceWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNmeaPositionInfoSource >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNmeaPositionInfoSource_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QNmeaPositionInfoSource_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QNmeaPositionInfoSource_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QIODevice * cppResult = const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QGeoPositionInfoSource::Error cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->::QNmeaPositionInfoSource::error()
                : const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.lastKnownPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:lastKnownPosition", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::lastKnownPosition(bool)const
    if (numArgs == 0) {
        overloadId = 0; // lastKnownPosition(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // lastKnownPosition(bool)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fromSatellitePositioningMethodsOnly = Shiboken::String::createStaticString("fromSatellitePositioningMethodsOnly");
            if (PyDict_Contains(kwds, key_fromSatellitePositioningMethodsOnly)) {
                value = PyDict_GetItem(kwds, key_fromSatellitePositioningMethodsOnly);
                if (value && pyArgs[0]) {
                    errInfo = key_fromSatellitePositioningMethodsOnly;
                    Py_INCREF(errInfo);
                    goto Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fromSatellitePositioningMethodsOnly);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError;
            }
        }
        bool cppArg0 = false;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // lastKnownPosition(bool)const
            QGeoPositionInfo cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->::QNmeaPositionInfoSource::lastKnownPosition(cppArg0)
                : const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->lastKnownPosition(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_minimumUpdateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.minimumUpdateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumUpdateInterval()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->::QNmeaPositionInfoSource::minimumUpdateInterval()
                : const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->minimumUpdateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.parsePosInfoFromNmeaData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "parsePosInfoFromNmeaData", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QNmeaPositionInfoSource::parsePosInfoFromNmeaData(const char*,int,QGeoPositionInfo*,bool*)
    if (numArgs == 4
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), (pyArgs[2])))
        && PyBool_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
        overloadId = 0; // parsePosInfoFromNmeaData(const char*,int,QGeoPositionInfo*,bool*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QGeoPositionInfo *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // parsePosInfoFromNmeaData(const char*,int,QGeoPositionInfo*,bool*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNmeaPositionInfoSource::parsePosInfoFromNmeaData(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->parsePosInfoFromNmeaData(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_requestUpdate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.requestUpdate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // requestUpdate(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNmeaPositionInfoSource::requestUpdate(cppArg0)
                : cppSelf->requestUpdate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNmeaPositionInfoSourceFunc_requestUpdate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNmeaPositionInfoSource::setDevice(QIODevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QIODevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QIODevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNmeaPositionInfoSourceFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_setUpdateInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.setUpdateInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSource::setUpdateInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUpdateInterval(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNmeaPositionInfoSource::setUpdateInterval(cppArg0)
                : cppSelf->setUpdateInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNmeaPositionInfoSourceFunc_setUpdateInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_setUserEquivalentRangeError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.setUserEquivalentRangeError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNmeaPositionInfoSource::setUserEquivalentRangeError(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setUserEquivalentRangeError(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNmeaPositionInfoSourceFunc_setUserEquivalentRangeError_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUserEquivalentRangeError(double)
            cppSelf->setUserEquivalentRangeError(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNmeaPositionInfoSourceFunc_setUserEquivalentRangeError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_startUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.startUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startUpdates()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNmeaPositionInfoSource::startUpdates()
                : cppSelf->startUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_stopUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.stopUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopUpdates()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNmeaPositionInfoSource::stopUpdates()
                : cppSelf->stopUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_supportedPositioningMethods(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.supportedPositioningMethods";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedPositioningMethods()const
            QFlags<QGeoPositionInfoSource::PositioningMethod> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->::QNmeaPositionInfoSource::supportedPositioningMethods()
                : const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->supportedPositioningMethods();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QFLAGS_QGEOPOSITIONINFOSOURCE_POSITIONINGMETHOD_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_updateMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.updateMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateMode()const
            QNmeaPositionInfoSource::UpdateMode cppResult = const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->updateMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNmeaPositionInfoSourceFunc_userEquivalentRangeError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QNmeaPositionInfoSource.userEquivalentRangeError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // userEquivalentRangeError()const
            double cppResult = const_cast<const ::QNmeaPositionInfoSource *>(cppSelf)->userEquivalentRangeError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNmeaPositionInfoSource_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNmeaPositionInfoSource_methods[] = {
    {"device", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_device), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_error), METH_NOARGS},
    {"lastKnownPosition", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_lastKnownPosition), METH_VARARGS|METH_KEYWORDS},
    {"minimumUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_minimumUpdateInterval), METH_NOARGS},
    {"parsePosInfoFromNmeaData", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_parsePosInfoFromNmeaData), METH_VARARGS},
    {"requestUpdate", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_requestUpdate), METH_VARARGS|METH_KEYWORDS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_setDevice), METH_O},
    {"setUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_setUpdateInterval), METH_O},
    {"setUserEquivalentRangeError", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_setUserEquivalentRangeError), METH_O},
    {"startUpdates", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_startUpdates), METH_NOARGS},
    {"stopUpdates", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_stopUpdates), METH_NOARGS},
    {"supportedPositioningMethods", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_supportedPositioningMethods), METH_NOARGS},
    {"updateMode", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_updateMode), METH_NOARGS},
    {"userEquivalentRangeError", reinterpret_cast<PyCFunction>(Sbk_QNmeaPositionInfoSourceFunc_userEquivalentRangeError), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNmeaPositionInfoSource_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QNmeaPositionInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNmeaPositionInfoSourceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QNmeaPositionInfoSource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNmeaPositionInfoSource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNmeaPositionInfoSource_Type = nullptr;
static SbkObjectType *Sbk_QNmeaPositionInfoSource_TypeF(void)
{
    return _Sbk_QNmeaPositionInfoSource_Type;
}

static PyType_Slot Sbk_QNmeaPositionInfoSource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QNmeaPositionInfoSource_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNmeaPositionInfoSource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNmeaPositionInfoSource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNmeaPositionInfoSource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNmeaPositionInfoSource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNmeaPositionInfoSource_spec = {
    "2:PySide2.QtPositioning.QNmeaPositionInfoSource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNmeaPositionInfoSource_slots
};

} //extern "C"

static void *Sbk_QNmeaPositionInfoSource_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QNmeaPositionInfoSource *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QNmeaPositionInfoSource_UpdateMode_PythonToCpp_QNmeaPositionInfoSource_UpdateMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNmeaPositionInfoSource::UpdateMode *>(cppOut) =
        static_cast<::QNmeaPositionInfoSource::UpdateMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNmeaPositionInfoSource_UpdateMode_PythonToCpp_QNmeaPositionInfoSource_UpdateMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX]))
        return QNmeaPositionInfoSource_UpdateMode_PythonToCpp_QNmeaPositionInfoSource_UpdateMode;
    return {};
}
static PyObject *QNmeaPositionInfoSource_UpdateMode_CppToPython_QNmeaPositionInfoSource_UpdateMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNmeaPositionInfoSource::UpdateMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNmeaPositionInfoSource_PythonToCpp_QNmeaPositionInfoSource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNmeaPositionInfoSource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNmeaPositionInfoSource_PythonToCpp_QNmeaPositionInfoSource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNmeaPositionInfoSource_TypeF())))
        return QNmeaPositionInfoSource_PythonToCpp_QNmeaPositionInfoSource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNmeaPositionInfoSource_PTR_CppToPython_QNmeaPositionInfoSource(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QNmeaPositionInfoSource *>(const_cast<void *>(cppIn)), Sbk_QNmeaPositionInfoSource_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNmeaPositionInfoSource_SignatureStrings[] = {
    "PySide2.QtPositioning.QNmeaPositionInfoSource(self,updateMode:PySide2.QtPositioning.QNmeaPositionInfoSource.UpdateMode,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.device(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.error(self)->PySide2.QtPositioning.QGeoPositionInfoSource.Error",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.lastKnownPosition(self,fromSatellitePositioningMethodsOnly:bool=false)->PySide2.QtPositioning.QGeoPositionInfo",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.minimumUpdateInterval(self)->int",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.parsePosInfoFromNmeaData(self,data:char*,size:int,posInfo:PySide2.QtPositioning.QGeoPositionInfo,hasFix:bool*)->bool",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.requestUpdate(self,timeout:int=0)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.setDevice(self,source:PySide2.QtCore.QIODevice)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.setUpdateInterval(self,msec:int)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.setUserEquivalentRangeError(self,uere:double)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.startUpdates(self)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.stopUpdates(self)",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.supportedPositioningMethods(self)->PySide2.QtPositioning.QGeoPositionInfoSource.PositioningMethods",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.updateMode(self)->PySide2.QtPositioning.QNmeaPositionInfoSource.UpdateMode",
    "PySide2.QtPositioning.QNmeaPositionInfoSource.userEquivalentRangeError(self)->double",
    nullptr}; // Sentinel

void init_QNmeaPositionInfoSource(PyObject *module)
{
    _Sbk_QNmeaPositionInfoSource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNmeaPositionInfoSource",
        "QNmeaPositionInfoSource*",
        &Sbk_QNmeaPositionInfoSource_spec,
        &Shiboken::callCppDestructor< ::QNmeaPositionInfoSource >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNmeaPositionInfoSource_Type);
    InitSignatureStrings(pyType, QNmeaPositionInfoSource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNmeaPositionInfoSource_Type), Sbk_QNmeaPositionInfoSource_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNmeaPositionInfoSource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNmeaPositionInfoSource_TypeF(),
        QNmeaPositionInfoSource_PythonToCpp_QNmeaPositionInfoSource_PTR,
        is_QNmeaPositionInfoSource_PythonToCpp_QNmeaPositionInfoSource_PTR_Convertible,
        QNmeaPositionInfoSource_PTR_CppToPython_QNmeaPositionInfoSource);

    Shiboken::Conversions::registerConverterName(converter, "QNmeaPositionInfoSource");
    Shiboken::Conversions::registerConverterName(converter, "QNmeaPositionInfoSource*");
    Shiboken::Conversions::registerConverterName(converter, "QNmeaPositionInfoSource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNmeaPositionInfoSource).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNmeaPositionInfoSourceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QNmeaPositionInfoSource_TypeF(), &Sbk_QNmeaPositionInfoSource_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'UpdateMode'.
    SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNmeaPositionInfoSource_TypeF(),
        "UpdateMode",
        "2:PySide2.QtPositioning.QNmeaPositionInfoSource.UpdateMode",
        "QNmeaPositionInfoSource::UpdateMode");
    if (!SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX],
        Sbk_QNmeaPositionInfoSource_TypeF(), "RealTimeMode", (long) QNmeaPositionInfoSource::UpdateMode::RealTimeMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX],
        Sbk_QNmeaPositionInfoSource_TypeF(), "SimulationMode", (long) QNmeaPositionInfoSource::UpdateMode::SimulationMode))
        return;
    // Register converter for enum 'QNmeaPositionInfoSource::UpdateMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX],
            QNmeaPositionInfoSource_UpdateMode_CppToPython_QNmeaPositionInfoSource_UpdateMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNmeaPositionInfoSource_UpdateMode_PythonToCpp_QNmeaPositionInfoSource_UpdateMode,
            is_QNmeaPositionInfoSource_UpdateMode_PythonToCpp_QNmeaPositionInfoSource_UpdateMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QNMEAPOSITIONINFOSOURCE_UPDATEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNmeaPositionInfoSource::UpdateMode");
        Shiboken::Conversions::registerConverterName(converter, "UpdateMode");
    }
    // End of 'UpdateMode' enum.

    PySide::Signal::registerSignals(Sbk_QNmeaPositionInfoSource_TypeF(), &::QNmeaPositionInfoSource::staticMetaObject);
    qRegisterMetaType< ::QNmeaPositionInfoSource::UpdateMode >("QNmeaPositionInfoSource::UpdateMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QNmeaPositionInfoSource_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QNmeaPositionInfoSource_TypeF(), &::QNmeaPositionInfoSource::staticMetaObject, sizeof(QNmeaPositionInfoSourceWrapper));
}
