/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeopositioninfosourcefactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoPositionInfoSourceFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoPositionInfoSourceFactoryWrapper::QGeoPositionInfoSourceFactoryWrapper() : QGeoPositionInfoSourceFactory()
{
    resetPyMethodCache();
    // ... middle
}

::QGeoAreaMonitorSource * QGeoPositionInfoSourceFactoryWrapper::areaMonitor(::QObject * parent)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.areaMonitor()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "areaMonitor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.areaMonitor()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSourceFactory.areaMonitor", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoAreaMonitorSource >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoAreaMonitorSource *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QGeoPositionInfoSource * QGeoPositionInfoSourceFactoryWrapper::positionInfoSource(::QObject * parent)
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.positionInfoSource()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "positionInfoSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.positionInfoSource()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSourceFactory.positionInfoSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoPositionInfoSource >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoPositionInfoSource *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QGeoSatelliteInfoSource * QGeoPositionInfoSourceFactoryWrapper::satelliteInfoSource(::QObject * parent)
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.satelliteInfoSource()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "satelliteInfoSource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.satelliteInfoSource()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoPositionInfoSourceFactory.satelliteInfoSource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoSatelliteInfoSource >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoSatelliteInfoSource *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QGeoPositionInfoSourceFactoryWrapper::~QGeoPositionInfoSourceFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoPositionInfoSourceFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGeoPositionInfoSourceFactory' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoPositionInfoSourceFactory >()))
        return -1;

    ::QGeoPositionInfoSourceFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QGeoPositionInfoSourceFactory()
            cptr = new ::QGeoPositionInfoSourceFactoryWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoPositionInfoSourceFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QGeoPositionInfoSourceFactoryFunc_areaMonitor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSourceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.areaMonitor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSourceFactory::areaMonitor(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // areaMonitor(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFactoryFunc_areaMonitor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // areaMonitor(QObject*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.areaMonitor()' not implemented.");
                return {};
            }
            QGeoAreaMonitorSource * cppResult = cppSelf->areaMonitor(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORSOURCE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFactoryFunc_areaMonitor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFactoryFunc_positionInfoSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSourceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.positionInfoSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSourceFactory::positionInfoSource(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // positionInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFactoryFunc_positionInfoSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // positionInfoSource(QObject*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.positionInfoSource()' not implemented.");
                return {};
            }
            QGeoPositionInfoSource * cppResult = cppSelf->positionInfoSource(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFactoryFunc_positionInfoSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoSourceFactoryFunc_satelliteInfoSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfoSourceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.satelliteInfoSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfoSourceFactory::satelliteInfoSource(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // satelliteInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoSourceFactoryFunc_satelliteInfoSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // satelliteInfoSource(QObject*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoPositionInfoSourceFactory.satelliteInfoSource()' not implemented.");
                return {};
            }
            QGeoSatelliteInfoSource * cppResult = cppSelf->satelliteInfoSource(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoSourceFactoryFunc_satelliteInfoSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGeoPositionInfoSourceFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoPositionInfoSourceFactory_methods[] = {
    {"areaMonitor", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFactoryFunc_areaMonitor), METH_O},
    {"positionInfoSource", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFactoryFunc_positionInfoSource), METH_O},
    {"satelliteInfoSource", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoSourceFactoryFunc_satelliteInfoSource), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoPositionInfoSourceFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoPositionInfoSourceFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoPositionInfoSourceFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoPositionInfoSourceFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoPositionInfoSourceFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoPositionInfoSourceFactory_Type = nullptr;
static SbkObjectType *Sbk_QGeoPositionInfoSourceFactory_TypeF(void)
{
    return _Sbk_QGeoPositionInfoSourceFactory_Type;
}

static PyType_Slot Sbk_QGeoPositionInfoSourceFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoPositionInfoSourceFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoPositionInfoSourceFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoPositionInfoSourceFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoPositionInfoSourceFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoPositionInfoSourceFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoPositionInfoSourceFactory_spec = {
    "2:PySide2.QtPositioning.QGeoPositionInfoSourceFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoPositionInfoSourceFactory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoPositionInfoSourceFactory_PythonToCpp_QGeoPositionInfoSourceFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoPositionInfoSourceFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoPositionInfoSourceFactory_PythonToCpp_QGeoPositionInfoSourceFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfoSourceFactory_TypeF())))
        return QGeoPositionInfoSourceFactory_PythonToCpp_QGeoPositionInfoSourceFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoPositionInfoSourceFactory_PTR_CppToPython_QGeoPositionInfoSourceFactory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoPositionInfoSourceFactory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoPositionInfoSourceFactory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoPositionInfoSourceFactory_SignatureStrings[] = {
    "PySide2.QtPositioning.QGeoPositionInfoSourceFactory(self)",
    "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.areaMonitor(self,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoAreaMonitorSource",
    "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.positionInfoSource(self,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoPositionInfoSource",
    "PySide2.QtPositioning.QGeoPositionInfoSourceFactory.satelliteInfoSource(self,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoSatelliteInfoSource",
    nullptr}; // Sentinel

void init_QGeoPositionInfoSourceFactory(PyObject *module)
{
    _Sbk_QGeoPositionInfoSourceFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoPositionInfoSourceFactory",
        "QGeoPositionInfoSourceFactory*",
        &Sbk_QGeoPositionInfoSourceFactory_spec,
        &Shiboken::callCppDestructor< ::QGeoPositionInfoSourceFactory >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfoSourceFactory_Type);
    InitSignatureStrings(pyType, QGeoPositionInfoSourceFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfoSourceFactory_Type), Sbk_QGeoPositionInfoSourceFactory_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFOSOURCEFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfoSourceFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoPositionInfoSourceFactory_TypeF(),
        QGeoPositionInfoSourceFactory_PythonToCpp_QGeoPositionInfoSourceFactory_PTR,
        is_QGeoPositionInfoSourceFactory_PythonToCpp_QGeoPositionInfoSourceFactory_PTR_Convertible,
        QGeoPositionInfoSourceFactory_PTR_CppToPython_QGeoPositionInfoSourceFactory);

    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSourceFactory");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSourceFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfoSourceFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPositionInfoSourceFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPositionInfoSourceFactoryWrapper).name());


}
