/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeoareamonitorinfo_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtPositioning/qgeoareamonitorinfo.h>
#include <QtPositioning/qgeoshape.h>
#include <qdatastream.h>
#include <qdatetime.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoAreaMonitorInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoAreaMonitorInfo >()))
        return -1;

    ::QGeoAreaMonitorInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QGeoAreaMonitorInfo", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::QGeoAreaMonitorInfo(QGeoAreaMonitorInfo)
    // 1: QGeoAreaMonitorInfo::QGeoAreaMonitorInfo(QString)
    if (numArgs == 0) {
        overloadId = 1; // QGeoAreaMonitorInfo(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // QGeoAreaMonitorInfo(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGeoAreaMonitorInfo(QGeoAreaMonitorInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoAreaMonitorInfo(const QGeoAreaMonitorInfo & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoAreaMonitorInfo cppArg0_local;
            ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoAreaMonitorInfo(QGeoAreaMonitorInfo)
                cptr = new ::QGeoAreaMonitorInfo(*cppArg0);
            }
            break;
        }
        case 1: // QGeoAreaMonitorInfo(const QString & name)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_name = Shiboken::String::createStaticString("name");
                if (PyDict_Contains(kwds, key_name)) {
                    value = PyDict_GetItem(kwds, key_name);
                    if (value && pyArgs[0]) {
                        errInfo = key_name;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                            goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_name);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGeoAreaMonitorInfo(QString)
                cptr = new ::QGeoAreaMonitorInfo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoAreaMonitorInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoAreaMonitorInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoAreaMonitorInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_area(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.area";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // area()const
            QGeoShape cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->area();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_expiration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.expiration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expiration()const
            QDateTime cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->expiration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_identifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.identifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // identifier()const
            QString cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->identifier();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_isPersistent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.isPersistent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPersistent()const
            bool cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->isPersistent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_notificationParameters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.notificationParameters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // notificationParameters()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QGeoAreaMonitorInfo *>(cppSelf)->notificationParameters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_setArea(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.setArea";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::setArea(QGeoShape)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), (pyArg)))) {
        overloadId = 0; // setArea(QGeoShape)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc_setArea_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoShape cppArg0_local;
        ::QGeoShape *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setArea(QGeoShape)
            cppSelf->setArea(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorInfoFunc_setArea_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_setExpiration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.setExpiration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::setExpiration(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // setExpiration(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc_setExpiration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setExpiration(QDateTime)
            cppSelf->setExpiration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorInfoFunc_setExpiration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorInfoFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_setNotificationParameters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.setNotificationParameters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::setNotificationParameters(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setNotificationParameters(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc_setNotificationParameters_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNotificationParameters(QMap<QString,QVariant>)
            cppSelf->setNotificationParameters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorInfoFunc_setNotificationParameters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc_setPersistent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.setPersistent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAreaMonitorInfo::setPersistent(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPersistent(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc_setPersistent_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPersistent(bool)
            cppSelf->setPersistent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAreaMonitorInfoFunc_setPersistent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoAreaMonitorInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoAreaMonitorInfo_methods[] = {
    {"area", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_area), METH_NOARGS},
    {"expiration", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_expiration), METH_NOARGS},
    {"identifier", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_identifier), METH_NOARGS},
    {"isPersistent", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_isPersistent), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_isValid), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_name), METH_NOARGS},
    {"notificationParameters", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_notificationParameters), METH_NOARGS},
    {"setArea", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_setArea), METH_O},
    {"setExpiration", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_setExpiration), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_setName), METH_O},
    {"setNotificationParameters", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_setNotificationParameters), METH_O},
    {"setPersistent", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfoFunc_setPersistent), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoAreaMonitorInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QGeoAreaMonitorInfoFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoAreaMonitorInfo::operator<<(QDataStream&,QGeoAreaMonitorInfo)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QGeoAreaMonitorInfo)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QGeoAreaMonitorInfo) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorInfoFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAreaMonitorInfoFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAreaMonitorInfo.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoAreaMonitorInfo::operator>>(QDataStream&,QGeoAreaMonitorInfo&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QGeoAreaMonitorInfo&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoAreaMonitorInfoFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QGeoAreaMonitorInfo&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoAreaMonitorInfoFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QGeoAreaMonitorInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArg)))) {
                // operator!=(const QGeoAreaMonitorInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoAreaMonitorInfo cppArg0_local;
                ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), (pyArg)))) {
                // operator==(const QGeoAreaMonitorInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoAreaMonitorInfo cppArg0_local;
                ::QGeoAreaMonitorInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoAreaMonitorInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoAreaMonitorInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoAreaMonitorInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoAreaMonitorInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGeoAreaMonitorInfo__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoAreaMonitorInfo_Type = nullptr;
static SbkObjectType *Sbk_QGeoAreaMonitorInfo_TypeF(void)
{
    return _Sbk_QGeoAreaMonitorInfo_Type;
}

static PyType_Slot Sbk_QGeoAreaMonitorInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoAreaMonitorInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QGeoAreaMonitorInfoFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QGeoAreaMonitorInfoFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoAreaMonitorInfo_spec = {
    "2:PySide2.QtPositioning.QGeoAreaMonitorInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoAreaMonitorInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoAreaMonitorInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoAreaMonitorInfo_TypeF())))
        return QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoAreaMonitorInfo_PTR_CppToPython_QGeoAreaMonitorInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoAreaMonitorInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoAreaMonitorInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoAreaMonitorInfo_COPY_CppToPython_QGeoAreaMonitorInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoAreaMonitorInfo_TypeF(), new ::QGeoAreaMonitorInfo(*reinterpret_cast<const ::QGeoAreaMonitorInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoAreaMonitorInfo *>(cppOut) = *reinterpret_cast< ::QGeoAreaMonitorInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoAreaMonitorInfo_TypeF())))
        return QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQStringREF_PythonToCpp_QGeoAreaMonitorInfo(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QGeoAreaMonitorInfo *>(cppOut) = ::QGeoAreaMonitorInfo(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QGeoAreaMonitorInfo_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QGeoAreaMonitorInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoAreaMonitorInfo_SignatureStrings[] = {
    "1:PySide2.QtPositioning.QGeoAreaMonitorInfo(self,other:PySide2.QtPositioning.QGeoAreaMonitorInfo)",
    "0:PySide2.QtPositioning.QGeoAreaMonitorInfo(self,name:QString=QString())",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.area(self)->PySide2.QtPositioning.QGeoShape",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.expiration(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.identifier(self)->QString",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.isPersistent(self)->bool",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.isValid(self)->bool",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.name(self)->QString",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.notificationParameters(self)->QMap[QString, QVariant]",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.setArea(self,newShape:PySide2.QtPositioning.QGeoShape)",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.setExpiration(self,expiry:PySide2.QtCore.QDateTime)",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.setName(self,name:QString)",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.setNotificationParameters(self,parameters:QMap[QString, QVariant])",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.setPersistent(self,isPersistent:bool)",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.__copy__()",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtPositioning.QGeoAreaMonitorInfo.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QGeoAreaMonitorInfo(PyObject *module)
{
    _Sbk_QGeoAreaMonitorInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoAreaMonitorInfo",
        "QGeoAreaMonitorInfo",
        &Sbk_QGeoAreaMonitorInfo_spec,
        &Shiboken::callCppDestructor< ::QGeoAreaMonitorInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAreaMonitorInfo_Type);
    InitSignatureStrings(pyType, QGeoAreaMonitorInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAreaMonitorInfo_Type), Sbk_QGeoAreaMonitorInfo_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOAREAMONITORINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoAreaMonitorInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoAreaMonitorInfo_TypeF(),
        QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_PTR,
        is_QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_PTR_Convertible,
        QGeoAreaMonitorInfo_PTR_CppToPython_QGeoAreaMonitorInfo,
        QGeoAreaMonitorInfo_COPY_CppToPython_QGeoAreaMonitorInfo);

    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorInfo");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAreaMonitorInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoAreaMonitorInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_COPY,
        is_QGeoAreaMonitorInfo_PythonToCpp_QGeoAreaMonitorInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QGeoAreaMonitorInfo,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QGeoAreaMonitorInfo_Convertible);

}
