/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopenglfunctions_python.h"

// main header
#include "qopenglfunctions_3_3_compatibility_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLFunctions_3_3_CompatibilityWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLFunctions_3_3_CompatibilityWrapper::QOpenGLFunctions_3_3_CompatibilityWrapper() : QOpenGLFunctions_3_3_Compatibility()
{
    resetPyMethodCache();
    // ... middle
}

bool QOpenGLFunctions_3_3_CompatibilityWrapper::initializeOpenGLFunctions()
{
    if (m_PyMethodCache[0])
        return this->::QOpenGLFunctions_3_3_Compatibility::initializeOpenGLFunctions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initializeOpenGLFunctions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QOpenGLFunctions_3_3_Compatibility::initializeOpenGLFunctions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLFunctions_3_3_Compatibility.initializeOpenGLFunctions", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QOpenGLFunctions_3_3_CompatibilityWrapper::~QOpenGLFunctions_3_3_CompatibilityWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLFunctions_3_3_Compatibility_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLFunctions_3_3_Compatibility >()))
        return -1;

    ::QOpenGLFunctions_3_3_CompatibilityWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QOpenGLFunctions_3_3_Compatibility()
            cptr = new ::QOpenGLFunctions_3_3_CompatibilityWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLFunctions_3_3_Compatibility >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAccum(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glAccum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glAccum", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glAccum(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glAccum(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAccum_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glAccum(uint,float)
            cppSelf->glAccum(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAccum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glActiveTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glActiveTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glActiveTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glActiveTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glActiveTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glActiveTexture(uint)
            cppSelf->glActiveTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glActiveTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAlphaFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glAlphaFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glAlphaFunc", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glAlphaFunc(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glAlphaFunc(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAlphaFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glAlphaFunc(uint,float)
            cppSelf->glAlphaFunc(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAlphaFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glArrayElement(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glArrayElement";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glArrayElement(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glArrayElement(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glArrayElement_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glArrayElement(int)
            cppSelf->glArrayElement(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glArrayElement_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAttachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glAttachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glAttachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glAttachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glAttachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAttachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glAttachShader(uint,uint)
            cppSelf->glAttachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glAttachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBegin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBegin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBegin(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBegin(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBegin_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBegin(uint)
            cppSelf->glBegin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBegin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginConditionalRender(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBeginConditionalRender";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginConditionalRender", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBeginConditionalRender(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginConditionalRender(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginConditionalRender_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginConditionalRender(uint,uint)
            cppSelf->glBeginConditionalRender(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginConditionalRender_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginQuery(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBeginQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginQuery", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBeginQuery(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginQuery(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginQuery(uint,uint)
            cppSelf->glBeginQuery(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBeginTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBeginTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBeginTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBeginTransformFeedback(uint)
            cppSelf->glBeginTransformFeedback(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBeginTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindAttribLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindAttribLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindAttribLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindAttribLocation(uint,uint,const char*)
            cppSelf->glBindAttribLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindBuffer(uint,uint)
            cppSelf->glBindBuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBufferBase(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindBufferBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBufferBase", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindBufferBase(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBindBufferBase(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBufferBase_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindBufferBase(uint,uint,uint)
            cppSelf->glBindBufferBase(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindBufferBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFragDataLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindFragDataLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindFragDataLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindFragDataLocation(uint,uint,const char*)
            cppSelf->glBindFragDataLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocationIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindFragDataLocationIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFragDataLocationIndexed", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindFragDataLocationIndexed(uint,uint,uint,const char*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
        overloadId = 0; // glBindFragDataLocationIndexed(uint,uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocationIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBindFragDataLocationIndexed(uint,uint,uint,const char*)
            cppSelf->glBindFragDataLocationIndexed(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFragDataLocationIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFramebuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindFramebuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindFramebuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindFramebuffer(uint,uint)
            cppSelf->glBindFramebuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindRenderbuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindRenderbuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindRenderbuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindRenderbuffer(uint,uint)
            cppSelf->glBindRenderbuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindSampler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindSampler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindSampler(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindSampler(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindSampler(uint,uint)
            cppSelf->glBindSampler(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindTexture", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindTexture(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindTexture(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindTexture(uint,uint)
            cppSelf->glBindTexture(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBindVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBindVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindVertexArray(uint)
            cppSelf->glBindVertexArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBindVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlendColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlendColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendColor(float,float,float,float)
            cppSelf->glBlendColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlendEquation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlendEquation(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBlendEquation(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBlendEquation(uint)
            cppSelf->glBlendEquation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquationSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlendEquationSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlendEquationSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendEquationSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquationSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendEquationSeparate(uint,uint)
            cppSelf->glBlendEquationSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendEquationSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlendFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFunc", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlendFunc(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendFunc(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendFunc(uint,uint)
            cppSelf->glBlendFunc(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlendFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlendFuncSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendFuncSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendFuncSeparate(uint,uint,uint,uint)
            cppSelf->glBlendFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlendFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlitFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glBlitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlitFramebuffer", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))) {
        overloadId = 0; // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlitFramebuffer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
            cppSelf->glBlitFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glBlitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCallList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCallList(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCallList(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallList_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCallList(uint)
            cppSelf->glCallList(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallLists(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCallLists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCallLists", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCallLists(int,uint,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glCallLists(int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallLists_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glCallLists(int,uint,const void*)
            cppSelf->glCallLists(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCallLists_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCheckFramebufferStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCheckFramebufferStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCheckFramebufferStatus(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCheckFramebufferStatus(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCheckFramebufferStatus_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCheckFramebufferStatus(uint)
            unsigned int cppResult = cppSelf->glCheckFramebufferStatus(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCheckFramebufferStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClampColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClampColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClampColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClampColor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glClampColor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClampColor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glClampColor(uint,uint)
            cppSelf->glClampColor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClampColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClear(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glClear(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClear_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClear(uint)
            cppSelf->glClear(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearAccum(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearAccum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearAccum", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearAccum(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glClearAccum(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearAccum_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearAccum(float,float,float,float)
            cppSelf->glClearAccum(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearAccum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearBufferfi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfi", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearBufferfi(uint,int,float,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glClearBufferfi(uint,int,float,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearBufferfi(uint,int,float,int)
            cppSelf->glClearBufferfi(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearBufferfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearBufferfv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferfv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferfv(uint,int,const float*)
            cppSelf->glClearBufferfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearBufferiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearBufferiv(uint,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferiv(uint,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferiv(uint,int,const int*)
            cppSelf->glClearBufferiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearBufferuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearBufferuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferuiv(uint,int,const uint*)
            cppSelf->glClearBufferuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearBufferuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glClearColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearColor(float,float,float,float)
            cppSelf->glClearColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearDepth(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glClearDepth(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearDepth_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearDepth(double)
            cppSelf->glClearDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearIndex(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glClearIndex(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearIndex_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearIndex(float)
            cppSelf->glClearIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearStencil(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClearStencil";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClearStencil(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glClearStencil(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearStencil_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearStencil(int)
            cppSelf->glClearStencil(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClearStencil_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClientActiveTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClientActiveTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClientActiveTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glClientActiveTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClientActiveTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClientActiveTexture(uint)
            cppSelf->glClientActiveTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClientActiveTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClipPlane(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glClipPlane";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClipPlane", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glClipPlane(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glClipPlane(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClipPlane_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glClipPlane(uint,const double*)
            cppSelf->glClipPlane(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glClipPlane_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3b(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3b";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3b", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3b(signed char,signed char,signed char)
    if (numArgs == 3
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3b(signed char,signed char,signed char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3b_TypeError;

    // Call function/method
    {
        signed char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        signed char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        signed char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3b(signed char,signed char,signed char)
            cppSelf->glColor3b(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3b_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3bv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3bv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3bv(const signed char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<signed char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3bv(const signed char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3bv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<signed char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3bv(const signed char*)
            cppSelf->glColor3bv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3bv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3d(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3d(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3d(double,double,double)
            cppSelf->glColor3d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3dv(const double*)
            cppSelf->glColor3dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3f(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3f(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3f(float,float,float)
            cppSelf->glColor3f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3fv(const float*)
            cppSelf->glColor3fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3i(int,int,int)
            cppSelf->glColor3i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3iv(const int*)
            cppSelf->glColor3iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3s", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3s(short,short,short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3s(short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3s(short,short,short)
            cppSelf->glColor3s(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3sv(const short*)
            cppSelf->glColor3sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ub(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3ub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3ub", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3ub(unsigned char,unsigned char,unsigned char)
    if (numArgs == 3
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3ub(unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3ub(unsigned char,unsigned char,unsigned char)
            cppSelf->glColor3ub(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ub_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3ubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3ubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3ubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ubv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3ubv(const unsigned char*)
            cppSelf->glColor3ubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3ui(uint,uint,uint)
            cppSelf->glColor3ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3uiv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3uiv(const uint*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3uiv(const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3uiv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3uiv(const uint*)
            cppSelf->glColor3uiv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3us(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3us";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor3us", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3us(unsigned short,unsigned short,unsigned short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[2])))) {
        overloadId = 0; // glColor3us(unsigned short,unsigned short,unsigned short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3us_TypeError;

    // Call function/method
    {
        unsigned short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColor3us(unsigned short,unsigned short,unsigned short)
            cppSelf->glColor3us(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3us_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3usv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor3usv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor3usv(const unsigned short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor3usv(const unsigned short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3usv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor3usv(const unsigned short*)
            cppSelf->glColor3usv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor3usv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4b(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4b";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4b", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4b(signed char,signed char,signed char,signed char)
    if (numArgs == 4
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4b(signed char,signed char,signed char,signed char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4b_TypeError;

    // Call function/method
    {
        signed char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        signed char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        signed char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        signed char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4b(signed char,signed char,signed char,signed char)
            cppSelf->glColor4b(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4b_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4bv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4bv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4bv(const signed char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<signed char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4bv(const signed char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4bv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<signed char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4bv(const signed char*)
            cppSelf->glColor4bv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4bv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4d(double,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4d(double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4d(double,double,double,double)
            cppSelf->glColor4d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4dv(const double*)
            cppSelf->glColor4dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4f(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4f(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4f(float,float,float,float)
            cppSelf->glColor4f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4fv(const float*)
            cppSelf->glColor4fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4i(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4i(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4i(int,int,int,int)
            cppSelf->glColor4i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4iv(const int*)
            cppSelf->glColor4iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4s", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4s(short,short,short,short)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4s(short,short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4s(short,short,short,short)
            cppSelf->glColor4s(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4sv(const short*)
            cppSelf->glColor4sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ub(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4ub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4ub", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4ub(unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 4
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4ub(unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4ub(unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColor4ub(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ub_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4ubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4ubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4ubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ubv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4ubv(const unsigned char*)
            cppSelf->glColor4ubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4ui(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4ui(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4ui(uint,uint,uint,uint)
            cppSelf->glColor4ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4uiv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4uiv(const uint*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4uiv(const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4uiv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4uiv(const uint*)
            cppSelf->glColor4uiv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4us(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4us";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColor4us", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4us(unsigned short,unsigned short,unsigned short,unsigned short)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[3])))) {
        overloadId = 0; // glColor4us(unsigned short,unsigned short,unsigned short,unsigned short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4us_TypeError;

    // Call function/method
    {
        unsigned short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColor4us(unsigned short,unsigned short,unsigned short,unsigned short)
            cppSelf->glColor4us(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4us_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4usv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColor4usv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColor4usv(const unsigned short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glColor4usv(const unsigned short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4usv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glColor4usv(const unsigned short*)
            cppSelf->glColor4usv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColor4usv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMask(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMask", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 4
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))) {
        overloadId = 0; // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMask(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMaski", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[4])))) {
        overloadId = 0; // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned char cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMaski(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaterial(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorMaterial";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMaterial", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorMaterial(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glColorMaterial(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaterial_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorMaterial(uint,uint)
            cppSelf->glColorMaterial(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorMaterial_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glColorP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP3ui(uint,uint)
            cppSelf->glColorP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glColorP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP3uiv(uint,const uint*)
            cppSelf->glColorP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP4ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorP4ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glColorP4ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP4ui(uint,uint)
            cppSelf->glColorP4ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP4uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorP4uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glColorP4uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP4uiv(uint,const uint*)
            cppSelf->glColorP4uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorPointer", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorPointer(int,uint,int,const void*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
        overloadId = 0; // glColorPointer(int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorPointer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColorPointer(int,uint,int,const void*)
            cppSelf->glColorPointer(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorSubTable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorSubTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorSubTable", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorSubTable(uint,int,int,uint,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glColorSubTable(uint,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorSubTable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glColorSubTable(uint,int,int,uint,uint,const void*)
            cppSelf->glColorSubTable(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorSubTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorTable", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorTable(uint,uint,int,uint,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glColorTable(uint,uint,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glColorTable(uint,uint,int,uint,uint,const void*)
            cppSelf->glColorTable(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorTableParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorTableParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorTableParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glColorTableParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColorTableParameterfv(uint,uint,const float*)
            cppSelf->glColorTableParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glColorTableParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorTableParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glColorTableParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glColorTableParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glColorTableParameteriv(uint,uint,const int*)
            cppSelf->glColorTableParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glColorTableParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompileShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompileShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompileShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCompileShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompileShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCompileShader(uint)
            cppSelf->glCompileShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompileShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
            cppSelf->glCompressedTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCompressedTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCompressedTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionFilter1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionFilter1D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionFilter1D(uint,uint,int,uint,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glConvolutionFilter1D(uint,uint,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glConvolutionFilter1D(uint,uint,int,uint,uint,const void*)
            cppSelf->glConvolutionFilter1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionFilter2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionFilter2D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionFilter2D(uint,uint,int,int,uint,uint,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glConvolutionFilter2D(uint,uint,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glConvolutionFilter2D(uint,uint,int,int,uint,uint,const void*)
            cppSelf->glConvolutionFilter2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionFilter2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glConvolutionParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glConvolutionParameterf(uint,uint,float)
            cppSelf->glConvolutionParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glConvolutionParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glConvolutionParameterfv(uint,uint,const float*)
            cppSelf->glConvolutionParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glConvolutionParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glConvolutionParameteri(uint,uint,int)
            cppSelf->glConvolutionParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glConvolutionParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glConvolutionParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glConvolutionParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glConvolutionParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glConvolutionParameteriv(uint,uint,const int*)
            cppSelf->glConvolutionParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glConvolutionParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorSubTable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyColorSubTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyColorSubTable", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyColorSubTable(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glCopyColorSubTable(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorSubTable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glCopyColorSubTable(uint,int,int,int,int)
            cppSelf->glCopyColorSubTable(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorSubTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorTable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyColorTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyColorTable", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyColorTable(uint,uint,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glCopyColorTable(uint,uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorTable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glCopyColorTable(uint,uint,int,int,int)
            cppSelf->glCopyColorTable(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyColorTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyConvolutionFilter1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyConvolutionFilter1D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyConvolutionFilter1D(uint,uint,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glCopyConvolutionFilter1D(uint,uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glCopyConvolutionFilter1D(uint,uint,int,int,int)
            cppSelf->glCopyConvolutionFilter1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyConvolutionFilter2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyConvolutionFilter2D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyConvolutionFilter2D(uint,uint,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glCopyConvolutionFilter2D(uint,uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glCopyConvolutionFilter2D(uint,uint,int,int,int,int)
            cppSelf->glCopyConvolutionFilter2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyConvolutionFilter2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyPixels(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyPixels", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyPixels(int,int,int,int,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glCopyPixels(int,int,int,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glCopyPixels(int,int,int,int,uint)
            cppSelf->glCopyPixels(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyTexImage1D(uint,int,uint,int,int,int,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glCopyTexImage1D(uint,int,uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCopyTexImage1D(uint,int,uint,int,int,int,int)
            cppSelf->glCopyTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
            cppSelf->glCopyTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage1D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyTexSubImage1D(uint,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glCopyTexSubImage1D(uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage1D(uint,int,int,int,int,int)
            cppSelf->glCopyTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCopyTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))) {
        overloadId = 0; // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCopyTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCreateProgram(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCreateProgram";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glCreateProgram()
            unsigned int cppResult = cppSelf->glCreateProgram();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCreateShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCreateShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCreateShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCreateShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCreateShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCreateShader(uint)
            unsigned int cppResult = cppSelf->glCreateShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCreateShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCullFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glCullFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glCullFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCullFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCullFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCullFace(uint)
            cppSelf->glCullFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glCullFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteBuffers(int,const uint*)
            cppSelf->glDeleteBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteFramebuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteFramebuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteFramebuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteFramebuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteFramebuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteFramebuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteFramebuffers(int,const uint*)
            cppSelf->glDeleteFramebuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteFramebuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteLists(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteLists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteLists", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteLists(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glDeleteLists(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteLists_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteLists(uint,int)
            cppSelf->glDeleteLists(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteLists_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteProgram(uint)
            cppSelf->glDeleteProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteQueries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteQueries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteQueries", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteQueries(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteQueries(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteQueries_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteQueries(int,const uint*)
            cppSelf->glDeleteQueries(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteQueries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteRenderbuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteRenderbuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteRenderbuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteRenderbuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteRenderbuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteRenderbuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteRenderbuffers(int,const uint*)
            cppSelf->glDeleteRenderbuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteRenderbuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteSamplers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteSamplers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteSamplers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteSamplers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteSamplers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteSamplers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteSamplers(int,const uint*)
            cppSelf->glDeleteSamplers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteSamplers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteShader(uint)
            cppSelf->glDeleteShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteTextures(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteTextures";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteTextures", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteTextures(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteTextures(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteTextures_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteTextures(int,const uint*)
            cppSelf->glDeleteTextures(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteTextures_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteVertexArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDeleteVertexArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteVertexArrays", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDeleteVertexArrays(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteVertexArrays(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteVertexArrays_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteVertexArrays(int,const uint*)
            cppSelf->glDeleteVertexArrays(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDeleteVertexArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthFunc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDepthFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDepthFunc(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDepthFunc(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthFunc(uint)
            cppSelf->glDepthFunc(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDepthMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDepthMask(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glDepthMask(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthMask(unsigned char)
            cppSelf->glDepthMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDepthRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDepthRange(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glDepthRange(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthRange_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDepthRange(double,double)
            cppSelf->glDepthRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDepthRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDetachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDetachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDetachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDetachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDetachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDetachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDetachShader(uint,uint)
            cppSelf->glDetachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDetachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDisable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDisable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisable(uint)
            cppSelf->glDisable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableClientState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDisableClientState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDisableClientState(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisableClientState(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableClientState_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisableClientState(uint)
            cppSelf->glDisableClientState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableClientState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDisableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDisableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisableVertexAttribArray(uint)
            cppSelf->glDisableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDisablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDisablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDisablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDisablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDisablei(uint,uint)
            cppSelf->glDisablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDisablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArrays", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawArrays(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawArrays(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawArrays(uint,int,int)
            cppSelf->glDrawArrays(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArraysInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawArraysInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysInstanced", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawArraysInstanced(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawArraysInstanced(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArraysInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawArraysInstanced(uint,int,int,int)
            cppSelf->glDrawArraysInstanced(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawArraysInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDrawBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDrawBuffer(uint)
            cppSelf->glDrawBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDrawBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawBuffers(int,const uint*)
            cppSelf->glDrawBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElements", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawElements(uint,int,uint,const void*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawElements(uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawElements(uint,int,uint,const void*)
            cppSelf->glDrawElements(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsBaseVertex", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawElementsInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstanced", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawElementsInstanced(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsInstanced(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstanced(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsInstanced(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstancedBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawElementsInstancedBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstancedBaseVertex", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstancedBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
            cppSelf->glDrawElementsInstancedBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawElementsInstancedBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawPixels(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawPixels", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawPixels(int,int,uint,uint,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawPixels(int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawPixels(int,int,uint,uint,const void*)
            cppSelf->glDrawPixels(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawRangeElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElements", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
            cppSelf->glDrawRangeElements(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glDrawRangeElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElementsBaseVertex", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
            cppSelf->glDrawRangeElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glDrawRangeElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlag(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEdgeFlag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEdgeFlag(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glEdgeFlag(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlag_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEdgeFlag(unsigned char)
            cppSelf->glEdgeFlag(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlag_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlagPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEdgeFlagPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEdgeFlagPointer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEdgeFlagPointer(int,const void*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
        overloadId = 0; // glEdgeFlagPointer(int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlagPointer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEdgeFlagPointer(int,const void*)
            cppSelf->glEdgeFlagPointer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEdgeFlagPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEnable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEnable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnable(uint)
            cppSelf->glEnable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableClientState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEnableClientState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEnableClientState(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnableClientState(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableClientState_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnableClientState(uint)
            cppSelf->glEnableClientState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableClientState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEnableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEnableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnableVertexAttribArray(uint)
            cppSelf->glEnableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEnablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEnablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEnablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glEnablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEnablei(uint,uint)
            cppSelf->glEnablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEnd()
            cppSelf->glEnd();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndConditionalRender(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEndConditionalRender";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndConditionalRender()
            cppSelf->glEndConditionalRender();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEndList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndList()
            cppSelf->glEndList();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEndQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEndQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEndQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEndQuery(uint)
            cppSelf->glEndQuery(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEndTransformFeedback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEndTransformFeedback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndTransformFeedback()
            cppSelf->glEndTransformFeedback();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1d(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord1d(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glEvalCoord1d(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord1d(double)
            cppSelf->glEvalCoord1d(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord1dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glEvalCoord1dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord1dv(const double*)
            cppSelf->glEvalCoord1dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1f(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord1f(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glEvalCoord1f(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord1f(float)
            cppSelf->glEvalCoord1f(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord1fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glEvalCoord1fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord1fv(const float*)
            cppSelf->glEvalCoord1fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEvalCoord2d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord2d(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glEvalCoord2d(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEvalCoord2d(double,double)
            cppSelf->glEvalCoord2d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord2dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glEvalCoord2dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord2dv(const double*)
            cppSelf->glEvalCoord2dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEvalCoord2f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord2f(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glEvalCoord2f(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEvalCoord2f(float,float)
            cppSelf->glEvalCoord2f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalCoord2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalCoord2fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glEvalCoord2fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalCoord2fv(const float*)
            cppSelf->glEvalCoord2fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalCoord2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh1(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalMesh1";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEvalMesh1", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalMesh1(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glEvalMesh1(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh1_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glEvalMesh1(uint,int,int)
            cppSelf->glEvalMesh1(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh1_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh2(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalMesh2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEvalMesh2", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalMesh2(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glEvalMesh2(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh2_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glEvalMesh2(uint,int,int,int,int)
            cppSelf->glEvalMesh2(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalMesh2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint1(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalPoint1";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalPoint1(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glEvalPoint1(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint1_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEvalPoint1(int)
            cppSelf->glEvalPoint1(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint1_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint2(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glEvalPoint2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEvalPoint2", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glEvalPoint2(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glEvalPoint2(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint2_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEvalPoint2(int,int)
            cppSelf->glEvalPoint2(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glEvalPoint2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFinish(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFinish";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFinish()
            cppSelf->glFinish();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFlush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFlush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFlush()
            cppSelf->glFlush();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogCoordPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFogCoordPointer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogCoordPointer(uint,int,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glFogCoordPointer(uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glFogCoordPointer(uint,int,const void*)
            cppSelf->glFogCoordPointer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogCoordd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogCoordd(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glFogCoordd(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordd_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFogCoordd(double)
            cppSelf->glFogCoordd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoorddv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogCoorddv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogCoorddv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glFogCoorddv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoorddv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFogCoorddv(const double*)
            cppSelf->glFogCoorddv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoorddv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogCoordf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogCoordf(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glFogCoordf(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordf_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFogCoordf(float)
            cppSelf->glFogCoordf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordfv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogCoordfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogCoordfv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glFogCoordfv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordfv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFogCoordfv(const float*)
            cppSelf->glFogCoordfv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogCoordfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFogf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glFogf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glFogf(uint,float)
            cppSelf->glFogf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFogfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glFogfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glFogfv(uint,const float*)
            cppSelf->glFogfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFogi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogi(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glFogi(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glFogi(uint,int)
            cppSelf->glFogi(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFogiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFogiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFogiv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glFogiv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glFogiv(uint,const int*)
            cppSelf->glFogiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFogiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferRenderbuffer", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferRenderbuffer(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferRenderbuffer(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferRenderbuffer(uint,uint,uint,uint)
            cppSelf->glFramebufferRenderbuffer(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferTexture(uint,uint,uint,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferTexture(uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture(uint,uint,uint,int)
            cppSelf->glFramebufferTexture(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferTexture1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture1D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferTexture1D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture1D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture1D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferTexture2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture2D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferTexture2D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture2D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture2D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferTexture3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture3D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
            cppSelf->glFramebufferTexture3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTexture3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTextureLayer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFramebufferTextureLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTextureLayer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFramebufferTextureLayer(uint,uint,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTextureLayer(uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTextureLayer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTextureLayer(uint,uint,uint,int,int)
            cppSelf->glFramebufferTextureLayer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFramebufferTextureLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrontFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFrontFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFrontFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glFrontFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrontFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFrontFace(uint)
            cppSelf->glFrontFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrontFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrustum(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glFrustum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFrustum", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glFrustum(double,double,double,double,double,double)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[5])))) {
        overloadId = 0; // glFrustum(double,double,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrustum_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        double cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glFrustum(double,double,double,double,double,double)
            cppSelf->glFrustum(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glFrustum_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenLists(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGenLists";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGenLists(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glGenLists(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenLists_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGenLists(int)
            unsigned int cppResult = cppSelf->glGenLists(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenLists_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenerateMipmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGenerateMipmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGenerateMipmap(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGenerateMipmap(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenerateMipmap_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGenerateMipmap(uint)
            cppSelf->glGenerateMipmap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGenerateMipmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetAttribLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetAttribLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetAttribLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetAttribLocation(uint,const char*)
            int cppResult = cppSelf->glGetAttribLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glGetError()
            unsigned int cppResult = cppSelf->glGetError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetFragDataIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetFragDataIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataIndex(uint,const char*)
            int cppResult = cppSelf->glGetFragDataIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetFragDataLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataLocation(uint,const char*)
            int cppResult = cppSelf->glGetFragDataLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetString(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGetString(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetString_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGetString(uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetString(cppArg0);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetStringi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetStringi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetStringi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetStringi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glGetStringi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetStringi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetStringi(uint,uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetStringi(cppArg0, cppArg1);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetStringi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformBlockIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetUniformBlockIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformBlockIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetUniformBlockIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformBlockIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformBlockIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformBlockIndex(uint,const char*)
            unsigned int cppResult = cppSelf->glGetUniformBlockIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformBlockIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glGetUniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glGetUniformLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformLocation(uint,const char*)
            int cppResult = cppSelf->glGetUniformLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glGetUniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glHint", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glHint(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glHint(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHint_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glHint(uint,uint)
            cppSelf->glHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHistogram(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glHistogram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glHistogram", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glHistogram(uint,int,uint,unsigned char)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))) {
        overloadId = 0; // glHistogram(uint,int,uint,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHistogram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glHistogram(uint,int,uint,unsigned char)
            cppSelf->glHistogram(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glHistogram_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexMask(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIndexMask(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexMask_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexMask(uint)
            cppSelf->glIndexMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glIndexPointer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexPointer(uint,int,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glIndexPointer(uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glIndexPointer(uint,int,const void*)
            cppSelf->glIndexPointer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexd(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glIndexd(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexd_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexd(double)
            cppSelf->glIndexd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexdv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexdv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexdv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glIndexdv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexdv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexdv(const double*)
            cppSelf->glIndexdv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexdv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexf(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glIndexf(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexf_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexf(float)
            cppSelf->glIndexf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexfv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexfv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glIndexfv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexfv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexfv(const float*)
            cppSelf->glIndexfv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexi(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexi(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glIndexi(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexi_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexi(int)
            cppSelf->glIndexi(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexi_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexiv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexiv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glIndexiv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexiv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexiv(const int*)
            cppSelf->glIndexiv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexs(short)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArg)))) {
        overloadId = 0; // glIndexs(short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexs_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexs(short)
            cppSelf->glIndexs(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexsv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexsv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexsv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glIndexsv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexsv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexsv(const short*)
            cppSelf->glIndexsv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexsv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexub(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexub(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexub(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexub(unsigned char)
            cppSelf->glIndexub(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexub_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIndexubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIndexubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexubv_TypeError;

    // Call function/method
    {
        unsigned char *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexubv(const unsigned char*)
            cppSelf->glIndexubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIndexubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glInitNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glInitNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glInitNames()
            cppSelf->glInitNames();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glInterleavedArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glInterleavedArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInterleavedArrays", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glInterleavedArrays(uint,int,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glInterleavedArrays(uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glInterleavedArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glInterleavedArrays(uint,int,const void*)
            cppSelf->glInterleavedArrays(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glInterleavedArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsBuffer(uint)
            unsigned char cppResult = cppSelf->glIsBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsEnabled(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsEnabled(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabled_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsEnabled(uint)
            unsigned char cppResult = cppSelf->glIsEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabledi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsEnabledi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glIsEnabledi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsEnabledi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glIsEnabledi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabledi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glIsEnabledi(uint,uint)
            unsigned char cppResult = cppSelf->glIsEnabledi(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsEnabledi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsFramebuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsFramebuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsFramebuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsFramebuffer(uint)
            unsigned char cppResult = cppSelf->glIsFramebuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsList(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsList(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsList_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsList(uint)
            unsigned char cppResult = cppSelf->glIsList(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsProgram(uint)
            unsigned char cppResult = cppSelf->glIsProgram(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsQuery(uint)
            unsigned char cppResult = cppSelf->glIsQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsRenderbuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsRenderbuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsRenderbuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsRenderbuffer(uint)
            unsigned char cppResult = cppSelf->glIsRenderbuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsSampler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsSampler(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsSampler(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsSampler(uint)
            unsigned char cppResult = cppSelf->glIsSampler(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsShader(uint)
            unsigned char cppResult = cppSelf->glIsShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsTexture(uint)
            unsigned char cppResult = cppSelf->glIsTexture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glIsVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glIsVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsVertexArray(uint)
            unsigned char cppResult = cppSelf->glIsVertexArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glIsVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightModelf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightModelf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightModelf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glLightModelf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glLightModelf(uint,float)
            cppSelf->glLightModelf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightModelfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightModelfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightModelfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glLightModelfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glLightModelfv(uint,const float*)
            cppSelf->glLightModelfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModelfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeli(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightModeli";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightModeli", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightModeli(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glLightModeli(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeli_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glLightModeli(uint,int)
            cppSelf->glLightModeli(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeli_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeliv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightModeliv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightModeliv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightModeliv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glLightModeliv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeliv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glLightModeliv(uint,const int*)
            cppSelf->glLightModeliv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightModeliv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glLightf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glLightf(uint,uint,float)
            cppSelf->glLightf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glLightfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glLightfv(uint,uint,const float*)
            cppSelf->glLightfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLighti(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLighti";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLighti", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLighti(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glLighti(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLighti_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glLighti(uint,uint,int)
            cppSelf->glLighti(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLighti_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLightiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLightiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLightiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glLightiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glLightiv(uint,uint,const int*)
            cppSelf->glLightiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLightiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineStipple(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLineStipple";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glLineStipple", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLineStipple(int,unsigned short)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[1])))) {
        overloadId = 0; // glLineStipple(int,unsigned short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineStipple_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glLineStipple(int,unsigned short)
            cppSelf->glLineStipple(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineStipple_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLineWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLineWidth(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glLineWidth(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineWidth_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLineWidth(float)
            cppSelf->glLineWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLineWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLinkProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLinkProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLinkProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLinkProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLinkProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLinkProgram(uint)
            cppSelf->glLinkProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLinkProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glListBase(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glListBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glListBase(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glListBase(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glListBase_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glListBase(uint)
            cppSelf->glListBase(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glListBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadIdentity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadIdentity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glLoadIdentity()
            cppSelf->glLoadIdentity();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadMatrixd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLoadMatrixd(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glLoadMatrixd(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixd_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLoadMatrixd(const double*)
            cppSelf->glLoadMatrixd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadMatrixf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLoadMatrixf(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glLoadMatrixf(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixf_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLoadMatrixf(const float*)
            cppSelf->glLoadMatrixf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadMatrixf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLoadName(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLoadName(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadName_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLoadName(uint)
            cppSelf->glLoadName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadTransposeMatrixd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLoadTransposeMatrixd(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glLoadTransposeMatrixd(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixd_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLoadTransposeMatrixd(const double*)
            cppSelf->glLoadTransposeMatrixd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLoadTransposeMatrixf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLoadTransposeMatrixf(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glLoadTransposeMatrixf(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixf_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLoadTransposeMatrixf(const float*)
            cppSelf->glLoadTransposeMatrixf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLoadTransposeMatrixf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLogicOp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glLogicOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glLogicOp(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLogicOp(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLogicOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLogicOp(uint)
            cppSelf->glLogicOp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glLogicOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMap1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMap1d", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMap1d(uint,double,double,int,int,const double*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && PyFloat_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[5])))) {
        overloadId = 0; // glMap1d(uint,double,double,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        Shiboken::Conversions::ArrayHandle<double> cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glMap1d(uint,double,double,int,int,const double*)
            cppSelf->glMap1d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMap1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMap1f", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMap1f(uint,float,float,int,int,const float*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && PyFloat_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[5])))) {
        overloadId = 0; // glMap1f(uint,float,float,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        Shiboken::Conversions::ArrayHandle<float> cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glMap1f(uint,float,float,int,int,const float*)
            cppSelf->glMap1f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMap2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMap2d", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMap2d(uint,double,double,int,int,double,double,int,int,const double*)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))
        && PyFloat_Check(pyArgs[9]) && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[9])))) {
        overloadId = 0; // glMap2d(uint,double,double,int,int,double,double,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        double cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        double cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        Shiboken::Conversions::ArrayHandle<double> cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glMap2d(uint,double,double,int,int,double,double,int,int,const double*)
            cppSelf->glMap2d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMap2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMap2f", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMap2f(uint,float,float,int,int,float,float,int,int,const float*)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))
        && PyFloat_Check(pyArgs[9]) && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[9])))) {
        overloadId = 0; // glMap2f(uint,float,float,int,int,float,float,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        float cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        Shiboken::Conversions::ArrayHandle<float> cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glMap2f(uint,float,float,int,int,float,float,int,int,const float*)
            cppSelf->glMap2f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMap2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMapBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glMapBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMapBuffer(uint,uint)
            void * cppResult = cppSelf->glMapBuffer(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMapGrid1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapGrid1d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMapGrid1d(int,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glMapGrid1d(int,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMapGrid1d(int,double,double)
            cppSelf->glMapGrid1d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMapGrid1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapGrid1f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMapGrid1f(int,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glMapGrid1f(int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMapGrid1f(int,float,float)
            cppSelf->glMapGrid1f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMapGrid2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapGrid2d", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMapGrid2d(int,double,double,int,double,double)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[5])))) {
        overloadId = 0; // glMapGrid2d(int,double,double,int,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        double cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glMapGrid2d(int,double,double,int,double,double)
            cppSelf->glMapGrid2d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMapGrid2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapGrid2f", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMapGrid2f(int,float,float,int,float,float)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
        overloadId = 0; // glMapGrid2f(int,float,float,int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glMapGrid2f(int,float,float,int,float,float)
            cppSelf->glMapGrid2f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMapGrid2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMaterialf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMaterialf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMaterialf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glMaterialf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMaterialf(uint,uint,float)
            cppSelf->glMaterialf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMaterialfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMaterialfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMaterialfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMaterialfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMaterialfv(uint,uint,const float*)
            cppSelf->glMaterialfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMateriali(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMateriali";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMateriali", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMateriali(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glMateriali(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMateriali_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMateriali(uint,uint,int)
            cppSelf->glMateriali(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMateriali_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMaterialiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMaterialiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMaterialiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMaterialiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMaterialiv(uint,uint,const int*)
            cppSelf->glMaterialiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMaterialiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMatrixMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMatrixMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMatrixMode(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glMatrixMode(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMatrixMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMatrixMode(uint)
            cppSelf->glMatrixMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMatrixMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMinmax(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMinmax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMinmax", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMinmax(uint,uint,unsigned char)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))) {
        overloadId = 0; // glMinmax(uint,uint,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMinmax_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMinmax(uint,uint,unsigned char)
            cppSelf->glMinmax(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMinmax_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultMatrixd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultMatrixd(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glMultMatrixd(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixd_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMultMatrixd(const double*)
            cppSelf->glMultMatrixd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultMatrixf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultMatrixf(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glMultMatrixf(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixf_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMultMatrixf(const float*)
            cppSelf->glMultMatrixf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultMatrixf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultTransposeMatrixd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultTransposeMatrixd(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glMultTransposeMatrixd(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixd_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMultTransposeMatrixd(const double*)
            cppSelf->glMultTransposeMatrixd(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixd_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultTransposeMatrixf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultTransposeMatrixf(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glMultTransposeMatrixf(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixf_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMultTransposeMatrixf(const float*)
            cppSelf->glMultTransposeMatrixf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultTransposeMatrixf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiDrawArrays", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiDrawArrays(uint,const int*,const int*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiDrawArrays(uint,const int*,const int*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiDrawArrays(uint,const int*,const int*,int)
            cppSelf->glMultiDrawArrays(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1d(uint,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1d(uint,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1d(uint,double)
            cppSelf->glMultiTexCoord1d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1dv(uint,const double*)
            cppSelf->glMultiTexCoord1dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1f(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1f(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1f(uint,float)
            cppSelf->glMultiTexCoord1f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1fv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1fv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1fv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1fv(uint,const float*)
            cppSelf->glMultiTexCoord1fv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1i(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1i(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1i(uint,int)
            cppSelf->glMultiTexCoord1i(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1iv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1iv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1iv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1iv(uint,const int*)
            cppSelf->glMultiTexCoord1iv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1s", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1s(uint,short)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1s(uint,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1s_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1s(uint,short)
            cppSelf->glMultiTexCoord1s(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1sv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord1sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord1sv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord1sv(uint,const short*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord1sv(uint,const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1sv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<short> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord1sv(uint,const short*)
            cppSelf->glMultiTexCoord1sv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord1sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2d(uint,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoord2d(uint,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2d(uint,double,double)
            cppSelf->glMultiTexCoord2d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord2dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2dv(uint,const double*)
            cppSelf->glMultiTexCoord2dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2f(uint,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoord2f(uint,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2f(uint,float,float)
            cppSelf->glMultiTexCoord2f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2fv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2fv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord2fv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2fv(uint,const float*)
            cppSelf->glMultiTexCoord2fv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2i(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoord2i(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2i(uint,int,int)
            cppSelf->glMultiTexCoord2i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2iv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2iv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord2iv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2iv(uint,const int*)
            cppSelf->glMultiTexCoord2iv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2s", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2s(uint,short,short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoord2s(uint,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2s_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2s(uint,short,short)
            cppSelf->glMultiTexCoord2s(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2sv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord2sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord2sv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord2sv(uint,const short*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord2sv(uint,const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2sv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<short> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord2sv(uint,const short*)
            cppSelf->glMultiTexCoord2sv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord2sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3d(uint,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiTexCoord3d(uint,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3d(uint,double,double,double)
            cppSelf->glMultiTexCoord3d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord3dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3dv(uint,const double*)
            cppSelf->glMultiTexCoord3dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3f(uint,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiTexCoord3f(uint,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3f(uint,float,float,float)
            cppSelf->glMultiTexCoord3f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3fv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3fv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord3fv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3fv(uint,const float*)
            cppSelf->glMultiTexCoord3fv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3i(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiTexCoord3i(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3i(uint,int,int,int)
            cppSelf->glMultiTexCoord3i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3iv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3iv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord3iv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3iv(uint,const int*)
            cppSelf->glMultiTexCoord3iv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3s", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3s(uint,short,short,short)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiTexCoord3s(uint,short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3s_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3s(uint,short,short,short)
            cppSelf->glMultiTexCoord3s(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3sv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord3sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord3sv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord3sv(uint,const short*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord3sv(uint,const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3sv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<short> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord3sv(uint,const short*)
            cppSelf->glMultiTexCoord3sv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord3sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4d", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4d(uint,double,double,double,double)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))) {
        overloadId = 0; // glMultiTexCoord4d(uint,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4d(uint,double,double,double,double)
            cppSelf->glMultiTexCoord4d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord4dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4dv(uint,const double*)
            cppSelf->glMultiTexCoord4dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4f", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4f(uint,float,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glMultiTexCoord4f(uint,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4f(uint,float,float,float,float)
            cppSelf->glMultiTexCoord4f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4fv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4fv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord4fv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4fv(uint,const float*)
            cppSelf->glMultiTexCoord4fv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4i(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glMultiTexCoord4i(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4i(uint,int,int,int,int)
            cppSelf->glMultiTexCoord4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4iv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4iv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord4iv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4iv(uint,const int*)
            cppSelf->glMultiTexCoord4iv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4s", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4s(uint,short,short,short,short)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[4])))) {
        overloadId = 0; // glMultiTexCoord4s(uint,short,short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4s_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        short cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4s(uint,short,short,short,short)
            cppSelf->glMultiTexCoord4s(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4sv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoord4sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoord4sv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoord4sv(uint,const short*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glMultiTexCoord4sv(uint,const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4sv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<short> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMultiTexCoord4sv(uint,const short*)
            cppSelf->glMultiTexCoord4sv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoord4sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP1ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP1ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP1ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP1ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP1ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP1uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP1uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP1uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP1uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP1uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP2ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP2ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP2ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP2ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP2ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP2uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP2uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP2uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP2uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP2uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP3ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP3ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP3ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP3ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP3ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP3uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP3uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP3uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP3uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP3uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP4ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP4ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP4ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP4ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP4ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glMultiTexCoordP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP4uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glMultiTexCoordP4uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP4uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP4uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP4uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glMultiTexCoordP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNewList(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNewList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNewList", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNewList(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glNewList(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNewList_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glNewList(uint,uint)
            cppSelf->glNewList(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNewList_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3b(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3b";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormal3b", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3b(signed char,signed char,signed char)
    if (numArgs == 3
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[2])))) {
        overloadId = 0; // glNormal3b(signed char,signed char,signed char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3b_TypeError;

    // Call function/method
    {
        signed char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        signed char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        signed char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormal3b(signed char,signed char,signed char)
            cppSelf->glNormal3b(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3b_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3bv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3bv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3bv(const signed char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<signed char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glNormal3bv(const signed char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3bv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<signed char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glNormal3bv(const signed char*)
            cppSelf->glNormal3bv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3bv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormal3d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3d(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glNormal3d(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormal3d(double,double,double)
            cppSelf->glNormal3d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glNormal3dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glNormal3dv(const double*)
            cppSelf->glNormal3dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormal3f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3f(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glNormal3f(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormal3f(float,float,float)
            cppSelf->glNormal3f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glNormal3fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glNormal3fv(const float*)
            cppSelf->glNormal3fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormal3i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glNormal3i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormal3i(int,int,int)
            cppSelf->glNormal3i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glNormal3iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glNormal3iv(const int*)
            cppSelf->glNormal3iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormal3s", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3s(short,short,short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))) {
        overloadId = 0; // glNormal3s(short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormal3s(short,short,short)
            cppSelf->glNormal3s(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormal3sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormal3sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glNormal3sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glNormal3sv(const short*)
            cppSelf->glNormal3sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormal3sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormalP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormalP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormalP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glNormalP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glNormalP3ui(uint,uint)
            cppSelf->glNormalP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormalP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormalP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormalP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glNormalP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glNormalP3uiv(uint,const uint*)
            cppSelf->glNormalP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glNormalPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormalPointer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glNormalPointer(uint,int,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glNormalPointer(uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glNormalPointer(uint,int,const void*)
            cppSelf->glNormalPointer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glNormalPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glOrtho(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glOrtho";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glOrtho", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glOrtho(double,double,double,double,double,double)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[5])))) {
        overloadId = 0; // glOrtho(double,double,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glOrtho_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        double cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glOrtho(double,double,double,double,double,double)
            cppSelf->glOrtho(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glOrtho_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPassThrough(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPassThrough";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPassThrough(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glPassThrough(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPassThrough_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPassThrough(float)
            cppSelf->glPassThrough(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPassThrough_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelMapfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelMapfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelMapfv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glPixelMapfv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glPixelMapfv(uint,int,const float*)
            cppSelf->glPixelMapfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelMapuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelMapuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelMapuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glPixelMapuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glPixelMapuiv(uint,int,const uint*)
            cppSelf->glPixelMapuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapusv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelMapusv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelMapusv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelMapusv(uint,int,const unsigned short*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned short>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glPixelMapusv(uint,int,const unsigned short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapusv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned short> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glPixelMapusv(uint,int,const unsigned short*)
            cppSelf->glPixelMapusv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelMapusv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStoref(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelStoref";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStoref", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelStoref(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStoref(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStoref_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStoref(uint,float)
            cppSelf->glPixelStoref(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStoref_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStorei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelStorei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStorei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelStorei(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStorei(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStorei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStorei(uint,int)
            cppSelf->glPixelStorei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelStorei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelTransferf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelTransferf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelTransferf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelTransferf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelTransferf(uint,float)
            cppSelf->glPixelTransferf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelTransferi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelTransferi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelTransferi(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelTransferi(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelTransferi(uint,int)
            cppSelf->glPixelTransferi(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelTransferi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelZoom(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPixelZoom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelZoom", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPixelZoom(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelZoom(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelZoom_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelZoom(float,float)
            cppSelf->glPixelZoom(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPixelZoom_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPointParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPointParameterf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameterf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterf(uint,float)
            cppSelf->glPointParameterf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPointParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPointParameterfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameterfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterfv(uint,const float*)
            cppSelf->glPointParameterfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPointParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteri", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPointParameteri(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameteri(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteri(uint,int)
            cppSelf->glPointParameteri(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPointParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteriv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPointParameteriv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameteriv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteriv(uint,const int*)
            cppSelf->glPointParameteriv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPointSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPointSize(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glPointSize(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointSize_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPointSize(float)
            cppSelf->glPointSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPointSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonMode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPolygonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonMode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPolygonMode(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonMode(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonMode(uint,uint)
            cppSelf->glPolygonMode(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonOffset(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPolygonOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonOffset", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPolygonOffset(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonOffset(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonOffset_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonOffset(float,float)
            cppSelf->glPolygonOffset(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPolygonOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPopAttrib(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPopAttrib";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPopAttrib()
            cppSelf->glPopAttrib();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPopClientAttrib(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPopClientAttrib";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPopClientAttrib()
            cppSelf->glPopClientAttrib();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPopMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPopMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPopMatrix()
            cppSelf->glPopMatrix();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPopName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPopName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPopName()
            cppSelf->glPopName();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrimitiveRestartIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPrimitiveRestartIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPrimitiveRestartIndex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPrimitiveRestartIndex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrimitiveRestartIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPrimitiveRestartIndex(uint)
            cppSelf->glPrimitiveRestartIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrimitiveRestartIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrioritizeTextures(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPrioritizeTextures";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPrioritizeTextures", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPrioritizeTextures(int,const uint*,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glPrioritizeTextures(int,const uint*,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrioritizeTextures_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glPrioritizeTextures(int,const uint*,const float*)
            cppSelf->glPrioritizeTextures(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPrioritizeTextures_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glProvokingVertex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glProvokingVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glProvokingVertex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glProvokingVertex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glProvokingVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glProvokingVertex(uint)
            cppSelf->glProvokingVertex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glProvokingVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushAttrib(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPushAttrib";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPushAttrib(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPushAttrib(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushAttrib_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPushAttrib(uint)
            cppSelf->glPushAttrib(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushAttrib_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushClientAttrib(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPushClientAttrib";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPushClientAttrib(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPushClientAttrib(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushClientAttrib_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPushClientAttrib(uint)
            cppSelf->glPushClientAttrib(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushClientAttrib_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPushMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPushMatrix()
            cppSelf->glPushMatrix();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glPushName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glPushName(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPushName(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushName_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPushName(uint)
            cppSelf->glPushName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glPushName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glQueryCounter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glQueryCounter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glQueryCounter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glQueryCounter(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glQueryCounter(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glQueryCounter_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glQueryCounter(uint,uint)
            cppSelf->glQueryCounter(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glQueryCounter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos2d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2d(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glRasterPos2d(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRasterPos2d(double,double)
            cppSelf->glRasterPos2d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos2dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos2dv(const double*)
            cppSelf->glRasterPos2dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos2f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2f(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glRasterPos2f(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRasterPos2f(float,float)
            cppSelf->glRasterPos2f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos2fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos2fv(const float*)
            cppSelf->glRasterPos2fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos2i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2i(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glRasterPos2i(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRasterPos2i(int,int)
            cppSelf->glRasterPos2i(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos2iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos2iv(const int*)
            cppSelf->glRasterPos2iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos2s", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2s(short,short)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))) {
        overloadId = 0; // glRasterPos2s(short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRasterPos2s(short,short)
            cppSelf->glRasterPos2s(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos2sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos2sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos2sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos2sv(const short*)
            cppSelf->glRasterPos2sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos2sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos3d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3d(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glRasterPos3d(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glRasterPos3d(double,double,double)
            cppSelf->glRasterPos3d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos3dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos3dv(const double*)
            cppSelf->glRasterPos3dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos3f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3f(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glRasterPos3f(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glRasterPos3f(float,float,float)
            cppSelf->glRasterPos3f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos3fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos3fv(const float*)
            cppSelf->glRasterPos3fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos3i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glRasterPos3i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glRasterPos3i(int,int,int)
            cppSelf->glRasterPos3i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos3iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos3iv(const int*)
            cppSelf->glRasterPos3iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos3s", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3s(short,short,short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))) {
        overloadId = 0; // glRasterPos3s(short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glRasterPos3s(short,short,short)
            cppSelf->glRasterPos3s(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos3sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos3sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos3sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos3sv(const short*)
            cppSelf->glRasterPos3sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos3sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos4d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4d(double,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glRasterPos4d(double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRasterPos4d(double,double,double,double)
            cppSelf->glRasterPos4d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos4dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos4dv(const double*)
            cppSelf->glRasterPos4dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos4f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4f(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glRasterPos4f(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRasterPos4f(float,float,float,float)
            cppSelf->glRasterPos4f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos4fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos4fv(const float*)
            cppSelf->glRasterPos4fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos4i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4i(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glRasterPos4i(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRasterPos4i(int,int,int,int)
            cppSelf->glRasterPos4i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos4iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos4iv(const int*)
            cppSelf->glRasterPos4iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRasterPos4s", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4s(short,short,short,short)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[3])))) {
        overloadId = 0; // glRasterPos4s(short,short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRasterPos4s(short,short,short,short)
            cppSelf->glRasterPos4s(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRasterPos4sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRasterPos4sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glRasterPos4sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRasterPos4sv(const short*)
            cppSelf->glRasterPos4sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRasterPos4sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glReadBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glReadBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glReadBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glReadBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glReadBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glReadBuffer(uint)
            cppSelf->glReadBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glReadBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectd(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectd";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectd", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectd(double,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glRectd(double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectd_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRectd(double,double,double,double)
            cppSelf->glRectd(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectd_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectdv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectdv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectdv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectdv(const double*,const double*)
    if (numArgs == 2
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glRectdv(const double*,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectdv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRectdv(const double*,const double*)
            cppSelf->glRectdv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectdv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectf", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectf(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glRectf(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectf_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRectf(float,float,float,float)
            cppSelf->glRectf(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectfv(const float*,const float*)
    if (numArgs == 2
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glRectfv(const float*,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectfv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRectfv(const float*,const float*)
            cppSelf->glRectfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRecti(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRecti";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRecti", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRecti(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glRecti(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRecti_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRecti(int,int,int,int)
            cppSelf->glRecti(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRecti_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectiv(const int*,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glRectiv(const int*,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectiv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRectiv(const int*,const int*)
            cppSelf->glRectiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRects(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRects", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRects(short,short,short,short)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[3])))) {
        overloadId = 0; // glRects(short,short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRects_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        short cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRects(short,short,short,short)
            cppSelf->glRects(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRects_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectsv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRectsv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRectsv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRectsv(const short*,const short*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glRectsv(const short*,const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectsv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<short> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glRectsv(const short*,const short*)
            cppSelf->glRectsv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRectsv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRenderMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRenderMode(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glRenderMode(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glRenderMode(uint)
            int cppResult = cppSelf->glRenderMode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRenderbufferStorage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRenderbufferStorage(uint,uint,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glRenderbufferStorage(uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorage_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorage(uint,uint,int,int)
            cppSelf->glRenderbufferStorage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorageMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRenderbufferStorageMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorageMultisample", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRenderbufferStorageMultisample(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glRenderbufferStorageMultisample(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorageMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorageMultisample(uint,int,uint,int,int)
            cppSelf->glRenderbufferStorageMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRenderbufferStorageMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetHistogram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glResetHistogram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glResetHistogram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glResetHistogram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetHistogram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glResetHistogram(uint)
            cppSelf->glResetHistogram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetHistogram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetMinmax(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glResetMinmax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glResetMinmax(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glResetMinmax(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetMinmax_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glResetMinmax(uint)
            cppSelf->glResetMinmax(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glResetMinmax_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotated(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRotated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRotated", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRotated(double,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glRotated(double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotated_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRotated(double,double,double,double)
            cppSelf->glRotated(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotated_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotatef(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glRotatef";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRotatef", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glRotatef(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glRotatef(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotatef_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRotatef(float,float,float,float)
            cppSelf->glRotatef(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glRotatef_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleCoverage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSampleCoverage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleCoverage", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSampleCoverage(float,unsigned char)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleCoverage(float,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleCoverage_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleCoverage(float,unsigned char)
            cppSelf->glSampleCoverage(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleCoverage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSampleMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleMaski", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSampleMaski(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleMaski(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleMaski(uint,uint)
            cppSelf->glSampleMaski(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSampleMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIiv(uint,uint,const int*)
            cppSelf->glSamplerParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIuiv(uint,uint,const uint*)
            cppSelf->glSamplerParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterf(uint,uint,float)
            cppSelf->glSamplerParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterfv(uint,uint,const float*)
            cppSelf->glSamplerParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteri(uint,uint,int)
            cppSelf->glSamplerParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSamplerParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSamplerParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteriv(uint,uint,const int*)
            cppSelf->glSamplerParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSamplerParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScaled(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glScaled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScaled", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glScaled(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glScaled(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScaled_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glScaled(double,double,double)
            cppSelf->glScaled(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScaled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScalef(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glScalef";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScalef", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glScalef(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glScalef(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScalef_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glScalef(float,float,float)
            cppSelf->glScalef(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScalef_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScissor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glScissor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glScissor(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glScissor(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScissor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glScissor(int,int,int,int)
            cppSelf->glScissor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glScissor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3b(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3b";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3b", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3b(signed char,signed char,signed char)
    if (numArgs == 3
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3b(signed char,signed char,signed char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3b_TypeError;

    // Call function/method
    {
        signed char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        signed char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        signed char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3b(signed char,signed char,signed char)
            cppSelf->glSecondaryColor3b(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3b_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3bv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3bv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3bv(const signed char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<signed char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3bv(const signed char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3bv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<signed char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3bv(const signed char*)
            cppSelf->glSecondaryColor3bv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3bv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3d(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3d(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3d(double,double,double)
            cppSelf->glSecondaryColor3d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3dv(const double*)
            cppSelf->glSecondaryColor3dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3f(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3f(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3f(float,float,float)
            cppSelf->glSecondaryColor3f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3fv(const float*)
            cppSelf->glSecondaryColor3fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3i(int,int,int)
            cppSelf->glSecondaryColor3i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3iv(const int*)
            cppSelf->glSecondaryColor3iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3s", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3s(short,short,short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3s(short,short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3s(short,short,short)
            cppSelf->glSecondaryColor3s(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3sv(const short*)
            cppSelf->glSecondaryColor3sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ub(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3ub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3ub", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3ub(unsigned char,unsigned char,unsigned char)
    if (numArgs == 3
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3ub(unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3ub(unsigned char,unsigned char,unsigned char)
            cppSelf->glSecondaryColor3ub(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ub_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3ubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3ubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned char>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3ubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ubv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned char> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3ubv(const unsigned char*)
            cppSelf->glSecondaryColor3ubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3ui(uint,uint,uint)
            cppSelf->glSecondaryColor3ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3uiv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3uiv(const uint*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3uiv(const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3uiv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3uiv(const uint*)
            cppSelf->glSecondaryColor3uiv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3us(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3us";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColor3us", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3us(unsigned short,unsigned short,unsigned short)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), (pyArgs[2])))) {
        overloadId = 0; // glSecondaryColor3us(unsigned short,unsigned short,unsigned short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3us_TypeError;

    // Call function/method
    {
        unsigned short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned short cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3us(unsigned short,unsigned short,unsigned short)
            cppSelf->glSecondaryColor3us(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3us_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3usv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColor3usv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColor3usv(const unsigned short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glSecondaryColor3usv(const unsigned short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3usv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<unsigned short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glSecondaryColor3usv(const unsigned short*)
            cppSelf->glSecondaryColor3usv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColor3usv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColorP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColorP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColorP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glSecondaryColorP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSecondaryColorP3ui(uint,uint)
            cppSelf->glSecondaryColorP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColorP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColorP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColorP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glSecondaryColorP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSecondaryColorP3uiv(uint,const uint*)
            cppSelf->glSecondaryColorP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSecondaryColorPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColorPointer", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSecondaryColorPointer(int,uint,int,const void*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
        overloadId = 0; // glSecondaryColorPointer(int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorPointer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glSecondaryColorPointer(int,uint,int,const void*)
            cppSelf->glSecondaryColorPointer(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSecondaryColorPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSeparableFilter2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glSeparableFilter2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSeparableFilter2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glSeparableFilter2D(uint,uint,int,int,uint,uint,const void*,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glSeparableFilter2D(uint,uint,int,int,uint,uint,const void*,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSeparableFilter2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glSeparableFilter2D(uint,uint,int,int,uint,uint,const void*,const void*)
            cppSelf->glSeparableFilter2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glSeparableFilter2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glShadeModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glShadeModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glShadeModel(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glShadeModel(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glShadeModel_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glShadeModel(uint)
            cppSelf->glShadeModel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glShadeModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFunc", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilFunc(uint,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilFunc(uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilFunc(uint,int,uint)
            cppSelf->glStencilFunc(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilFuncSeparate(uint,uint,int,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilFuncSeparate(uint,uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilFuncSeparate(uint,uint,int,uint)
            cppSelf->glStencilFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilMask(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glStencilMask(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMask_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glStencilMask(uint)
            cppSelf->glStencilMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMaskSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilMaskSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilMaskSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilMaskSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glStencilMaskSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMaskSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glStencilMaskSeparate(uint,uint)
            cppSelf->glStencilMaskSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilMaskSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOp(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOp", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilOp(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilOp(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilOp(uint,uint,uint)
            cppSelf->glStencilOp(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOpSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glStencilOpSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOpSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glStencilOpSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilOpSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOpSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilOpSeparate(uint,uint,uint,uint)
            cppSelf->glStencilOpSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glStencilOpSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexBuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexBuffer(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexBuffer(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexBuffer(uint,uint,uint)
            cppSelf->glTexBuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1d(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1d(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glTexCoord1d(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1d(double)
            cppSelf->glTexCoord1d(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord1dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1dv(const double*)
            cppSelf->glTexCoord1dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1f(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1f(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glTexCoord1f(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1f(float)
            cppSelf->glTexCoord1f(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord1fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1fv(const float*)
            cppSelf->glTexCoord1fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1i(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1i(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glTexCoord1i(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1i(int)
            cppSelf->glTexCoord1i(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord1iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1iv(const int*)
            cppSelf->glTexCoord1iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1s(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1s(short)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArg)))) {
        overloadId = 0; // glTexCoord1s(short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1s(short)
            cppSelf->glTexCoord1s(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1s_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord1sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord1sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord1sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord1sv(const short*)
            cppSelf->glTexCoord1sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord1sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord2d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2d(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoord2d(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoord2d(double,double)
            cppSelf->glTexCoord2d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord2dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord2dv(const double*)
            cppSelf->glTexCoord2dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord2f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2f(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoord2f(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoord2f(float,float)
            cppSelf->glTexCoord2f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord2fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord2fv(const float*)
            cppSelf->glTexCoord2fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord2i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2i(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoord2i(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoord2i(int,int)
            cppSelf->glTexCoord2i(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2iv(const int*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord2iv(const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2iv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<int> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord2iv(const int*)
            cppSelf->glTexCoord2iv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2s(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2s";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord2s", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2s(short,short)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<short>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoord2s(short,short)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2s_TypeError;

    // Call function/method
    {
        short cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        short cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoord2s(short,short)
            cppSelf->glTexCoord2s(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2s_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2sv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord2sv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord2sv(const short*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<short>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord2sv(const short*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2sv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<short> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord2sv(const short*)
            cppSelf->glTexCoord2sv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord2sv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord3d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord3d(double,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glTexCoord3d(double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3d_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexCoord3d(double,double,double)
            cppSelf->glTexCoord3d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3dv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord3dv(const double*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord3dv(const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3dv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<double> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord3dv(const double*)
            cppSelf->glTexCoord3dv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord3f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord3f(float,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glTexCoord3f(float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3f_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexCoord3f(float,float,float)
            cppSelf->glTexCoord3f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3fv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord3fv(const float*)
    if (PyFloat_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArg)))) {
        overloadId = 0; // glTexCoord3fv(const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3fv_TypeError;

    // Call function/method
    {
        Shiboken::Conversions::ArrayHandle<float> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glTexCoord3fv(const float*)
            cppSelf->glTexCoord3fv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoord3i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_3_3_Compatibility::glTexCoord3i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexCoord3i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexCoord3i(int,int,int)
            cppSelf->glTexCoord3i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_3_3_CompatibilityFunc_glTexCoord3iv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_3_3_Compatibility *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_3_3_Compatibility.glTexCoord3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Ove