/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglshaderprogram_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGLShaderProgramWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGLShaderProgramWrapper::QGLShaderProgramWrapper(::QObject * parent) : QGLShaderProgram(parent)
{
    resetPyMethodCache();
    // ... middle
}

QGLShaderProgramWrapper::QGLShaderProgramWrapper(const ::QGLContext * context, ::QObject * parent) : QGLShaderProgram(context, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGLShaderProgramWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGLShaderProgramWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGLShaderProgramWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGLShaderProgramWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGLShaderProgramWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGLShaderProgramWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QGLShaderProgramWrapper::link()
{
    if (m_PyMethodCache[6])
        return this->::QGLShaderProgram::link();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "link";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QGLShaderProgram::link();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLShaderProgram.link", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGLShaderProgramWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGLShaderProgramWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGLShaderProgram::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGLShaderProgramWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGLShaderProgram::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGLShaderProgramWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGLShaderProgramWrapper *>(this));
        return QGLShaderProgram::qt_metacast(_clname);
}

QGLShaderProgramWrapper::~QGLShaderProgramWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLShaderProgram_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLShaderProgram >()))
        return -1;

    ::QGLShaderProgramWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QGLShaderProgram", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGLShaderProgram::QGLShaderProgram(QObject*)
    // 1: QGLShaderProgram::QGLShaderProgram(const QGLContext*,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGLShaderProgram(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGLShaderProgram(const QGLContext*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QGLShaderProgram(const QGLContext*,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGLShaderProgram(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgram_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLShaderProgram(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgram_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QGLShaderProgram_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGLShaderProgram(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGLShaderProgramWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGLShaderProgramWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QGLShaderProgram(const QGLContext * context, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgram_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QGLShaderProgram_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGLContext *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGLShaderProgram(const QGLContext*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGLShaderProgramWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGLShaderProgramWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLShaderProgram >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLShaderProgram_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGLShaderProgram_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGLShaderProgram_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLShaderProgramFunc_addShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.addShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::addShader(QGLShader*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADER_IDX]), (pyArg)))) {
        overloadId = 0; // addShader(QGLShader*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_addShader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLShader *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addShader(QGLShader*)
            bool cppResult = cppSelf->addShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_addShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_addShaderFromSourceCode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addShaderFromSourceCode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QByteArray)
    // 1: QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QString)
    // 2: QGLShaderProgram::addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,const char*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 2; // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_addShaderFromSourceCode_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit> type, const QByteArray & source)
        {
            ::QFlags<QGLShader::ShaderTypeBit> cppArg0 = QFlags<QGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QByteArray)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit> type, const QString & source)
        {
            ::QFlags<QGLShader::ShaderTypeBit> cppArg0 = QFlags<QGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,QString)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit> type, const char * source)
        {
            ::QFlags<QGLShader::ShaderTypeBit> cppArg0 = QFlags<QGLShader::ShaderTypeBit>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addShaderFromSourceCode(QFlags<QGLShader::ShaderTypeBit>,const char*)
                bool cppResult = cppSelf->addShaderFromSourceCode(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_addShaderFromSourceCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_addShaderFromSourceFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addShaderFromSourceFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::addShaderFromSourceFile(QFlags<QGLShader::ShaderTypeBit>,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLSHADER_SHADERTYPEBIT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // addShaderFromSourceFile(QFlags<QGLShader::ShaderTypeBit>,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_addShaderFromSourceFile_TypeError;

    // Call function/method
    {
        ::QFlags<QGLShader::ShaderTypeBit> cppArg0 = QFlags<QGLShader::ShaderTypeBit>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // addShaderFromSourceFile(QFlags<QGLShader::ShaderTypeBit>,QString)
            bool cppResult = cppSelf->addShaderFromSourceFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_addShaderFromSourceFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_attributeLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.attributeLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::attributeLocation(QByteArray)const
    // 1: QGLShaderProgram::attributeLocation(QString)const
    // 2: QGLShaderProgram::attributeLocation(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // attributeLocation(const char*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // attributeLocation(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // attributeLocation(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_attributeLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // attributeLocation(const QByteArray & name) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // attributeLocation(QByteArray)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->attributeLocation(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // attributeLocation(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // attributeLocation(QString)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->attributeLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // attributeLocation(const char * name) const
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // attributeLocation(const char*)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->attributeLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_attributeLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_bindAttributeLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.bindAttributeLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bindAttributeLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::bindAttributeLocation(QByteArray,int)
    // 1: QGLShaderProgram::bindAttributeLocation(QString,int)
    // 2: QGLShaderProgram::bindAttributeLocation(const char*,int)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 2; // bindAttributeLocation(const char*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // bindAttributeLocation(QString,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // bindAttributeLocation(QByteArray,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_bindAttributeLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bindAttributeLocation(const QByteArray & name, int location)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(QByteArray,int)
                cppSelf->bindAttributeLocation(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // bindAttributeLocation(const QString & name, int location)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(QString,int)
                cppSelf->bindAttributeLocation(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // bindAttributeLocation(const char * name, int location)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindAttributeLocation(const char*,int)
                cppSelf->bindAttributeLocation(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_bindAttributeLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_disableAttributeArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.disableAttributeArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::disableAttributeArray(const char*)
    // 1: QGLShaderProgram::disableAttributeArray(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // disableAttributeArray(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // disableAttributeArray(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_disableAttributeArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // disableAttributeArray(const char * name)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // disableAttributeArray(const char*)
                cppSelf->disableAttributeArray(cppArg0);
            }
            break;
        }
        case 1: // disableAttributeArray(int location)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // disableAttributeArray(int)
                cppSelf->disableAttributeArray(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_disableAttributeArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_enableAttributeArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.enableAttributeArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::enableAttributeArray(const char*)
    // 1: QGLShaderProgram::enableAttributeArray(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // enableAttributeArray(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // enableAttributeArray(const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_enableAttributeArray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // enableAttributeArray(const char * name)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // enableAttributeArray(const char*)
                cppSelf->enableAttributeArray(cppArg0);
            }
            break;
        }
        case 1: // enableAttributeArray(int location)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // enableAttributeArray(int)
                cppSelf->enableAttributeArray(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_enableAttributeArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_geometryInputType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.geometryInputType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometryInputType()const
            GLenum cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->geometryInputType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_geometryOutputType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.geometryOutputType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometryOutputType()const
            GLenum cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->geometryOutputType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_geometryOutputVertexCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.geometryOutputVertexCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometryOutputVertexCount()const
            int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->geometryOutputVertexCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.hasOpenGLShaderPrograms";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:hasOpenGLShaderPrograms", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QGLShaderProgram::hasOpenGLShaderPrograms(const QGLContext*)
    if (numArgs == 0) {
        overloadId = 0; // hasOpenGLShaderPrograms(const QGLContext*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // hasOpenGLShaderPrograms(const QGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_context = Shiboken::String::createStaticString("context");
            if (PyDict_Contains(kwds, key_context)) {
                value = PyDict_GetItem(kwds, key_context);
                if (value && pyArgs[0]) {
                    errInfo = key_context;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_context);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGLContext *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // hasOpenGLShaderPrograms(const QGLContext*)
            bool cppResult = ::QGLShaderProgram::hasOpenGLShaderPrograms(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_isLinked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.isLinked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLinked()const
            bool cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->isLinked();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_link(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.link";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // link()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGLShaderProgram::link()
                : cppSelf->link();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_log(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.log";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // log()const
            QString cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->log();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_maxGeometryOutputVertices(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.maxGeometryOutputVertices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxGeometryOutputVertices()const
            int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->maxGeometryOutputVertices();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_programId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.programId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // programId()const
            GLuint cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->programId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLShaderProgramFunc_removeAllShaders(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.removeAllShaders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeAllShaders()
            cppSelf->removeAllShaders();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLShaderProgramFunc_removeShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.removeShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::removeShader(QGLShader*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADER_IDX]), (pyArg)))) {
        overloadId = 0; // removeShader(QGLShader*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_removeShader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLShader *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeShader(QGLShader*)
            cppSelf->removeShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_removeShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setAttributeArray2D(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setAttributeArray2D", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setAttributeArray(const char*,const QVector2D*,int)
    // 1: QGLShaderProgram::setAttributeArray(int,const QVector2D*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 1; // setAttributeArray(int,const QVector2D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // setAttributeArray(int,const QVector2D*,int)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 0; // setAttributeArray(const char*,const QVector2D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setAttributeArray(const char*,const QVector2D*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeArray(const char * name, const QVector2D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(const char*,const QVector2D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector2D *_list = new QVector2D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector2D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setAttributeArray(int location, const QVector2D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(int,const QVector2D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector2D *_list = new QVector2D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector2D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setAttributeArray2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setAttributeArray3D(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setAttributeArray3D", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setAttributeArray(const char*,const QVector3D*,int)
    // 1: QGLShaderProgram::setAttributeArray(int,const QVector3D*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 1; // setAttributeArray(int,const QVector3D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // setAttributeArray(int,const QVector3D*,int)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 0; // setAttributeArray(const char*,const QVector3D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setAttributeArray(const char*,const QVector3D*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeArray(const char * name, const QVector3D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(const char*,const QVector3D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector3D *_list = new QVector3D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector3D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setAttributeArray(int location, const QVector3D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(int,const QVector3D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector3D *_list = new QVector3D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector3D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setAttributeArray3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setAttributeArray4D(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray4D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setAttributeArray4D", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setAttributeArray(const char*,const QVector4D*,int)
    // 1: QGLShaderProgram::setAttributeArray(int,const QVector4D*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 1; // setAttributeArray(int,const QVector4D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // setAttributeArray(int,const QVector4D*,int)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        if (numArgs == 2) {
            overloadId = 0; // setAttributeArray(const char*,const QVector4D*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setAttributeArray(const char*,const QVector4D*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeArray(const char * name, const QVector4D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(const char*,const QVector4D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector4D *_list = new QVector4D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector4D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setAttributeArray(int location, const QVector4D * values, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[2]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeArray(int,const QVector4D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector4D *_list = new QVector4D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setAttributeArray(cppArg0, _list, cppArg2);
                    delete[] _list;
                 } else {
                    cppSelf->setAttributeArray(cppArg0, (QVector4D*)nullptr, cppArg2);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setAttributeArray4D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setAttributeBuffer(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setAttributeBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:setAttributeBuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setAttributeBuffer(const char*,GLenum,int,int,int)
    // 1: QGLShaderProgram::setAttributeBuffer(int,GLenum,int,int,int)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 1; // setAttributeBuffer(int,GLenum,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 1; // setAttributeBuffer(int,GLenum,int,int,int)
        }
    } else if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // setAttributeBuffer(const char*,GLenum,int,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // setAttributeBuffer(const char*,GLenum,int,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeBuffer(const char * name, GLenum type, int offset, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                }
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLenum cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeBuffer(const char*,GLenum,int,int,int)
                cppSelf->setAttributeBuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 1: // setAttributeBuffer(int location, GLenum type, int offset, int tupleSize, int stride)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_stride = Shiboken::String::createStaticString("stride");
                if (PyDict_Contains(kwds, key_stride)) {
                    value = PyDict_GetItem(kwds, key_stride);
                    if (value && pyArgs[4]) {
                        errInfo = key_stride;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                            goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_stride);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLenum cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4 = 0;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeBuffer(int,GLenum,int,int,int)
                cppSelf->setAttributeBuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setAttributeBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setAttributeValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttributeValue", 2, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setAttributeValue(const char*,GLfloat)
    // 1: QGLShaderProgram::setAttributeValue(const char*,GLfloat,GLfloat)
    // 2: QGLShaderProgram::setAttributeValue(const char*,GLfloat,GLfloat,GLfloat)
    // 3: QGLShaderProgram::setAttributeValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
    // 4: QGLShaderProgram::setAttributeValue(const char*,QColor)
    // 5: QGLShaderProgram::setAttributeValue(const char*,QVector2D)
    // 6: QGLShaderProgram::setAttributeValue(const char*,QVector3D)
    // 7: QGLShaderProgram::setAttributeValue(const char*,QVector4D)
    // 8: QGLShaderProgram::setAttributeValue(int,GLfloat)
    // 9: QGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat)
    // 10: QGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat,GLfloat)
    // 11: QGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
    // 12: QGLShaderProgram::setAttributeValue(int,QColor)
    // 13: QGLShaderProgram::setAttributeValue(int,QVector2D)
    // 14: QGLShaderProgram::setAttributeValue(int,QVector3D)
    // 15: QGLShaderProgram::setAttributeValue(int,QVector4D)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 13; // setAttributeValue(int,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 14; // setAttributeValue(int,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 15; // setAttributeValue(int,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 12; // setAttributeValue(int,QColor)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 8; // setAttributeValue(int,GLfloat)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 9; // setAttributeValue(int,GLfloat,GLfloat)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 10; // setAttributeValue(int,GLfloat,GLfloat,GLfloat)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[4])))) {
                        overloadId = 11; // setAttributeValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
                    }
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 5; // setAttributeValue(const char*,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 6; // setAttributeValue(const char*,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 7; // setAttributeValue(const char*,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 4; // setAttributeValue(const char*,QColor)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setAttributeValue(const char*,GLfloat)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // setAttributeValue(const char*,GLfloat,GLfloat)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // setAttributeValue(const char*,GLfloat,GLfloat,GLfloat)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[4])))) {
                        overloadId = 3; // setAttributeValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setAttributeValue_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAttributeValue(const char * name, GLfloat value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setAttributeValue(const char * name, GLfloat x, GLfloat y)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // setAttributeValue(const char * name, GLfloat x, GLfloat y, GLfloat z)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,GLfloat,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // setAttributeValue(const char * name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            GLfloat cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 4: // setAttributeValue(const char * name, const QColor & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QColor)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // setAttributeValue(const char * name, const QVector2D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector2D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 6: // setAttributeValue(const char * name, const QVector3D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector3D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // setAttributeValue(const char * name, const QVector4D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(const char*,QVector4D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 8: // setAttributeValue(int location, GLfloat value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1);
            }
            break;
        }
        case 9: // setAttributeValue(int location, GLfloat x, GLfloat y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 10: // setAttributeValue(int location, GLfloat x, GLfloat y, GLfloat z)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,GLfloat,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 11: // setAttributeValue(int location, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            GLfloat cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setAttributeValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
                cppSelf->setAttributeValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 12: // setAttributeValue(int location, const QColor & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QColor)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 13: // setAttributeValue(int location, const QVector2D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector2D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 14: // setAttributeValue(int location, const QVector3D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector3D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 15: // setAttributeValue(int location, const QVector4D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setAttributeValue(int,QVector4D)
                cppSelf->setAttributeValue(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setAttributeValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setGeometryInputType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setGeometryInputType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::setGeometryInputType(GLenum)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArg)))) {
        overloadId = 0; // setGeometryInputType(GLenum)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setGeometryInputType_TypeError;

    // Call function/method
    {
        GLenum cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGeometryInputType(GLenum)
            cppSelf->setGeometryInputType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setGeometryInputType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setGeometryOutputType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setGeometryOutputType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::setGeometryOutputType(GLenum)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArg)))) {
        overloadId = 0; // setGeometryOutputType(GLenum)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setGeometryOutputType_TypeError;

    // Call function/method
    {
        GLenum cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGeometryOutputType(GLenum)
            cppSelf->setGeometryOutputType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setGeometryOutputType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setGeometryOutputVertexCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setGeometryOutputVertexCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::setGeometryOutputVertexCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGeometryOutputVertexCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setGeometryOutputVertexCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGeometryOutputVertexCount(int)
            cppSelf->setGeometryOutputVertexCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setGeometryOutputVertexCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValue", 2, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValue(const char*,GLfloat)
    // 1: QGLShaderProgram::setUniformValue(const char*,GLfloat,GLfloat)
    // 2: QGLShaderProgram::setUniformValue(const char*,GLfloat,GLfloat,GLfloat)
    // 3: QGLShaderProgram::setUniformValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
    // 4: QGLShaderProgram::setUniformValue(const char*,GLint)
    // 5: QGLShaderProgram::setUniformValue(const char*,GLuint)
    // 6: QGLShaderProgram::setUniformValue(const char*,QColor)
    // 7: QGLShaderProgram::setUniformValue(const char*,QMatrix2x2)
    // 8: QGLShaderProgram::setUniformValue(const char*,QMatrix2x3)
    // 9: QGLShaderProgram::setUniformValue(const char*,QMatrix2x4)
    // 10: QGLShaderProgram::setUniformValue(const char*,QMatrix3x2)
    // 11: QGLShaderProgram::setUniformValue(const char*,QMatrix3x3)
    // 12: QGLShaderProgram::setUniformValue(const char*,QMatrix3x4)
    // 13: QGLShaderProgram::setUniformValue(const char*,QMatrix4x2)
    // 14: QGLShaderProgram::setUniformValue(const char*,QMatrix4x3)
    // 15: QGLShaderProgram::setUniformValue(const char*,QMatrix4x4)
    // 16: QGLShaderProgram::setUniformValue(const char*,QPoint)
    // 17: QGLShaderProgram::setUniformValue(const char*,QPointF)
    // 18: QGLShaderProgram::setUniformValue(const char*,QSize)
    // 19: QGLShaderProgram::setUniformValue(const char*,QSizeF)
    // 20: QGLShaderProgram::setUniformValue(const char*,QTransform)
    // 21: QGLShaderProgram::setUniformValue(const char*,QVector2D)
    // 22: QGLShaderProgram::setUniformValue(const char*,QVector3D)
    // 23: QGLShaderProgram::setUniformValue(const char*,QVector4D)
    // 24: QGLShaderProgram::setUniformValue(int,GLfloat)
    // 25: QGLShaderProgram::setUniformValue(int,GLfloat,GLfloat)
    // 26: QGLShaderProgram::setUniformValue(int,GLfloat,GLfloat,GLfloat)
    // 27: QGLShaderProgram::setUniformValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
    // 28: QGLShaderProgram::setUniformValue(int,GLint)
    // 29: QGLShaderProgram::setUniformValue(int,GLuint)
    // 30: QGLShaderProgram::setUniformValue(int,QColor)
    // 31: QGLShaderProgram::setUniformValue(int,QMatrix2x2)
    // 32: QGLShaderProgram::setUniformValue(int,QMatrix2x3)
    // 33: QGLShaderProgram::setUniformValue(int,QMatrix2x4)
    // 34: QGLShaderProgram::setUniformValue(int,QMatrix3x2)
    // 35: QGLShaderProgram::setUniformValue(int,QMatrix3x3)
    // 36: QGLShaderProgram::setUniformValue(int,QMatrix3x4)
    // 37: QGLShaderProgram::setUniformValue(int,QMatrix4x2)
    // 38: QGLShaderProgram::setUniformValue(int,QMatrix4x3)
    // 39: QGLShaderProgram::setUniformValue(int,QMatrix4x4)
    // 40: QGLShaderProgram::setUniformValue(int,QPoint)
    // 41: QGLShaderProgram::setUniformValue(int,QPointF)
    // 42: QGLShaderProgram::setUniformValue(int,QSize)
    // 43: QGLShaderProgram::setUniformValue(int,QSizeF)
    // 44: QGLShaderProgram::setUniformValue(int,QTransform)
    // 45: QGLShaderProgram::setUniformValue(int,QVector2D)
    // 46: QGLShaderProgram::setUniformValue(int,QVector3D)
    // 47: QGLShaderProgram::setUniformValue(int,QVector4D)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 45; // setUniformValue(int,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 46; // setUniformValue(int,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 47; // setUniformValue(int,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
            overloadId = 44; // setUniformValue(int,QTransform)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 42; // setUniformValue(int,QSize)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 43; // setUniformValue(int,QSizeF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 40; // setUniformValue(int,QPoint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
            overloadId = 41; // setUniformValue(int,QPointF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArgs[1])))) {
            overloadId = 39; // setUniformValue(int,QMatrix4x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), (pyArgs[1])))) {
            overloadId = 38; // setUniformValue(int,QMatrix4x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), (pyArgs[1])))) {
            overloadId = 37; // setUniformValue(int,QMatrix4x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), (pyArgs[1])))) {
            overloadId = 36; // setUniformValue(int,QMatrix3x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), (pyArgs[1])))) {
            overloadId = 35; // setUniformValue(int,QMatrix3x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), (pyArgs[1])))) {
            overloadId = 34; // setUniformValue(int,QMatrix3x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), (pyArgs[1])))) {
            overloadId = 33; // setUniformValue(int,QMatrix2x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), (pyArgs[1])))) {
            overloadId = 32; // setUniformValue(int,QMatrix2x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), (pyArgs[1])))) {
            overloadId = 31; // setUniformValue(int,QMatrix2x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
            overloadId = 29; // setUniformValue(int,GLuint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 30; // setUniformValue(int,QColor)
        } else if (numArgs >= 2
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 24; // setUniformValue(int,GLfloat)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 25; // setUniformValue(int,GLfloat,GLfloat)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 26; // setUniformValue(int,GLfloat,GLfloat,GLfloat)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[4])))) {
                        overloadId = 27; // setUniformValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
                    }
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[1])))) {
            overloadId = 28; // setUniformValue(int,GLint)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
            overloadId = 21; // setUniformValue(const char*,QVector2D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[1])))) {
            overloadId = 22; // setUniformValue(const char*,QVector3D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[1])))) {
            overloadId = 23; // setUniformValue(const char*,QVector4D)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[1])))) {
            overloadId = 20; // setUniformValue(const char*,QTransform)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 18; // setUniformValue(const char*,QSize)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 19; // setUniformValue(const char*,QSizeF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            overloadId = 16; // setUniformValue(const char*,QPoint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
            overloadId = 17; // setUniformValue(const char*,QPointF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArgs[1])))) {
            overloadId = 15; // setUniformValue(const char*,QMatrix4x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), (pyArgs[1])))) {
            overloadId = 14; // setUniformValue(const char*,QMatrix4x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), (pyArgs[1])))) {
            overloadId = 13; // setUniformValue(const char*,QMatrix4x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), (pyArgs[1])))) {
            overloadId = 12; // setUniformValue(const char*,QMatrix3x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), (pyArgs[1])))) {
            overloadId = 11; // setUniformValue(const char*,QMatrix3x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), (pyArgs[1])))) {
            overloadId = 10; // setUniformValue(const char*,QMatrix3x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), (pyArgs[1])))) {
            overloadId = 9; // setUniformValue(const char*,QMatrix2x4)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), (pyArgs[1])))) {
            overloadId = 8; // setUniformValue(const char*,QMatrix2x3)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), (pyArgs[1])))) {
            overloadId = 7; // setUniformValue(const char*,QMatrix2x2)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
            overloadId = 5; // setUniformValue(const char*,GLuint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 6; // setUniformValue(const char*,QColor)
        } else if (numArgs >= 2
            && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setUniformValue(const char*,GLfloat)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // setUniformValue(const char*,GLfloat,GLfloat)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // setUniformValue(const char*,GLfloat,GLfloat,GLfloat)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLfloat>(), (pyArgs[4])))) {
                        overloadId = 3; // setUniformValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
                    }
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[1])))) {
            overloadId = 4; // setUniformValue(const char*,GLint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValue_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValue(const char * name, GLfloat value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setUniformValue(const char * name, GLfloat x, GLfloat y)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // setUniformValue(const char * name, GLfloat x, GLfloat y, GLfloat z)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLfloat,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // setUniformValue(const char * name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            GLfloat cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLfloat,GLfloat,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 4: // setUniformValue(const char * name, GLint value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLint)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 5: // setUniformValue(const char * name, GLuint value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,GLuint)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 6: // setUniformValue(const char * name, const QColor & color)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QColor)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 7: // setUniformValue(const char * name, const QMatrix2x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x2 cppArg1_local;
            ::QMatrix2x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 8: // setUniformValue(const char * name, const QMatrix2x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x3 cppArg1_local;
            ::QMatrix2x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 9: // setUniformValue(const char * name, const QMatrix2x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x4 cppArg1_local;
            ::QMatrix2x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix2x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 10: // setUniformValue(const char * name, const QMatrix3x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x2 cppArg1_local;
            ::QMatrix3x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 11: // setUniformValue(const char * name, const QMatrix3x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x3 cppArg1_local;
            ::QMatrix3x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 12: // setUniformValue(const char * name, const QMatrix3x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x4 cppArg1_local;
            ::QMatrix3x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix3x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 13: // setUniformValue(const char * name, const QMatrix4x2 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x2 cppArg1_local;
            ::QMatrix4x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 14: // setUniformValue(const char * name, const QMatrix4x3 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x3 cppArg1_local;
            ::QMatrix4x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 15: // setUniformValue(const char * name, const QMatrix4x4 & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QMatrix4x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 16: // setUniformValue(const char * name, const QPoint & point)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QPoint)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 17: // setUniformValue(const char * name, const QPointF & point)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QPointF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 18: // setUniformValue(const char * name, const QSize & size)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QSize)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 19: // setUniformValue(const char * name, const QSizeF & size)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSizeF cppArg1_local;
            ::QSizeF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QSizeF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 20: // setUniformValue(const char * name, const QTransform & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QTransform)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 21: // setUniformValue(const char * name, const QVector2D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector2D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 22: // setUniformValue(const char * name, const QVector3D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector3D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 23: // setUniformValue(const char * name, const QVector4D & value)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(const char*,QVector4D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 24: // setUniformValue(int location, GLfloat value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 25: // setUniformValue(int location, GLfloat x, GLfloat y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 26: // setUniformValue(int location, GLfloat x, GLfloat y, GLfloat z)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLfloat,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 27: // setUniformValue(int location, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLfloat cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLfloat cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            GLfloat cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            GLfloat cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLfloat,GLfloat,GLfloat,GLfloat)
                cppSelf->setUniformValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 28: // setUniformValue(int location, GLint value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLint)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 29: // setUniformValue(int location, GLuint value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setUniformValue(int,GLuint)
                cppSelf->setUniformValue(cppArg0, cppArg1);
            }
            break;
        }
        case 30: // setUniformValue(int location, const QColor & color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QColor)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 31: // setUniformValue(int location, const QMatrix2x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x2 cppArg1_local;
            ::QMatrix2x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 32: // setUniformValue(int location, const QMatrix2x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x3 cppArg1_local;
            ::QMatrix2x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 33: // setUniformValue(int location, const QMatrix2x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix2x4 cppArg1_local;
            ::QMatrix2x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix2x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 34: // setUniformValue(int location, const QMatrix3x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x2 cppArg1_local;
            ::QMatrix3x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 35: // setUniformValue(int location, const QMatrix3x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x3 cppArg1_local;
            ::QMatrix3x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 36: // setUniformValue(int location, const QMatrix3x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix3x4 cppArg1_local;
            ::QMatrix3x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix3x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 37: // setUniformValue(int location, const QMatrix4x2 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x2 cppArg1_local;
            ::QMatrix4x2 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x2)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 38: // setUniformValue(int location, const QMatrix4x3 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x3 cppArg1_local;
            ::QMatrix4x3 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x3)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 39: // setUniformValue(int location, const QMatrix4x4 & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QMatrix4x4)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 40: // setUniformValue(int location, const QPoint & point)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPoint cppArg1_local;
            ::QPoint *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QPoint)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 41: // setUniformValue(int location, const QPointF & point)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QPointF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 42: // setUniformValue(int location, const QSize & size)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QSize)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 43: // setUniformValue(int location, const QSizeF & size)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSizeF cppArg1_local;
            ::QSizeF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QSizeF)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 44: // setUniformValue(int location, const QTransform & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTransform cppArg1_local;
            ::QTransform *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QTransform)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 45: // setUniformValue(int location, const QVector2D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector2D cppArg1_local;
            ::QVector2D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector2D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 46: // setUniformValue(int location, const QVector3D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector3D cppArg1_local;
            ::QVector3D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector3D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
        case 47: // setUniformValue(int location, const QVector4D & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QVector4D cppArg1_local;
            ::QVector4D *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setUniformValue(int,QVector4D)
                cppSelf->setUniformValue(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray2D", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QVector2D*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QVector2D*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QVector2D*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QVector2D*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray2D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QVector2D * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QVector2D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector2D *_list = new QVector2D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector2D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QVector2D * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QVector2D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector2D *_list = new QVector2D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector2D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray2x2(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray2x2", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix2x2*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix2x2*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix2x2*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix2x2*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray2x2_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix2x2 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix2x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x2 *_list = new QMatrix2x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix2x2 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix2x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x2 *_list = new QMatrix2x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray2x2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray2x3(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x3";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray2x3", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix2x3*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix2x3*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix2x3*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix2x3*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray2x3_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix2x3 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix2x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x3 *_list = new QMatrix2x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix2x3 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix2x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x3 *_list = new QMatrix2x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray2x3_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray2x4(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x4";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray2x4", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix2x4*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix2x4*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix2x4*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix2x4*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray2x4_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix2x4 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix2x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x4 *_list = new QMatrix2x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix2x4 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix2x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix2x4 *_list = new QMatrix2x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX2X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix2x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray2x4_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray3D", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QVector3D*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QVector3D*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QVector3D*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QVector3D*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray3D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QVector3D * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QVector3D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector3D *_list = new QVector3D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector3D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QVector3D * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QVector3D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector3D *_list = new QVector3D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector3D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray3x2(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray3x2", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix3x2*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix3x2*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix3x2*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix3x2*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray3x2_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix3x2 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix3x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x2 *_list = new QMatrix3x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix3x2 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix3x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x2 *_list = new QMatrix3x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray3x2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray3x3(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x3";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray3x3", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix3x3*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix3x3*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix3x3*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix3x3*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray3x3_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix3x3 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix3x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x3 *_list = new QMatrix3x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix3x3 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix3x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x3 *_list = new QMatrix3x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray3x3_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray3x4(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x4";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray3x4", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix3x4*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix3x4*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix3x4*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix3x4*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray3x4_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix3x4 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix3x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x4 *_list = new QMatrix3x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix3x4 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix3x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix3x4 *_list = new QMatrix3x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix3x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray3x4_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray4D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray4D", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QVector4D*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QVector4D*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QVector4D*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QVector4D*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray4D_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QVector4D * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QVector4D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector4D *_list = new QVector4D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector4D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QVector4D * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QVector4D*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QVector4D *_list = new QVector4D[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QVector4D*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray4D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray4x2(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x2";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray4x2", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix4x2*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix4x2*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix4x2*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix4x2*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray4x2_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix4x2 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix4x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x2 *_list = new QMatrix4x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix4x2 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix4x2*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x2 *_list = new QMatrix4x2[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X2_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x2*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray4x2_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray4x3(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x3";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray4x3", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix4x3*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix4x3*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix4x3*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix4x3*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray4x3_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix4x3 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix4x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x3 *_list = new QMatrix4x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix4x3 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix4x3*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x3 *_list = new QMatrix4x3[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X3_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x3*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray4x3_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArray4x4(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x4";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArray4x4", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const QMatrix4x4*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const QMatrix4x4*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const QMatrix4x4*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const QMatrix4x4*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArray4x4_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const QMatrix4x4 * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const QMatrix4x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x4 *_list = new QMatrix4x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const QMatrix4x4 * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const QMatrix4x4*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    QMatrix4x4 *_list = new QMatrix4x4[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (QMatrix4x4*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArray4x4_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArrayInt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayInt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArrayInt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const GLint*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const GLint*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const GLint*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const GLint*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArrayInt_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const GLint * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const GLint*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    GLint *_list = new GLint[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (GLint*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const GLint * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const GLint*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    GLint *_list = new GLint[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (GLint*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArrayInt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_setUniformValueArrayUint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayUint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setUniformValueArrayUint", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLShaderProgram::setUniformValueArray(const char*,const GLuint*,int)
    // 1: QGLShaderProgram::setUniformValueArray(int,const GLuint*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 1; // setUniformValueArray(int,const GLuint*,int)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && Shiboken::String::checkIterable(pyArgs[1])) {
        overloadId = 0; // setUniformValueArray(const char*,const GLuint*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_setUniformValueArrayUint_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setUniformValueArray(const char * name, const GLuint * values, int count)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(const char*,const GLuint*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    GLuint *_list = new GLuint[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (GLuint*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
        case 1: // setUniformValueArray(int location, const GLuint * values, int count)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setUniformValueArray(int,const GLuint*,int)
                // Begin code injection
                // TEMPLATE - callArrayFunction - START
                Py_ssize_t _size = PySequence_Size(pyArgs[2-1]);
                if (_size) {
                    GLuint *_list = new GLuint[_size];
                    if (_size) {
                      Shiboken::AutoDecRef fast(PySequence_Fast(pyArgs[2-1],
                        "Failed to parse sequence with type %VECTOR_TYPE."));
                      for(Py_ssize_t i=0; i < _size; i++) {
                          PyObject* pv = PySequence_Fast_GET_ITEM(fast.object(), i);
                          Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), pv, &(_list[i]));
                      }
                    }
                    cppSelf->setUniformValueArray(cppArg0, _list, _size);
                    delete[] _list;
                 } else {
                    cppSelf->setUniformValueArray(cppArg0, (GLuint*)nullptr, 0);
                 }
                // TEMPLATE - callArrayFunction - END

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLShaderProgramFunc_setUniformValueArrayUint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLShaderProgramFunc_shaders(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.shaders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaders()const
            QList<QGLShader* > cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->shaders();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtOpenGLTypeConverters[SBK_QTOPENGL_QLIST_QGLSHADERPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLShaderProgramFunc_uniformLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLShaderProgram.uniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLShaderProgram::uniformLocation(QByteArray)const
    // 1: QGLShaderProgram::uniformLocation(QString)const
    // 2: QGLShaderProgram::uniformLocation(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 2; // uniformLocation(const char*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // uniformLocation(QString)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // uniformLocation(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLShaderProgramFunc_uniformLocation_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // uniformLocation(const QByteArray & name) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // uniformLocation(QByteArray)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->uniformLocation(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // uniformLocation(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // uniformLocation(QString)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->uniformLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // uniformLocation(const char * name) const
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // uniformLocation(const char*)const
                int cppResult = const_cast<const ::QGLShaderProgram *>(cppSelf)->uniformLocation(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLShaderProgramFunc_uniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGLShaderProgram_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLShaderProgram_methods[] = {
    {"addShader", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_addShader), METH_O},
    {"addShaderFromSourceCode", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_addShaderFromSourceCode), METH_VARARGS},
    {"addShaderFromSourceFile", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_addShaderFromSourceFile), METH_VARARGS},
    {"attributeLocation", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_attributeLocation), METH_O},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_bind), METH_NOARGS},
    {"bindAttributeLocation", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_bindAttributeLocation), METH_VARARGS},
    {"disableAttributeArray", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_disableAttributeArray), METH_O},
    {"enableAttributeArray", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_enableAttributeArray), METH_O},
    {"geometryInputType", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_geometryInputType), METH_NOARGS},
    {"geometryOutputType", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_geometryOutputType), METH_NOARGS},
    {"geometryOutputVertexCount", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_geometryOutputVertexCount), METH_NOARGS},
    {"hasOpenGLShaderPrograms", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_hasOpenGLShaderPrograms), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isLinked", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_isLinked), METH_NOARGS},
    {"link", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_link), METH_NOARGS},
    {"log", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_log), METH_NOARGS},
    {"maxGeometryOutputVertices", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_maxGeometryOutputVertices), METH_NOARGS},
    {"programId", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_programId), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_release), METH_NOARGS},
    {"removeAllShaders", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_removeAllShaders), METH_NOARGS},
    {"removeShader", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_removeShader), METH_O},
    {"setAttributeArray2D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setAttributeArray2D), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeArray3D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setAttributeArray3D), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeArray4D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setAttributeArray4D), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeBuffer", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setAttributeBuffer), METH_VARARGS|METH_KEYWORDS},
    {"setAttributeValue", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setAttributeValue), METH_VARARGS},
    {"setGeometryInputType", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setGeometryInputType), METH_O},
    {"setGeometryOutputType", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setGeometryOutputType), METH_O},
    {"setGeometryOutputVertexCount", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setGeometryOutputVertexCount), METH_O},
    {"setUniformValue", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValue), METH_VARARGS},
    {"setUniformValueArray2D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray2D), METH_VARARGS},
    {"setUniformValueArray2x2", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray2x2), METH_VARARGS},
    {"setUniformValueArray2x3", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray2x3), METH_VARARGS},
    {"setUniformValueArray2x4", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray2x4), METH_VARARGS},
    {"setUniformValueArray3D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray3D), METH_VARARGS},
    {"setUniformValueArray3x2", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray3x2), METH_VARARGS},
    {"setUniformValueArray3x3", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray3x3), METH_VARARGS},
    {"setUniformValueArray3x4", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray3x4), METH_VARARGS},
    {"setUniformValueArray4D", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray4D), METH_VARARGS},
    {"setUniformValueArray4x2", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray4x2), METH_VARARGS},
    {"setUniformValueArray4x3", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray4x3), METH_VARARGS},
    {"setUniformValueArray4x4", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArray4x4), METH_VARARGS},
    {"setUniformValueArrayInt", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArrayInt), METH_VARARGS},
    {"setUniformValueArrayUint", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_setUniformValueArrayUint), METH_VARARGS},
    {"shaders", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_shaders), METH_NOARGS},
    {"uniformLocation", reinterpret_cast<PyCFunction>(Sbk_QGLShaderProgramFunc_uniformLocation), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGLShaderProgram_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGLShaderProgram *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGLShaderProgramWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGLShaderProgram_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLShaderProgram_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLShaderProgram_Type = nullptr;
static SbkObjectType *Sbk_QGLShaderProgram_TypeF(void)
{
    return _Sbk_QGLShaderProgram_Type;
}

static PyType_Slot Sbk_QGLShaderProgram_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGLShaderProgram_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLShaderProgram_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLShaderProgram_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLShaderProgram_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLShaderProgram_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLShaderProgram_spec = {
    "2:PySide2.QtOpenGL.QGLShaderProgram",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLShaderProgram_slots
};

} //extern "C"

static void *Sbk_QGLShaderProgram_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGLShaderProgram *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLShaderProgram_PythonToCpp_QGLShaderProgram_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLShaderProgram_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLShaderProgram_PythonToCpp_QGLShaderProgram_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLShaderProgram_TypeF())))
        return QGLShaderProgram_PythonToCpp_QGLShaderProgram_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLShaderProgram_PTR_CppToPython_QGLShaderProgram(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGLShaderProgram *>(const_cast<void *>(cppIn)), Sbk_QGLShaderProgram_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLShaderProgram_SignatureStrings[] = {
    "1:PySide2.QtOpenGL.QGLShaderProgram(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtOpenGL.QGLShaderProgram(self,context:PySide2.QtOpenGL.QGLContext,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtOpenGL.QGLShaderProgram.addShader(self,shader:PySide2.QtOpenGL.QGLShader)->bool",
    "2:PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtOpenGL.QGLShader.ShaderType,source:PySide2.QtCore.QByteArray)->bool",
    "1:PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtOpenGL.QGLShader.ShaderType,source:QString)->bool",
    "0:PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceCode(self,type:PySide2.QtOpenGL.QGLShader.ShaderType,source:char*)->bool",
    "PySide2.QtOpenGL.QGLShaderProgram.addShaderFromSourceFile(self,type:PySide2.QtOpenGL.QGLShader.ShaderType,fileName:QString)->bool",
    "2:PySide2.QtOpenGL.QGLShaderProgram.attributeLocation(self,name:PySide2.QtCore.QByteArray)->int",
    "1:PySide2.QtOpenGL.QGLShaderProgram.attributeLocation(self,name:QString)->int",
    "0:PySide2.QtOpenGL.QGLShaderProgram.attributeLocation(self,name:char*)->int",
    "PySide2.QtOpenGL.QGLShaderProgram.bind(self)->bool",
    "2:PySide2.QtOpenGL.QGLShaderProgram.bindAttributeLocation(self,name:PySide2.QtCore.QByteArray,location:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.bindAttributeLocation(self,name:QString,location:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.bindAttributeLocation(self,name:char*,location:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.disableAttributeArray(self,name:char*)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.disableAttributeArray(self,location:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.enableAttributeArray(self,name:char*)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.enableAttributeArray(self,location:int)",
    "PySide2.QtOpenGL.QGLShaderProgram.geometryInputType(self)->GLenum",
    "PySide2.QtOpenGL.QGLShaderProgram.geometryOutputType(self)->GLenum",
    "PySide2.QtOpenGL.QGLShaderProgram.geometryOutputVertexCount(self)->int",
    "PySide2.QtOpenGL.QGLShaderProgram.hasOpenGLShaderPrograms(context:PySide2.QtOpenGL.QGLContext=nullptr)->bool",
    "PySide2.QtOpenGL.QGLShaderProgram.isLinked(self)->bool",
    "PySide2.QtOpenGL.QGLShaderProgram.link(self)->bool",
    "PySide2.QtOpenGL.QGLShaderProgram.log(self)->QString",
    "PySide2.QtOpenGL.QGLShaderProgram.maxGeometryOutputVertices(self)->int",
    "PySide2.QtOpenGL.QGLShaderProgram.programId(self)->GLuint",
    "PySide2.QtOpenGL.QGLShaderProgram.release(self)",
    "PySide2.QtOpenGL.QGLShaderProgram.removeAllShaders(self)",
    "PySide2.QtOpenGL.QGLShaderProgram.removeShader(self,shader:PySide2.QtOpenGL.QGLShader)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray2D(self,name:char*,values:PySide2.QtGui.QVector2D,stride:int=0)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray2D(self,location:int,values:PySide2.QtGui.QVector2D,stride:int=0)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray3D(self,name:char*,values:PySide2.QtGui.QVector3D,stride:int=0)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray3D(self,location:int,values:PySide2.QtGui.QVector3D,stride:int=0)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray4D(self,name:char*,values:PySide2.QtGui.QVector4D,stride:int=0)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setAttributeArray4D(self,location:int,values:PySide2.QtGui.QVector4D,stride:int=0)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setAttributeBuffer(self,name:char*,type:GLenum,offset:int,tupleSize:int,stride:int=0)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setAttributeBuffer(self,location:int,type:GLenum,offset:int,tupleSize:int,stride:int=0)",
    "15:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,value:GLfloat)",
    "14:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,x:GLfloat,y:GLfloat)",
    "13:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,x:GLfloat,y:GLfloat,z:GLfloat)",
    "12:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,x:GLfloat,y:GLfloat,z:GLfloat,w:GLfloat)",
    "11:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QColor)",
    "10:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector2D)",
    "9:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector3D)",
    "8:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,name:char*,value:PySide2.QtGui.QVector4D)",
    "7:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,value:GLfloat)",
    "6:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,x:GLfloat,y:GLfloat)",
    "5:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,x:GLfloat,y:GLfloat,z:GLfloat)",
    "4:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,x:GLfloat,y:GLfloat,z:GLfloat,w:GLfloat)",
    "3:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QColor)",
    "2:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector2D)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector3D)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setAttributeValue(self,location:int,value:PySide2.QtGui.QVector4D)",
    "PySide2.QtOpenGL.QGLShaderProgram.setGeometryInputType(self,inputType:GLenum)",
    "PySide2.QtOpenGL.QGLShaderProgram.setGeometryOutputType(self,outputType:GLenum)",
    "PySide2.QtOpenGL.QGLShaderProgram.setGeometryOutputVertexCount(self,count:int)",
    "47:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:GLfloat)",
    "46:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,x:GLfloat,y:GLfloat)",
    "45:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,x:GLfloat,y:GLfloat,z:GLfloat)",
    "44:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,x:GLfloat,y:GLfloat,z:GLfloat,w:GLfloat)",
    "43:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:GLint)",
    "42:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:GLuint)",
    "41:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,color:PySide2.QtGui.QColor)",
    "40:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x2)",
    "39:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x3)",
    "38:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix2x4)",
    "37:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x2)",
    "36:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x3)",
    "35:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix3x4)",
    "34:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x2)",
    "33:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x3)",
    "32:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QMatrix4x4)",
    "31:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,point:PySide2.QtCore.QPoint)",
    "30:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,point:PySide2.QtCore.QPointF)",
    "29:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,size:PySide2.QtCore.QSize)",
    "28:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,size:PySide2.QtCore.QSizeF)",
    "27:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QTransform)",
    "26:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector2D)",
    "25:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector3D)",
    "24:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,name:char*,value:PySide2.QtGui.QVector4D)",
    "23:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:GLfloat)",
    "22:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,x:GLfloat,y:GLfloat)",
    "21:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,x:GLfloat,y:GLfloat,z:GLfloat)",
    "20:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,x:GLfloat,y:GLfloat,z:GLfloat,w:GLfloat)",
    "19:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:GLint)",
    "18:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:GLuint)",
    "17:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,color:PySide2.QtGui.QColor)",
    "16:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x2)",
    "15:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x3)",
    "14:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix2x4)",
    "13:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x2)",
    "12:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x3)",
    "11:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix3x4)",
    "10:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x2)",
    "9:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x3)",
    "8:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QMatrix4x4)",
    "7:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,point:PySide2.QtCore.QPoint)",
    "6:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,point:PySide2.QtCore.QPointF)",
    "5:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,size:PySide2.QtCore.QSize)",
    "4:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,size:PySide2.QtCore.QSizeF)",
    "3:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QTransform)",
    "2:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector2D)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector3D)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValue(self,location:int,value:PySide2.QtGui.QVector4D)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2D(self,name:char*,values:PySide2.QtGui.QVector2D,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2D(self,location:int,values:PySide2.QtGui.QVector2D,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x2(self,name:char*,values:PySide2.QtGui.QMatrix2x2,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x2(self,location:int,values:PySide2.QtGui.QMatrix2x2,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x3(self,name:char*,values:PySide2.QtGui.QMatrix2x3,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x3(self,location:int,values:PySide2.QtGui.QMatrix2x3,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x4(self,name:char*,values:PySide2.QtGui.QMatrix2x4,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray2x4(self,location:int,values:PySide2.QtGui.QMatrix2x4,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3D(self,name:char*,values:PySide2.QtGui.QVector3D,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3D(self,location:int,values:PySide2.QtGui.QVector3D,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x2(self,name:char*,values:PySide2.QtGui.QMatrix3x2,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x2(self,location:int,values:PySide2.QtGui.QMatrix3x2,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x3(self,name:char*,values:PySide2.QtGui.QMatrix3x3,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x3(self,location:int,values:PySide2.QtGui.QMatrix3x3,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x4(self,name:char*,values:PySide2.QtGui.QMatrix3x4,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray3x4(self,location:int,values:PySide2.QtGui.QMatrix3x4,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4D(self,name:char*,values:PySide2.QtGui.QVector4D,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4D(self,location:int,values:PySide2.QtGui.QVector4D,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x2(self,name:char*,values:PySide2.QtGui.QMatrix4x2,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x2(self,location:int,values:PySide2.QtGui.QMatrix4x2,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x3(self,name:char*,values:PySide2.QtGui.QMatrix4x3,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x3(self,location:int,values:PySide2.QtGui.QMatrix4x3,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x4(self,name:char*,values:PySide2.QtGui.QMatrix4x4,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArray4x4(self,location:int,values:PySide2.QtGui.QMatrix4x4,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayInt(self,name:char*,values:array GLint*,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayInt(self,location:int,values:array GLint*,count:int)",
    "1:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayUint(self,name:char*,values:array GLuint*,count:int)",
    "0:PySide2.QtOpenGL.QGLShaderProgram.setUniformValueArrayUint(self,location:int,values:array GLuint*,count:int)",
    "PySide2.QtOpenGL.QGLShaderProgram.shaders(self)->QList[PySide2.QtOpenGL.QGLShader]",
    "2:PySide2.QtOpenGL.QGLShaderProgram.uniformLocation(self,name:PySide2.QtCore.QByteArray)->int",
    "1:PySide2.QtOpenGL.QGLShaderProgram.uniformLocation(self,name:QString)->int",
    "0:PySide2.QtOpenGL.QGLShaderProgram.uniformLocation(self,name:char*)->int",
    nullptr}; // Sentinel

void init_QGLShaderProgram(PyObject *module)
{
    _Sbk_QGLShaderProgram_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLShaderProgram",
        "QGLShaderProgram*",
        &Sbk_QGLShaderProgram_spec,
        &Shiboken::callCppDestructor< ::QGLShaderProgram >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLShaderProgram_Type);
    InitSignatureStrings(pyType, QGLShaderProgram_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLShaderProgram_Type), Sbk_QGLShaderProgram_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLSHADERPROGRAM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLShaderProgram_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLShaderProgram_TypeF(),
        QGLShaderProgram_PythonToCpp_QGLShaderProgram_PTR,
        is_QGLShaderProgram_PythonToCpp_QGLShaderProgram_PTR_Convertible,
        QGLShaderProgram_PTR_CppToPython_QGLShaderProgram);

    Shiboken::Conversions::registerConverterName(converter, "QGLShaderProgram");
    Shiboken::Conversions::registerConverterName(converter, "QGLShaderProgram*");
    Shiboken::Conversions::registerConverterName(converter, "QGLShaderProgram&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLShaderProgram).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLShaderProgramWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGLShaderProgram_TypeF(), &Sbk_QGLShaderProgram_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QGLShaderProgram_TypeF(), &::QGLShaderProgram::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGLShaderProgram_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGLShaderProgram_TypeF(), &::QGLShaderProgram::staticMetaObject, sizeof(QGLShaderProgramWrapper));
}
