/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglbuffer_wrapper.h"

// inner classes

// Extra includes
#include <QtOpenGL/qglbuffer.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLBuffer >()))
        return -1;

    ::QGLBuffer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGLBuffer", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGLBuffer::QGLBuffer()
    // 1: QGLBuffer::QGLBuffer(QGLBuffer::Type)
    // 2: QGLBuffer::QGLBuffer(QGLBuffer)
    if (numArgs == 0) {
        overloadId = 0; // QGLBuffer()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QGLBuffer(QGLBuffer)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QGLBuffer(QGLBuffer::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBuffer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLBuffer()
        {

            if (!PyErr_Occurred()) {
                // QGLBuffer()
                cptr = new ::QGLBuffer();
            }
            break;
        }
        case 1: // QGLBuffer(QGLBuffer::Type type)
        {
            ::QGLBuffer::Type cppArg0 = static_cast< ::QGLBuffer::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGLBuffer(QGLBuffer::Type)
                cptr = new ::QGLBuffer(cppArg0);
            }
            break;
        }
        case 2: // QGLBuffer(const QGLBuffer & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGLBuffer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGLBuffer(QGLBuffer)
                cptr = new ::QGLBuffer(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLBufferFunc_allocate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.allocate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLBufferFunc_allocate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLBufferFunc_allocate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:allocate", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLBuffer::allocate(const void*,int)
    // 1: QGLBuffer::allocate(int)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // allocate(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // allocate(const void*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // allocate(const void*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_allocate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // allocate(const void * data, int count)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_count = Shiboken::String::createStaticString("count");
                if (PyDict_Contains(kwds, key_count)) {
                    value = PyDict_GetItem(kwds, key_count);
                    if (value && pyArgs[1]) {
                        errInfo = key_count;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLBufferFunc_allocate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QGLBufferFunc_allocate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_count);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLBufferFunc_allocate_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = -1;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // allocate(const void*,int)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-allocate)]
                int size = (cppArg1 < 0) ? cppArg0->size() : cppArg1;
                cppSelf->allocate(static_cast<const void *>(cppArg0->data()), size);
                // END of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-allocate)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // allocate(int count)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLBufferFunc_allocate_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // allocate(int)
                cppSelf->allocate(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLBufferFunc_allocate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLBufferFunc_bind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.bind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bind()
            bool cppResult = cppSelf->bind();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_bufferId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.bufferId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferId()const
            GLuint cppResult = const_cast<const ::QGLBuffer *>(cppSelf)->bufferId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_destroy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.destroy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroy()
            cppSelf->destroy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLBufferFunc_isCreated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.isCreated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCreated()const
            bool cppResult = const_cast<const ::QGLBuffer *>(cppSelf)->isCreated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_map(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.map";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLBuffer::map(QGLBuffer::Access)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // map(QGLBuffer::Access)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_map_TypeError;

    // Call function/method
    {
        ::QGLBuffer::Access cppArg0 = static_cast< ::QGLBuffer::Access>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // map(QGLBuffer::Access)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-map)]
            Py_ssize_t dataSize = cppSelf->size();
            void *data = cppSelf->map(cppArg0);

            if (!data) {
                Py_INCREF(Py_None);
                pyResult = Py_None;
            } else if (cppArg0 == QGLBuffer::ReadOnly) {
                pyResult = Shiboken::Buffer::newObject(data, dataSize, Shiboken::Buffer::ReadOnly);
            } else {
                pyResult = Shiboken::Buffer::newObject(data, dataSize, Shiboken::Buffer::ReadWrite);
            }
            // END of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-map)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLBufferFunc_map_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLBufferFunc_read(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.read";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "read", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLBuffer::read(int,void*,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // read(int,void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_read_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // read(int,void*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-read)]
            char *data = new char[cppArg1];
            bool result = cppSelf->read(cppArg0, data, cppArg1);
            QByteArray ret;
            if (result)
                ret.append(data, cppArg1);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &result));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &ret));
            delete[] data;
            // END of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-read)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLBufferFunc_read_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLBufferFunc_release(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    ::QGLBuffer *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.release";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "release", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGLBuffer::release()
    // 1: static QGLBuffer::release(QGLBuffer::Type)
    if (numArgs == 0) {
        overloadId = 0; // release()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // release(QGLBuffer::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_release_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // release()
        {

            if (!PyErr_Occurred()) {
                // release()
                cppSelf->release();
            }
            break;
        }
        case 1: // release(QGLBuffer::Type type)
        {
            ::QGLBuffer::Type cppArg0 = static_cast< ::QGLBuffer::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // release(QGLBuffer::Type)
                ::QGLBuffer::release(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLBufferFunc_release_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLBufferFunc_setUsagePattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.setUsagePattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLBuffer::setUsagePattern(QGLBuffer::UsagePattern)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUsagePattern(QGLBuffer::UsagePattern)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_setUsagePattern_TypeError;

    // Call function/method
    {
        ::QGLBuffer::UsagePattern cppArg0 = static_cast< ::QGLBuffer::UsagePattern>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUsagePattern(QGLBuffer::UsagePattern)
            cppSelf->setUsagePattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLBufferFunc_setUsagePattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLBufferFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QGLBuffer *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QGLBuffer::Type cppResult = const_cast<const ::QGLBuffer *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_unmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.unmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unmap()
            bool cppResult = cppSelf->unmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_usagePattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.usagePattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usagePattern()const
            QGLBuffer::UsagePattern cppResult = const_cast<const ::QGLBuffer *>(cppSelf)->usagePattern();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLBufferFunc_write(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLBuffer.write";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLBufferFunc_write_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLBufferFunc_write_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:write", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLBuffer::write(int,const void*,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // write(int,const void*,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // write(int,const void*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLBufferFunc_write_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_count = Shiboken::String::createStaticString("count");
            if (PyDict_Contains(kwds, key_count)) {
                value = PyDict_GetItem(kwds, key_count);
                if (value && pyArgs[2]) {
                    errInfo = key_count;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLBufferFunc_write_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QGLBufferFunc_write_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_count);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGLBufferFunc_write_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2 = -1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // write(int,const void*,int)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-write)]
            int size = (cppArg2 < 0) ? cppArg1->size() : cppArg2;
            cppSelf->write(cppArg0, static_cast<const void *>(cppArg1->data()), size);
            // END of custom code block [file: ../glue/qtopengl.cpp (qglbuffer-write)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLBufferFunc_write_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyMethodDef Sbk_QGLBufferMethod_release = {
    "release", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_release), METH_VARARGS|METH_STATIC
};


static const char *Sbk_QGLBuffer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLBuffer_methods[] = {
    {"allocate", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_allocate), METH_VARARGS|METH_KEYWORDS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_bind), METH_NOARGS},
    {"bufferId", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_bufferId), METH_NOARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_create), METH_NOARGS},
    {"destroy", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_destroy), METH_NOARGS},
    {"isCreated", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_isCreated), METH_NOARGS},
    {"map", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_map), METH_O},
    {"read", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_read), METH_VARARGS},
    Sbk_QGLBufferMethod_release,
    {"setUsagePattern", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_setUsagePattern), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_size), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_type), METH_NOARGS},
    {"unmap", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_unmap), METH_NOARGS},
    {"usagePattern", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_usagePattern), METH_NOARGS},
    {"write", reinterpret_cast<PyCFunction>(Sbk_QGLBufferFunc_write), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QGLBuffer_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    if (auto ob_dict = reinterpret_cast<SbkObject *>(self)->ob_dict) {
        if (auto meth = PyDict_GetItem(ob_dict, name)) {
            Py_INCREF(meth);
            return meth;
        }
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        if (auto meth = PyDict_GetItem(Py_TYPE(self)->tp_dict, tmp))
            return PyFunction_Check(meth) ? SBK_PyMethod_New(meth, self) : PyObject_GenericGetAttr(self, name);
    }
    static PyMethodDef non_static_Sbk_QGLBufferMethod_release = {
        Sbk_QGLBufferMethod_release.ml_name,
        Sbk_QGLBufferMethod_release.ml_meth,
        Sbk_QGLBufferMethod_release.ml_flags & (~METH_STATIC),
        Sbk_QGLBufferMethod_release.ml_doc,
    };
    if (Shiboken::String::compare(name, "release") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_QGLBufferMethod_release, self, 0);
    return PyObject_GenericGetAttr(self, name);
}

} // extern "C"

static int Sbk_QGLBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLBuffer_Type = nullptr;
static SbkObjectType *Sbk_QGLBuffer_TypeF(void)
{
    return _Sbk_QGLBuffer_Type;
}

static PyType_Slot Sbk_QGLBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_QGLBuffer_getattro)},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLBuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLBuffer_spec = {
    "2:PySide2.QtOpenGL.QGLBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLBuffer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGLBuffer_Type_PythonToCpp_QGLBuffer_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLBuffer::Type *>(cppOut) =
        static_cast<::QGLBuffer::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLBuffer_Type_PythonToCpp_QGLBuffer_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX]))
        return QGLBuffer_Type_PythonToCpp_QGLBuffer_Type;
    return {};
}
static PyObject *QGLBuffer_Type_CppToPython_QGLBuffer_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLBuffer::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX], castCppIn);

}

static void QGLBuffer_UsagePattern_PythonToCpp_QGLBuffer_UsagePattern(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLBuffer::UsagePattern *>(cppOut) =
        static_cast<::QGLBuffer::UsagePattern>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLBuffer_UsagePattern_PythonToCpp_QGLBuffer_UsagePattern_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX]))
        return QGLBuffer_UsagePattern_PythonToCpp_QGLBuffer_UsagePattern;
    return {};
}
static PyObject *QGLBuffer_UsagePattern_CppToPython_QGLBuffer_UsagePattern(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLBuffer::UsagePattern *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX], castCppIn);

}

static void QGLBuffer_Access_PythonToCpp_QGLBuffer_Access(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLBuffer::Access *>(cppOut) =
        static_cast<::QGLBuffer::Access>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLBuffer_Access_PythonToCpp_QGLBuffer_Access_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX]))
        return QGLBuffer_Access_PythonToCpp_QGLBuffer_Access;
    return {};
}
static PyObject *QGLBuffer_Access_CppToPython_QGLBuffer_Access(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLBuffer::Access *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLBuffer_PythonToCpp_QGLBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLBuffer_PythonToCpp_QGLBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLBuffer_TypeF())))
        return QGLBuffer_PythonToCpp_QGLBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLBuffer_PTR_CppToPython_QGLBuffer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLBuffer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLBuffer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLBuffer_SignatureStrings[] = {
    "2:PySide2.QtOpenGL.QGLBuffer(self)",
    "1:PySide2.QtOpenGL.QGLBuffer(self,type:PySide2.QtOpenGL.QGLBuffer.Type)",
    "0:PySide2.QtOpenGL.QGLBuffer(self,other:PySide2.QtOpenGL.QGLBuffer)",
    "1:PySide2.QtOpenGL.QGLBuffer.allocate(self,data:void,count:int=-1)",
    "0:PySide2.QtOpenGL.QGLBuffer.allocate(self,count:int)",
    "PySide2.QtOpenGL.QGLBuffer.bind(self)->bool",
    "PySide2.QtOpenGL.QGLBuffer.bufferId(self)->GLuint",
    "PySide2.QtOpenGL.QGLBuffer.create(self)->bool",
    "PySide2.QtOpenGL.QGLBuffer.destroy(self)",
    "PySide2.QtOpenGL.QGLBuffer.isCreated(self)->bool",
    "PySide2.QtOpenGL.QGLBuffer.map(self,access:PySide2.QtOpenGL.QGLBuffer.Access)->void",
    "PySide2.QtOpenGL.QGLBuffer.read(self,offset:int,data:void,count:int)->bool",
    "1:PySide2.QtOpenGL.QGLBuffer.release(self)",
    "0:PySide2.QtOpenGL.QGLBuffer.release(type:PySide2.QtOpenGL.QGLBuffer.Type)",
    "PySide2.QtOpenGL.QGLBuffer.setUsagePattern(self,value:PySide2.QtOpenGL.QGLBuffer.UsagePattern)",
    "PySide2.QtOpenGL.QGLBuffer.size(self)->int",
    "PySide2.QtOpenGL.QGLBuffer.type(self)->PySide2.QtOpenGL.QGLBuffer.Type",
    "PySide2.QtOpenGL.QGLBuffer.unmap(self)->bool",
    "PySide2.QtOpenGL.QGLBuffer.usagePattern(self)->PySide2.QtOpenGL.QGLBuffer.UsagePattern",
    "PySide2.QtOpenGL.QGLBuffer.write(self,offset:int,data:void,count:int=-1)",
    nullptr}; // Sentinel

void init_QGLBuffer(PyObject *module)
{
    _Sbk_QGLBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLBuffer",
        "QGLBuffer*",
        &Sbk_QGLBuffer_spec,
        &Shiboken::callCppDestructor< ::QGLBuffer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLBuffer_Type);
    InitSignatureStrings(pyType, QGLBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLBuffer_Type), Sbk_QGLBuffer_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLBuffer_TypeF(),
        QGLBuffer_PythonToCpp_QGLBuffer_PTR,
        is_QGLBuffer_PythonToCpp_QGLBuffer_PTR_Convertible,
        QGLBuffer_PTR_CppToPython_QGLBuffer);

    Shiboken::Conversions::registerConverterName(converter, "QGLBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QGLBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QGLBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLBuffer).name());


    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLBuffer_TypeF(),
        "Type",
        "2:PySide2.QtOpenGL.QGLBuffer.Type",
        "QGLBuffer::Type");
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX],
        Sbk_QGLBuffer_TypeF(), "VertexBuffer", (long) QGLBuffer::Type::VertexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX],
        Sbk_QGLBuffer_TypeF(), "IndexBuffer", (long) QGLBuffer::Type::IndexBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX],
        Sbk_QGLBuffer_TypeF(), "PixelPackBuffer", (long) QGLBuffer::Type::PixelPackBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX],
        Sbk_QGLBuffer_TypeF(), "PixelUnpackBuffer", (long) QGLBuffer::Type::PixelUnpackBuffer))
        return;
    // Register converter for enum 'QGLBuffer::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX],
            QGLBuffer_Type_CppToPython_QGLBuffer_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLBuffer_Type_PythonToCpp_QGLBuffer_Type,
            is_QGLBuffer_Type_PythonToCpp_QGLBuffer_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLBuffer::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'UsagePattern'.
    SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLBuffer_TypeF(),
        "UsagePattern",
        "2:PySide2.QtOpenGL.QGLBuffer.UsagePattern",
        "QGLBuffer::UsagePattern");
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StreamDraw", (long) QGLBuffer::UsagePattern::StreamDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StreamRead", (long) QGLBuffer::UsagePattern::StreamRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StreamCopy", (long) QGLBuffer::UsagePattern::StreamCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StaticDraw", (long) QGLBuffer::UsagePattern::StaticDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StaticRead", (long) QGLBuffer::UsagePattern::StaticRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "StaticCopy", (long) QGLBuffer::UsagePattern::StaticCopy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "DynamicDraw", (long) QGLBuffer::UsagePattern::DynamicDraw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "DynamicRead", (long) QGLBuffer::UsagePattern::DynamicRead))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
        Sbk_QGLBuffer_TypeF(), "DynamicCopy", (long) QGLBuffer::UsagePattern::DynamicCopy))
        return;
    // Register converter for enum 'QGLBuffer::UsagePattern'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX],
            QGLBuffer_UsagePattern_CppToPython_QGLBuffer_UsagePattern);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLBuffer_UsagePattern_PythonToCpp_QGLBuffer_UsagePattern,
            is_QGLBuffer_UsagePattern_PythonToCpp_QGLBuffer_UsagePattern_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_USAGEPATTERN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLBuffer::UsagePattern");
        Shiboken::Conversions::registerConverterName(converter, "UsagePattern");
    }
    // End of 'UsagePattern' enum.

    // Initialization of enum 'Access'.
    SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLBuffer_TypeF(),
        "Access",
        "2:PySide2.QtOpenGL.QGLBuffer.Access",
        "QGLBuffer::Access");
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX],
        Sbk_QGLBuffer_TypeF(), "ReadOnly", (long) QGLBuffer::Access::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX],
        Sbk_QGLBuffer_TypeF(), "WriteOnly", (long) QGLBuffer::Access::WriteOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX],
        Sbk_QGLBuffer_TypeF(), "ReadWrite", (long) QGLBuffer::Access::ReadWrite))
        return;
    // Register converter for enum 'QGLBuffer::Access'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX],
            QGLBuffer_Access_CppToPython_QGLBuffer_Access);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLBuffer_Access_PythonToCpp_QGLBuffer_Access,
            is_QGLBuffer_Access_PythonToCpp_QGLBuffer_Access_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLBUFFER_ACCESS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLBuffer::Access");
        Shiboken::Conversions::registerConverterName(converter, "Access");
    }
    // End of 'Access' enum.

    qRegisterMetaType< ::QGLBuffer::Type >("QGLBuffer::Type");
    qRegisterMetaType< ::QGLBuffer::UsagePattern >("QGLBuffer::UsagePattern");
    qRegisterMetaType< ::QGLBuffer::Access >("QGLBuffer::Access");
}
