/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qsslerror_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qsslcertificate.h>
#include <QtNetwork/qsslerror.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslError_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslError >()))
        return -1;

    ::QSslError *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslError.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSslError", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSslError::QSslError()
    // 1: QSslError::QSslError(QSslError::SslError)
    // 2: QSslError::QSslError(QSslError::SslError,QSslCertificate)
    // 3: QSslError::QSslError(QSslError)
    if (numArgs == 0) {
        overloadId = 0; // QSslError()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QSslError(QSslError::SslError)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QSslError(QSslError::SslError,QSslCertificate)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QSslError(QSslError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslError_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslError()
        {

            if (!PyErr_Occurred()) {
                // QSslError()
                cptr = new ::QSslError();
            }
            break;
        }
        case 1: // QSslError(QSslError::SslError error)
        {
            ::QSslError::SslError cppArg0{QSslError::NoError};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSslError(QSslError::SslError)
                cptr = new ::QSslError(cppArg0);
            }
            break;
        }
        case 2: // QSslError(QSslError::SslError error, const QSslCertificate & certificate)
        {
            ::QSslError::SslError cppArg0{QSslError::NoError};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QSslCertificate cppArg1_local;
            ::QSslCertificate *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QSslError(QSslError::SslError,QSslCertificate)
                cptr = new ::QSslError(cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // QSslError(const QSslError & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslError cppArg0_local;
            ::QSslError *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslError(QSslError)
                cptr = new ::QSslError(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslError >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslError_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslError_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslErrorFunc_certificate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslError.certificate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // certificate()const
            QSslCertificate cppResult = const_cast<const ::QSslError *>(cppSelf)->certificate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslErrorFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslError.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QSslError::SslError cppResult = const_cast<const ::QSslError *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslErrorFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslError.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QSslError *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslErrorFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslError.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslError::swap(QSslError&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslError&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslErrorFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslError cppArg0_local;
        ::QSslError *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslError&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslErrorFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslError___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslError_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslError_methods[] = {
    {"certificate", reinterpret_cast<PyCFunction>(Sbk_QSslErrorFunc_certificate), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QSslErrorFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QSslErrorFunc_errorString), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslErrorFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslError___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QSslError_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), (pyArg)))) {
                // operator!=(const QSslError & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslError cppArg0_local;
                ::QSslError *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), (pyArg)))) {
                // operator==(const QSslError & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslError cppArg0_local;
                ::QSslError *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSslError_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSslError_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSslError_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslError_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSslError__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslError_Type = nullptr;
static SbkObjectType *Sbk_QSslError_TypeF(void)
{
    return _Sbk_QSslError_Type;
}

static PyType_Slot Sbk_QSslError_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSslError__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslError_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslError_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSslError_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslError_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslError_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSslError_spec = {
    "2:PySide2.QtNetwork.QSslError",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslError_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSslError_SslError_PythonToCpp_QSslError_SslError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslError::SslError *>(cppOut) =
        static_cast<::QSslError::SslError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSslError_SslError_PythonToCpp_QSslError_SslError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX]))
        return QSslError_SslError_PythonToCpp_QSslError_SslError;
    return {};
}
static PyObject *QSslError_SslError_CppToPython_QSslError_SslError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSslError::SslError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslError_PythonToCpp_QSslError_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslError_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslError_PythonToCpp_QSslError_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslError_TypeF())))
        return QSslError_PythonToCpp_QSslError_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslError_PTR_CppToPython_QSslError(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslError *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslError_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslError_COPY_CppToPython_QSslError(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslError_TypeF(), new ::QSslError(*reinterpret_cast<const ::QSslError *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslError_PythonToCpp_QSslError_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslError *>(cppOut) = *reinterpret_cast< ::QSslError *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslError_PythonToCpp_QSslError_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslError_TypeF())))
        return QSslError_PythonToCpp_QSslError_COPY;
    return {};
}

// Implicit conversions.
static void QSslError_SslError_PythonToCpp_QSslError(PyObject *pyIn, void *cppOut) {
    ::QSslError::SslError cppIn{QSslError::NoError};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QSslError *>(cppOut) = ::QSslError(cppIn);
}
static PythonToCppFunc is_QSslError_SslError_PythonToCpp_QSslError_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX], pyIn))
        return QSslError_SslError_PythonToCpp_QSslError;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslError_SignatureStrings[] = {
    "3:PySide2.QtNetwork.QSslError(self)",
    "2:PySide2.QtNetwork.QSslError(self,error:PySide2.QtNetwork.QSslError.SslError)",
    "1:PySide2.QtNetwork.QSslError(self,error:PySide2.QtNetwork.QSslError.SslError,certificate:PySide2.QtNetwork.QSslCertificate)",
    "0:PySide2.QtNetwork.QSslError(self,other:PySide2.QtNetwork.QSslError)",
    "PySide2.QtNetwork.QSslError.certificate(self)->PySide2.QtNetwork.QSslCertificate",
    "PySide2.QtNetwork.QSslError.error(self)->PySide2.QtNetwork.QSslError.SslError",
    "PySide2.QtNetwork.QSslError.errorString(self)->QString",
    "PySide2.QtNetwork.QSslError.swap(self,other:PySide2.QtNetwork.QSslError)",
    "PySide2.QtNetwork.QSslError.__copy__()",
    nullptr}; // Sentinel

void init_QSslError(PyObject *module)
{
    _Sbk_QSslError_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslError",
        "QSslError",
        &Sbk_QSslError_spec,
        &Shiboken::callCppDestructor< ::QSslError >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslError_Type);
    InitSignatureStrings(pyType, QSslError_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslError_Type), Sbk_QSslError_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslError_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslError_TypeF(),
        QSslError_PythonToCpp_QSslError_PTR,
        is_QSslError_PythonToCpp_QSslError_PTR_Convertible,
        QSslError_PTR_CppToPython_QSslError,
        QSslError_COPY_CppToPython_QSslError);

    Shiboken::Conversions::registerConverterName(converter, "QSslError");
    Shiboken::Conversions::registerConverterName(converter, "QSslError*");
    Shiboken::Conversions::registerConverterName(converter, "QSslError&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslError).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslError_PythonToCpp_QSslError_COPY,
        is_QSslError_PythonToCpp_QSslError_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslError_SslError_PythonToCpp_QSslError,
        is_QSslError_SslError_PythonToCpp_QSslError_Convertible);

    // Initialization of enums.

    // Initialization of enum 'SslError'.
    SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSslError_TypeF(),
        "SslError",
        "2:PySide2.QtNetwork.QSslError.SslError",
        "QSslError::SslError");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "NoError", (long) QSslError::SslError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnableToGetIssuerCertificate", (long) QSslError::SslError::UnableToGetIssuerCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnableToDecryptCertificateSignature", (long) QSslError::SslError::UnableToDecryptCertificateSignature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnableToDecodeIssuerPublicKey", (long) QSslError::SslError::UnableToDecodeIssuerPublicKey))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateSignatureFailed", (long) QSslError::SslError::CertificateSignatureFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateNotYetValid", (long) QSslError::SslError::CertificateNotYetValid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateExpired", (long) QSslError::SslError::CertificateExpired))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "InvalidNotBeforeField", (long) QSslError::SslError::InvalidNotBeforeField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "InvalidNotAfterField", (long) QSslError::SslError::InvalidNotAfterField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "SelfSignedCertificate", (long) QSslError::SslError::SelfSignedCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "SelfSignedCertificateInChain", (long) QSslError::SslError::SelfSignedCertificateInChain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnableToGetLocalIssuerCertificate", (long) QSslError::SslError::UnableToGetLocalIssuerCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnableToVerifyFirstCertificate", (long) QSslError::SslError::UnableToVerifyFirstCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateRevoked", (long) QSslError::SslError::CertificateRevoked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "InvalidCaCertificate", (long) QSslError::SslError::InvalidCaCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "PathLengthExceeded", (long) QSslError::SslError::PathLengthExceeded))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "InvalidPurpose", (long) QSslError::SslError::InvalidPurpose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateUntrusted", (long) QSslError::SslError::CertificateUntrusted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateRejected", (long) QSslError::SslError::CertificateRejected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "SubjectIssuerMismatch", (long) QSslError::SslError::SubjectIssuerMismatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "AuthorityIssuerSerialNumberMismatch", (long) QSslError::SslError::AuthorityIssuerSerialNumberMismatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "NoPeerCertificate", (long) QSslError::SslError::NoPeerCertificate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "HostNameMismatch", (long) QSslError::SslError::HostNameMismatch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "NoSslSupport", (long) QSslError::SslError::NoSslSupport))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateBlacklisted", (long) QSslError::SslError::CertificateBlacklisted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "CertificateStatusUnknown", (long) QSslError::SslError::CertificateStatusUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspNoResponseFound", (long) QSslError::SslError::OcspNoResponseFound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspMalformedRequest", (long) QSslError::SslError::OcspMalformedRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspMalformedResponse", (long) QSslError::SslError::OcspMalformedResponse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspInternalError", (long) QSslError::SslError::OcspInternalError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspTryLater", (long) QSslError::SslError::OcspTryLater))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspSigRequred", (long) QSslError::SslError::OcspSigRequred))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspUnauthorized", (long) QSslError::SslError::OcspUnauthorized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspResponseCannotBeTrusted", (long) QSslError::SslError::OcspResponseCannotBeTrusted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspResponseCertIdUnknown", (long) QSslError::SslError::OcspResponseCertIdUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspResponseExpired", (long) QSslError::SslError::OcspResponseExpired))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "OcspStatusUnknown", (long) QSslError::SslError::OcspStatusUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
        Sbk_QSslError_TypeF(), "UnspecifiedError", (long) QSslError::SslError::UnspecifiedError))
        return;
    // Register converter for enum 'QSslError::SslError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX],
            QSslError_SslError_CppToPython_QSslError_SslError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSslError_SslError_PythonToCpp_QSslError_SslError,
            is_QSslError_SslError_PythonToCpp_QSslError_SslError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_SSLERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSslError::SslError");
        Shiboken::Conversions::registerConverterName(converter, "SslError");
    }
    // End of 'SslError' enum.

    qRegisterMetaType< ::QSslError >("QSslError");
    qRegisterMetaType< ::QSslError::SslError >("QSslError::SslError");
}
