/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qocspresponse_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qocspresponse.h>
#include <QtNetwork/qsslcertificate.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOcspResponse_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOcspResponse >()))
        return -1;

    ::QOcspResponse *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QOcspResponse", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOcspResponse::QOcspResponse()
    // 1: QOcspResponse::QOcspResponse(QOcspResponse)
    if (numArgs == 0) {
        overloadId = 0; // QOcspResponse()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QOcspResponse(QOcspResponse)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOcspResponse_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOcspResponse()
        {

            if (!PyErr_Occurred()) {
                // QOcspResponse()
                cptr = new ::QOcspResponse();
            }
            break;
        }
        case 1: // QOcspResponse(const QOcspResponse & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOcspResponse cppArg0_local;
            ::QOcspResponse *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QOcspResponse(QOcspResponse)
                cptr = new ::QOcspResponse(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOcspResponse >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOcspResponse_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOcspResponse_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOcspResponseFunc_certificateStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.certificateStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // certificateStatus()const
            QOcspCertificateStatus cppResult = const_cast<const ::QOcspResponse *>(cppSelf)->certificateStatus();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOcspResponseFunc_responder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.responder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // responder()const
            QSslCertificate cppResult = const_cast<const ::QOcspResponse *>(cppSelf)->responder();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOcspResponseFunc_revocationReason(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.revocationReason";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revocationReason()const
            QOcspRevocationReason cppResult = const_cast<const ::QOcspResponse *>(cppSelf)->revocationReason();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOcspResponseFunc_subject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.subject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subject()const
            QSslCertificate cppResult = const_cast<const ::QOcspResponse *>(cppSelf)->subject();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOcspResponseFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QOcspResponse.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOcspResponse::swap(QOcspResponse&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QOcspResponse&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOcspResponseFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOcspResponse cppArg0_local;
        ::QOcspResponse *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QOcspResponse&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOcspResponseFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOcspResponse___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOcspResponse_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOcspResponse_methods[] = {
    {"certificateStatus", reinterpret_cast<PyCFunction>(Sbk_QOcspResponseFunc_certificateStatus), METH_NOARGS},
    {"responder", reinterpret_cast<PyCFunction>(Sbk_QOcspResponseFunc_responder), METH_NOARGS},
    {"revocationReason", reinterpret_cast<PyCFunction>(Sbk_QOcspResponseFunc_revocationReason), METH_NOARGS},
    {"subject", reinterpret_cast<PyCFunction>(Sbk_QOcspResponseFunc_subject), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QOcspResponseFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QOcspResponse___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QOcspResponse_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), (pyArg)))) {
                // operator!=(const QOcspResponse & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QOcspResponse cppArg0_local;
                ::QOcspResponse *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QOcspResponse_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QOcspResponse_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QOcspResponse_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOcspResponse_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOcspResponse_Type = nullptr;
static SbkObjectType *Sbk_QOcspResponse_TypeF(void)
{
    return _Sbk_QOcspResponse_Type;
}

static PyType_Slot Sbk_QOcspResponse_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOcspResponse_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOcspResponse_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QOcspResponse_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOcspResponse_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOcspResponse_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOcspResponse_spec = {
    "2:PySide2.QtNetwork.QOcspResponse",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOcspResponse_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOcspResponse_PythonToCpp_QOcspResponse_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOcspResponse_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOcspResponse_PythonToCpp_QOcspResponse_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOcspResponse_TypeF())))
        return QOcspResponse_PythonToCpp_QOcspResponse_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOcspResponse_PTR_CppToPython_QOcspResponse(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOcspResponse *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOcspResponse_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QOcspResponse_COPY_CppToPython_QOcspResponse(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QOcspResponse_TypeF(), new ::QOcspResponse(*reinterpret_cast<const ::QOcspResponse *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QOcspResponse_PythonToCpp_QOcspResponse_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOcspResponse *>(cppOut) = *reinterpret_cast< ::QOcspResponse *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QOcspResponse_PythonToCpp_QOcspResponse_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOcspResponse_TypeF())))
        return QOcspResponse_PythonToCpp_QOcspResponse_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOcspResponse_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QOcspResponse(self)",
    "0:PySide2.QtNetwork.QOcspResponse(self,other:PySide2.QtNetwork.QOcspResponse)",
    "PySide2.QtNetwork.QOcspResponse.certificateStatus(self)->PySide2.QtNetwork.QOcspCertificateStatus",
    "PySide2.QtNetwork.QOcspResponse.responder(self)->PySide2.QtNetwork.QSslCertificate",
    "PySide2.QtNetwork.QOcspResponse.revocationReason(self)->PySide2.QtNetwork.QOcspRevocationReason",
    "PySide2.QtNetwork.QOcspResponse.subject(self)->PySide2.QtNetwork.QSslCertificate",
    "PySide2.QtNetwork.QOcspResponse.swap(self,other:PySide2.QtNetwork.QOcspResponse)",
    "PySide2.QtNetwork.QOcspResponse.__copy__()",
    nullptr}; // Sentinel

void init_QOcspResponse(PyObject *module)
{
    _Sbk_QOcspResponse_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOcspResponse",
        "QOcspResponse",
        &Sbk_QOcspResponse_spec,
        &Shiboken::callCppDestructor< ::QOcspResponse >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOcspResponse_Type);
    InitSignatureStrings(pyType, QOcspResponse_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOcspResponse_Type), Sbk_QOcspResponse_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOcspResponse_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOcspResponse_TypeF(),
        QOcspResponse_PythonToCpp_QOcspResponse_PTR,
        is_QOcspResponse_PythonToCpp_QOcspResponse_PTR_Convertible,
        QOcspResponse_PTR_CppToPython_QOcspResponse,
        QOcspResponse_COPY_CppToPython_QOcspResponse);

    Shiboken::Conversions::registerConverterName(converter, "QOcspResponse");
    Shiboken::Conversions::registerConverterName(converter, "QOcspResponse*");
    Shiboken::Conversions::registerConverterName(converter, "QOcspResponse&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOcspResponse).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QOcspResponse_PythonToCpp_QOcspResponse_COPY,
        is_QOcspResponse_PythonToCpp_QOcspResponse_COPY_Convertible);

    qRegisterMetaType< ::QOcspResponse >("QOcspResponse");
}
