/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkrequest_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qnetworkrequest.h>
#include <QtNetwork/qsslconfiguration.h>
#include <qbytearray.h>
#include <qobject.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkRequest >()))
        return -1;

    ::QNetworkRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNetworkRequest", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkRequest::QNetworkRequest()
    // 1: QNetworkRequest::QNetworkRequest(QNetworkRequest)
    // 2: QNetworkRequest::QNetworkRequest(QUrl)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkRequest()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QNetworkRequest(QUrl)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QNetworkRequest(QNetworkRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkRequest()
        {

            if (!PyErr_Occurred()) {
                // QNetworkRequest()
                cptr = new ::QNetworkRequest();
            }
            break;
        }
        case 1: // QNetworkRequest(const QNetworkRequest & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkRequest(QNetworkRequest)
                cptr = new ::QNetworkRequest(*cppArg0);
            }
            break;
        }
        case 2: // QNetworkRequest(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkRequest(QUrl)
                cptr = new ::QNetworkRequest(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkRequestFunc_attribute(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.attribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkRequestFunc_attribute_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkRequestFunc_attribute_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:attribute", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkRequest::attribute(QNetworkRequest::Attribute,QVariant)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // attribute(QNetworkRequest::Attribute,QVariant)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            overloadId = 0; // attribute(QNetworkRequest::Attribute,QVariant)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_attribute_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_defaultValue = Shiboken::String::createStaticString("defaultValue");
            if (PyDict_Contains(kwds, key_defaultValue)) {
                value = PyDict_GetItem(kwds, key_defaultValue);
                if (value && pyArgs[1]) {
                    errInfo = key_defaultValue;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkRequestFunc_attribute_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QNetworkRequestFunc_attribute_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_defaultValue);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkRequestFunc_attribute_TypeError;
            }
        }
        ::QNetworkRequest::Attribute cppArg0{QNetworkRequest::HttpStatusCodeAttribute};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // attribute(QNetworkRequest::Attribute,QVariant)const
            QVariant cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->attribute(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkRequestFunc_attribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_hasRawHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.hasRawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::hasRawHeader(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // hasRawHeader(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_hasRawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // hasRawHeader(QByteArray)const
            bool cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->hasRawHeader(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkRequestFunc_hasRawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_header(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.header";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::header(QNetworkRequest::KnownHeaders)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // header(QNetworkRequest::KnownHeaders)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_header_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::KnownHeaders cppArg0{QNetworkRequest::ContentTypeHeader};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // header(QNetworkRequest::KnownHeaders)const
            QVariant cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->header(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkRequestFunc_header_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_maximumRedirectsAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.maximumRedirectsAllowed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumRedirectsAllowed()const
            int cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->maximumRedirectsAllowed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_originatingObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.originatingObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // originatingObject()const
            QObject * cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->originatingObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_peerVerifyName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.peerVerifyName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerVerifyName()const
            QString cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->peerVerifyName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_priority(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.priority";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // priority()const
            QNetworkRequest::Priority cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->priority();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_rawHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.rawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::rawHeader(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // rawHeader(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_rawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // rawHeader(QByteArray)const
            QByteArray cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->rawHeader(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkRequestFunc_rawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_rawHeaderList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.rawHeaderList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawHeaderList()const
            QList<QByteArray > cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->rawHeaderList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_setAttribute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkRequest::setAttribute(QNetworkRequest::Attribute,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setAttribute(QNetworkRequest::Attribute,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setAttribute_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::Attribute cppArg0{QNetworkRequest::HttpStatusCodeAttribute};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAttribute(QNetworkRequest::Attribute,QVariant)
            cppSelf->setAttribute(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setHeader(QNetworkRequest::KnownHeaders,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setHeader_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::KnownHeaders cppArg0{QNetworkRequest::ContentTypeHeader};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHeader(QNetworkRequest::KnownHeaders,QVariant)
            cppSelf->setHeader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setMaximumRedirectsAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setMaximumRedirectsAllowed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setMaximumRedirectsAllowed(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaximumRedirectsAllowed(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setMaximumRedirectsAllowed_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumRedirectsAllowed(int)
            cppSelf->setMaximumRedirectsAllowed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setMaximumRedirectsAllowed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setOriginatingObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setOriginatingObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setOriginatingObject(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setOriginatingObject(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setOriginatingObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOriginatingObject(QObject*)
            cppSelf->setOriginatingObject(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setOriginatingObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setPeerVerifyName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setPeerVerifyName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setPeerVerifyName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPeerVerifyName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setPeerVerifyName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerVerifyName(QString)
            cppSelf->setPeerVerifyName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setPeerVerifyName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setPriority(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setPriority";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setPriority(QNetworkRequest::Priority)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPriority(QNetworkRequest::Priority)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setPriority_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::Priority cppArg0 = static_cast< ::QNetworkRequest::Priority>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPriority(QNetworkRequest::Priority)
            cppSelf->setPriority(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setPriority_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setRawHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setRawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRawHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkRequest::setRawHeader(QByteArray,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setRawHeader(QByteArray,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setRawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setRawHeader(QByteArray,QByteArray)
            cppSelf->setRawHeader(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setRawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setSslConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setSslConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setSslConfiguration(QSslConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setSslConfiguration(QSslConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setSslConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslConfiguration cppArg0_local;
        ::QSslConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSslConfiguration(QSslConfiguration)
            cppSelf->setSslConfiguration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setSslConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setTransferTimeout(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setTransferTimeout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setTransferTimeout", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkRequest::setTransferTimeout(int)
    if (numArgs == 0) {
        overloadId = 0; // setTransferTimeout(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // setTransferTimeout(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError;
            }
        }
        int cppArg0 = QNetworkRequest::DefaultTransferTimeoutConstant;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setTransferTimeout(int)
            cppSelf->setTransferTimeout(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setTransferTimeout_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_sslConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.sslConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sslConfiguration()const
            QSslConfiguration cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->sslConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkRequest::swap(QNetworkRequest&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkRequest&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkRequestFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkRequest cppArg0_local;
        ::QNetworkRequest *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkRequest&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkRequestFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkRequestFunc_transferTimeout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.transferTimeout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transferTimeout()const
            int cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->transferTimeout();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequestFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkRequest.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QNetworkRequest *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkRequest___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkRequest_methods[] = {
    {"attribute", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_attribute), METH_VARARGS|METH_KEYWORDS},
    {"hasRawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_hasRawHeader), METH_O},
    {"header", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_header), METH_O},
    {"maximumRedirectsAllowed", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_maximumRedirectsAllowed), METH_NOARGS},
    {"originatingObject", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_originatingObject), METH_NOARGS},
    {"peerVerifyName", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_peerVerifyName), METH_NOARGS},
    {"priority", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_priority), METH_NOARGS},
    {"rawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_rawHeader), METH_O},
    {"rawHeaderList", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_rawHeaderList), METH_NOARGS},
    {"setAttribute", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setAttribute), METH_VARARGS},
    {"setHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setHeader), METH_VARARGS},
    {"setMaximumRedirectsAllowed", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setMaximumRedirectsAllowed), METH_O},
    {"setOriginatingObject", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setOriginatingObject), METH_O},
    {"setPeerVerifyName", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setPeerVerifyName), METH_O},
    {"setPriority", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setPriority), METH_O},
    {"setRawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setRawHeader), METH_VARARGS},
    {"setSslConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setSslConfiguration), METH_O},
    {"setTransferTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setTransferTimeout), METH_VARARGS|METH_KEYWORDS},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_setUrl), METH_O},
    {"sslConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_sslConfiguration), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_swap), METH_O},
    {"transferTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_transferTimeout), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequestFunc_url), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkRequest___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QNetworkRequest_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
                // operator!=(const QNetworkRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkRequest cppArg0_local;
                ::QNetworkRequest *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
                // operator==(const QNetworkRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkRequest cppArg0_local;
                ::QNetworkRequest *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QNetworkRequest_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QNetworkRequest_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QNetworkRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkRequest_Type = nullptr;
static SbkObjectType *Sbk_QNetworkRequest_TypeF(void)
{
    return _Sbk_QNetworkRequest_Type;
}

static PyType_Slot Sbk_QNetworkRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkRequest_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QNetworkRequest_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkRequest_spec = {
    "2:PySide2.QtNetwork.QNetworkRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkRequest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkRequest_KnownHeaders_PythonToCpp_QNetworkRequest_KnownHeaders(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::KnownHeaders *>(cppOut) =
        static_cast<::QNetworkRequest::KnownHeaders>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_KnownHeaders_PythonToCpp_QNetworkRequest_KnownHeaders_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX]))
        return QNetworkRequest_KnownHeaders_PythonToCpp_QNetworkRequest_KnownHeaders;
    return {};
}
static PyObject *QNetworkRequest_KnownHeaders_CppToPython_QNetworkRequest_KnownHeaders(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::KnownHeaders *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX], castCppIn);

}

static void QNetworkRequest_Attribute_PythonToCpp_QNetworkRequest_Attribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::Attribute *>(cppOut) =
        static_cast<::QNetworkRequest::Attribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_Attribute_PythonToCpp_QNetworkRequest_Attribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX]))
        return QNetworkRequest_Attribute_PythonToCpp_QNetworkRequest_Attribute;
    return {};
}
static PyObject *QNetworkRequest_Attribute_CppToPython_QNetworkRequest_Attribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::Attribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX], castCppIn);

}

static void QNetworkRequest_CacheLoadControl_PythonToCpp_QNetworkRequest_CacheLoadControl(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::CacheLoadControl *>(cppOut) =
        static_cast<::QNetworkRequest::CacheLoadControl>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_CacheLoadControl_PythonToCpp_QNetworkRequest_CacheLoadControl_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX]))
        return QNetworkRequest_CacheLoadControl_PythonToCpp_QNetworkRequest_CacheLoadControl;
    return {};
}
static PyObject *QNetworkRequest_CacheLoadControl_CppToPython_QNetworkRequest_CacheLoadControl(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::CacheLoadControl *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX], castCppIn);

}

static void QNetworkRequest_LoadControl_PythonToCpp_QNetworkRequest_LoadControl(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::LoadControl *>(cppOut) =
        static_cast<::QNetworkRequest::LoadControl>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_LoadControl_PythonToCpp_QNetworkRequest_LoadControl_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX]))
        return QNetworkRequest_LoadControl_PythonToCpp_QNetworkRequest_LoadControl;
    return {};
}
static PyObject *QNetworkRequest_LoadControl_CppToPython_QNetworkRequest_LoadControl(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::LoadControl *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX], castCppIn);

}

static void QNetworkRequest_Priority_PythonToCpp_QNetworkRequest_Priority(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::Priority *>(cppOut) =
        static_cast<::QNetworkRequest::Priority>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_Priority_PythonToCpp_QNetworkRequest_Priority_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX]))
        return QNetworkRequest_Priority_PythonToCpp_QNetworkRequest_Priority;
    return {};
}
static PyObject *QNetworkRequest_Priority_CppToPython_QNetworkRequest_Priority(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::Priority *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX], castCppIn);

}

static void QNetworkRequest_RedirectPolicy_PythonToCpp_QNetworkRequest_RedirectPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::RedirectPolicy *>(cppOut) =
        static_cast<::QNetworkRequest::RedirectPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_RedirectPolicy_PythonToCpp_QNetworkRequest_RedirectPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX]))
        return QNetworkRequest_RedirectPolicy_PythonToCpp_QNetworkRequest_RedirectPolicy;
    return {};
}
static PyObject *QNetworkRequest_RedirectPolicy_CppToPython_QNetworkRequest_RedirectPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::RedirectPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX], castCppIn);

}

static void QNetworkRequest_TransferTimeoutConstant_PythonToCpp_QNetworkRequest_TransferTimeoutConstant(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest::TransferTimeoutConstant *>(cppOut) =
        static_cast<::QNetworkRequest::TransferTimeoutConstant>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkRequest_TransferTimeoutConstant_PythonToCpp_QNetworkRequest_TransferTimeoutConstant_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX]))
        return QNetworkRequest_TransferTimeoutConstant_PythonToCpp_QNetworkRequest_TransferTimeoutConstant;
    return {};
}
static PyObject *QNetworkRequest_TransferTimeoutConstant_CppToPython_QNetworkRequest_TransferTimeoutConstant(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkRequest::TransferTimeoutConstant *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkRequest_PythonToCpp_QNetworkRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkRequest_PythonToCpp_QNetworkRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkRequest_TypeF())))
        return QNetworkRequest_PythonToCpp_QNetworkRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkRequest_PTR_CppToPython_QNetworkRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkRequest_COPY_CppToPython_QNetworkRequest(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkRequest_TypeF(), new ::QNetworkRequest(*reinterpret_cast<const ::QNetworkRequest *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkRequest_PythonToCpp_QNetworkRequest_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkRequest *>(cppOut) = *reinterpret_cast< ::QNetworkRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkRequest_PythonToCpp_QNetworkRequest_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkRequest_TypeF())))
        return QNetworkRequest_PythonToCpp_QNetworkRequest_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkRequest_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QNetworkRequest(self)",
    "1:PySide2.QtNetwork.QNetworkRequest(self,other:PySide2.QtNetwork.QNetworkRequest)",
    "0:PySide2.QtNetwork.QNetworkRequest(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtNetwork.QNetworkRequest.attribute(self,code:PySide2.QtNetwork.QNetworkRequest.Attribute,defaultValue:QVariant=QVariant())->QVariant",
    "PySide2.QtNetwork.QNetworkRequest.hasRawHeader(self,headerName:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtNetwork.QNetworkRequest.header(self,header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders)->QVariant",
    "PySide2.QtNetwork.QNetworkRequest.maximumRedirectsAllowed(self)->int",
    "PySide2.QtNetwork.QNetworkRequest.originatingObject(self)->PySide2.QtCore.QObject",
    "PySide2.QtNetwork.QNetworkRequest.peerVerifyName(self)->QString",
    "PySide2.QtNetwork.QNetworkRequest.priority(self)->PySide2.QtNetwork.QNetworkRequest.Priority",
    "PySide2.QtNetwork.QNetworkRequest.rawHeader(self,headerName:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QNetworkRequest.rawHeaderList(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtNetwork.QNetworkRequest.setAttribute(self,code:PySide2.QtNetwork.QNetworkRequest.Attribute,value:QVariant)",
    "PySide2.QtNetwork.QNetworkRequest.setHeader(self,header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders,value:QVariant)",
    "PySide2.QtNetwork.QNetworkRequest.setMaximumRedirectsAllowed(self,maximumRedirectsAllowed:int)",
    "PySide2.QtNetwork.QNetworkRequest.setOriginatingObject(self,object:PySide2.QtCore.QObject)",
    "PySide2.QtNetwork.QNetworkRequest.setPeerVerifyName(self,peerName:QString)",
    "PySide2.QtNetwork.QNetworkRequest.setPriority(self,priority:PySide2.QtNetwork.QNetworkRequest.Priority)",
    "PySide2.QtNetwork.QNetworkRequest.setRawHeader(self,headerName:PySide2.QtCore.QByteArray,value:PySide2.QtCore.QByteArray)",
    "PySide2.QtNetwork.QNetworkRequest.setSslConfiguration(self,configuration:PySide2.QtNetwork.QSslConfiguration)",
    "PySide2.QtNetwork.QNetworkRequest.setTransferTimeout(self,timeout:int=DefaultTransferTimeoutConstant)",
    "PySide2.QtNetwork.QNetworkRequest.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtNetwork.QNetworkRequest.sslConfiguration(self)->PySide2.QtNetwork.QSslConfiguration",
    "PySide2.QtNetwork.QNetworkRequest.swap(self,other:PySide2.QtNetwork.QNetworkRequest)",
    "PySide2.QtNetwork.QNetworkRequest.transferTimeout(self)->int",
    "PySide2.QtNetwork.QNetworkRequest.url(self)->PySide2.QtCore.QUrl",
    "PySide2.QtNetwork.QNetworkRequest.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkRequest(PyObject *module)
{
    _Sbk_QNetworkRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkRequest",
        "QNetworkRequest",
        &Sbk_QNetworkRequest_spec,
        &Shiboken::callCppDestructor< ::QNetworkRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkRequest_Type);
    InitSignatureStrings(pyType, QNetworkRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkRequest_Type), Sbk_QNetworkRequest_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkRequest_TypeF(),
        QNetworkRequest_PythonToCpp_QNetworkRequest_PTR,
        is_QNetworkRequest_PythonToCpp_QNetworkRequest_PTR_Convertible,
        QNetworkRequest_PTR_CppToPython_QNetworkRequest,
        QNetworkRequest_COPY_CppToPython_QNetworkRequest);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkRequest).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkRequest_PythonToCpp_QNetworkRequest_COPY,
        is_QNetworkRequest_PythonToCpp_QNetworkRequest_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'KnownHeaders'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "KnownHeaders",
        "2:PySide2.QtNetwork.QNetworkRequest.KnownHeaders",
        "QNetworkRequest::KnownHeaders");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "ContentTypeHeader", (long) QNetworkRequest::KnownHeaders::ContentTypeHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "ContentLengthHeader", (long) QNetworkRequest::KnownHeaders::ContentLengthHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "LocationHeader", (long) QNetworkRequest::KnownHeaders::LocationHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "LastModifiedHeader", (long) QNetworkRequest::KnownHeaders::LastModifiedHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "CookieHeader", (long) QNetworkRequest::KnownHeaders::CookieHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "SetCookieHeader", (long) QNetworkRequest::KnownHeaders::SetCookieHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "ContentDispositionHeader", (long) QNetworkRequest::KnownHeaders::ContentDispositionHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "UserAgentHeader", (long) QNetworkRequest::KnownHeaders::UserAgentHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "ServerHeader", (long) QNetworkRequest::KnownHeaders::ServerHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "IfModifiedSinceHeader", (long) QNetworkRequest::KnownHeaders::IfModifiedSinceHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "ETagHeader", (long) QNetworkRequest::KnownHeaders::ETagHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "IfMatchHeader", (long) QNetworkRequest::KnownHeaders::IfMatchHeader))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
        Sbk_QNetworkRequest_TypeF(), "IfNoneMatchHeader", (long) QNetworkRequest::KnownHeaders::IfNoneMatchHeader))
        return;
    // Register converter for enum 'QNetworkRequest::KnownHeaders'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX],
            QNetworkRequest_KnownHeaders_CppToPython_QNetworkRequest_KnownHeaders);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_KnownHeaders_PythonToCpp_QNetworkRequest_KnownHeaders,
            is_QNetworkRequest_KnownHeaders_PythonToCpp_QNetworkRequest_KnownHeaders_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::KnownHeaders");
        Shiboken::Conversions::registerConverterName(converter, "KnownHeaders");
    }
    // End of 'KnownHeaders' enum.

    // Initialization of enum 'Attribute'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "Attribute",
        "2:PySide2.QtNetwork.QNetworkRequest.Attribute",
        "QNetworkRequest::Attribute");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HttpStatusCodeAttribute", (long) QNetworkRequest::Attribute::HttpStatusCodeAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HttpReasonPhraseAttribute", (long) QNetworkRequest::Attribute::HttpReasonPhraseAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "RedirectionTargetAttribute", (long) QNetworkRequest::Attribute::RedirectionTargetAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "ConnectionEncryptedAttribute", (long) QNetworkRequest::Attribute::ConnectionEncryptedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "CacheLoadControlAttribute", (long) QNetworkRequest::Attribute::CacheLoadControlAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "CacheSaveControlAttribute", (long) QNetworkRequest::Attribute::CacheSaveControlAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "SourceIsFromCacheAttribute", (long) QNetworkRequest::Attribute::SourceIsFromCacheAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "DoNotBufferUploadDataAttribute", (long) QNetworkRequest::Attribute::DoNotBufferUploadDataAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HttpPipeliningAllowedAttribute", (long) QNetworkRequest::Attribute::HttpPipeliningAllowedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HttpPipeliningWasUsedAttribute", (long) QNetworkRequest::Attribute::HttpPipeliningWasUsedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "CustomVerbAttribute", (long) QNetworkRequest::Attribute::CustomVerbAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "CookieLoadControlAttribute", (long) QNetworkRequest::Attribute::CookieLoadControlAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "AuthenticationReuseAttribute", (long) QNetworkRequest::Attribute::AuthenticationReuseAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "CookieSaveControlAttribute", (long) QNetworkRequest::Attribute::CookieSaveControlAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "MaximumDownloadBufferSizeAttribute", (long) QNetworkRequest::Attribute::MaximumDownloadBufferSizeAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "DownloadBufferAttribute", (long) QNetworkRequest::Attribute::DownloadBufferAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "SynchronousRequestAttribute", (long) QNetworkRequest::Attribute::SynchronousRequestAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "BackgroundRequestAttribute", (long) QNetworkRequest::Attribute::BackgroundRequestAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "SpdyAllowedAttribute", (long) QNetworkRequest::Attribute::SpdyAllowedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "SpdyWasUsedAttribute", (long) QNetworkRequest::Attribute::SpdyWasUsedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "EmitAllUploadProgressSignalsAttribute", (long) QNetworkRequest::Attribute::EmitAllUploadProgressSignalsAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "FollowRedirectsAttribute", (long) QNetworkRequest::Attribute::FollowRedirectsAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "Http2AllowedAttribute", (long) QNetworkRequest::Attribute::Http2AllowedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "Http2WasUsedAttribute", (long) QNetworkRequest::Attribute::Http2WasUsedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HTTP2AllowedAttribute", (long) QNetworkRequest::Attribute::HTTP2AllowedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "HTTP2WasUsedAttribute", (long) QNetworkRequest::Attribute::HTTP2WasUsedAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "OriginalContentLengthAttribute", (long) QNetworkRequest::Attribute::OriginalContentLengthAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "RedirectPolicyAttribute", (long) QNetworkRequest::Attribute::RedirectPolicyAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "Http2DirectAttribute", (long) QNetworkRequest::Attribute::Http2DirectAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "ResourceTypeAttribute", (long) QNetworkRequest::Attribute::ResourceTypeAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "AutoDeleteReplyOnFinishAttribute", (long) QNetworkRequest::Attribute::AutoDeleteReplyOnFinishAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "User", (long) QNetworkRequest::Attribute::User))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
        Sbk_QNetworkRequest_TypeF(), "UserMax", (long) QNetworkRequest::Attribute::UserMax))
        return;
    // Register converter for enum 'QNetworkRequest::Attribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX],
            QNetworkRequest_Attribute_CppToPython_QNetworkRequest_Attribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_Attribute_PythonToCpp_QNetworkRequest_Attribute,
            is_QNetworkRequest_Attribute_PythonToCpp_QNetworkRequest_Attribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::Attribute");
        Shiboken::Conversions::registerConverterName(converter, "Attribute");
    }
    // End of 'Attribute' enum.

    // Initialization of enum 'CacheLoadControl'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "CacheLoadControl",
        "2:PySide2.QtNetwork.QNetworkRequest.CacheLoadControl",
        "QNetworkRequest::CacheLoadControl");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "AlwaysNetwork", (long) QNetworkRequest::CacheLoadControl::AlwaysNetwork))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "PreferNetwork", (long) QNetworkRequest::CacheLoadControl::PreferNetwork))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "PreferCache", (long) QNetworkRequest::CacheLoadControl::PreferCache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "AlwaysCache", (long) QNetworkRequest::CacheLoadControl::AlwaysCache))
        return;
    // Register converter for enum 'QNetworkRequest::CacheLoadControl'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX],
            QNetworkRequest_CacheLoadControl_CppToPython_QNetworkRequest_CacheLoadControl);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_CacheLoadControl_PythonToCpp_QNetworkRequest_CacheLoadControl,
            is_QNetworkRequest_CacheLoadControl_PythonToCpp_QNetworkRequest_CacheLoadControl_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_CACHELOADCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::CacheLoadControl");
        Shiboken::Conversions::registerConverterName(converter, "CacheLoadControl");
    }
    // End of 'CacheLoadControl' enum.

    // Initialization of enum 'LoadControl'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "LoadControl",
        "2:PySide2.QtNetwork.QNetworkRequest.LoadControl",
        "QNetworkRequest::LoadControl");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "Automatic", (long) QNetworkRequest::LoadControl::Automatic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX],
        Sbk_QNetworkRequest_TypeF(), "Manual", (long) QNetworkRequest::LoadControl::Manual))
        return;
    // Register converter for enum 'QNetworkRequest::LoadControl'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX],
            QNetworkRequest_LoadControl_CppToPython_QNetworkRequest_LoadControl);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_LoadControl_PythonToCpp_QNetworkRequest_LoadControl,
            is_QNetworkRequest_LoadControl_PythonToCpp_QNetworkRequest_LoadControl_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_LOADCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::LoadControl");
        Shiboken::Conversions::registerConverterName(converter, "LoadControl");
    }
    // End of 'LoadControl' enum.

    // Initialization of enum 'Priority'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "Priority",
        "2:PySide2.QtNetwork.QNetworkRequest.Priority",
        "QNetworkRequest::Priority");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX],
        Sbk_QNetworkRequest_TypeF(), "HighPriority", (long) QNetworkRequest::Priority::HighPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX],
        Sbk_QNetworkRequest_TypeF(), "NormalPriority", (long) QNetworkRequest::Priority::NormalPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX],
        Sbk_QNetworkRequest_TypeF(), "LowPriority", (long) QNetworkRequest::Priority::LowPriority))
        return;
    // Register converter for enum 'QNetworkRequest::Priority'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX],
            QNetworkRequest_Priority_CppToPython_QNetworkRequest_Priority);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_Priority_PythonToCpp_QNetworkRequest_Priority,
            is_QNetworkRequest_Priority_PythonToCpp_QNetworkRequest_Priority_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_PRIORITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::Priority");
        Shiboken::Conversions::registerConverterName(converter, "Priority");
    }
    // End of 'Priority' enum.

    // Initialization of enum 'RedirectPolicy'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "RedirectPolicy",
        "2:PySide2.QtNetwork.QNetworkRequest.RedirectPolicy",
        "QNetworkRequest::RedirectPolicy");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX],
        Sbk_QNetworkRequest_TypeF(), "ManualRedirectPolicy", (long) QNetworkRequest::RedirectPolicy::ManualRedirectPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX],
        Sbk_QNetworkRequest_TypeF(), "NoLessSafeRedirectPolicy", (long) QNetworkRequest::RedirectPolicy::NoLessSafeRedirectPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX],
        Sbk_QNetworkRequest_TypeF(), "SameOriginRedirectPolicy", (long) QNetworkRequest::RedirectPolicy::SameOriginRedirectPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX],
        Sbk_QNetworkRequest_TypeF(), "UserVerifiedRedirectPolicy", (long) QNetworkRequest::RedirectPolicy::UserVerifiedRedirectPolicy))
        return;
    // Register converter for enum 'QNetworkRequest::RedirectPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX],
            QNetworkRequest_RedirectPolicy_CppToPython_QNetworkRequest_RedirectPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_RedirectPolicy_PythonToCpp_QNetworkRequest_RedirectPolicy,
            is_QNetworkRequest_RedirectPolicy_PythonToCpp_QNetworkRequest_RedirectPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::RedirectPolicy");
        Shiboken::Conversions::registerConverterName(converter, "RedirectPolicy");
    }
    // End of 'RedirectPolicy' enum.

    // Initialization of enum 'TransferTimeoutConstant'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkRequest_TypeF(),
        "TransferTimeoutConstant",
        "2:PySide2.QtNetwork.QNetworkRequest.TransferTimeoutConstant",
        "QNetworkRequest::TransferTimeoutConstant");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX],
        Sbk_QNetworkRequest_TypeF(), "DefaultTransferTimeoutConstant", (long) QNetworkRequest::TransferTimeoutConstant::DefaultTransferTimeoutConstant))
        return;
    // Register converter for enum 'QNetworkRequest::TransferTimeoutConstant'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX],
            QNetworkRequest_TransferTimeoutConstant_CppToPython_QNetworkRequest_TransferTimeoutConstant);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkRequest_TransferTimeoutConstant_PythonToCpp_QNetworkRequest_TransferTimeoutConstant,
            is_QNetworkRequest_TransferTimeoutConstant_PythonToCpp_QNetworkRequest_TransferTimeoutConstant_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_TRANSFERTIMEOUTCONSTANT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkRequest::TransferTimeoutConstant");
        Shiboken::Conversions::registerConverterName(converter, "TransferTimeoutConstant");
    }
    // End of 'TransferTimeoutConstant' enum.

    qRegisterMetaType< ::QNetworkRequest >("QNetworkRequest");
    qRegisterMetaType< ::QNetworkRequest::KnownHeaders >("QNetworkRequest::KnownHeaders");
    qRegisterMetaType< ::QNetworkRequest::Attribute >("QNetworkRequest::Attribute");
    qRegisterMetaType< ::QNetworkRequest::CacheLoadControl >("QNetworkRequest::CacheLoadControl");
    qRegisterMetaType< ::QNetworkRequest::LoadControl >("QNetworkRequest::LoadControl");
    qRegisterMetaType< ::QNetworkRequest::Priority >("QNetworkRequest::Priority");
    qRegisterMetaType< ::QNetworkRequest::RedirectPolicy >("QNetworkRequest::RedirectPolicy");
    qRegisterMetaType< ::QNetworkRequest::TransferTimeoutConstant >("QNetworkRequest::TransferTimeoutConstant");
}
