/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkconfiguration_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qnetworkconfiguration.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkConfiguration_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkConfiguration >()))
        return -1;

    ::QNetworkConfiguration *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNetworkConfiguration", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkConfiguration::QNetworkConfiguration()
    // 1: QNetworkConfiguration::QNetworkConfiguration(QNetworkConfiguration)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkConfiguration()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QNetworkConfiguration(QNetworkConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfiguration_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkConfiguration()
        {

            if (!PyErr_Occurred()) {
                // QNetworkConfiguration()
                cptr = new ::QNetworkConfiguration();
            }
            break;
        }
        case 1: // QNetworkConfiguration(const QNetworkConfiguration & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkConfiguration cppArg0_local;
            ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkConfiguration(QNetworkConfiguration)
                cptr = new ::QNetworkConfiguration(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkConfiguration >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkConfiguration_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkConfiguration_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkConfigurationFunc_bearerType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.bearerType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bearerType()const
            QNetworkConfiguration::BearerType cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->bearerType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_bearerTypeFamily(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.bearerTypeFamily";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bearerTypeFamily()const
            QNetworkConfiguration::BearerType cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->bearerTypeFamily();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_bearerTypeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.bearerTypeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bearerTypeName()const
            QString cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->bearerTypeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_children(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.children";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // children()const
            QList<QNetworkConfiguration > cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->children();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCONFIGURATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_connectTimeout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.connectTimeout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // connectTimeout()const
            int cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->connectTimeout();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_identifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.identifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // identifier()const
            QString cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->identifier();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_isRoamingAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.isRoamingAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRoamingAvailable()const
            bool cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->isRoamingAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_purpose(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.purpose";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // purpose()const
            QNetworkConfiguration::Purpose cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->purpose();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_setConnectTimeout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.setConnectTimeout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkConfiguration::setConnectTimeout(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setConnectTimeout(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfigurationFunc_setConnectTimeout_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setConnectTimeout(int)
            bool cppResult = cppSelf->setConnectTimeout(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkConfigurationFunc_setConnectTimeout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkConfigurationFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QFlags<QNetworkConfiguration::StateFlag> cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkConfiguration::swap(QNetworkConfiguration&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkConfiguration&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfigurationFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkConfiguration cppArg0_local;
        ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkConfiguration&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkConfigurationFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkConfigurationFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfiguration.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QNetworkConfiguration::Type cppResult = const_cast<const ::QNetworkConfiguration *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfiguration___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkConfiguration_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkConfiguration_methods[] = {
    {"bearerType", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_bearerType), METH_NOARGS},
    {"bearerTypeFamily", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_bearerTypeFamily), METH_NOARGS},
    {"bearerTypeName", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_bearerTypeName), METH_NOARGS},
    {"children", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_children), METH_NOARGS},
    {"connectTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_connectTimeout), METH_NOARGS},
    {"identifier", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_identifier), METH_NOARGS},
    {"isRoamingAvailable", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_isRoamingAvailable), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_isValid), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_name), METH_NOARGS},
    {"purpose", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_purpose), METH_NOARGS},
    {"setConnectTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_setConnectTimeout), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_state), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_swap), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfiguration___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QNetworkConfiguration_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArg)))) {
                // operator!=(const QNetworkConfiguration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkConfiguration cppArg0_local;
                ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArg)))) {
                // operator==(const QNetworkConfiguration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkConfiguration cppArg0_local;
                ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QNetworkConfiguration_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QNetworkConfiguration_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QNetworkConfiguration_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkConfiguration_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkConfiguration_Type = nullptr;
static SbkObjectType *Sbk_QNetworkConfiguration_TypeF(void)
{
    return _Sbk_QNetworkConfiguration_Type;
}

static PyType_Slot Sbk_QNetworkConfiguration_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkConfiguration_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkConfiguration_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QNetworkConfiguration_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkConfiguration_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkConfiguration_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkConfiguration_spec = {
    "2:PySide2.QtNetwork.QNetworkConfiguration",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkConfiguration_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfiguration::StateFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfiguration::StateFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfiguration::StateFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfiguration::StateFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfiguration::StateFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, self, &cppSelf);
    ::QNetworkConfiguration::StateFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkConfiguration_Type_PythonToCpp_QNetworkConfiguration_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfiguration::Type *>(cppOut) =
        static_cast<::QNetworkConfiguration::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkConfiguration_Type_PythonToCpp_QNetworkConfiguration_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX]))
        return QNetworkConfiguration_Type_PythonToCpp_QNetworkConfiguration_Type;
    return {};
}
static PyObject *QNetworkConfiguration_Type_CppToPython_QNetworkConfiguration_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkConfiguration::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX], castCppIn);

}

static void QNetworkConfiguration_Purpose_PythonToCpp_QNetworkConfiguration_Purpose(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfiguration::Purpose *>(cppOut) =
        static_cast<::QNetworkConfiguration::Purpose>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkConfiguration_Purpose_PythonToCpp_QNetworkConfiguration_Purpose_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX]))
        return QNetworkConfiguration_Purpose_PythonToCpp_QNetworkConfiguration_Purpose;
    return {};
}
static PyObject *QNetworkConfiguration_Purpose_CppToPython_QNetworkConfiguration_Purpose(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkConfiguration::Purpose *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX], castCppIn);

}

static void QNetworkConfiguration_StateFlag_PythonToCpp_QNetworkConfiguration_StateFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfiguration::StateFlag *>(cppOut) =
        static_cast<::QNetworkConfiguration::StateFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkConfiguration_StateFlag_PythonToCpp_QNetworkConfiguration_StateFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX]))
        return QNetworkConfiguration_StateFlag_PythonToCpp_QNetworkConfiguration_StateFlag;
    return {};
}
static PyObject *QNetworkConfiguration_StateFlag_CppToPython_QNetworkConfiguration_StateFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkConfiguration::StateFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX], castCppIn);

}

static void QFlags_QNetworkConfiguration_StateFlag__PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkConfiguration::StateFlag> *>(cppOut) =
        ::QFlags<QNetworkConfiguration::StateFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QNetworkConfiguration_StateFlag__PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX]))
        return QFlags_QNetworkConfiguration_StateFlag__PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_;
    return {};
}
static PyObject *QFlags_QNetworkConfiguration_StateFlag__CppToPython_QFlags_QNetworkConfiguration_StateFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QNetworkConfiguration::StateFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX]));

}

static void QNetworkConfiguration_StateFlag_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkConfiguration::StateFlag> *>(cppOut) =
        ::QFlags<QNetworkConfiguration::StateFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QNetworkConfiguration_StateFlag_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX]))
        return QNetworkConfiguration_StateFlag_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QNetworkConfiguration::StateFlag> *>(cppOut) =
        ::QFlags<QNetworkConfiguration::StateFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_;
    return {};
}
static void QNetworkConfiguration_BearerType_PythonToCpp_QNetworkConfiguration_BearerType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfiguration::BearerType *>(cppOut) =
        static_cast<::QNetworkConfiguration::BearerType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkConfiguration_BearerType_PythonToCpp_QNetworkConfiguration_BearerType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX]))
        return QNetworkConfiguration_BearerType_PythonToCpp_QNetworkConfiguration_BearerType;
    return {};
}
static PyObject *QNetworkConfiguration_BearerType_CppToPython_QNetworkConfiguration_BearerType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkConfiguration::BearerType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkConfiguration_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkConfiguration_TypeF())))
        return QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkConfiguration_PTR_CppToPython_QNetworkConfiguration(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkConfiguration *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkConfiguration_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkConfiguration_COPY_CppToPython_QNetworkConfiguration(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkConfiguration_TypeF(), new ::QNetworkConfiguration(*reinterpret_cast<const ::QNetworkConfiguration *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfiguration *>(cppOut) = *reinterpret_cast< ::QNetworkConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkConfiguration_TypeF())))
        return QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkConfiguration_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QNetworkConfiguration(self)",
    "0:PySide2.QtNetwork.QNetworkConfiguration(self,other:PySide2.QtNetwork.QNetworkConfiguration)",
    "PySide2.QtNetwork.QNetworkConfiguration.bearerType(self)->PySide2.QtNetwork.QNetworkConfiguration.BearerType",
    "PySide2.QtNetwork.QNetworkConfiguration.bearerTypeFamily(self)->PySide2.QtNetwork.QNetworkConfiguration.BearerType",
    "PySide2.QtNetwork.QNetworkConfiguration.bearerTypeName(self)->QString",
    "PySide2.QtNetwork.QNetworkConfiguration.children(self)->QList[PySide2.QtNetwork.QNetworkConfiguration]",
    "PySide2.QtNetwork.QNetworkConfiguration.connectTimeout(self)->int",
    "PySide2.QtNetwork.QNetworkConfiguration.identifier(self)->QString",
    "PySide2.QtNetwork.QNetworkConfiguration.isRoamingAvailable(self)->bool",
    "PySide2.QtNetwork.QNetworkConfiguration.isValid(self)->bool",
    "PySide2.QtNetwork.QNetworkConfiguration.name(self)->QString",
    "PySide2.QtNetwork.QNetworkConfiguration.purpose(self)->PySide2.QtNetwork.QNetworkConfiguration.Purpose",
    "PySide2.QtNetwork.QNetworkConfiguration.setConnectTimeout(self,timeout:int)->bool",
    "PySide2.QtNetwork.QNetworkConfiguration.state(self)->PySide2.QtNetwork.QNetworkConfiguration.StateFlags",
    "PySide2.QtNetwork.QNetworkConfiguration.swap(self,other:PySide2.QtNetwork.QNetworkConfiguration)",
    "PySide2.QtNetwork.QNetworkConfiguration.type(self)->PySide2.QtNetwork.QNetworkConfiguration.Type",
    "PySide2.QtNetwork.QNetworkConfiguration.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkConfiguration(PyObject *module)
{
    _Sbk_QNetworkConfiguration_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkConfiguration",
        "QNetworkConfiguration",
        &Sbk_QNetworkConfiguration_spec,
        &Shiboken::callCppDestructor< ::QNetworkConfiguration >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkConfiguration_Type);
    InitSignatureStrings(pyType, QNetworkConfiguration_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkConfiguration_Type), Sbk_QNetworkConfiguration_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkConfiguration_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkConfiguration_TypeF(),
        QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_PTR,
        is_QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_PTR_Convertible,
        QNetworkConfiguration_PTR_CppToPython_QNetworkConfiguration,
        QNetworkConfiguration_COPY_CppToPython_QNetworkConfiguration);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkConfiguration).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_COPY,
        is_QNetworkConfiguration_PythonToCpp_QNetworkConfiguration_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkConfiguration_TypeF(),
        "Type",
        "2:PySide2.QtNetwork.QNetworkConfiguration.Type",
        "QNetworkConfiguration::Type");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "InternetAccessPoint", (long) QNetworkConfiguration::Type::InternetAccessPoint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "ServiceNetwork", (long) QNetworkConfiguration::Type::ServiceNetwork))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "UserChoice", (long) QNetworkConfiguration::Type::UserChoice))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Invalid", (long) QNetworkConfiguration::Type::Invalid))
        return;
    // Register converter for enum 'QNetworkConfiguration::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX],
            QNetworkConfiguration_Type_CppToPython_QNetworkConfiguration_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfiguration_Type_PythonToCpp_QNetworkConfiguration_Type,
            is_QNetworkConfiguration_Type_PythonToCpp_QNetworkConfiguration_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'Purpose'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkConfiguration_TypeF(),
        "Purpose",
        "2:PySide2.QtNetwork.QNetworkConfiguration.Purpose",
        "QNetworkConfiguration::Purpose");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "UnknownPurpose", (long) QNetworkConfiguration::Purpose::UnknownPurpose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "PublicPurpose", (long) QNetworkConfiguration::Purpose::PublicPurpose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "PrivatePurpose", (long) QNetworkConfiguration::Purpose::PrivatePurpose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "ServiceSpecificPurpose", (long) QNetworkConfiguration::Purpose::ServiceSpecificPurpose))
        return;
    // Register converter for enum 'QNetworkConfiguration::Purpose'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX],
            QNetworkConfiguration_Purpose_CppToPython_QNetworkConfiguration_Purpose);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfiguration_Purpose_PythonToCpp_QNetworkConfiguration_Purpose,
            is_QNetworkConfiguration_Purpose_PythonToCpp_QNetworkConfiguration_Purpose_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_PURPOSE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration::Purpose");
        Shiboken::Conversions::registerConverterName(converter, "Purpose");
    }
    // End of 'Purpose' enum.

    // Initialization of enum 'StateFlag'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QNetworkConfiguration.StateFlags", SbkPySide2_QtNetwork_QNetworkConfiguration_StateFlag_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkConfiguration_TypeF(),
        "StateFlag",
        "2:PySide2.QtNetwork.QNetworkConfiguration.StateFlag",
        "QNetworkConfiguration::StateFlag",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Undefined", (long) QNetworkConfiguration::StateFlag::Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Defined", (long) QNetworkConfiguration::StateFlag::Defined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Discovered", (long) QNetworkConfiguration::StateFlag::Discovered))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Active", (long) QNetworkConfiguration::StateFlag::Active))
        return;
    // Register converter for enum 'QNetworkConfiguration::StateFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX],
            QNetworkConfiguration_StateFlag_CppToPython_QNetworkConfiguration_StateFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfiguration_StateFlag_PythonToCpp_QNetworkConfiguration_StateFlag,
            is_QNetworkConfiguration_StateFlag_PythonToCpp_QNetworkConfiguration_StateFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_STATEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration::StateFlag");
        Shiboken::Conversions::registerConverterName(converter, "StateFlag");
    }
    // Register converter for flag 'QFlags<QNetworkConfiguration::StateFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX],
            QFlags_QNetworkConfiguration_StateFlag__CppToPython_QFlags_QNetworkConfiguration_StateFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfiguration_StateFlag_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_,
            is_QNetworkConfiguration_StateFlag_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QNetworkConfiguration_StateFlag__PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_,
            is_QFlags_QNetworkConfiguration_StateFlag__PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag_,
            is_number_PythonToCpp_QFlags_QNetworkConfiguration_StateFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration::StateFlags");
        Shiboken::Conversions::registerConverterName(converter, "StateFlags");
    }
    // End of 'StateFlag' enum/flags.

    // Initialization of enum 'BearerType'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkConfiguration_TypeF(),
        "BearerType",
        "2:PySide2.QtNetwork.QNetworkConfiguration.BearerType",
        "QNetworkConfiguration::BearerType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerUnknown", (long) QNetworkConfiguration::BearerType::BearerUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerEthernet", (long) QNetworkConfiguration::BearerType::BearerEthernet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerWLAN", (long) QNetworkConfiguration::BearerType::BearerWLAN))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Bearer2G", (long) QNetworkConfiguration::BearerType::Bearer2G))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerCDMA2000", (long) QNetworkConfiguration::BearerType::BearerCDMA2000))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerWCDMA", (long) QNetworkConfiguration::BearerType::BearerWCDMA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerHSPA", (long) QNetworkConfiguration::BearerType::BearerHSPA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerBluetooth", (long) QNetworkConfiguration::BearerType::BearerBluetooth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerWiMAX", (long) QNetworkConfiguration::BearerType::BearerWiMAX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerEVDO", (long) QNetworkConfiguration::BearerType::BearerEVDO))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "BearerLTE", (long) QNetworkConfiguration::BearerType::BearerLTE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Bearer3G", (long) QNetworkConfiguration::BearerType::Bearer3G))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
        Sbk_QNetworkConfiguration_TypeF(), "Bearer4G", (long) QNetworkConfiguration::BearerType::Bearer4G))
        return;
    // Register converter for enum 'QNetworkConfiguration::BearerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX],
            QNetworkConfiguration_BearerType_CppToPython_QNetworkConfiguration_BearerType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfiguration_BearerType_PythonToCpp_QNetworkConfiguration_BearerType,
            is_QNetworkConfiguration_BearerType_PythonToCpp_QNetworkConfiguration_BearerType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_BEARERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfiguration::BearerType");
        Shiboken::Conversions::registerConverterName(converter, "BearerType");
    }
    // End of 'BearerType' enum.

    qRegisterMetaType< ::QNetworkConfiguration >("QNetworkConfiguration");
    qRegisterMetaType< ::QNetworkConfiguration::Type >("QNetworkConfiguration::Type");
    qRegisterMetaType< ::QNetworkConfiguration::Purpose >("QNetworkConfiguration::Purpose");
    qRegisterMetaType< ::QNetworkConfiguration::StateFlag >("QNetworkConfiguration::StateFlag");
    qRegisterMetaType< ::QNetworkConfiguration::StateFlags >("QNetworkConfiguration::StateFlags");
    qRegisterMetaType< ::QNetworkConfiguration::BearerType >("QNetworkConfiguration::BearerType");
}
