/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QNETWORKACCESSMANAGERWRAPPER_H
#define SBK_QNETWORKACCESSMANAGERWRAPPER_H

#define protected public

#include <QtNetwork/qnetworkaccessmanager.h>


// Extra includes
#include <qobject.h>
#include <QtNetwork/qnetworkproxy.h>
#include <QtNetwork/qabstractnetworkcache.h>
#include <QtNetwork/qnetworkcookiejar.h>
#include <QVector>
#include <QtNetwork/qhstspolicy.h>
#include <QtNetwork/qnetworkreply.h>
#include <QtNetwork/qnetworkrequest.h>
#include <qiodevice.h>
#include <qbytearray.h>
#include <QtNetwork/qhttpmultipart.h>
#include <QtNetwork/qnetworkconfiguration.h>
#include <QtNetwork/qsslconfiguration.h>
#include <QtNetwork/qauthenticator.h>
#include <QList>
#include <QtNetwork/qsslerror.h>
#include <QtNetwork/qsslpresharedkeyauthenticator.h>
#include <qobjectdefs.h>
#include <qcoreevent.h>
#include <qthread.h>
#include <qmetaobject.h>
namespace PySide { class DynamicQMetaObject; }

class QNetworkAccessManagerWrapper : public QNetworkAccessManager
{
public:
    QNetworkAccessManagerWrapper(::QObject * parent = nullptr);
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QNetworkReply * createRequest(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData = nullptr) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    void timerEvent(::QTimerEvent * event) override;
    ~QNetworkAccessManagerWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[9];
};

#endif // SBK_QNETWORKACCESSMANAGERWRAPPER_H

