/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qauthenticator_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qauthenticator.h>
#include <pysideqflags.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAuthenticator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAuthenticator >()))
        return -1;

    ::QAuthenticator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAuthenticator", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAuthenticator::QAuthenticator()
    // 1: QAuthenticator::QAuthenticator(QAuthenticator)
    if (numArgs == 0) {
        overloadId = 0; // QAuthenticator()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QAuthenticator(QAuthenticator)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAuthenticator()
        {

            if (!PyErr_Occurred()) {
                // QAuthenticator()
                cptr = new ::QAuthenticator();
            }
            break;
        }
        case 1: // QAuthenticator(const QAuthenticator & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAuthenticator cppArg0_local;
            ::QAuthenticator *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QAuthenticator(QAuthenticator)
                cptr = new ::QAuthenticator(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAuthenticator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAuthenticator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAuthenticator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAuthenticatorFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAuthenticatorFunc_option(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.option";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAuthenticator::option(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // option(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticatorFunc_option_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // option(QString)const
            QVariant cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->option(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAuthenticatorFunc_option_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAuthenticatorFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.options";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // options()const
            QHash<QString,QVariant > cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->options();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAuthenticatorFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.password";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // password()const
            QString cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->password();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAuthenticatorFunc_realm(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.realm";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // realm()const
            QString cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->realm();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAuthenticatorFunc_setOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.setOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAuthenticator::setOption(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setOption(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticatorFunc_setOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setOption(QString,QVariant)
            cppSelf->setOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAuthenticatorFunc_setOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAuthenticatorFunc_setPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.setPassword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAuthenticator::setPassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticatorFunc_setPassword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPassword(QString)
            cppSelf->setPassword(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAuthenticatorFunc_setPassword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAuthenticatorFunc_setRealm(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.setRealm";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAuthenticator::setRealm(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRealm(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticatorFunc_setRealm_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRealm(QString)
            cppSelf->setRealm(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAuthenticatorFunc_setRealm_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAuthenticatorFunc_setUser(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.setUser";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAuthenticator::setUser(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setUser(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAuthenticatorFunc_setUser_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUser(QString)
            cppSelf->setUser(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAuthenticatorFunc_setUser_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAuthenticatorFunc_user(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QAuthenticator.user";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // user()const
            QString cppResult = const_cast<const ::QAuthenticator *>(cppSelf)->user();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAuthenticator___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAuthenticator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAuthenticator_methods[] = {
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_isNull), METH_NOARGS},
    {"option", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_option), METH_O},
    {"options", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_options), METH_NOARGS},
    {"password", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_password), METH_NOARGS},
    {"realm", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_realm), METH_NOARGS},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_setOption), METH_VARARGS},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_setPassword), METH_O},
    {"setRealm", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_setRealm), METH_O},
    {"setUser", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_setUser), METH_O},
    {"user", reinterpret_cast<PyCFunction>(Sbk_QAuthenticatorFunc_user), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAuthenticator___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAuthenticator___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QAuthenticator_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), (pyArg)))) {
                // operator!=(const QAuthenticator & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAuthenticator cppArg0_local;
                ::QAuthenticator *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), (pyArg)))) {
                // operator==(const QAuthenticator & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAuthenticator cppArg0_local;
                ::QAuthenticator *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QAuthenticator_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QAuthenticator_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QAuthenticator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAuthenticator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAuthenticator_Type = nullptr;
static SbkObjectType *Sbk_QAuthenticator_TypeF(void)
{
    return _Sbk_QAuthenticator_Type;
}

static PyType_Slot Sbk_QAuthenticator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAuthenticator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAuthenticator_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QAuthenticator_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAuthenticator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAuthenticator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QAuthenticator___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QAuthenticator___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QAuthenticator_spec = {
    "2:PySide2.QtNetwork.QAuthenticator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAuthenticator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAuthenticator_PythonToCpp_QAuthenticator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAuthenticator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAuthenticator_PythonToCpp_QAuthenticator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAuthenticator_TypeF())))
        return QAuthenticator_PythonToCpp_QAuthenticator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAuthenticator_PTR_CppToPython_QAuthenticator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAuthenticator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAuthenticator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAuthenticator_COPY_CppToPython_QAuthenticator(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAuthenticator_TypeF(), new ::QAuthenticator(*reinterpret_cast<const ::QAuthenticator *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAuthenticator_PythonToCpp_QAuthenticator_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAuthenticator *>(cppOut) = *reinterpret_cast< ::QAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAuthenticator_PythonToCpp_QAuthenticator_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAuthenticator_TypeF())))
        return QAuthenticator_PythonToCpp_QAuthenticator_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAuthenticator_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QAuthenticator(self)",
    "0:PySide2.QtNetwork.QAuthenticator(self,other:PySide2.QtNetwork.QAuthenticator)",
    "PySide2.QtNetwork.QAuthenticator.isNull(self)->bool",
    "PySide2.QtNetwork.QAuthenticator.option(self,opt:QString)->QVariant",
    "PySide2.QtNetwork.QAuthenticator.options(self)->QHash[QString, QVariant]",
    "PySide2.QtNetwork.QAuthenticator.password(self)->QString",
    "PySide2.QtNetwork.QAuthenticator.realm(self)->QString",
    "PySide2.QtNetwork.QAuthenticator.setOption(self,opt:QString,value:QVariant)",
    "PySide2.QtNetwork.QAuthenticator.setPassword(self,password:QString)",
    "PySide2.QtNetwork.QAuthenticator.setRealm(self,realm:QString)",
    "PySide2.QtNetwork.QAuthenticator.setUser(self,user:QString)",
    "PySide2.QtNetwork.QAuthenticator.user(self)->QString",
    "PySide2.QtNetwork.QAuthenticator.__copy__()",
    nullptr}; // Sentinel

void init_QAuthenticator(PyObject *module)
{
    _Sbk_QAuthenticator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAuthenticator",
        "QAuthenticator",
        &Sbk_QAuthenticator_spec,
        &Shiboken::callCppDestructor< ::QAuthenticator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAuthenticator_Type);
    InitSignatureStrings(pyType, QAuthenticator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAuthenticator_Type), Sbk_QAuthenticator_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QAUTHENTICATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAuthenticator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAuthenticator_TypeF(),
        QAuthenticator_PythonToCpp_QAuthenticator_PTR,
        is_QAuthenticator_PythonToCpp_QAuthenticator_PTR_Convertible,
        QAuthenticator_PTR_CppToPython_QAuthenticator,
        QAuthenticator_COPY_CppToPython_QAuthenticator);

    Shiboken::Conversions::registerConverterName(converter, "QAuthenticator");
    Shiboken::Conversions::registerConverterName(converter, "QAuthenticator*");
    Shiboken::Conversions::registerConverterName(converter, "QAuthenticator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAuthenticator).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAuthenticator_PythonToCpp_QAuthenticator_COPY,
        is_QAuthenticator_PythonToCpp_QAuthenticator_COPY_Convertible);

    qRegisterMetaType< ::QAuthenticator >("QAuthenticator");
}
