/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qvideofilterrunnable_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QVideoFilterRunnableWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QVideoFilterRunnableWrapper::QVideoFilterRunnableWrapper() : QVideoFilterRunnable()
{
    resetPyMethodCache();
    // ... middle
}

::QVideoFrame QVideoFilterRunnableWrapper::run(::QVideoFrame * input, const ::QVideoSurfaceFormat & surfaceFormat, ::QFlags<QVideoFilterRunnable::RunFlag> flags)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVideoFilterRunnable.run()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "run";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVideoFilterRunnable.run()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), input),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), &surfaceFormat),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QVideoFilterRunnable.run", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QVideoFrame >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QVideoFrame cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QVideoFilterRunnableWrapper::~QVideoFilterRunnableWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVideoFilterRunnable_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QVideoFilterRunnable' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVideoFilterRunnable >()))
        return -1;

    ::QVideoFilterRunnableWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFilterRunnable.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QVideoFilterRunnable()
            cptr = new ::QVideoFilterRunnableWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVideoFilterRunnable >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QVideoFilterRunnableFunc_run(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFilterRunnable *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFilterRunnable.run";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "run", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QVideoFilterRunnable::run(QVideoFrame*,QVideoSurfaceFormat,QFlags<QVideoFilterRunnable::RunFlag>)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // run(QVideoFrame*,QVideoSurfaceFormat,QFlags<QVideoFilterRunnable::RunFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFilterRunnableFunc_run_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVideoFrame *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVideoSurfaceFormat cppArg1_local;
        ::QVideoSurfaceFormat *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QFlags<QVideoFilterRunnable::RunFlag> cppArg2 = QFlags<QVideoFilterRunnable::RunFlag>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // run(QVideoFrame*,QVideoSurfaceFormat,QFlags<QVideoFilterRunnable::RunFlag>)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QVideoFilterRunnable.run()' not implemented.");
                return {};
            }
            QVideoFrame cppResult = cppSelf->run(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFilterRunnableFunc_run_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QVideoFilterRunnable_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVideoFilterRunnable_methods[] = {
    {"run", reinterpret_cast<PyCFunction>(Sbk_QVideoFilterRunnableFunc_run), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QVideoFilterRunnable_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QVideoFilterRunnable *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QVideoFilterRunnableWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QVideoFilterRunnable_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVideoFilterRunnable_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVideoFilterRunnable_Type = nullptr;
static SbkObjectType *Sbk_QVideoFilterRunnable_TypeF(void)
{
    return _Sbk_QVideoFilterRunnable_Type;
}

static PyType_Slot Sbk_QVideoFilterRunnable_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QVideoFilterRunnable_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVideoFilterRunnable_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVideoFilterRunnable_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVideoFilterRunnable_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVideoFilterRunnable_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QVideoFilterRunnable_spec = {
    "2:PySide2.QtMultimedia.QVideoFilterRunnable",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVideoFilterRunnable_slots
};

} //extern "C"

PyObject *SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QVideoFilterRunnable::RunFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QVideoFilterRunnable::RunFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QVideoFilterRunnable::RunFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QVideoFilterRunnable::RunFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QVideoFilterRunnable::RunFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, self, &cppSelf);
    ::QVideoFilterRunnable::RunFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QVideoFilterRunnable_RunFlag_PythonToCpp_QVideoFilterRunnable_RunFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoFilterRunnable::RunFlag *>(cppOut) =
        static_cast<::QVideoFilterRunnable::RunFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVideoFilterRunnable_RunFlag_PythonToCpp_QVideoFilterRunnable_RunFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]))
        return QVideoFilterRunnable_RunFlag_PythonToCpp_QVideoFilterRunnable_RunFlag;
    return {};
}
static PyObject *QVideoFilterRunnable_RunFlag_CppToPython_QVideoFilterRunnable_RunFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVideoFilterRunnable::RunFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX], castCppIn);

}

static void QFlags_QVideoFilterRunnable_RunFlag__PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QVideoFilterRunnable::RunFlag> *>(cppOut) =
        ::QFlags<QVideoFilterRunnable::RunFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QVideoFilterRunnable_RunFlag__PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]))
        return QFlags_QVideoFilterRunnable_RunFlag__PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_;
    return {};
}
static PyObject *QFlags_QVideoFilterRunnable_RunFlag__CppToPython_QFlags_QVideoFilterRunnable_RunFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QVideoFilterRunnable::RunFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]));

}

static void QVideoFilterRunnable_RunFlag_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QVideoFilterRunnable::RunFlag> *>(cppOut) =
        ::QFlags<QVideoFilterRunnable::RunFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QVideoFilterRunnable_RunFlag_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]))
        return QVideoFilterRunnable_RunFlag_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QVideoFilterRunnable::RunFlag> *>(cppOut) =
        ::QFlags<QVideoFilterRunnable::RunFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]))
        return number_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVideoFilterRunnable_PythonToCpp_QVideoFilterRunnable_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVideoFilterRunnable_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVideoFilterRunnable_PythonToCpp_QVideoFilterRunnable_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoFilterRunnable_TypeF())))
        return QVideoFilterRunnable_PythonToCpp_QVideoFilterRunnable_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVideoFilterRunnable_PTR_CppToPython_QVideoFilterRunnable(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVideoFilterRunnable *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVideoFilterRunnable_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVideoFilterRunnable_SignatureStrings[] = {
    "PySide2.QtMultimedia.QVideoFilterRunnable(self)",
    "PySide2.QtMultimedia.QVideoFilterRunnable.run(self,input:PySide2.QtMultimedia.QVideoFrame,surfaceFormat:PySide2.QtMultimedia.QVideoSurfaceFormat,flags:PySide2.QtMultimedia.QVideoFilterRunnable.RunFlags)->PySide2.QtMultimedia.QVideoFrame",
    nullptr}; // Sentinel

void init_QVideoFilterRunnable(PyObject *module)
{
    _Sbk_QVideoFilterRunnable_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVideoFilterRunnable",
        "QVideoFilterRunnable*",
        &Sbk_QVideoFilterRunnable_spec,
        &Shiboken::callCppDestructor< ::QVideoFilterRunnable >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVideoFilterRunnable_Type);
    InitSignatureStrings(pyType, QVideoFilterRunnable_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVideoFilterRunnable_Type), Sbk_QVideoFilterRunnable_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVideoFilterRunnable_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVideoFilterRunnable_TypeF(),
        QVideoFilterRunnable_PythonToCpp_QVideoFilterRunnable_PTR,
        is_QVideoFilterRunnable_PythonToCpp_QVideoFilterRunnable_PTR_Convertible,
        QVideoFilterRunnable_PTR_CppToPython_QVideoFilterRunnable);

    Shiboken::Conversions::registerConverterName(converter, "QVideoFilterRunnable");
    Shiboken::Conversions::registerConverterName(converter, "QVideoFilterRunnable*");
    Shiboken::Conversions::registerConverterName(converter, "QVideoFilterRunnable&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVideoFilterRunnable).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVideoFilterRunnableWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'RunFlag'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QVideoFilterRunnable.RunFlags", SbkPySide2_QtMultimedia_QVideoFilterRunnable_RunFlag_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVideoFilterRunnable_TypeF(),
        "RunFlag",
        "2:PySide2.QtMultimedia.QVideoFilterRunnable.RunFlag",
        "QVideoFilterRunnable::RunFlag",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX],
        Sbk_QVideoFilterRunnable_TypeF(), "LastInChain", (long) QVideoFilterRunnable::RunFlag::LastInChain))
        return;
    // Register converter for enum 'QVideoFilterRunnable::RunFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX],
            QVideoFilterRunnable_RunFlag_CppToPython_QVideoFilterRunnable_RunFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoFilterRunnable_RunFlag_PythonToCpp_QVideoFilterRunnable_RunFlag,
            is_QVideoFilterRunnable_RunFlag_PythonToCpp_QVideoFilterRunnable_RunFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoFilterRunnable::RunFlag");
        Shiboken::Conversions::registerConverterName(converter, "RunFlag");
    }
    // Register converter for flag 'QFlags<QVideoFilterRunnable::RunFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX],
            QFlags_QVideoFilterRunnable_RunFlag__CppToPython_QFlags_QVideoFilterRunnable_RunFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoFilterRunnable_RunFlag_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_,
            is_QVideoFilterRunnable_RunFlag_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QVideoFilterRunnable_RunFlag__PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_,
            is_QFlags_QVideoFilterRunnable_RunFlag__PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag_,
            is_number_PythonToCpp_QFlags_QVideoFilterRunnable_RunFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QVIDEOFILTERRUNNABLE_RUNFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoFilterRunnable::RunFlags");
        Shiboken::Conversions::registerConverterName(converter, "RunFlags");
    }
    // End of 'RunFlag' enum/flags.

    qRegisterMetaType< ::QVideoFilterRunnable::RunFlag >("QVideoFilterRunnable::RunFlag");
    qRegisterMetaType< ::QVideoFilterRunnable::RunFlags >("QVideoFilterRunnable::RunFlags");
}
