/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qsoundeffect_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSoundEffectWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSoundEffectWrapper::QSoundEffectWrapper(::QObject * parent) : QSoundEffect(parent)
{
    resetPyMethodCache();
    // ... middle
}

QSoundEffectWrapper::QSoundEffectWrapper(const ::QAudioDeviceInfo & audioDevice, ::QObject * parent) : QSoundEffect(audioDevice, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSoundEffectWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSoundEffectWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSoundEffectWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSoundEffectWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSoundEffectWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSoundEffect.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSoundEffectWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSoundEffect.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSoundEffectWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSoundEffectWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSoundEffect::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSoundEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSoundEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSoundEffectWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSoundEffectWrapper *>(this));
        return QSoundEffect::qt_metacast(_clname);
}

QSoundEffectWrapper::~QSoundEffectWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSoundEffect_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSoundEffect >()))
        return -1;

    ::QSoundEffectWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QSoundEffect", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSoundEffect::QSoundEffect(QObject*)
    // 1: QSoundEffect::QSoundEffect(QAudioDeviceInfo,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSoundEffect(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QSoundEffect(QAudioDeviceInfo,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QSoundEffect(QAudioDeviceInfo,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSoundEffect(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffect_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSoundEffect(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSoundEffect_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QSoundEffect_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSoundEffect(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSoundEffectWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSoundEffectWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QSoundEffect(const QAudioDeviceInfo & audioDevice, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSoundEffect_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QSoundEffect_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAudioDeviceInfo cppArg0_local;
            ::QAudioDeviceInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSoundEffect(QAudioDeviceInfo,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSoundEffectWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSoundEffectWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSoundEffect >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSoundEffect_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSoundEffect_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSoundEffect_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSoundEffectFunc_category(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.category";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // category()const
            QString cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->category();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_isLoaded(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.isLoaded";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoaded()const
            bool cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->isLoaded();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_isMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.isMuted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMuted()const
            bool cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->isMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_isPlaying(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.isPlaying";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPlaying()const
            bool cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->isPlaying();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_loopCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.loopCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopCount()const
            int cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->loopCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_loopsRemaining(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.loopsRemaining";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // loopsRemaining()const
            int cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->loopsRemaining();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_play(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.play";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // play()
            cppSelf->play();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSoundEffectFunc_setCategory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.setCategory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSoundEffect::setCategory(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCategory(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffectFunc_setCategory_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCategory(QString)
            cppSelf->setCategory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSoundEffectFunc_setCategory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSoundEffectFunc_setLoopCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.setLoopCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSoundEffect::setLoopCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLoopCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffectFunc_setLoopCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLoopCount(int)
            cppSelf->setLoopCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSoundEffectFunc_setLoopCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSoundEffectFunc_setMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.setMuted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSoundEffect::setMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffectFunc_setMuted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMuted(bool)
            cppSelf->setMuted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSoundEffectFunc_setMuted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSoundEffectFunc_setSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.setSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSoundEffect::setSource(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setSource(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffectFunc_setSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSource(QUrl)
            cppSelf->setSource(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSoundEffectFunc_setSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSoundEffectFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSoundEffect::setVolume(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setVolume(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSoundEffectFunc_setVolume_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(qreal)
            cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSoundEffectFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSoundEffectFunc_source(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.source";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // source()const
            QUrl cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->source();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QSoundEffect::Status cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSoundEffectFunc_supportedMimeTypes(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.supportedMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedMimeTypes()
            QStringList cppResult = ::QSoundEffect::supportedMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSoundEffectFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QSoundEffect.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            qreal cppResult = const_cast<const ::QSoundEffect *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSoundEffect_PropertyStrings[] = {
    "category::",
    "loops:loopCount:setLoopCount",
    "loopsRemaining:",
    "muted:isMuted:",
    "playing:isPlaying",
    "source::",
    "status:",
    "volume::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSoundEffect_methods[] = {
    {"category", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_category), METH_NOARGS},
    {"isLoaded", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_isLoaded), METH_NOARGS},
    {"isMuted", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_isMuted), METH_NOARGS},
    {"isPlaying", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_isPlaying), METH_NOARGS},
    {"loopCount", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_loopCount), METH_NOARGS},
    {"loopsRemaining", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_loopsRemaining), METH_NOARGS},
    {"play", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_play), METH_NOARGS},
    {"setCategory", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_setCategory), METH_O},
    {"setLoopCount", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_setLoopCount), METH_O},
    {"setMuted", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_setMuted), METH_O},
    {"setSource", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_setSource), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_setVolume), METH_O},
    {"source", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_source), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_status), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_stop), METH_NOARGS},
    {"supportedMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_supportedMimeTypes), METH_NOARGS|METH_STATIC},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QSoundEffectFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSoundEffect_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSoundEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSoundEffectWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSoundEffect_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSoundEffect_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSoundEffect_Type = nullptr;
static SbkObjectType *Sbk_QSoundEffect_TypeF(void)
{
    return _Sbk_QSoundEffect_Type;
}

static PyType_Slot Sbk_QSoundEffect_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSoundEffect_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSoundEffect_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSoundEffect_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSoundEffect_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSoundEffect_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSoundEffect_spec = {
    "2:PySide2.QtMultimedia.QSoundEffect",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSoundEffect_slots
};

} //extern "C"

static void *Sbk_QSoundEffect_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSoundEffect *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QSoundEffect_Loop_PythonToCpp_QSoundEffect_Loop(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSoundEffect::Loop *>(cppOut) =
        static_cast<::QSoundEffect::Loop>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSoundEffect_Loop_PythonToCpp_QSoundEffect_Loop_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX]))
        return QSoundEffect_Loop_PythonToCpp_QSoundEffect_Loop;
    return {};
}
static PyObject *QSoundEffect_Loop_CppToPython_QSoundEffect_Loop(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSoundEffect::Loop *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX], castCppIn);

}

static void QSoundEffect_Status_PythonToCpp_QSoundEffect_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSoundEffect::Status *>(cppOut) =
        static_cast<::QSoundEffect::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSoundEffect_Status_PythonToCpp_QSoundEffect_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX]))
        return QSoundEffect_Status_PythonToCpp_QSoundEffect_Status;
    return {};
}
static PyObject *QSoundEffect_Status_CppToPython_QSoundEffect_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSoundEffect::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSoundEffect_PythonToCpp_QSoundEffect_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSoundEffect_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSoundEffect_PythonToCpp_QSoundEffect_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSoundEffect_TypeF())))
        return QSoundEffect_PythonToCpp_QSoundEffect_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSoundEffect_PTR_CppToPython_QSoundEffect(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSoundEffect *>(const_cast<void *>(cppIn)), Sbk_QSoundEffect_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSoundEffect_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QSoundEffect(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtMultimedia.QSoundEffect(self,audioDevice:PySide2.QtMultimedia.QAudioDeviceInfo,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QSoundEffect.category(self)->QString",
    "PySide2.QtMultimedia.QSoundEffect.isLoaded(self)->bool",
    "PySide2.QtMultimedia.QSoundEffect.isMuted(self)->bool",
    "PySide2.QtMultimedia.QSoundEffect.isPlaying(self)->bool",
    "PySide2.QtMultimedia.QSoundEffect.loopCount(self)->int",
    "PySide2.QtMultimedia.QSoundEffect.loopsRemaining(self)->int",
    "PySide2.QtMultimedia.QSoundEffect.play(self)",
    "PySide2.QtMultimedia.QSoundEffect.setCategory(self,category:QString)",
    "PySide2.QtMultimedia.QSoundEffect.setLoopCount(self,loopCount:int)",
    "PySide2.QtMultimedia.QSoundEffect.setMuted(self,muted:bool)",
    "PySide2.QtMultimedia.QSoundEffect.setSource(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtMultimedia.QSoundEffect.setVolume(self,volume:qreal)",
    "PySide2.QtMultimedia.QSoundEffect.source(self)->PySide2.QtCore.QUrl",
    "PySide2.QtMultimedia.QSoundEffect.status(self)->PySide2.QtMultimedia.QSoundEffect.Status",
    "PySide2.QtMultimedia.QSoundEffect.stop(self)",
    "PySide2.QtMultimedia.QSoundEffect.supportedMimeTypes()->QStringList",
    "PySide2.QtMultimedia.QSoundEffect.volume(self)->qreal",
    nullptr}; // Sentinel

void init_QSoundEffect(PyObject *module)
{
    _Sbk_QSoundEffect_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSoundEffect",
        "QSoundEffect*",
        &Sbk_QSoundEffect_spec,
        &Shiboken::callCppDestructor< ::QSoundEffect >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSoundEffect_Type);
    InitSignatureStrings(pyType, QSoundEffect_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSoundEffect_Type), Sbk_QSoundEffect_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSoundEffect_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSoundEffect_TypeF(),
        QSoundEffect_PythonToCpp_QSoundEffect_PTR,
        is_QSoundEffect_PythonToCpp_QSoundEffect_PTR_Convertible,
        QSoundEffect_PTR_CppToPython_QSoundEffect);

    Shiboken::Conversions::registerConverterName(converter, "QSoundEffect");
    Shiboken::Conversions::registerConverterName(converter, "QSoundEffect*");
    Shiboken::Conversions::registerConverterName(converter, "QSoundEffect&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSoundEffect).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSoundEffectWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSoundEffect_TypeF(), &Sbk_QSoundEffect_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Loop'.
    SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSoundEffect_TypeF(),
        "Loop",
        "2:PySide2.QtMultimedia.QSoundEffect.Loop",
        "QSoundEffect::Loop");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX],
        Sbk_QSoundEffect_TypeF(), "Infinite", (long) QSoundEffect::Loop::Infinite))
        return;
    // Register converter for enum 'QSoundEffect::Loop'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX],
            QSoundEffect_Loop_CppToPython_QSoundEffect_Loop);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSoundEffect_Loop_PythonToCpp_QSoundEffect_Loop,
            is_QSoundEffect_Loop_PythonToCpp_QSoundEffect_Loop_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_LOOP_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSoundEffect::Loop");
        Shiboken::Conversions::registerConverterName(converter, "Loop");
    }
    // End of 'Loop' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSoundEffect_TypeF(),
        "Status",
        "2:PySide2.QtMultimedia.QSoundEffect.Status",
        "QSoundEffect::Status");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX],
        Sbk_QSoundEffect_TypeF(), "Null", (long) QSoundEffect::Status::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX],
        Sbk_QSoundEffect_TypeF(), "Loading", (long) QSoundEffect::Status::Loading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX],
        Sbk_QSoundEffect_TypeF(), "Ready", (long) QSoundEffect::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX],
        Sbk_QSoundEffect_TypeF(), "Error", (long) QSoundEffect::Status::Error))
        return;
    // Register converter for enum 'QSoundEffect::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX],
            QSoundEffect_Status_CppToPython_QSoundEffect_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSoundEffect_Status_PythonToCpp_QSoundEffect_Status,
            is_QSoundEffect_Status_PythonToCpp_QSoundEffect_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QSOUNDEFFECT_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSoundEffect::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    PySide::Signal::registerSignals(Sbk_QSoundEffect_TypeF(), &::QSoundEffect::staticMetaObject);
    qRegisterMetaType< ::QSoundEffect::Loop >("QSoundEffect::Loop");
    qRegisterMetaType< ::QSoundEffect::Status >("QSoundEffect::Status");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSoundEffect_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSoundEffect_TypeF(), &::QSoundEffect::staticMetaObject, sizeof(QSoundEffectWrapper));
}
