/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmultimedia_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {

static const char *Sbk_QMultimedia_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMultimedia_methods[] = {

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QMultimedia_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMultimedia_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMultimedia_Type = nullptr;
static SbkObjectType *Sbk_QMultimedia_TypeF(void)
{
    return _Sbk_QMultimedia_Type;
}

static PyType_Slot Sbk_QMultimedia_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMultimedia_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMultimedia_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMultimedia_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMultimedia_spec = {
    "2:PySide2.QtMultimedia.QMultimedia",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMultimedia_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QMultimedia_SupportEstimate_PythonToCpp_QMultimedia_SupportEstimate(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMultimedia::SupportEstimate *>(cppOut) =
        static_cast<::QMultimedia::SupportEstimate>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMultimedia_SupportEstimate_PythonToCpp_QMultimedia_SupportEstimate_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX]))
        return QMultimedia_SupportEstimate_PythonToCpp_QMultimedia_SupportEstimate;
    return {};
}
static PyObject *QMultimedia_SupportEstimate_CppToPython_QMultimedia_SupportEstimate(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMultimedia::SupportEstimate *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX], castCppIn);

}

static void QMultimedia_EncodingQuality_PythonToCpp_QMultimedia_EncodingQuality(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMultimedia::EncodingQuality *>(cppOut) =
        static_cast<::QMultimedia::EncodingQuality>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMultimedia_EncodingQuality_PythonToCpp_QMultimedia_EncodingQuality_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX]))
        return QMultimedia_EncodingQuality_PythonToCpp_QMultimedia_EncodingQuality;
    return {};
}
static PyObject *QMultimedia_EncodingQuality_CppToPython_QMultimedia_EncodingQuality(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMultimedia::EncodingQuality *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX], castCppIn);

}

static void QMultimedia_EncodingMode_PythonToCpp_QMultimedia_EncodingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMultimedia::EncodingMode *>(cppOut) =
        static_cast<::QMultimedia::EncodingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMultimedia_EncodingMode_PythonToCpp_QMultimedia_EncodingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX]))
        return QMultimedia_EncodingMode_PythonToCpp_QMultimedia_EncodingMode;
    return {};
}
static PyObject *QMultimedia_EncodingMode_CppToPython_QMultimedia_EncodingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMultimedia::EncodingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX], castCppIn);

}

static void QMultimedia_AvailabilityStatus_PythonToCpp_QMultimedia_AvailabilityStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMultimedia::AvailabilityStatus *>(cppOut) =
        static_cast<::QMultimedia::AvailabilityStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMultimedia_AvailabilityStatus_PythonToCpp_QMultimedia_AvailabilityStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX]))
        return QMultimedia_AvailabilityStatus_PythonToCpp_QMultimedia_AvailabilityStatus;
    return {};
}
static PyObject *QMultimedia_AvailabilityStatus_CppToPython_QMultimedia_AvailabilityStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMultimedia::AvailabilityStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX], castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QtMultimediaQMultimedia_SignatureStrings[] = {
    nullptr}; // Sentinel

void init_QtMultimediaQMultimedia(PyObject *module)
{
    _Sbk_QMultimedia_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMultimedia",
        "QMultimedia",
        &Sbk_QMultimedia_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMultimedia_Type);
    InitSignatureStrings(pyType, QtMultimediaQMultimedia_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMultimedia_Type), Sbk_QMultimedia_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QtMultimediaQMULTIMEDIA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMultimedia_TypeF());


    // Initialization of enums.

    // Initialization of enum 'SupportEstimate'.
    SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMultimedia_TypeF(),
        "SupportEstimate",
        "2:PySide2.QtMultimedia.QMultimedia.SupportEstimate",
        "QMultimedia::SupportEstimate");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX],
        Sbk_QMultimedia_TypeF(), "NotSupported", (long) QMultimedia::SupportEstimate::NotSupported))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX],
        Sbk_QMultimedia_TypeF(), "MaybeSupported", (long) QMultimedia::SupportEstimate::MaybeSupported))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX],
        Sbk_QMultimedia_TypeF(), "ProbablySupported", (long) QMultimedia::SupportEstimate::ProbablySupported))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX],
        Sbk_QMultimedia_TypeF(), "PreferredService", (long) QMultimedia::SupportEstimate::PreferredService))
        return;
    // Register converter for enum 'QMultimedia::SupportEstimate'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX],
            QMultimedia_SupportEstimate_CppToPython_QMultimedia_SupportEstimate);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMultimedia_SupportEstimate_PythonToCpp_QMultimedia_SupportEstimate,
            is_QMultimedia_SupportEstimate_PythonToCpp_QMultimedia_SupportEstimate_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMultimedia::SupportEstimate");
        Shiboken::Conversions::registerConverterName(converter, "SupportEstimate");
    }
    // End of 'SupportEstimate' enum.

    // Initialization of enum 'EncodingQuality'.
    SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMultimedia_TypeF(),
        "EncodingQuality",
        "2:PySide2.QtMultimedia.QMultimedia.EncodingQuality",
        "QMultimedia::EncodingQuality");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
        Sbk_QMultimedia_TypeF(), "VeryLowQuality", (long) QMultimedia::EncodingQuality::VeryLowQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
        Sbk_QMultimedia_TypeF(), "LowQuality", (long) QMultimedia::EncodingQuality::LowQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
        Sbk_QMultimedia_TypeF(), "NormalQuality", (long) QMultimedia::EncodingQuality::NormalQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
        Sbk_QMultimedia_TypeF(), "HighQuality", (long) QMultimedia::EncodingQuality::HighQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
        Sbk_QMultimedia_TypeF(), "VeryHighQuality", (long) QMultimedia::EncodingQuality::VeryHighQuality))
        return;
    // Register converter for enum 'QMultimedia::EncodingQuality'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX],
            QMultimedia_EncodingQuality_CppToPython_QMultimedia_EncodingQuality);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMultimedia_EncodingQuality_PythonToCpp_QMultimedia_EncodingQuality,
            is_QMultimedia_EncodingQuality_PythonToCpp_QMultimedia_EncodingQuality_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMultimedia::EncodingQuality");
        Shiboken::Conversions::registerConverterName(converter, "EncodingQuality");
    }
    // End of 'EncodingQuality' enum.

    // Initialization of enum 'EncodingMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMultimedia_TypeF(),
        "EncodingMode",
        "2:PySide2.QtMultimedia.QMultimedia.EncodingMode",
        "QMultimedia::EncodingMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX],
        Sbk_QMultimedia_TypeF(), "ConstantQualityEncoding", (long) QMultimedia::EncodingMode::ConstantQualityEncoding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX],
        Sbk_QMultimedia_TypeF(), "ConstantBitRateEncoding", (long) QMultimedia::EncodingMode::ConstantBitRateEncoding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX],
        Sbk_QMultimedia_TypeF(), "AverageBitRateEncoding", (long) QMultimedia::EncodingMode::AverageBitRateEncoding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX],
        Sbk_QMultimedia_TypeF(), "TwoPassEncoding", (long) QMultimedia::EncodingMode::TwoPassEncoding))
        return;
    // Register converter for enum 'QMultimedia::EncodingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX],
            QMultimedia_EncodingMode_CppToPython_QMultimedia_EncodingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMultimedia_EncodingMode_PythonToCpp_QMultimedia_EncodingMode,
            is_QMultimedia_EncodingMode_PythonToCpp_QMultimedia_EncodingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMultimedia::EncodingMode");
        Shiboken::Conversions::registerConverterName(converter, "EncodingMode");
    }
    // End of 'EncodingMode' enum.

    // Initialization of enum 'AvailabilityStatus'.
    SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMultimedia_TypeF(),
        "AvailabilityStatus",
        "2:PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
        "QMultimedia::AvailabilityStatus");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX],
        Sbk_QMultimedia_TypeF(), "Available", (long) QMultimedia::AvailabilityStatus::Available))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX],
        Sbk_QMultimedia_TypeF(), "ServiceMissing", (long) QMultimedia::AvailabilityStatus::ServiceMissing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX],
        Sbk_QMultimedia_TypeF(), "Busy", (long) QMultimedia::AvailabilityStatus::Busy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX],
        Sbk_QMultimedia_TypeF(), "ResourceError", (long) QMultimedia::AvailabilityStatus::ResourceError))
        return;
    // Register converter for enum 'QMultimedia::AvailabilityStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX],
            QMultimedia_AvailabilityStatus_CppToPython_QMultimedia_AvailabilityStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMultimedia_AvailabilityStatus_PythonToCpp_QMultimedia_AvailabilityStatus,
            is_QMultimedia_AvailabilityStatus_PythonToCpp_QMultimedia_AvailabilityStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMultimedia::AvailabilityStatus");
        Shiboken::Conversions::registerConverterName(converter, "AvailabilityStatus");
    }
    // End of 'AvailabilityStatus' enum.

    qRegisterMetaType< ::QMultimedia::SupportEstimate >("QMultimedia::SupportEstimate");
    qRegisterMetaType< ::QMultimedia::EncodingQuality >("QMultimedia::EncodingQuality");
    qRegisterMetaType< ::QMultimedia::EncodingMode >("QMultimedia::EncodingMode");
    qRegisterMetaType< ::QMultimedia::AvailabilityStatus >("QMultimedia::AvailabilityStatus");
}
