/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediaservicesupportedformatsinterface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMediaServiceSupportedFormatsInterfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMediaServiceSupportedFormatsInterfaceWrapper::QMediaServiceSupportedFormatsInterfaceWrapper() : QMediaServiceSupportedFormatsInterface()
{
    resetPyMethodCache();
    // ... middle
}

::QMultimedia::SupportEstimate QMediaServiceSupportedFormatsInterfaceWrapper::hasSupport(const ::QString & mimeType, const ::QStringList & codecs) const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.hasSupport()' not implemented.");
        return QMultimedia::NotSupported;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QMultimedia::NotSupported;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasSupport";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.hasSupport()' not implemented.");
        return QMultimedia::NotSupported;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &mimeType),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &codecs)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMultimedia::NotSupported;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaServiceSupportedFormatsInterface.hasSupport", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMultimedia::SupportEstimate >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QMultimedia::NotSupported;
    }
    ::QMultimedia::SupportEstimate cppResult{QMultimedia::NotSupported};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList QMediaServiceSupportedFormatsInterfaceWrapper::supportedMimeTypes() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.supportedMimeTypes()' not implemented.");
        return ::QStringList();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedMimeTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.supportedMimeTypes()' not implemented.");
        return ::QStringList();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaServiceSupportedFormatsInterface.supportedMimeTypes", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QMediaServiceSupportedFormatsInterfaceWrapper::~QMediaServiceSupportedFormatsInterfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaServiceSupportedFormatsInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICESUPPORTEDFORMATSINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QMediaServiceSupportedFormatsInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaServiceSupportedFormatsInterface >()))
        return -1;

    ::QMediaServiceSupportedFormatsInterfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QMediaServiceSupportedFormatsInterface()
            cptr = new ::QMediaServiceSupportedFormatsInterfaceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaServiceSupportedFormatsInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QMediaServiceSupportedFormatsInterfaceFunc_hasSupport(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceSupportedFormatsInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICESUPPORTEDFORMATSINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface.hasSupport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "hasSupport", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMediaServiceSupportedFormatsInterface::hasSupport(QString,QStringList)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
        overloadId = 0; // hasSupport(QString,QStringList)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaServiceSupportedFormatsInterfaceFunc_hasSupport_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // hasSupport(QString,QStringList)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.hasSupport()' not implemented.");
                return {};
            }
            QMultimedia::SupportEstimate cppResult = const_cast<const ::QMediaServiceSupportedFormatsInterface *>(cppSelf)->hasSupport(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaServiceSupportedFormatsInterfaceFunc_hasSupport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaServiceSupportedFormatsInterfaceFunc_supportedMimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceSupportedFormatsInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICESUPPORTEDFORMATSINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface.supportedMimeTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedMimeTypes()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaServiceSupportedFormatsInterface.supportedMimeTypes()' not implemented.");
                return {};
            }
            QStringList cppResult = const_cast<const ::QMediaServiceSupportedFormatsInterface *>(cppSelf)->supportedMimeTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaServiceSupportedFormatsInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaServiceSupportedFormatsInterface_methods[] = {
    {"hasSupport", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceSupportedFormatsInterfaceFunc_hasSupport), METH_VARARGS},
    {"supportedMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceSupportedFormatsInterfaceFunc_supportedMimeTypes), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaServiceSupportedFormatsInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QMediaServiceSupportedFormatsInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICESUPPORTEDFORMATSINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMediaServiceSupportedFormatsInterfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QMediaServiceSupportedFormatsInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaServiceSupportedFormatsInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaServiceSupportedFormatsInterface_Type = nullptr;
static SbkObjectType *Sbk_QMediaServiceSupportedFormatsInterface_TypeF(void)
{
    return _Sbk_QMediaServiceSupportedFormatsInterface_Type;
}

static PyType_Slot Sbk_QMediaServiceSupportedFormatsInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QMediaServiceSupportedFormatsInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaServiceSupportedFormatsInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaServiceSupportedFormatsInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaServiceSupportedFormatsInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaServiceSupportedFormatsInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaServiceSupportedFormatsInterface_spec = {
    "2:PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaServiceSupportedFormatsInterface_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaServiceSupportedFormatsInterface_PythonToCpp_QMediaServiceSupportedFormatsInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaServiceSupportedFormatsInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaServiceSupportedFormatsInterface_PythonToCpp_QMediaServiceSupportedFormatsInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaServiceSupportedFormatsInterface_TypeF())))
        return QMediaServiceSupportedFormatsInterface_PythonToCpp_QMediaServiceSupportedFormatsInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaServiceSupportedFormatsInterface_PTR_CppToPython_QMediaServiceSupportedFormatsInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMediaServiceSupportedFormatsInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMediaServiceSupportedFormatsInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaServiceSupportedFormatsInterface_SignatureStrings[] = {
    "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface(self)",
    "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface.hasSupport(self,mimeType:QString,codecs:QStringList)->PySide2.QtMultimedia.QMultimedia.SupportEstimate",
    "PySide2.QtMultimedia.QMediaServiceSupportedFormatsInterface.supportedMimeTypes(self)->QStringList",
    nullptr}; // Sentinel

void init_QMediaServiceSupportedFormatsInterface(PyObject *module)
{
    _Sbk_QMediaServiceSupportedFormatsInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaServiceSupportedFormatsInterface",
        "QMediaServiceSupportedFormatsInterface*",
        &Sbk_QMediaServiceSupportedFormatsInterface_spec,
        &Shiboken::callCppDestructor< ::QMediaServiceSupportedFormatsInterface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaServiceSupportedFormatsInterface_Type);
    InitSignatureStrings(pyType, QMediaServiceSupportedFormatsInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaServiceSupportedFormatsInterface_Type), Sbk_QMediaServiceSupportedFormatsInterface_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICESUPPORTEDFORMATSINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaServiceSupportedFormatsInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaServiceSupportedFormatsInterface_TypeF(),
        QMediaServiceSupportedFormatsInterface_PythonToCpp_QMediaServiceSupportedFormatsInterface_PTR,
        is_QMediaServiceSupportedFormatsInterface_PythonToCpp_QMediaServiceSupportedFormatsInterface_PTR_Convertible,
        QMediaServiceSupportedFormatsInterface_PTR_CppToPython_QMediaServiceSupportedFormatsInterface);

    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceSupportedFormatsInterface");
    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceSupportedFormatsInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceSupportedFormatsInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaServiceSupportedFormatsInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaServiceSupportedFormatsInterfaceWrapper).name());


}
