/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediaplayer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMediaPlayerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMediaPlayerWrapper::QMediaPlayerWrapper(::QObject * parent, ::QFlags<QMediaPlayer::Flag> flags) : QMediaPlayer(parent, flags)
{
    resetPyMethodCache();
    // ... middle
}

::QMultimedia::AvailabilityStatus QMediaPlayerWrapper::availability() const
{
    if (m_PyMethodCache[0])
        return this->::QMediaPlayer::availability();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QMultimedia::Available;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "availability";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QMediaPlayer::availability();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMultimedia::Available;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.availability", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMultimedia::AvailabilityStatus >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QMultimedia::Available;
    }
    ::QMultimedia::AvailabilityStatus cppResult{QMultimedia::Available};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QMediaPlayerWrapper::bind(::QObject * arg__1)
{
    if (m_PyMethodCache[1])
        return this->::QMediaPlayer::bind(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QMediaPlayer::bind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.bind", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QMediaPlayerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaPlayerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMediaPlayerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaPlayerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMediaPlayerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMediaPlayerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QMediaPlayerWrapper::isAvailable() const
{
    if (m_PyMethodCache[8])
        return this->::QMediaObject::isAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QMediaObject::isAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.isAvailable", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMediaService * QMediaPlayerWrapper::service() const
{
    if (m_PyMethodCache[10])
        return this->::QMediaObject::service();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "service";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QMediaObject::service();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaPlayer.service", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaService >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaService *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QMediaPlayerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaPlayerWrapper::unbind(::QObject * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QMediaPlayer::unbind(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unbind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QMediaPlayer::unbind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QMediaPlayerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QMediaPlayer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMediaPlayerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QMediaPlayer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMediaPlayerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMediaPlayerWrapper *>(this));
        return QMediaPlayer::qt_metacast(_clname);
}

QMediaPlayerWrapper::~QMediaPlayerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaPlayer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaPlayer >()))
        return -1;

    ::QMediaPlayerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QMediaPlayer", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaPlayer::QMediaPlayer(QObject*,QFlags<QMediaPlayer::Flag>)
    if (numArgs == 0) {
        overloadId = 0; // QMediaPlayer(QObject*,QFlags<QMediaPlayer::Flag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QMediaPlayer(QObject*,QFlags<QMediaPlayer::Flag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QMediaPlayer(QObject*,QFlags<QMediaPlayer::Flag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMediaPlayer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[1]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayer_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QMediaPlayer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QMediaPlayer::Flag> cppArg1 = QMediaPlayer::Flags();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QMediaPlayer(QObject*,QFlags<QMediaPlayer::Flag>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMediaPlayerWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMediaPlayerWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaPlayer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaPlayer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QMediaPlayer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QMediaPlayer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaPlayerFunc_audioRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.audioRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // audioRole()const
            QAudio::Role cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->audioRole();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QMediaPlayer *>(cppSelf)->::QMediaPlayer::availability()
                : const_cast<const ::QMediaPlayer *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_bind(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.bind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaObject::bind(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // bind(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_bind_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bind(QObject*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QMediaPlayer::bind(cppArg0)
                : cppSelf->bind(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaPlayerFunc_bind_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_bufferStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.bufferStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bufferStatus()const
            int cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->bufferStatus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_currentMedia(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.currentMedia";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentMedia()const
            QMediaContent cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->currentMedia();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_currentNetworkConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.currentNetworkConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentNetworkConfiguration()const
            QNetworkConfiguration cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->currentNetworkConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_customAudioRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.customAudioRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // customAudioRole()const
            QString cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->customAudioRole();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_duration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.duration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duration()const
            qint64 cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->duration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QMediaPlayer::Error cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_hasSupport(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.hasSupport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:hasSupport", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QMediaPlayer::hasSupport(QString,QStringList,QFlags<QMediaPlayer::Flag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // hasSupport(QString,QStringList,QFlags<QMediaPlayer::Flag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // hasSupport(QString,QStringList,QFlags<QMediaPlayer::Flag>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // hasSupport(QString,QStringList,QFlags<QMediaPlayer::Flag>)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_codecs = Shiboken::String::createStaticString("codecs");
            if (PyDict_Contains(kwds, key_codecs)) {
                value = PyDict_GetItem(kwds, key_codecs);
                if (value && pyArgs[1]) {
                    errInfo = key_codecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1]))))
                        goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_codecs);
            }
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[2]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMediaPlayerFunc_hasSupport_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1 = QStringList();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<QMediaPlayer::Flag> cppArg2 = QMediaPlayer::Flags();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // hasSupport(QString,QStringList,QFlags<QMediaPlayer::Flag>)
            QMultimedia::SupportEstimate cppResult = ::QMediaPlayer::hasSupport(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_SUPPORTESTIMATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaPlayerFunc_hasSupport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_isAudioAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.isAudioAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAudioAvailable()const
            bool cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->isAudioAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_isMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.isMuted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMuted()const
            bool cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->isMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_isSeekable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.isSeekable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSeekable()const
            bool cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->isSeekable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_isVideoAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.isVideoAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVideoAvailable()const
            bool cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->isVideoAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_media(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.media";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // media()const
            QMediaContent cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->media();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_mediaStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.mediaStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaStatus()const
            QMediaPlayer::MediaStatus cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->mediaStatus();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_mediaStream(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.mediaStream";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaStream()const
            const QIODevice * cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->mediaStream();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaPlayerFunc_play(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.play";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // play()
            cppSelf->play();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaPlayerFunc_playbackRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.playbackRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // playbackRate()const
            qreal cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->playbackRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_playlist(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.playlist";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // playlist()const
            QMediaPlaylist * cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->playlist();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            qint64 cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_setAudioRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setAudioRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setAudioRole(QAudio::Role)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAudioRole(QAudio::Role)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setAudioRole_TypeError;

    // Call function/method
    {
        ::QAudio::Role cppArg0{QAudio::UnknownRole};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAudioRole(QAudio::Role)
            cppSelf->setAudioRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setAudioRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setCustomAudioRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setCustomAudioRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setCustomAudioRole(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCustomAudioRole(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setCustomAudioRole_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCustomAudioRole(QString)
            cppSelf->setCustomAudioRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setCustomAudioRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setMedia(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setMedia";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMediaPlayerFunc_setMedia_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMediaPlayerFunc_setMedia_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setMedia", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMediaPlayer::setMedia(QMediaContent,QIODevice*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMedia(QMediaContent,QIODevice*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setMedia(QMediaContent,QIODevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setMedia_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_stream = Shiboken::String::createStaticString("stream");
            if (PyDict_Contains(kwds, key_stream)) {
                value = PyDict_GetItem(kwds, key_stream);
                if (value && pyArgs[1]) {
                    errInfo = key_stream;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayerFunc_setMedia_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1]))))
                        goto Sbk_QMediaPlayerFunc_setMedia_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_stream);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMediaPlayerFunc_setMedia_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMediaContent cppArg0_local;
        ::QMediaContent *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QIODevice *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMedia(QMediaContent,QIODevice*)
            cppSelf->setMedia(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setMedia_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setMuted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setMuted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMuted(bool)
            cppSelf->setMuted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setMuted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setNetworkConfigurations(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setNetworkConfigurations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setNetworkConfigurations(QList<QNetworkConfiguration>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QNETWORKCONFIGURATION_IDX], (pyArg)))) {
        overloadId = 0; // setNetworkConfigurations(QList<QNetworkConfiguration>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setNetworkConfigurations_TypeError;

    // Call function/method
    {
        ::QList<QNetworkConfiguration > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNetworkConfigurations(QList<QNetworkConfiguration>)
            cppSelf->setNetworkConfigurations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setNetworkConfigurations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setPlaybackRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setPlaybackRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setPlaybackRate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPlaybackRate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setPlaybackRate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPlaybackRate(qreal)
            cppSelf->setPlaybackRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setPlaybackRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setPlaylist(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setPlaylist";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setPlaylist(QMediaPlaylist*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYLIST_IDX]), (pyArg)))) {
        overloadId = 0; // setPlaylist(QMediaPlaylist*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setPlaylist_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaPlaylist *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPlaylist(QMediaPlaylist*)
            cppSelf->setPlaylist(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setPlaylist_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setPosition(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setPosition(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setPosition_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPosition(qint64)
            cppSelf->setPosition(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setVideoOutput(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setVideoOutput";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setVideoOutput(QAbstractVideoSurface*)
    // 1: QMediaPlayer::setVideoOutput(QGraphicsVideoItem*)
    // 2: QMediaPlayer::setVideoOutput(QVideoWidget*)
    // 3: QMediaPlayer::setVideoOutput(QVector<QAbstractVideoSurface*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 1; // setVideoOutput(QGraphicsVideoItem*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]), (pyArg)))) {
        overloadId = 0; // setVideoOutput(QAbstractVideoSurface*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QVECTOR_QABSTRACTVIDEOSURFACEPTR_IDX], (pyArg)))) {
        overloadId = 3; // setVideoOutput(QVector<QAbstractVideoSurface*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setVideoOutput_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setVideoOutput(QAbstractVideoSurface * surface)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QAbstractVideoSurface *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setVideoOutput(QAbstractVideoSurface*)
                cppSelf->setVideoOutput(cppArg0);
            }
            break;
        }
        case 1: // setVideoOutput(QGraphicsVideoItem * arg__1)
        {

            if (!PyErr_Occurred()) {
                // setVideoOutput(QGraphicsVideoItem*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QObject* upcastedArg{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyArg, &(upcastedArg));
                //XXX   /|\ omitting this space crashes shiboken!
                cppSelf->setVideoOutput(reinterpret_cast< QGraphicsVideoItem * >(upcastedArg));
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                // END of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // setVideoOutput(QVideoWidget * arg__1)
        {

            if (!PyErr_Occurred()) {
                // setVideoOutput(QVideoWidget*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QObject* upcastedArg{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyArg, &(upcastedArg));
                //XXX   /|\ omitting this space crashes shiboken!
                cppSelf->setVideoOutput(reinterpret_cast< QVideoWidget * >(upcastedArg));
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                // END of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 3: // setVideoOutput(const QVector<QAbstractVideoSurface* > & surfaces)
        {
            ::QVector<QAbstractVideoSurface* > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setVideoOutput(QVector<QAbstractVideoSurface*>)
                cppSelf->setVideoOutput(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setVideoOutput_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaPlayer::setVolume(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVolume(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_setVolume_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(int)
            cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QMediaPlayer::State cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaPlayerFunc_supportedAudioRoles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.supportedAudioRoles";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedAudioRoles()const
            QList<QAudio::Role > cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->supportedAudioRoles();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_supportedCustomAudioRoles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.supportedCustomAudioRoles";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedCustomAudioRoles()const
            QStringList cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->supportedCustomAudioRoles();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaPlayerFunc_supportedMimeTypes(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.supportedMimeTypes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:supportedMimeTypes", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QMediaPlayer::supportedMimeTypes(QFlags<QMediaPlayer::Flag>)
    if (numArgs == 0) {
        overloadId = 0; // supportedMimeTypes(QFlags<QMediaPlayer::Flag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // supportedMimeTypes(QFlags<QMediaPlayer::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError;
            }
        }
        ::QFlags<QMediaPlayer::Flag> cppArg0 = QMediaPlayer::Flags();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // supportedMimeTypes(QFlags<QMediaPlayer::Flag>)
            QStringList cppResult = ::QMediaPlayer::supportedMimeTypes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaPlayerFunc_supportedMimeTypes_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_unbind(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.unbind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaObject::unbind(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // unbind(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaPlayerFunc_unbind_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // unbind(QObject*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QMediaPlayer::unbind(cppArg0)
                : cppSelf->unbind(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaPlayerFunc_unbind_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaPlayerFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaPlayer.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            int cppResult = const_cast<const ::QMediaPlayer *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaPlayer_PropertyStrings[] = {
    "audioAvailable:isAudioAvailable",
    "audioRole::",
    "bufferStatus:",
    "currentMedia:",
    "customAudioRole::",
    "duration:",
    "error:errorString",
    "media::",
    "mediaStatus:",
    "muted:isMuted:",
    "playbackRate::",
    "playlist::",
    "position::",
    "seekable:isSeekable",
    "state:",
    "videoAvailable:isVideoAvailable",
    "volume::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaPlayer_methods[] = {
    {"audioRole", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_audioRole), METH_NOARGS},
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_availability), METH_NOARGS},
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_bind), METH_O},
    {"bufferStatus", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_bufferStatus), METH_NOARGS},
    {"currentMedia", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_currentMedia), METH_NOARGS},
    {"currentNetworkConfiguration", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_currentNetworkConfiguration), METH_NOARGS},
    {"customAudioRole", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_customAudioRole), METH_NOARGS},
    {"duration", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_duration), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_errorString), METH_NOARGS},
    {"hasSupport", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_hasSupport), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isAudioAvailable", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_isAudioAvailable), METH_NOARGS},
    {"isMuted", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_isMuted), METH_NOARGS},
    {"isSeekable", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_isSeekable), METH_NOARGS},
    {"isVideoAvailable", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_isVideoAvailable), METH_NOARGS},
    {"media", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_media), METH_NOARGS},
    {"mediaStatus", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_mediaStatus), METH_NOARGS},
    {"mediaStream", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_mediaStream), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_pause), METH_NOARGS},
    {"play", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_play), METH_NOARGS},
    {"playbackRate", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_playbackRate), METH_NOARGS},
    {"playlist", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_playlist), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_position), METH_NOARGS},
    {"setAudioRole", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setAudioRole), METH_O},
    {"setCustomAudioRole", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setCustomAudioRole), METH_O},
    {"setMedia", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setMedia), METH_VARARGS|METH_KEYWORDS},
    {"setMuted", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setMuted), METH_O},
    {"setNetworkConfigurations", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setNetworkConfigurations), METH_O},
    {"setPlaybackRate", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setPlaybackRate), METH_O},
    {"setPlaylist", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setPlaylist), METH_O},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setPosition), METH_O},
    {"setVideoOutput", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setVideoOutput), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_setVolume), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_stop), METH_NOARGS},
    {"supportedAudioRoles", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_supportedAudioRoles), METH_NOARGS},
    {"supportedCustomAudioRoles", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_supportedCustomAudioRoles), METH_NOARGS},
    {"supportedMimeTypes", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_supportedMimeTypes), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"unbind", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_unbind), METH_O},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QMediaPlayerFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaPlayer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QMediaPlayer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMediaPlayerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QMediaPlayer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaPlayer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaPlayer_Type = nullptr;
static SbkObjectType *Sbk_QMediaPlayer_TypeF(void)
{
    return _Sbk_QMediaPlayer_Type;
}

static PyType_Slot Sbk_QMediaPlayer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QMediaPlayer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaPlayer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaPlayer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaPlayer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaPlayer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaPlayer_spec = {
    "2:PySide2.QtMultimedia.QMediaPlayer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaPlayer_slots
};

} //extern "C"

static void *Sbk_QMediaPlayer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QMediaPlayer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtMultimedia_QMediaPlayer_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QMediaPlayer::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaPlayer_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QMediaPlayer::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaPlayer_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QMediaPlayer::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaPlayer::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaPlayer::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaPlayer_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QMediaPlayer::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, self, &cppSelf);
    ::QMediaPlayer::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QMediaPlayer_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QMediaPlayer_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QMediaPlayer_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaPlayer_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QMediaPlayer_State_PythonToCpp_QMediaPlayer_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaPlayer::State *>(cppOut) =
        static_cast<::QMediaPlayer::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaPlayer_State_PythonToCpp_QMediaPlayer_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX]))
        return QMediaPlayer_State_PythonToCpp_QMediaPlayer_State;
    return {};
}
static PyObject *QMediaPlayer_State_CppToPython_QMediaPlayer_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaPlayer::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX], castCppIn);

}

static void QMediaPlayer_MediaStatus_PythonToCpp_QMediaPlayer_MediaStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaPlayer::MediaStatus *>(cppOut) =
        static_cast<::QMediaPlayer::MediaStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaPlayer_MediaStatus_PythonToCpp_QMediaPlayer_MediaStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX]))
        return QMediaPlayer_MediaStatus_PythonToCpp_QMediaPlayer_MediaStatus;
    return {};
}
static PyObject *QMediaPlayer_MediaStatus_CppToPython_QMediaPlayer_MediaStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaPlayer::MediaStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX], castCppIn);

}

static void QMediaPlayer_Flag_PythonToCpp_QMediaPlayer_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaPlayer::Flag *>(cppOut) =
        static_cast<::QMediaPlayer::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaPlayer_Flag_PythonToCpp_QMediaPlayer_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX]))
        return QMediaPlayer_Flag_PythonToCpp_QMediaPlayer_Flag;
    return {};
}
static PyObject *QMediaPlayer_Flag_CppToPython_QMediaPlayer_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaPlayer::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX], castCppIn);

}

static void QFlags_QMediaPlayer_Flag__PythonToCpp_QFlags_QMediaPlayer_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QMediaPlayer::Flag> *>(cppOut) =
        ::QFlags<QMediaPlayer::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QMediaPlayer_Flag__PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX]))
        return QFlags_QMediaPlayer_Flag__PythonToCpp_QFlags_QMediaPlayer_Flag_;
    return {};
}
static PyObject *QFlags_QMediaPlayer_Flag__CppToPython_QFlags_QMediaPlayer_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QMediaPlayer::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX]));

}

static void QMediaPlayer_Flag_PythonToCpp_QFlags_QMediaPlayer_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QMediaPlayer::Flag> *>(cppOut) =
        ::QFlags<QMediaPlayer::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QMediaPlayer_Flag_PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX]))
        return QMediaPlayer_Flag_PythonToCpp_QFlags_QMediaPlayer_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QMediaPlayer_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QMediaPlayer::Flag> *>(cppOut) =
        ::QFlags<QMediaPlayer::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QMediaPlayer_Flag_;
    return {};
}
static void QMediaPlayer_Error_PythonToCpp_QMediaPlayer_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaPlayer::Error *>(cppOut) =
        static_cast<::QMediaPlayer::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaPlayer_Error_PythonToCpp_QMediaPlayer_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX]))
        return QMediaPlayer_Error_PythonToCpp_QMediaPlayer_Error;
    return {};
}
static PyObject *QMediaPlayer_Error_CppToPython_QMediaPlayer_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaPlayer::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaPlayer_PythonToCpp_QMediaPlayer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaPlayer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaPlayer_PythonToCpp_QMediaPlayer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaPlayer_TypeF())))
        return QMediaPlayer_PythonToCpp_QMediaPlayer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaPlayer_PTR_CppToPython_QMediaPlayer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QMediaPlayer *>(const_cast<void *>(cppIn)), Sbk_QMediaPlayer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaPlayer_SignatureStrings[] = {
    "PySide2.QtMultimedia.QMediaPlayer(self,parent:PySide2.QtCore.QObject=nullptr,flags:PySide2.QtMultimedia.QMediaPlayer.Flags=QMediaPlayer.Flags())",
    "PySide2.QtMultimedia.QMediaPlayer.audioRole(self)->PySide2.QtMultimedia.QAudio.Role",
    "PySide2.QtMultimedia.QMediaPlayer.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QMediaPlayer.bind(self,arg__1:PySide2.QtCore.QObject)->bool",
    "PySide2.QtMultimedia.QMediaPlayer.bufferStatus(self)->int",
    "PySide2.QtMultimedia.QMediaPlayer.currentMedia(self)->PySide2.QtMultimedia.QMediaContent",
    "PySide2.QtMultimedia.QMediaPlayer.currentNetworkConfiguration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtMultimedia.QMediaPlayer.customAudioRole(self)->QString",
    "PySide2.QtMultimedia.QMediaPlayer.duration(self)->qint64",
    "PySide2.QtMultimedia.QMediaPlayer.error(self)->PySide2.QtMultimedia.QMediaPlayer.Error",
    "PySide2.QtMultimedia.QMediaPlayer.errorString(self)->QString",
    "PySide2.QtMultimedia.QMediaPlayer.hasSupport(mimeType:QString,codecs:QStringList=QStringList(),flags:PySide2.QtMultimedia.QMediaPlayer.Flags=QMediaPlayer.Flags())->PySide2.QtMultimedia.QMultimedia.SupportEstimate",
    "PySide2.QtMultimedia.QMediaPlayer.isAudioAvailable(self)->bool",
    "PySide2.QtMultimedia.QMediaPlayer.isMuted(self)->bool",
    "PySide2.QtMultimedia.QMediaPlayer.isSeekable(self)->bool",
    "PySide2.QtMultimedia.QMediaPlayer.isVideoAvailable(self)->bool",
    "PySide2.QtMultimedia.QMediaPlayer.media(self)->PySide2.QtMultimedia.QMediaContent",
    "PySide2.QtMultimedia.QMediaPlayer.mediaStatus(self)->PySide2.QtMultimedia.QMediaPlayer.MediaStatus",
    "PySide2.QtMultimedia.QMediaPlayer.mediaStream(self)->PySide2.QtCore.QIODevice",
    "PySide2.QtMultimedia.QMediaPlayer.pause(self)",
    "PySide2.QtMultimedia.QMediaPlayer.play(self)",
    "PySide2.QtMultimedia.QMediaPlayer.playbackRate(self)->qreal",
    "PySide2.QtMultimedia.QMediaPlayer.playlist(self)->PySide2.QtMultimedia.QMediaPlaylist",
    "PySide2.QtMultimedia.QMediaPlayer.position(self)->qint64",
    "PySide2.QtMultimedia.QMediaPlayer.setAudioRole(self,audioRole:PySide2.QtMultimedia.QAudio.Role)",
    "PySide2.QtMultimedia.QMediaPlayer.setCustomAudioRole(self,audioRole:QString)",
    "PySide2.QtMultimedia.QMediaPlayer.setMedia(self,media:PySide2.QtMultimedia.QMediaContent,stream:PySide2.QtCore.QIODevice=nullptr)",
    "PySide2.QtMultimedia.QMediaPlayer.setMuted(self,muted:bool)",
    "PySide2.QtMultimedia.QMediaPlayer.setNetworkConfigurations(self,configurations:QList[PySide2.QtNetwork.QNetworkConfiguration])",
    "PySide2.QtMultimedia.QMediaPlayer.setPlaybackRate(self,rate:qreal)",
    "PySide2.QtMultimedia.QMediaPlayer.setPlaylist(self,playlist:PySide2.QtMultimedia.QMediaPlaylist)",
    "PySide2.QtMultimedia.QMediaPlayer.setPosition(self,position:qint64)",
    "3:PySide2.QtMultimedia.QMediaPlayer.setVideoOutput(self,surface:PySide2.QtMultimedia.QAbstractVideoSurface)",
    "2:PySide2.QtMultimedia.QMediaPlayer.setVideoOutput(self,arg__1:QGraphicsVideoItem)",
    "1:PySide2.QtMultimedia.QMediaPlayer.setVideoOutput(self,arg__1:QVideoWidget)",
    "0:PySide2.QtMultimedia.QMediaPlayer.setVideoOutput(self,surfaces:QVector[PySide2.QtMultimedia.QAbstractVideoSurface])",
    "PySide2.QtMultimedia.QMediaPlayer.setVolume(self,volume:int)",
    "PySide2.QtMultimedia.QMediaPlayer.state(self)->PySide2.QtMultimedia.QMediaPlayer.State",
    "PySide2.QtMultimedia.QMediaPlayer.stop(self)",
    "PySide2.QtMultimedia.QMediaPlayer.supportedAudioRoles(self)->QList[PySide2.QtMultimedia.QAudio.Role]",
    "PySide2.QtMultimedia.QMediaPlayer.supportedCustomAudioRoles(self)->QStringList",
    "PySide2.QtMultimedia.QMediaPlayer.supportedMimeTypes(flags:PySide2.QtMultimedia.QMediaPlayer.Flags=QMediaPlayer.Flags())->QStringList",
    "PySide2.QtMultimedia.QMediaPlayer.unbind(self,arg__1:PySide2.QtCore.QObject)",
    "PySide2.QtMultimedia.QMediaPlayer.volume(self)->int",
    nullptr}; // Sentinel

void init_QMediaPlayer(PyObject *module)
{
    _Sbk_QMediaPlayer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaPlayer",
        "QMediaPlayer*",
        &Sbk_QMediaPlayer_spec,
        &Shiboken::callCppDestructor< ::QMediaPlayer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaPlayer_Type);
    InitSignatureStrings(pyType, QMediaPlayer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaPlayer_Type), Sbk_QMediaPlayer_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaPlayer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaPlayer_TypeF(),
        QMediaPlayer_PythonToCpp_QMediaPlayer_PTR,
        is_QMediaPlayer_PythonToCpp_QMediaPlayer_PTR_Convertible,
        QMediaPlayer_PTR_CppToPython_QMediaPlayer);

    Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer");
    Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaPlayer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaPlayerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QMediaPlayer_TypeF(), &Sbk_QMediaPlayer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaPlayer_TypeF(),
        "State",
        "2:PySide2.QtMultimedia.QMediaPlayer.State",
        "QMediaPlayer::State");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX],
        Sbk_QMediaPlayer_TypeF(), "StoppedState", (long) QMediaPlayer::State::StoppedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX],
        Sbk_QMediaPlayer_TypeF(), "PlayingState", (long) QMediaPlayer::State::PlayingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX],
        Sbk_QMediaPlayer_TypeF(), "PausedState", (long) QMediaPlayer::State::PausedState))
        return;
    // Register converter for enum 'QMediaPlayer::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX],
            QMediaPlayer_State_CppToPython_QMediaPlayer_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaPlayer_State_PythonToCpp_QMediaPlayer_State,
            is_QMediaPlayer_State_PythonToCpp_QMediaPlayer_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'MediaStatus'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaPlayer_TypeF(),
        "MediaStatus",
        "2:PySide2.QtMultimedia.QMediaPlayer.MediaStatus",
        "QMediaPlayer::MediaStatus");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "UnknownMediaStatus", (long) QMediaPlayer::MediaStatus::UnknownMediaStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "NoMedia", (long) QMediaPlayer::MediaStatus::NoMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "LoadingMedia", (long) QMediaPlayer::MediaStatus::LoadingMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "LoadedMedia", (long) QMediaPlayer::MediaStatus::LoadedMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "StalledMedia", (long) QMediaPlayer::MediaStatus::StalledMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "BufferingMedia", (long) QMediaPlayer::MediaStatus::BufferingMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "BufferedMedia", (long) QMediaPlayer::MediaStatus::BufferedMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "EndOfMedia", (long) QMediaPlayer::MediaStatus::EndOfMedia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
        Sbk_QMediaPlayer_TypeF(), "InvalidMedia", (long) QMediaPlayer::MediaStatus::InvalidMedia))
        return;
    // Register converter for enum 'QMediaPlayer::MediaStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX],
            QMediaPlayer_MediaStatus_CppToPython_QMediaPlayer_MediaStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaPlayer_MediaStatus_PythonToCpp_QMediaPlayer_MediaStatus,
            is_QMediaPlayer_MediaStatus_PythonToCpp_QMediaPlayer_MediaStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_MEDIASTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer::MediaStatus");
        Shiboken::Conversions::registerConverterName(converter, "MediaStatus");
    }
    // End of 'MediaStatus' enum.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QMediaPlayer.Flags", SbkPySide2_QtMultimedia_QMediaPlayer_Flag_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaPlayer_TypeF(),
        "Flag",
        "2:PySide2.QtMultimedia.QMediaPlayer.Flag",
        "QMediaPlayer::Flag",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX],
        Sbk_QMediaPlayer_TypeF(), "LowLatency", (long) QMediaPlayer::Flag::LowLatency))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX],
        Sbk_QMediaPlayer_TypeF(), "StreamPlayback", (long) QMediaPlayer::Flag::StreamPlayback))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX],
        Sbk_QMediaPlayer_TypeF(), "VideoSurface", (long) QMediaPlayer::Flag::VideoSurface))
        return;
    // Register converter for enum 'QMediaPlayer::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX],
            QMediaPlayer_Flag_CppToPython_QMediaPlayer_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaPlayer_Flag_PythonToCpp_QMediaPlayer_Flag,
            is_QMediaPlayer_Flag_PythonToCpp_QMediaPlayer_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QMediaPlayer::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX],
            QFlags_QMediaPlayer_Flag__CppToPython_QFlags_QMediaPlayer_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaPlayer_Flag_PythonToCpp_QFlags_QMediaPlayer_Flag_,
            is_QMediaPlayer_Flag_PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QMediaPlayer_Flag__PythonToCpp_QFlags_QMediaPlayer_Flag_,
            is_QFlags_QMediaPlayer_Flag__PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QMediaPlayer_Flag_,
            is_number_PythonToCpp_QFlags_QMediaPlayer_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIAPLAYER_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaPlayer_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QMediaPlayer.Error",
        "QMediaPlayer::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "NoError", (long) QMediaPlayer::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "ResourceError", (long) QMediaPlayer::Error::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "FormatError", (long) QMediaPlayer::Error::FormatError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "NetworkError", (long) QMediaPlayer::Error::NetworkError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "AccessDeniedError", (long) QMediaPlayer::Error::AccessDeniedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "ServiceMissingError", (long) QMediaPlayer::Error::ServiceMissingError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
        Sbk_QMediaPlayer_TypeF(), "MediaIsPlaylist", (long) QMediaPlayer::Error::MediaIsPlaylist))
        return;
    // Register converter for enum 'QMediaPlayer::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX],
            QMediaPlayer_Error_CppToPython_QMediaPlayer_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaPlayer_Error_PythonToCpp_QMediaPlayer_Error,
            is_QMediaPlayer_Error_PythonToCpp_QMediaPlayer_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAPLAYER_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaPlayer::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QMediaPlayer_TypeF(), &::QMediaPlayer::staticMetaObject);
    qRegisterMetaType< ::QMediaPlayer::State >("QMediaPlayer::State");
    qRegisterMetaType< ::QMediaPlayer::MediaStatus >("QMediaPlayer::MediaStatus");
    qRegisterMetaType< ::QMediaPlayer::Flag >("QMediaPlayer::Flag");
    qRegisterMetaType< ::QMediaPlayer::Flags >("QMediaPlayer::Flags");
    qRegisterMetaType< ::QMediaPlayer::Error >("QMediaPlayer::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QMediaPlayer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QMediaPlayer_TypeF(), &::QMediaPlayer::staticMetaObject, sizeof(QMediaPlayerWrapper));
}
