/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qimageencodersettings_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtMultimedia/qmediaencodersettings.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QImageEncoderSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QImageEncoderSettings >()))
        return -1;

    ::QImageEncoderSettings *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QImageEncoderSettings", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QImageEncoderSettings::QImageEncoderSettings()
    // 1: QImageEncoderSettings::QImageEncoderSettings(QImageEncoderSettings)
    if (numArgs == 0) {
        overloadId = 0; // QImageEncoderSettings()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QImageEncoderSettings(QImageEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettings_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QImageEncoderSettings()
        {

            if (!PyErr_Occurred()) {
                // QImageEncoderSettings()
                cptr = new ::QImageEncoderSettings();
            }
            break;
        }
        case 1: // QImageEncoderSettings(const QImageEncoderSettings & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImageEncoderSettings cppArg0_local;
            ::QImageEncoderSettings *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QImageEncoderSettings(QImageEncoderSettings)
                cptr = new ::QImageEncoderSettings(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QImageEncoderSettings >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QImageEncoderSettings_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QImageEncoderSettings_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_codec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.codec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codec()const
            QString cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->codec();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_encodingOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.encodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageEncoderSettings::encodingOption(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // encodingOption(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_encodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // encodingOption(QString)const
            QVariant cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->encodingOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QImageEncoderSettingsFunc_encodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettingsFunc_encodingOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.encodingOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingOptions()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->encodingOptions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_quality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.quality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quality()const
            QMultimedia::EncodingQuality cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->quality();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_resolution(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.resolution";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resolution()const
            QSize cppResult = const_cast<const ::QImageEncoderSettings *>(cppSelf)->resolution();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QImageEncoderSettingsFunc_setCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.setCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageEncoderSettings::setCodec(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCodec(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_setCodec_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCodec(QString)
            cppSelf->setCodec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageEncoderSettingsFunc_setCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettingsFunc_setEncodingOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.setEncodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setEncodingOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImageEncoderSettings::setEncodingOption(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setEncodingOption(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_setEncodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setEncodingOption(QString,QVariant)
            cppSelf->setEncodingOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageEncoderSettingsFunc_setEncodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettingsFunc_setEncodingOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.setEncodingOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageEncoderSettings::setEncodingOptions(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setEncodingOptions(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_setEncodingOptions_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEncodingOptions(QMap<QString,QVariant>)
            cppSelf->setEncodingOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageEncoderSettingsFunc_setEncodingOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettingsFunc_setQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.setQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QImageEncoderSettings::setQuality(QMultimedia::EncodingQuality)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setQuality(QMultimedia::EncodingQuality)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_setQuality_TypeError;

    // Call function/method
    {
        ::QMultimedia::EncodingQuality cppArg0{QMultimedia::VeryLowQuality};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuality(QMultimedia::EncodingQuality)
            cppSelf->setQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageEncoderSettingsFunc_setQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettingsFunc_setResolution(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QImageEncoderSettings.setResolution";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setResolution", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QImageEncoderSettings::setResolution(QSize)
    // 1: QImageEncoderSettings::setResolution(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setResolution(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setResolution(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QImageEncoderSettingsFunc_setResolution_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setResolution(const QSize & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setResolution(QSize)
                cppSelf->setResolution(*cppArg0);
            }
            break;
        }
        case 1: // setResolution(int width, int height)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setResolution(int,int)
                cppSelf->setResolution(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QImageEncoderSettingsFunc_setResolution_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QImageEncoderSettings___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QImageEncoderSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QImageEncoderSettings_methods[] = {
    {"codec", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_codec), METH_NOARGS},
    {"encodingOption", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_encodingOption), METH_O},
    {"encodingOptions", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_encodingOptions), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_isNull), METH_NOARGS},
    {"quality", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_quality), METH_NOARGS},
    {"resolution", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_resolution), METH_NOARGS},
    {"setCodec", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_setCodec), METH_O},
    {"setEncodingOption", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_setEncodingOption), METH_VARARGS},
    {"setEncodingOptions", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_setEncodingOptions), METH_O},
    {"setQuality", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_setQuality), METH_O},
    {"setResolution", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettingsFunc_setResolution), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QImageEncoderSettings___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QImageEncoderSettings___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QImageEncoderSettings_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator!=(const QImageEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QImageEncoderSettings cppArg0_local;
                ::QImageEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator==(const QImageEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QImageEncoderSettings cppArg0_local;
                ::QImageEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QImageEncoderSettings_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QImageEncoderSettings_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QImageEncoderSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QImageEncoderSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QImageEncoderSettings_Type = nullptr;
static SbkObjectType *Sbk_QImageEncoderSettings_TypeF(void)
{
    return _Sbk_QImageEncoderSettings_Type;
}

static PyType_Slot Sbk_QImageEncoderSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QImageEncoderSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QImageEncoderSettings_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QImageEncoderSettings_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QImageEncoderSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QImageEncoderSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QImageEncoderSettings___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QImageEncoderSettings___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QImageEncoderSettings_spec = {
    "2:PySide2.QtMultimedia.QImageEncoderSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QImageEncoderSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QImageEncoderSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImageEncoderSettings_TypeF())))
        return QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QImageEncoderSettings_PTR_CppToPython_QImageEncoderSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QImageEncoderSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QImageEncoderSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QImageEncoderSettings_COPY_CppToPython_QImageEncoderSettings(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QImageEncoderSettings_TypeF(), new ::QImageEncoderSettings(*reinterpret_cast<const ::QImageEncoderSettings *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QImageEncoderSettings *>(cppOut) = *reinterpret_cast< ::QImageEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QImageEncoderSettings_TypeF())))
        return QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QImageEncoderSettings_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QImageEncoderSettings(self)",
    "0:PySide2.QtMultimedia.QImageEncoderSettings(self,other:PySide2.QtMultimedia.QImageEncoderSettings)",
    "PySide2.QtMultimedia.QImageEncoderSettings.codec(self)->QString",
    "PySide2.QtMultimedia.QImageEncoderSettings.encodingOption(self,option:QString)->QVariant",
    "PySide2.QtMultimedia.QImageEncoderSettings.encodingOptions(self)->QMap[QString, QVariant]",
    "PySide2.QtMultimedia.QImageEncoderSettings.isNull(self)->bool",
    "PySide2.QtMultimedia.QImageEncoderSettings.quality(self)->PySide2.QtMultimedia.QMultimedia.EncodingQuality",
    "PySide2.QtMultimedia.QImageEncoderSettings.resolution(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QImageEncoderSettings.setCodec(self,arg__1:QString)",
    "PySide2.QtMultimedia.QImageEncoderSettings.setEncodingOption(self,option:QString,value:QVariant)",
    "PySide2.QtMultimedia.QImageEncoderSettings.setEncodingOptions(self,options:QMap[QString, QVariant])",
    "PySide2.QtMultimedia.QImageEncoderSettings.setQuality(self,quality:PySide2.QtMultimedia.QMultimedia.EncodingQuality)",
    "1:PySide2.QtMultimedia.QImageEncoderSettings.setResolution(self,arg__1:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QImageEncoderSettings.setResolution(self,width:int,height:int)",
    "PySide2.QtMultimedia.QImageEncoderSettings.__copy__()",
    nullptr}; // Sentinel

void init_QImageEncoderSettings(PyObject *module)
{
    _Sbk_QImageEncoderSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QImageEncoderSettings",
        "QImageEncoderSettings",
        &Sbk_QImageEncoderSettings_spec,
        &Shiboken::callCppDestructor< ::QImageEncoderSettings >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QImageEncoderSettings_Type);
    InitSignatureStrings(pyType, QImageEncoderSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QImageEncoderSettings_Type), Sbk_QImageEncoderSettings_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QIMAGEENCODERSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QImageEncoderSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QImageEncoderSettings_TypeF(),
        QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_PTR,
        is_QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_PTR_Convertible,
        QImageEncoderSettings_PTR_CppToPython_QImageEncoderSettings,
        QImageEncoderSettings_COPY_CppToPython_QImageEncoderSettings);

    Shiboken::Conversions::registerConverterName(converter, "QImageEncoderSettings");
    Shiboken::Conversions::registerConverterName(converter, "QImageEncoderSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QImageEncoderSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QImageEncoderSettings).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_COPY,
        is_QImageEncoderSettings_PythonToCpp_QImageEncoderSettings_COPY_Convertible);

    qRegisterMetaType< ::QImageEncoderSettings >("QImageEncoderSettings");
}
