/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcamerafocuszone_wrapper.h"

// inner classes

// Extra includes
#include <QtMultimedia/qcamerafocus.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCameraFocusZone_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCameraFocusZone >()))
        return -1;

    ::QCameraFocusZone *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocusZone.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraFocusZone_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QCameraFocusZone", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCameraFocusZone::QCameraFocusZone()
    // 1: QCameraFocusZone::QCameraFocusZone(QCameraFocusZone)
    // 2: QCameraFocusZone::QCameraFocusZone(QRectF,QCameraFocusZone::FocusZoneStatus)
    if (numArgs == 0) {
        overloadId = 0; // QCameraFocusZone()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QCameraFocusZone(QRectF,QCameraFocusZone::FocusZoneStatus)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX])->converter, (pyArgs[1])))) {
            overloadId = 2; // QCameraFocusZone(QRectF,QCameraFocusZone::FocusZoneStatus)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCameraFocusZone(QCameraFocusZone)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusZone_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCameraFocusZone()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCameraFocusZone_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QCameraFocusZone()
                cptr = new ::QCameraFocusZone();
            }
            break;
        }
        case 1: // QCameraFocusZone(const QCameraFocusZone & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QCameraFocusZone_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCameraFocusZone cppArg0_local;
            ::QCameraFocusZone *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCameraFocusZone(QCameraFocusZone)
                cptr = new ::QCameraFocusZone(*cppArg0);
            }
            break;
        }
        case 2: // QCameraFocusZone(const QRectF & area, QCameraFocusZone::FocusZoneStatus status)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_status = Shiboken::String::createStaticString("status");
                if (PyDict_Contains(kwds, key_status)) {
                    value = PyDict_GetItem(kwds, key_status);
                    if (value && pyArgs[1]) {
                        errInfo = key_status;
                        Py_INCREF(errInfo);
                        goto Sbk_QCameraFocusZone_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QCameraFocusZone_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_status);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QCameraFocusZone_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QCameraFocusZone::FocusZoneStatus cppArg1 = QCameraFocusZone::FocusZoneStatus::Selected;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCameraFocusZone(QRectF,QCameraFocusZone::FocusZoneStatus)
                cptr = new ::QCameraFocusZone(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCameraFocusZone >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCameraFocusZone_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCameraFocusZone_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCameraFocusZoneFunc_area(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocusZone.area";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // area()const
            QRectF cppResult = const_cast<const ::QCameraFocusZone *>(cppSelf)->area();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusZoneFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocusZone.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QCameraFocusZone *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusZoneFunc_setStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocusZone.setStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraFocusZone::setStatus(QCameraFocusZone::FocusZoneStatus)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStatus(QCameraFocusZone::FocusZoneStatus)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFocusZoneFunc_setStatus_TypeError;

    // Call function/method
    {
        ::QCameraFocusZone::FocusZoneStatus cppArg0{QCameraFocusZone::Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStatus(QCameraFocusZone::FocusZoneStatus)
            cppSelf->setStatus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFocusZoneFunc_setStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFocusZoneFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraFocusZone.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QCameraFocusZone::FocusZoneStatus cppResult = const_cast<const ::QCameraFocusZone *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFocusZone___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCameraFocusZone_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraFocusZone_methods[] = {
    {"area", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusZoneFunc_area), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusZoneFunc_isValid), METH_NOARGS},
    {"setStatus", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusZoneFunc_setStatus), METH_O},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusZoneFunc_status), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCameraFocusZone___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QCameraFocusZone_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), (pyArg)))) {
                // operator!=(const QCameraFocusZone & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCameraFocusZone cppArg0_local;
                ::QCameraFocusZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), (pyArg)))) {
                // operator==(const QCameraFocusZone & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCameraFocusZone cppArg0_local;
                ::QCameraFocusZone *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QCameraFocusZone_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QCameraFocusZone_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QCameraFocusZone_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraFocusZone_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraFocusZone_Type = nullptr;
static SbkObjectType *Sbk_QCameraFocusZone_TypeF(void)
{
    return _Sbk_QCameraFocusZone_Type;
}

static PyType_Slot Sbk_QCameraFocusZone_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraFocusZone_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraFocusZone_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QCameraFocusZone_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraFocusZone_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCameraFocusZone_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraFocusZone_spec = {
    "2:PySide2.QtMultimedia.QCameraFocusZone",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraFocusZone_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraFocusZone_FocusZoneStatus_PythonToCpp_QCameraFocusZone_FocusZoneStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraFocusZone::FocusZoneStatus *>(cppOut) =
        static_cast<::QCameraFocusZone::FocusZoneStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraFocusZone_FocusZoneStatus_PythonToCpp_QCameraFocusZone_FocusZoneStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX]))
        return QCameraFocusZone_FocusZoneStatus_PythonToCpp_QCameraFocusZone_FocusZoneStatus;
    return {};
}
static PyObject *QCameraFocusZone_FocusZoneStatus_CppToPython_QCameraFocusZone_FocusZoneStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraFocusZone::FocusZoneStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraFocusZone_PythonToCpp_QCameraFocusZone_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraFocusZone_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraFocusZone_PythonToCpp_QCameraFocusZone_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraFocusZone_TypeF())))
        return QCameraFocusZone_PythonToCpp_QCameraFocusZone_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraFocusZone_PTR_CppToPython_QCameraFocusZone(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCameraFocusZone *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCameraFocusZone_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCameraFocusZone_COPY_CppToPython_QCameraFocusZone(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCameraFocusZone_TypeF(), new ::QCameraFocusZone(*reinterpret_cast<const ::QCameraFocusZone *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCameraFocusZone_PythonToCpp_QCameraFocusZone_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraFocusZone *>(cppOut) = *reinterpret_cast< ::QCameraFocusZone *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCameraFocusZone_PythonToCpp_QCameraFocusZone_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraFocusZone_TypeF())))
        return QCameraFocusZone_PythonToCpp_QCameraFocusZone_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQRectFREF_PythonToCpp_QCameraFocusZone(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraFocusZone *>(cppOut) = ::QCameraFocusZone( *reinterpret_cast< ::QRectF *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQRectFREF_PythonToCpp_QCameraFocusZone_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX], pyIn))
        return PySide2_QtCore_constQRectFREF_PythonToCpp_QCameraFocusZone;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraFocusZone_SignatureStrings[] = {
    "2:PySide2.QtMultimedia.QCameraFocusZone(self)",
    "1:PySide2.QtMultimedia.QCameraFocusZone(self,other:PySide2.QtMultimedia.QCameraFocusZone)",
    "0:PySide2.QtMultimedia.QCameraFocusZone(self,area:PySide2.QtCore.QRectF,status:PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus=Selected)",
    "PySide2.QtMultimedia.QCameraFocusZone.area(self)->PySide2.QtCore.QRectF",
    "PySide2.QtMultimedia.QCameraFocusZone.isValid(self)->bool",
    "PySide2.QtMultimedia.QCameraFocusZone.setStatus(self,status:PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus)",
    "PySide2.QtMultimedia.QCameraFocusZone.status(self)->PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus",
    "PySide2.QtMultimedia.QCameraFocusZone.__copy__()",
    nullptr}; // Sentinel

void init_QCameraFocusZone(PyObject *module)
{
    _Sbk_QCameraFocusZone_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraFocusZone",
        "QCameraFocusZone",
        &Sbk_QCameraFocusZone_spec,
        &Shiboken::callCppDestructor< ::QCameraFocusZone >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraFocusZone_Type);
    InitSignatureStrings(pyType, QCameraFocusZone_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraFocusZone_Type), Sbk_QCameraFocusZone_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraFocusZone_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraFocusZone_TypeF(),
        QCameraFocusZone_PythonToCpp_QCameraFocusZone_PTR,
        is_QCameraFocusZone_PythonToCpp_QCameraFocusZone_PTR_Convertible,
        QCameraFocusZone_PTR_CppToPython_QCameraFocusZone,
        QCameraFocusZone_COPY_CppToPython_QCameraFocusZone);

    Shiboken::Conversions::registerConverterName(converter, "QCameraFocusZone");
    Shiboken::Conversions::registerConverterName(converter, "QCameraFocusZone*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraFocusZone&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraFocusZone).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCameraFocusZone_PythonToCpp_QCameraFocusZone_COPY,
        is_QCameraFocusZone_PythonToCpp_QCameraFocusZone_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQRectFREF_PythonToCpp_QCameraFocusZone,
        is_PySide2_QtCore_constQRectFREF_PythonToCpp_QCameraFocusZone_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FocusZoneStatus'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraFocusZone_TypeF(),
        "FocusZoneStatus",
        "2:PySide2.QtMultimedia.QCameraFocusZone.FocusZoneStatus",
        "QCameraFocusZone::FocusZoneStatus");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX],
        Sbk_QCameraFocusZone_TypeF(), "Invalid", (long) QCameraFocusZone::FocusZoneStatus::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX],
        Sbk_QCameraFocusZone_TypeF(), "Unused", (long) QCameraFocusZone::FocusZoneStatus::Unused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX],
        Sbk_QCameraFocusZone_TypeF(), "Selected", (long) QCameraFocusZone::FocusZoneStatus::Selected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX],
        Sbk_QCameraFocusZone_TypeF(), "Focused", (long) QCameraFocusZone::FocusZoneStatus::Focused))
        return;
    // Register converter for enum 'QCameraFocusZone::FocusZoneStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX],
            QCameraFocusZone_FocusZoneStatus_CppToPython_QCameraFocusZone_FocusZoneStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraFocusZone_FocusZoneStatus_PythonToCpp_QCameraFocusZone_FocusZoneStatus,
            is_QCameraFocusZone_FocusZoneStatus_PythonToCpp_QCameraFocusZone_FocusZoneStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_FOCUSZONESTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraFocusZone::FocusZoneStatus");
        Shiboken::Conversions::registerConverterName(converter, "FocusZoneStatus");
    }
    // End of 'FocusZoneStatus' enum.

    qRegisterMetaType< ::QCameraFocusZone >("QCameraFocusZone");
    qRegisterMetaType< ::QCameraFocusZone::FocusZoneStatus >("QCameraFocusZone::FocusZoneStatus");
}
