/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcameraexposure_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraExposureWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QCameraExposureWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraExposureWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraExposureWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraExposureWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraExposureWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraExposure.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraExposureWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCameraExposure.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QCameraExposureWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QCameraExposureWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCameraExposure::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraExposureWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCameraExposure::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraExposureWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraExposureWrapper *>(this));
        return QCameraExposure::qt_metacast(_clname);
}

QCameraExposureWrapper::~QCameraExposureWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QCameraExposureFunc_aperture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.aperture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // aperture()const
            qreal cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->aperture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_exposureCompensation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.exposureCompensation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exposureCompensation()const
            qreal cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->exposureCompensation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_exposureMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.exposureMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exposureMode()const
            QCameraExposure::ExposureMode cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->exposureMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_flashMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.flashMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flashMode()const
            QFlags<QCameraExposure::FlashMode> cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->flashMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_isAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAvailable()const
            bool cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_isExposureModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isExposureModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::isExposureModeSupported(QCameraExposure::ExposureMode)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isExposureModeSupported(QCameraExposure::ExposureMode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_isExposureModeSupported_TypeError;

    // Call function/method
    {
        ::QCameraExposure::ExposureMode cppArg0{QCameraExposure::ExposureAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isExposureModeSupported(QCameraExposure::ExposureMode)const
            bool cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isExposureModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraExposureFunc_isExposureModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_isFlashModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isFlashModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::isFlashModeSupported(QFlags<QCameraExposure::FlashMode>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isFlashModeSupported(QFlags<QCameraExposure::FlashMode>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_isFlashModeSupported_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraExposure::FlashMode> cppArg0 = QFlags<QCameraExposure::FlashMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isFlashModeSupported(QFlags<QCameraExposure::FlashMode>)const
            bool cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isFlashModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraExposureFunc_isFlashModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_isFlashReady(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isFlashReady";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFlashReady()const
            bool cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isFlashReady();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_isMeteringModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isMeteringModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::isMeteringModeSupported(QCameraExposure::MeteringMode)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isMeteringModeSupported(QCameraExposure::MeteringMode)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_isMeteringModeSupported_TypeError;

    // Call function/method
    {
        ::QCameraExposure::MeteringMode cppArg0 = static_cast< ::QCameraExposure::MeteringMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isMeteringModeSupported(QCameraExposure::MeteringMode)const
            bool cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isMeteringModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraExposureFunc_isMeteringModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_isoSensitivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.isoSensitivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isoSensitivity()const
            int cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->isoSensitivity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_meteringMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.meteringMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // meteringMode()const
            QCameraExposure::MeteringMode cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->meteringMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_requestedAperture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.requestedAperture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedAperture()const
            qreal cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->requestedAperture();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_requestedIsoSensitivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.requestedIsoSensitivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedIsoSensitivity()const
            int cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->requestedIsoSensitivity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_requestedShutterSpeed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.requestedShutterSpeed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedShutterSpeed()const
            qreal cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->requestedShutterSpeed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_setAutoAperture(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setAutoAperture";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setAutoAperture()
            cppSelf->setAutoAperture();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraExposureFunc_setAutoIsoSensitivity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setAutoIsoSensitivity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setAutoIsoSensitivity()
            cppSelf->setAutoIsoSensitivity();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraExposureFunc_setAutoShutterSpeed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setAutoShutterSpeed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setAutoShutterSpeed()
            cppSelf->setAutoShutterSpeed();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraExposureFunc_setExposureCompensation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setExposureCompensation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setExposureCompensation(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setExposureCompensation(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setExposureCompensation_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExposureCompensation(qreal)
            cppSelf->setExposureCompensation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setExposureCompensation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setExposureMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setExposureMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setExposureMode(QCameraExposure::ExposureMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setExposureMode(QCameraExposure::ExposureMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setExposureMode_TypeError;

    // Call function/method
    {
        ::QCameraExposure::ExposureMode cppArg0{QCameraExposure::ExposureAuto};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExposureMode(QCameraExposure::ExposureMode)
            cppSelf->setExposureMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setExposureMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setFlashMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setFlashMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setFlashMode(QFlags<QCameraExposure::FlashMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlashMode(QFlags<QCameraExposure::FlashMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setFlashMode_TypeError;

    // Call function/method
    {
        ::QFlags<QCameraExposure::FlashMode> cppArg0 = QFlags<QCameraExposure::FlashMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlashMode(QFlags<QCameraExposure::FlashMode>)
            cppSelf->setFlashMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setFlashMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setManualAperture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setManualAperture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setManualAperture(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setManualAperture(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setManualAperture_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setManualAperture(qreal)
            cppSelf->setManualAperture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setManualAperture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setManualIsoSensitivity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setManualIsoSensitivity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setManualIsoSensitivity(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setManualIsoSensitivity(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setManualIsoSensitivity_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setManualIsoSensitivity(int)
            cppSelf->setManualIsoSensitivity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setManualIsoSensitivity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setManualShutterSpeed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setManualShutterSpeed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setManualShutterSpeed(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setManualShutterSpeed(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setManualShutterSpeed_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setManualShutterSpeed(qreal)
            cppSelf->setManualShutterSpeed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setManualShutterSpeed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setMeteringMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setMeteringMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setMeteringMode(QCameraExposure::MeteringMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMeteringMode(QCameraExposure::MeteringMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setMeteringMode_TypeError;

    // Call function/method
    {
        ::QCameraExposure::MeteringMode cppArg0 = static_cast< ::QCameraExposure::MeteringMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMeteringMode(QCameraExposure::MeteringMode)
            cppSelf->setMeteringMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setMeteringMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_setSpotMeteringPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.setSpotMeteringPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCameraExposure::setSpotMeteringPoint(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setSpotMeteringPoint(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraExposureFunc_setSpotMeteringPoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSpotMeteringPoint(QPointF)
            cppSelf->setSpotMeteringPoint(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraExposureFunc_setSpotMeteringPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraExposureFunc_shutterSpeed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.shutterSpeed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shutterSpeed()const
            qreal cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->shutterSpeed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraExposureFunc_spotMeteringPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCameraExposure.spotMeteringPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spotMeteringPoint()const
            QPointF cppResult = const_cast<const ::QCameraExposure *>(cppSelf)->spotMeteringPoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCameraExposure_PropertyStrings[] = {
    "aperture:",
    "exposureCompensation::",
    "exposureMode::",
    "flashMode::",
    "flashReady:isFlashReady",
    "isoSensitivity:",
    "meteringMode::",
    "shutterSpeed:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCameraExposure_methods[] = {
    {"aperture", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_aperture), METH_NOARGS},
    {"exposureCompensation", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_exposureCompensation), METH_NOARGS},
    {"exposureMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_exposureMode), METH_NOARGS},
    {"flashMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_flashMode), METH_NOARGS},
    {"isAvailable", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isAvailable), METH_NOARGS},
    {"isExposureModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isExposureModeSupported), METH_O},
    {"isFlashModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isFlashModeSupported), METH_O},
    {"isFlashReady", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isFlashReady), METH_NOARGS},
    {"isMeteringModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isMeteringModeSupported), METH_O},
    {"isoSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_isoSensitivity), METH_NOARGS},
    {"meteringMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_meteringMode), METH_NOARGS},
    {"requestedAperture", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_requestedAperture), METH_NOARGS},
    {"requestedIsoSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_requestedIsoSensitivity), METH_NOARGS},
    {"requestedShutterSpeed", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_requestedShutterSpeed), METH_NOARGS},
    {"setAutoAperture", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setAutoAperture), METH_NOARGS},
    {"setAutoIsoSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setAutoIsoSensitivity), METH_NOARGS},
    {"setAutoShutterSpeed", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setAutoShutterSpeed), METH_NOARGS},
    {"setExposureCompensation", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setExposureCompensation), METH_O},
    {"setExposureMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setExposureMode), METH_O},
    {"setFlashMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setFlashMode), METH_O},
    {"setManualAperture", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setManualAperture), METH_O},
    {"setManualIsoSensitivity", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setManualIsoSensitivity), METH_O},
    {"setManualShutterSpeed", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setManualShutterSpeed), METH_O},
    {"setMeteringMode", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setMeteringMode), METH_O},
    {"setSpotMeteringPoint", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_setSpotMeteringPoint), METH_O},
    {"shutterSpeed", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_shutterSpeed), METH_NOARGS},
    {"spotMeteringPoint", reinterpret_cast<PyCFunction>(Sbk_QCameraExposureFunc_spotMeteringPoint), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCameraExposure_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCameraExposure *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraExposureWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCameraExposure_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCameraExposure_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCameraExposure_Type = nullptr;
static SbkObjectType *Sbk_QCameraExposure_TypeF(void)
{
    return _Sbk_QCameraExposure_Type;
}

static PyType_Slot Sbk_QCameraExposure_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCameraExposure_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCameraExposure_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCameraExposure_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCameraExposure_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCameraExposure_spec = {
    "2:PySide2.QtMultimedia.QCameraExposure",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCameraExposure_slots
};

} //extern "C"

static void *Sbk_QCameraExposure_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCameraExposure *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___and__(PyObject *self, PyObject *pyArg)
{
    ::QCameraExposure::FlashModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___or__(PyObject *self, PyObject *pyArg)
{
    ::QCameraExposure::FlashModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCameraExposure::FlashModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCameraExposure::FlashModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCameraExposure::FlashModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCameraExposure::FlashModes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, self, &cppSelf);
    ::QCameraExposure::FlashModes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QCameraExposure_FlashMode__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCameraExposure_FlashMode_PythonToCpp_QCameraExposure_FlashMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraExposure::FlashMode *>(cppOut) =
        static_cast<::QCameraExposure::FlashMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraExposure_FlashMode_PythonToCpp_QCameraExposure_FlashMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX]))
        return QCameraExposure_FlashMode_PythonToCpp_QCameraExposure_FlashMode;
    return {};
}
static PyObject *QCameraExposure_FlashMode_CppToPython_QCameraExposure_FlashMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraExposure::FlashMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX], castCppIn);

}

static void QFlags_QCameraExposure_FlashMode__PythonToCpp_QFlags_QCameraExposure_FlashMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraExposure::FlashMode> *>(cppOut) =
        ::QFlags<QCameraExposure::FlashMode>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCameraExposure_FlashMode__PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX]))
        return QFlags_QCameraExposure_FlashMode__PythonToCpp_QFlags_QCameraExposure_FlashMode_;
    return {};
}
static PyObject *QFlags_QCameraExposure_FlashMode__CppToPython_QFlags_QCameraExposure_FlashMode_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCameraExposure::FlashMode> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX]));

}

static void QCameraExposure_FlashMode_PythonToCpp_QFlags_QCameraExposure_FlashMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCameraExposure::FlashMode> *>(cppOut) =
        ::QFlags<QCameraExposure::FlashMode>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCameraExposure_FlashMode_PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX]))
        return QCameraExposure_FlashMode_PythonToCpp_QFlags_QCameraExposure_FlashMode_;
    return {};
}
static void number_PythonToCpp_QFlags_QCameraExposure_FlashMode_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCameraExposure::FlashMode> *>(cppOut) =
        ::QFlags<QCameraExposure::FlashMode>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX]))
        return number_PythonToCpp_QFlags_QCameraExposure_FlashMode_;
    return {};
}
static void QCameraExposure_ExposureMode_PythonToCpp_QCameraExposure_ExposureMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraExposure::ExposureMode *>(cppOut) =
        static_cast<::QCameraExposure::ExposureMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraExposure_ExposureMode_PythonToCpp_QCameraExposure_ExposureMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX]))
        return QCameraExposure_ExposureMode_PythonToCpp_QCameraExposure_ExposureMode;
    return {};
}
static PyObject *QCameraExposure_ExposureMode_CppToPython_QCameraExposure_ExposureMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraExposure::ExposureMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX], castCppIn);

}

static void QCameraExposure_MeteringMode_PythonToCpp_QCameraExposure_MeteringMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCameraExposure::MeteringMode *>(cppOut) =
        static_cast<::QCameraExposure::MeteringMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCameraExposure_MeteringMode_PythonToCpp_QCameraExposure_MeteringMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX]))
        return QCameraExposure_MeteringMode_PythonToCpp_QCameraExposure_MeteringMode;
    return {};
}
static PyObject *QCameraExposure_MeteringMode_CppToPython_QCameraExposure_MeteringMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCameraExposure::MeteringMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCameraExposure_PythonToCpp_QCameraExposure_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCameraExposure_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCameraExposure_PythonToCpp_QCameraExposure_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCameraExposure_TypeF())))
        return QCameraExposure_PythonToCpp_QCameraExposure_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCameraExposure_PTR_CppToPython_QCameraExposure(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCameraExposure *>(const_cast<void *>(cppIn)), Sbk_QCameraExposure_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCameraExposure_SignatureStrings[] = {
    "PySide2.QtMultimedia.QCameraExposure.aperture(self)->qreal",
    "PySide2.QtMultimedia.QCameraExposure.exposureCompensation(self)->qreal",
    "PySide2.QtMultimedia.QCameraExposure.exposureMode(self)->PySide2.QtMultimedia.QCameraExposure.ExposureMode",
    "PySide2.QtMultimedia.QCameraExposure.flashMode(self)->PySide2.QtMultimedia.QCameraExposure.FlashModes",
    "PySide2.QtMultimedia.QCameraExposure.isAvailable(self)->bool",
    "PySide2.QtMultimedia.QCameraExposure.isExposureModeSupported(self,mode:PySide2.QtMultimedia.QCameraExposure.ExposureMode)->bool",
    "PySide2.QtMultimedia.QCameraExposure.isFlashModeSupported(self,mode:PySide2.QtMultimedia.QCameraExposure.FlashModes)->bool",
    "PySide2.QtMultimedia.QCameraExposure.isFlashReady(self)->bool",
    "PySide2.QtMultimedia.QCameraExposure.isMeteringModeSupported(self,mode:PySide2.QtMultimedia.QCameraExposure.MeteringMode)->bool",
    "PySide2.QtMultimedia.QCameraExposure.isoSensitivity(self)->int",
    "PySide2.QtMultimedia.QCameraExposure.meteringMode(self)->PySide2.QtMultimedia.QCameraExposure.MeteringMode",
    "PySide2.QtMultimedia.QCameraExposure.requestedAperture(self)->qreal",
    "PySide2.QtMultimedia.QCameraExposure.requestedIsoSensitivity(self)->int",
    "PySide2.QtMultimedia.QCameraExposure.requestedShutterSpeed(self)->qreal",
    "PySide2.QtMultimedia.QCameraExposure.setAutoAperture(self)",
    "PySide2.QtMultimedia.QCameraExposure.setAutoIsoSensitivity(self)",
    "PySide2.QtMultimedia.QCameraExposure.setAutoShutterSpeed(self)",
    "PySide2.QtMultimedia.QCameraExposure.setExposureCompensation(self,ev:qreal)",
    "PySide2.QtMultimedia.QCameraExposure.setExposureMode(self,mode:PySide2.QtMultimedia.QCameraExposure.ExposureMode)",
    "PySide2.QtMultimedia.QCameraExposure.setFlashMode(self,mode:PySide2.QtMultimedia.QCameraExposure.FlashModes)",
    "PySide2.QtMultimedia.QCameraExposure.setManualAperture(self,aperture:qreal)",
    "PySide2.QtMultimedia.QCameraExposure.setManualIsoSensitivity(self,iso:int)",
    "PySide2.QtMultimedia.QCameraExposure.setManualShutterSpeed(self,seconds:qreal)",
    "PySide2.QtMultimedia.QCameraExposure.setMeteringMode(self,mode:PySide2.QtMultimedia.QCameraExposure.MeteringMode)",
    "PySide2.QtMultimedia.QCameraExposure.setSpotMeteringPoint(self,point:PySide2.QtCore.QPointF)",
    "PySide2.QtMultimedia.QCameraExposure.shutterSpeed(self)->qreal",
    "PySide2.QtMultimedia.QCameraExposure.spotMeteringPoint(self)->PySide2.QtCore.QPointF",
    nullptr}; // Sentinel

void init_QCameraExposure(PyObject *module)
{
    _Sbk_QCameraExposure_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCameraExposure",
        "QCameraExposure*",
        &Sbk_QCameraExposure_spec,
        &Shiboken::callCppDestructor< ::QCameraExposure >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCameraExposure_Type);
    InitSignatureStrings(pyType, QCameraExposure_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCameraExposure_Type), Sbk_QCameraExposure_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCameraExposure_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCameraExposure_TypeF(),
        QCameraExposure_PythonToCpp_QCameraExposure_PTR,
        is_QCameraExposure_PythonToCpp_QCameraExposure_PTR_Convertible,
        QCameraExposure_PTR_CppToPython_QCameraExposure);

    Shiboken::Conversions::registerConverterName(converter, "QCameraExposure");
    Shiboken::Conversions::registerConverterName(converter, "QCameraExposure*");
    Shiboken::Conversions::registerConverterName(converter, "QCameraExposure&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraExposure).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraExposureWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCameraExposure_TypeF(), &Sbk_QCameraExposure_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'FlashMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QCameraExposure.FlashModes", SbkPySide2_QtMultimedia_QCameraExposure_FlashMode_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraExposure_TypeF(),
        "FlashMode",
        "2:PySide2.QtMultimedia.QCameraExposure.FlashMode",
        "QCameraExposure::FlashMode",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashAuto", (long) QCameraExposure::FlashMode::FlashAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashOff", (long) QCameraExposure::FlashMode::FlashOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashOn", (long) QCameraExposure::FlashMode::FlashOn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashRedEyeReduction", (long) QCameraExposure::FlashMode::FlashRedEyeReduction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashFill", (long) QCameraExposure::FlashMode::FlashFill))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashTorch", (long) QCameraExposure::FlashMode::FlashTorch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashVideoLight", (long) QCameraExposure::FlashMode::FlashVideoLight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashSlowSyncFrontCurtain", (long) QCameraExposure::FlashMode::FlashSlowSyncFrontCurtain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashSlowSyncRearCurtain", (long) QCameraExposure::FlashMode::FlashSlowSyncRearCurtain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "FlashManual", (long) QCameraExposure::FlashMode::FlashManual))
        return;
    // Register converter for enum 'QCameraExposure::FlashMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX],
            QCameraExposure_FlashMode_CppToPython_QCameraExposure_FlashMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraExposure_FlashMode_PythonToCpp_QCameraExposure_FlashMode,
            is_QCameraExposure_FlashMode_PythonToCpp_QCameraExposure_FlashMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_FLASHMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraExposure::FlashMode");
        Shiboken::Conversions::registerConverterName(converter, "FlashMode");
    }
    // Register converter for flag 'QFlags<QCameraExposure::FlashMode>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX],
            QFlags_QCameraExposure_FlashMode__CppToPython_QFlags_QCameraExposure_FlashMode_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraExposure_FlashMode_PythonToCpp_QFlags_QCameraExposure_FlashMode_,
            is_QCameraExposure_FlashMode_PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCameraExposure_FlashMode__PythonToCpp_QFlags_QCameraExposure_FlashMode_,
            is_QFlags_QCameraExposure_FlashMode__PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCameraExposure_FlashMode_,
            is_number_PythonToCpp_QFlags_QCameraExposure_FlashMode__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERAEXPOSURE_FLASHMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraExposure::FlashModes");
        Shiboken::Conversions::registerConverterName(converter, "FlashModes");
    }
    // End of 'FlashMode' enum/flags.

    // Initialization of enum 'ExposureMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraExposure_TypeF(),
        "ExposureMode",
        "2:PySide2.QtMultimedia.QCameraExposure.ExposureMode",
        "QCameraExposure::ExposureMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureAuto", (long) QCameraExposure::ExposureMode::ExposureAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureManual", (long) QCameraExposure::ExposureMode::ExposureManual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposurePortrait", (long) QCameraExposure::ExposureMode::ExposurePortrait))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureNight", (long) QCameraExposure::ExposureMode::ExposureNight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureBacklight", (long) QCameraExposure::ExposureMode::ExposureBacklight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSpotlight", (long) QCameraExposure::ExposureMode::ExposureSpotlight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSports", (long) QCameraExposure::ExposureMode::ExposureSports))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSnow", (long) QCameraExposure::ExposureMode::ExposureSnow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureBeach", (long) QCameraExposure::ExposureMode::ExposureBeach))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureLargeAperture", (long) QCameraExposure::ExposureMode::ExposureLargeAperture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSmallAperture", (long) QCameraExposure::ExposureMode::ExposureSmallAperture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureAction", (long) QCameraExposure::ExposureMode::ExposureAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureLandscape", (long) QCameraExposure::ExposureMode::ExposureLandscape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureNightPortrait", (long) QCameraExposure::ExposureMode::ExposureNightPortrait))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureTheatre", (long) QCameraExposure::ExposureMode::ExposureTheatre))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSunset", (long) QCameraExposure::ExposureMode::ExposureSunset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureSteadyPhoto", (long) QCameraExposure::ExposureMode::ExposureSteadyPhoto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureFireworks", (long) QCameraExposure::ExposureMode::ExposureFireworks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureParty", (long) QCameraExposure::ExposureMode::ExposureParty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureCandlelight", (long) QCameraExposure::ExposureMode::ExposureCandlelight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureBarcode", (long) QCameraExposure::ExposureMode::ExposureBarcode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "ExposureModeVendor", (long) QCameraExposure::ExposureMode::ExposureModeVendor))
        return;
    // Register converter for enum 'QCameraExposure::ExposureMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX],
            QCameraExposure_ExposureMode_CppToPython_QCameraExposure_ExposureMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraExposure_ExposureMode_PythonToCpp_QCameraExposure_ExposureMode,
            is_QCameraExposure_ExposureMode_PythonToCpp_QCameraExposure_ExposureMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_EXPOSUREMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraExposure::ExposureMode");
        Shiboken::Conversions::registerConverterName(converter, "ExposureMode");
    }
    // End of 'ExposureMode' enum.

    // Initialization of enum 'MeteringMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCameraExposure_TypeF(),
        "MeteringMode",
        "2:PySide2.QtMultimedia.QCameraExposure.MeteringMode",
        "QCameraExposure::MeteringMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "MeteringMatrix", (long) QCameraExposure::MeteringMode::MeteringMatrix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "MeteringAverage", (long) QCameraExposure::MeteringMode::MeteringAverage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX],
        Sbk_QCameraExposure_TypeF(), "MeteringSpot", (long) QCameraExposure::MeteringMode::MeteringSpot))
        return;
    // Register converter for enum 'QCameraExposure::MeteringMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX],
            QCameraExposure_MeteringMode_CppToPython_QCameraExposure_MeteringMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCameraExposure_MeteringMode_PythonToCpp_QCameraExposure_MeteringMode,
            is_QCameraExposure_MeteringMode_PythonToCpp_QCameraExposure_MeteringMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_METERINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCameraExposure::MeteringMode");
        Shiboken::Conversions::registerConverterName(converter, "MeteringMode");
    }
    // End of 'MeteringMode' enum.

    PySide::Signal::registerSignals(Sbk_QCameraExposure_TypeF(), &::QCameraExposure::staticMetaObject);
    qRegisterMetaType< ::QCameraExposure::FlashMode >("QCameraExposure::FlashMode");
    qRegisterMetaType< ::QCameraExposure::FlashModes >("QCameraExposure::FlashModes");
    qRegisterMetaType< ::QCameraExposure::ExposureMode >("QCameraExposure::ExposureMode");
    qRegisterMetaType< ::QCameraExposure::MeteringMode >("QCameraExposure::MeteringMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCameraExposure_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCameraExposure_TypeF(), &::QCameraExposure::staticMetaObject, sizeof(QCameraExposureWrapper));
}
