/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcamera_frameraterange_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCamera_FrameRateRange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCamera::FrameRateRange >()))
        return -1;

    ::QCamera::FrameRateRange *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.FrameRateRange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "FrameRateRange", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: FrameRateRange::FrameRateRange()
    // 1: FrameRateRange::FrameRateRange(QCamera::FrameRateRange)
    // 2: FrameRateRange::FrameRateRange(qreal,qreal)
    if (numArgs == 0) {
        overloadId = 0; // FrameRateRange()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 2; // FrameRateRange(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // FrameRateRange(QCamera::FrameRateRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCamera_FrameRateRange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // FrameRateRange()
        {

            if (!PyErr_Occurred()) {
                // FrameRateRange()
                cptr = new ::QCamera::FrameRateRange();
            }
            break;
        }
        case 1: // FrameRateRange(const QCamera::FrameRateRange & FrameRateRange)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCamera::FrameRateRange cppArg0_local;
            ::QCamera::FrameRateRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // FrameRateRange(QCamera::FrameRateRange)
                cptr = new ::QCamera::FrameRateRange(*cppArg0);
            }
            break;
        }
        case 2: // FrameRateRange(qreal minimum, qreal maximum)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // FrameRateRange(qreal,qreal)
                cptr = new ::QCamera::FrameRateRange(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCamera::FrameRateRange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCamera_FrameRateRange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCamera_FrameRateRange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCamera_FrameRateRange___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCamera_FrameRateRange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCamera_FrameRateRange_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCamera_FrameRateRange___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QCamera_FrameRateRange_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), (pyArg)))) {
                // operator!=(const QCamera::FrameRateRange & r2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCamera::FrameRateRange cppArg0_local;
                ::QCamera::FrameRateRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), (pyArg)))) {
                // operator==(const QCamera::FrameRateRange & r2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QCamera::FrameRateRange cppArg0_local;
                ::QCamera::FrameRateRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QCamera_FrameRateRange_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QCamera_FrameRateRange_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_QCamera_FrameRateRange_get_minimumFrameRate(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->minimumFrameRate);
    return pyOut;
}
static int Sbk_QCamera_FrameRateRange_set_minimumFrameRate(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'minimumFrameRate' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'minimumFrameRate', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->minimumFrameRate;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QCamera_FrameRateRange_get_maximumFrameRate(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->maximumFrameRate);
    return pyOut;
}
static int Sbk_QCamera_FrameRateRange_set_maximumFrameRate(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'maximumFrameRate' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'maximumFrameRate', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->maximumFrameRate;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for FrameRateRange
static PyGetSetDef Sbk_QCamera_FrameRateRange_getsetlist[] = {
    {const_cast<char *>("minimumFrameRate"), Sbk_QCamera_FrameRateRange_get_minimumFrameRate, Sbk_QCamera_FrameRateRange_set_minimumFrameRate},
    {const_cast<char *>("maximumFrameRate"), Sbk_QCamera_FrameRateRange_get_maximumFrameRate, Sbk_QCamera_FrameRateRange_set_maximumFrameRate},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QCamera_FrameRateRange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCamera_FrameRateRange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCamera_FrameRateRange_Type = nullptr;
static SbkObjectType *Sbk_QCamera_FrameRateRange_TypeF(void)
{
    return _Sbk_QCamera_FrameRateRange_Type;
}

static PyType_Slot Sbk_QCamera_FrameRateRange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCamera_FrameRateRange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCamera_FrameRateRange_spec = {
    "2:PySide2.QtMultimedia.QCamera.FrameRateRange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCamera_FrameRateRange_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void FrameRateRange_PythonToCpp_FrameRateRange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCamera_FrameRateRange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_FrameRateRange_PythonToCpp_FrameRateRange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCamera_FrameRateRange_TypeF())))
        return FrameRateRange_PythonToCpp_FrameRateRange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *FrameRateRange_PTR_CppToPython_FrameRateRange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCamera::FrameRateRange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCamera_FrameRateRange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *FrameRateRange_COPY_CppToPython_FrameRateRange(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCamera_FrameRateRange_TypeF(), new ::QCamera::FrameRateRange(*reinterpret_cast<const ::QCamera::FrameRateRange *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void FrameRateRange_PythonToCpp_FrameRateRange_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::FrameRateRange *>(cppOut) = *reinterpret_cast< ::QCamera::FrameRateRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_FrameRateRange_PythonToCpp_FrameRateRange_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCamera_FrameRateRange_TypeF())))
        return FrameRateRange_PythonToCpp_FrameRateRange_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCamera_FrameRateRange_SignatureStrings[] = {
    "2:PySide2.QtMultimedia.QCamera.FrameRateRange(self)",
    "1:PySide2.QtMultimedia.QCamera.FrameRateRange(self,FrameRateRange:PySide2.QtMultimedia.QCamera.FrameRateRange)",
    "0:PySide2.QtMultimedia.QCamera.FrameRateRange(self,minimum:qreal,maximum:qreal)",
    "PySide2.QtMultimedia.QCamera.FrameRateRange.__copy__()",
    nullptr}; // Sentinel

void init_QCamera_FrameRateRange(PyObject *enclosingClass)
{
    _Sbk_QCamera_FrameRateRange_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "FrameRateRange",
        "QCamera::FrameRateRange",
        &Sbk_QCamera_FrameRateRange_spec,
        &Shiboken::callCppDestructor< ::QCamera::FrameRateRange >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCamera_FrameRateRange_Type);
    InitSignatureStrings(pyType, QCamera_FrameRateRange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCamera_FrameRateRange_Type), Sbk_QCamera_FrameRateRange_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCamera_FrameRateRange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCamera_FrameRateRange_TypeF(),
        FrameRateRange_PythonToCpp_FrameRateRange_PTR,
        is_FrameRateRange_PythonToCpp_FrameRateRange_PTR_Convertible,
        FrameRateRange_PTR_CppToPython_FrameRateRange,
        FrameRateRange_COPY_CppToPython_FrameRateRange);

    Shiboken::Conversions::registerConverterName(converter, "QCamera::FrameRateRange");
    Shiboken::Conversions::registerConverterName(converter, "QCamera::FrameRateRange*");
    Shiboken::Conversions::registerConverterName(converter, "QCamera::FrameRateRange&");
    Shiboken::Conversions::registerConverterName(converter, "FrameRateRange");
    Shiboken::Conversions::registerConverterName(converter, "FrameRateRange*");
    Shiboken::Conversions::registerConverterName(converter, "FrameRateRange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCamera::FrameRateRange).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        FrameRateRange_PythonToCpp_FrameRateRange_COPY,
        is_FrameRateRange_PythonToCpp_FrameRateRange_COPY_Convertible);

    qRegisterMetaType< ::QCamera::FrameRateRange >("FrameRateRange");
    qRegisterMetaType< ::QCamera::FrameRateRange >("QCamera::FrameRateRange");
}
