/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudioencodersettings_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtMultimedia/qmediaencodersettings.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAudioEncoderSettings_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAudioEncoderSettings >()))
        return -1;

    ::QAudioEncoderSettings *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAudioEncoderSettings", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAudioEncoderSettings::QAudioEncoderSettings()
    // 1: QAudioEncoderSettings::QAudioEncoderSettings(QAudioEncoderSettings)
    if (numArgs == 0) {
        overloadId = 0; // QAudioEncoderSettings()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QAudioEncoderSettings(QAudioEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettings_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAudioEncoderSettings()
        {

            if (!PyErr_Occurred()) {
                // QAudioEncoderSettings()
                cptr = new ::QAudioEncoderSettings();
            }
            break;
        }
        case 1: // QAudioEncoderSettings(const QAudioEncoderSettings & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAudioEncoderSettings cppArg0_local;
            ::QAudioEncoderSettings *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QAudioEncoderSettings(QAudioEncoderSettings)
                cptr = new ::QAudioEncoderSettings(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAudioEncoderSettings >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAudioEncoderSettings_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAudioEncoderSettings_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_bitRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.bitRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bitRate()const
            int cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->bitRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_channelCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.channelCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // channelCount()const
            int cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->channelCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_codec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.codec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codec()const
            QString cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->codec();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_encodingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.encodingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingMode()const
            QMultimedia::EncodingMode cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->encodingMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_encodingOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.encodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::encodingOption(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // encodingOption(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_encodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // encodingOption(QString)const
            QVariant cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->encodingOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioEncoderSettingsFunc_encodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_encodingOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.encodingOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encodingOptions()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->encodingOptions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_quality(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.quality";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quality()const
            QMultimedia::EncodingQuality cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->quality();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_sampleRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.sampleRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleRate()const
            int cppResult = const_cast<const ::QAudioEncoderSettings *>(cppSelf)->sampleRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setBitRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setBitRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setBitRate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBitRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setBitRate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBitRate(int)
            cppSelf->setBitRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setBitRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setChannelCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setChannelCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setChannelCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setChannelCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setChannelCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setChannelCount(int)
            cppSelf->setChannelCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setChannelCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setCodec(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCodec(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setCodec_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCodec(QString)
            cppSelf->setCodec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setEncodingMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setEncodingMode(QMultimedia::EncodingMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEncodingMode(QMultimedia::EncodingMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setEncodingMode_TypeError;

    // Call function/method
    {
        ::QMultimedia::EncodingMode cppArg0{QMultimedia::ConstantQualityEncoding};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEncodingMode(QMultimedia::EncodingMode)
            cppSelf->setEncodingMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setEncodingMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setEncodingOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setEncodingOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setEncodingOption(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setEncodingOption(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setEncodingOption_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setEncodingOption(QString,QVariant)
            cppSelf->setEncodingOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setEncodingOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setEncodingOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setEncodingOptions(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setEncodingOptions(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setEncodingOptions_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEncodingOptions(QMap<QString,QVariant>)
            cppSelf->setEncodingOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setEncodingOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setQuality(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setQuality";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setQuality(QMultimedia::EncodingQuality)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_ENCODINGQUALITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setQuality(QMultimedia::EncodingQuality)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setQuality_TypeError;

    // Call function/method
    {
        ::QMultimedia::EncodingQuality cppArg0{QMultimedia::VeryLowQuality};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQuality(QMultimedia::EncodingQuality)
            cppSelf->setQuality(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setQuality_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettingsFunc_setSampleRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioEncoderSettings.setSampleRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioEncoderSettings::setSampleRate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSampleRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioEncoderSettingsFunc_setSampleRate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSampleRate(int)
            cppSelf->setSampleRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioEncoderSettingsFunc_setSampleRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioEncoderSettings___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAudioEncoderSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudioEncoderSettings_methods[] = {
    {"bitRate", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_bitRate), METH_NOARGS},
    {"channelCount", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_channelCount), METH_NOARGS},
    {"codec", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_codec), METH_NOARGS},
    {"encodingMode", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_encodingMode), METH_NOARGS},
    {"encodingOption", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_encodingOption), METH_O},
    {"encodingOptions", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_encodingOptions), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_isNull), METH_NOARGS},
    {"quality", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_quality), METH_NOARGS},
    {"sampleRate", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_sampleRate), METH_NOARGS},
    {"setBitRate", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setBitRate), METH_O},
    {"setChannelCount", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setChannelCount), METH_O},
    {"setCodec", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setCodec), METH_O},
    {"setEncodingMode", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setEncodingMode), METH_O},
    {"setEncodingOption", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setEncodingOption), METH_VARARGS},
    {"setEncodingOptions", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setEncodingOptions), METH_O},
    {"setQuality", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setQuality), METH_O},
    {"setSampleRate", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettingsFunc_setSampleRate), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAudioEncoderSettings___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAudioEncoderSettings___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QAudioEncoderSettings_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator!=(const QAudioEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioEncoderSettings cppArg0_local;
                ::QAudioEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), (pyArg)))) {
                // operator==(const QAudioEncoderSettings & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioEncoderSettings cppArg0_local;
                ::QAudioEncoderSettings *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QAudioEncoderSettings_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QAudioEncoderSettings_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QAudioEncoderSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudioEncoderSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudioEncoderSettings_Type = nullptr;
static SbkObjectType *Sbk_QAudioEncoderSettings_TypeF(void)
{
    return _Sbk_QAudioEncoderSettings_Type;
}

static PyType_Slot Sbk_QAudioEncoderSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudioEncoderSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudioEncoderSettings_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QAudioEncoderSettings_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudioEncoderSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAudioEncoderSettings_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QAudioEncoderSettings___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QAudioEncoderSettings___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QAudioEncoderSettings_spec = {
    "2:PySide2.QtMultimedia.QAudioEncoderSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudioEncoderSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAudioEncoderSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioEncoderSettings_TypeF())))
        return QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAudioEncoderSettings_PTR_CppToPython_QAudioEncoderSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAudioEncoderSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAudioEncoderSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAudioEncoderSettings_COPY_CppToPython_QAudioEncoderSettings(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAudioEncoderSettings_TypeF(), new ::QAudioEncoderSettings(*reinterpret_cast<const ::QAudioEncoderSettings *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioEncoderSettings *>(cppOut) = *reinterpret_cast< ::QAudioEncoderSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioEncoderSettings_TypeF())))
        return QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAudioEncoderSettings_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QAudioEncoderSettings(self)",
    "0:PySide2.QtMultimedia.QAudioEncoderSettings(self,other:PySide2.QtMultimedia.QAudioEncoderSettings)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.bitRate(self)->int",
    "PySide2.QtMultimedia.QAudioEncoderSettings.channelCount(self)->int",
    "PySide2.QtMultimedia.QAudioEncoderSettings.codec(self)->QString",
    "PySide2.QtMultimedia.QAudioEncoderSettings.encodingMode(self)->PySide2.QtMultimedia.QMultimedia.EncodingMode",
    "PySide2.QtMultimedia.QAudioEncoderSettings.encodingOption(self,option:QString)->QVariant",
    "PySide2.QtMultimedia.QAudioEncoderSettings.encodingOptions(self)->QMap[QString, QVariant]",
    "PySide2.QtMultimedia.QAudioEncoderSettings.isNull(self)->bool",
    "PySide2.QtMultimedia.QAudioEncoderSettings.quality(self)->PySide2.QtMultimedia.QMultimedia.EncodingQuality",
    "PySide2.QtMultimedia.QAudioEncoderSettings.sampleRate(self)->int",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setBitRate(self,bitrate:int)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setChannelCount(self,channels:int)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setCodec(self,codec:QString)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingMode(self,arg__1:PySide2.QtMultimedia.QMultimedia.EncodingMode)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingOption(self,option:QString,value:QVariant)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setEncodingOptions(self,options:QMap[QString, QVariant])",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setQuality(self,quality:PySide2.QtMultimedia.QMultimedia.EncodingQuality)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.setSampleRate(self,rate:int)",
    "PySide2.QtMultimedia.QAudioEncoderSettings.__copy__()",
    nullptr}; // Sentinel

void init_QAudioEncoderSettings(PyObject *module)
{
    _Sbk_QAudioEncoderSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudioEncoderSettings",
        "QAudioEncoderSettings",
        &Sbk_QAudioEncoderSettings_spec,
        &Shiboken::callCppDestructor< ::QAudioEncoderSettings >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudioEncoderSettings_Type);
    InitSignatureStrings(pyType, QAudioEncoderSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudioEncoderSettings_Type), Sbk_QAudioEncoderSettings_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudioEncoderSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAudioEncoderSettings_TypeF(),
        QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_PTR,
        is_QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_PTR_Convertible,
        QAudioEncoderSettings_PTR_CppToPython_QAudioEncoderSettings,
        QAudioEncoderSettings_COPY_CppToPython_QAudioEncoderSettings);

    Shiboken::Conversions::registerConverterName(converter, "QAudioEncoderSettings");
    Shiboken::Conversions::registerConverterName(converter, "QAudioEncoderSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QAudioEncoderSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioEncoderSettings).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_COPY,
        is_QAudioEncoderSettings_PythonToCpp_QAudioEncoderSettings_COPY_Convertible);

    qRegisterMetaType< ::QAudioEncoderSettings >("QAudioEncoderSettings");
}
