/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qabstractvideobuffer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractVideoBufferWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractVideoBufferWrapper::QAbstractVideoBufferWrapper(::QAbstractVideoBuffer::HandleType type) : QAbstractVideoBuffer(type)
{
    resetPyMethodCache();
    // ... middle
}

::QVariant QAbstractVideoBufferWrapper::handle() const
{
    if (m_PyMethodCache[0])
        return this->::QAbstractVideoBuffer::handle();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "handle";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QAbstractVideoBuffer::handle();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoBuffer.handle", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

uchar * QAbstractVideoBufferWrapper::map(::QAbstractVideoBuffer::MapMode mode, int * numBytes, int * bytesPerLine)
{
    return nullptr;
}

::QAbstractVideoBuffer::MapMode QAbstractVideoBufferWrapper::mapMode() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.mapMode()' not implemented.");
        return QAbstractVideoBuffer::NotMapped;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QAbstractVideoBuffer::NotMapped;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mapMode";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.mapMode()' not implemented.");
        return QAbstractVideoBuffer::NotMapped;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QAbstractVideoBuffer::NotMapped;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoBuffer.mapMode", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAbstractVideoBuffer::MapMode >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QAbstractVideoBuffer::NotMapped;
    }
    ::QAbstractVideoBuffer::MapMode cppResult{QAbstractVideoBuffer::NotMapped};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractVideoBufferWrapper::release()
{
    if (m_PyMethodCache[3]) {
        return this->::QAbstractVideoBuffer::release();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "release";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QAbstractVideoBuffer::release();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractVideoBufferWrapper::unmap()
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.unmap()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.unmap()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QAbstractVideoBufferWrapper::~QAbstractVideoBufferWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractVideoBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractVideoBuffer' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractVideoBuffer >()))
        return -1;

    ::QAbstractVideoBufferWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAbstractVideoBuffer", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractVideoBuffer::QAbstractVideoBuffer(QAbstractVideoBuffer::HandleType)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QAbstractVideoBuffer(QAbstractVideoBuffer::HandleType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractVideoBuffer_Init_TypeError;

    // Call function/method
    {
        ::QAbstractVideoBuffer::HandleType cppArg0{QAbstractVideoBuffer::NoHandle};
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractVideoBuffer(QAbstractVideoBuffer::HandleType)
            cptr = new ::QAbstractVideoBufferWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractVideoBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractVideoBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAbstractVideoBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractVideoBufferFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractVideoBuffer *>(cppSelf)->::QAbstractVideoBuffer::handle()
                : const_cast<const ::QAbstractVideoBuffer *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractVideoBufferFunc_handleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.handleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handleType()const
            QAbstractVideoBuffer::HandleType cppResult = const_cast<const ::QAbstractVideoBuffer *>(cppSelf)->handleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractVideoBufferFunc_mapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.mapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mapMode()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.mapMode()' not implemented.");
                return {};
            }
            QAbstractVideoBuffer::MapMode cppResult = const_cast<const ::QAbstractVideoBuffer *>(cppSelf)->mapMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractVideoBufferFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractVideoBuffer::release()
                : cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractVideoBufferFunc_unmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAbstractVideoBuffer.unmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unmap()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoBuffer.unmap()' not implemented.");
                return {};
            }
            cppSelf->unmap();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QAbstractVideoBuffer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractVideoBuffer_methods[] = {
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QAbstractVideoBufferFunc_handle), METH_NOARGS},
    {"handleType", reinterpret_cast<PyCFunction>(Sbk_QAbstractVideoBufferFunc_handleType), METH_NOARGS},
    {"mapMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractVideoBufferFunc_mapMode), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QAbstractVideoBufferFunc_release), METH_NOARGS},
    {"unmap", reinterpret_cast<PyCFunction>(Sbk_QAbstractVideoBufferFunc_unmap), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractVideoBuffer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractVideoBufferWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QAbstractVideoBuffer_get_m_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QAbstractVideoBuffer::HandleType cppOut_local = cppSelf->m_type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QAbstractVideoBuffer_set_m_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QAbstractVideoBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'m_type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'm_type', 'HandleType' or convertible type expected");
        return -1;
    }

    ::QAbstractVideoBuffer::HandleType cppOut_local = cppSelf->m_type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->m_type = cppOut_local;

    return 0;
}

// Getters and Setters for QAbstractVideoBuffer
static PyGetSetDef Sbk_QAbstractVideoBuffer_getsetlist[] = {
    {const_cast<char *>("m_type"), Sbk_QAbstractVideoBuffer_get_m_type, Sbk_QAbstractVideoBuffer_set_m_type},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAbstractVideoBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractVideoBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractVideoBuffer_Type = nullptr;
static SbkObjectType *Sbk_QAbstractVideoBuffer_TypeF(void)
{
    return _Sbk_QAbstractVideoBuffer_Type;
}

static PyType_Slot Sbk_QAbstractVideoBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractVideoBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractVideoBuffer_spec = {
    "2:PySide2.QtMultimedia.QAbstractVideoBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractVideoBuffer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractVideoBuffer_HandleType_PythonToCpp_QAbstractVideoBuffer_HandleType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractVideoBuffer::HandleType *>(cppOut) =
        static_cast<::QAbstractVideoBuffer::HandleType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractVideoBuffer_HandleType_PythonToCpp_QAbstractVideoBuffer_HandleType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX]))
        return QAbstractVideoBuffer_HandleType_PythonToCpp_QAbstractVideoBuffer_HandleType;
    return {};
}
static PyObject *QAbstractVideoBuffer_HandleType_CppToPython_QAbstractVideoBuffer_HandleType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractVideoBuffer::HandleType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX], castCppIn);

}

static void QAbstractVideoBuffer_MapMode_PythonToCpp_QAbstractVideoBuffer_MapMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractVideoBuffer::MapMode *>(cppOut) =
        static_cast<::QAbstractVideoBuffer::MapMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractVideoBuffer_MapMode_PythonToCpp_QAbstractVideoBuffer_MapMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX]))
        return QAbstractVideoBuffer_MapMode_PythonToCpp_QAbstractVideoBuffer_MapMode;
    return {};
}
static PyObject *QAbstractVideoBuffer_MapMode_CppToPython_QAbstractVideoBuffer_MapMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractVideoBuffer::MapMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractVideoBuffer_PythonToCpp_QAbstractVideoBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractVideoBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractVideoBuffer_PythonToCpp_QAbstractVideoBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractVideoBuffer_TypeF())))
        return QAbstractVideoBuffer_PythonToCpp_QAbstractVideoBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractVideoBuffer_PTR_CppToPython_QAbstractVideoBuffer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAbstractVideoBuffer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAbstractVideoBuffer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractVideoBuffer_SignatureStrings[] = {
    "PySide2.QtMultimedia.QAbstractVideoBuffer(self,type:PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType)",
    "PySide2.QtMultimedia.QAbstractVideoBuffer.handle(self)->QVariant",
    "PySide2.QtMultimedia.QAbstractVideoBuffer.handleType(self)->PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType",
    "PySide2.QtMultimedia.QAbstractVideoBuffer.mapMode(self)->PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode",
    "PySide2.QtMultimedia.QAbstractVideoBuffer.release(self)",
    "PySide2.QtMultimedia.QAbstractVideoBuffer.unmap(self)",
    nullptr}; // Sentinel

void init_QAbstractVideoBuffer(PyObject *module)
{
    _Sbk_QAbstractVideoBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractVideoBuffer",
        "QAbstractVideoBuffer*",
        &Sbk_QAbstractVideoBuffer_spec,
        &Shiboken::callCppDestructor< ::QAbstractVideoBuffer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractVideoBuffer_Type);
    InitSignatureStrings(pyType, QAbstractVideoBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractVideoBuffer_Type), Sbk_QAbstractVideoBuffer_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractVideoBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractVideoBuffer_TypeF(),
        QAbstractVideoBuffer_PythonToCpp_QAbstractVideoBuffer_PTR,
        is_QAbstractVideoBuffer_PythonToCpp_QAbstractVideoBuffer_PTR_Convertible,
        QAbstractVideoBuffer_PTR_CppToPython_QAbstractVideoBuffer);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractVideoBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractVideoBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractVideoBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractVideoBuffer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractVideoBufferWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'HandleType'.
    SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractVideoBuffer_TypeF(),
        "HandleType",
        "2:PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType",
        "QAbstractVideoBuffer::HandleType");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "NoHandle", (long) QAbstractVideoBuffer::HandleType::NoHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "GLTextureHandle", (long) QAbstractVideoBuffer::HandleType::GLTextureHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "XvShmImageHandle", (long) QAbstractVideoBuffer::HandleType::XvShmImageHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "CoreImageHandle", (long) QAbstractVideoBuffer::HandleType::CoreImageHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "QPixmapHandle", (long) QAbstractVideoBuffer::HandleType::QPixmapHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "EGLImageHandle", (long) QAbstractVideoBuffer::HandleType::EGLImageHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "GLTextureRectangleHandle", (long) QAbstractVideoBuffer::HandleType::GLTextureRectangleHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "UserHandle", (long) QAbstractVideoBuffer::HandleType::UserHandle))
        return;
    // Register converter for enum 'QAbstractVideoBuffer::HandleType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX],
            QAbstractVideoBuffer_HandleType_CppToPython_QAbstractVideoBuffer_HandleType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractVideoBuffer_HandleType_PythonToCpp_QAbstractVideoBuffer_HandleType,
            is_QAbstractVideoBuffer_HandleType_PythonToCpp_QAbstractVideoBuffer_HandleType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractVideoBuffer::HandleType");
        Shiboken::Conversions::registerConverterName(converter, "HandleType");
    }
    // End of 'HandleType' enum.

    // Initialization of enum 'MapMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractVideoBuffer_TypeF(),
        "MapMode",
        "2:PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode",
        "QAbstractVideoBuffer::MapMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "NotMapped", (long) QAbstractVideoBuffer::MapMode::NotMapped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "ReadOnly", (long) QAbstractVideoBuffer::MapMode::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "WriteOnly", (long) QAbstractVideoBuffer::MapMode::WriteOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX],
        Sbk_QAbstractVideoBuffer_TypeF(), "ReadWrite", (long) QAbstractVideoBuffer::MapMode::ReadWrite))
        return;
    // Register converter for enum 'QAbstractVideoBuffer::MapMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX],
            QAbstractVideoBuffer_MapMode_CppToPython_QAbstractVideoBuffer_MapMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractVideoBuffer_MapMode_PythonToCpp_QAbstractVideoBuffer_MapMode,
            is_QAbstractVideoBuffer_MapMode_PythonToCpp_QAbstractVideoBuffer_MapMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractVideoBuffer::MapMode");
        Shiboken::Conversions::registerConverterName(converter, "MapMode");
    }
    // End of 'MapMode' enum.

    qRegisterMetaType< ::QAbstractVideoBuffer::HandleType >("QAbstractVideoBuffer::HandleType");
    qRegisterMetaType< ::QAbstractVideoBuffer::MapMode >("QAbstractVideoBuffer::MapMode");
}
