/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplaceimage_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPlaceImageWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPlaceImageWrapper::QPlaceImageWrapper() : QPlaceImage()
{
    resetPyMethodCache();
    // ... middle
}

QPlaceImageWrapper::QPlaceImageWrapper(const ::QPlaceContent & other) : QPlaceImage(other)
{
    resetPyMethodCache();
    // ... middle
}

QPlaceImageWrapper::~QPlaceImageWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceImage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceImage >()))
        return -1;

    ::QPlaceImageWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceImage", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceImage::QPlaceImage()
    // 1: QPlaceImage::QPlaceImage(QPlaceContent)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceImage()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceImage(QPlaceContent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceImage_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceImage()
        {

            if (!PyErr_Occurred()) {
                // QPlaceImage()
                cptr = new ::QPlaceImageWrapper();
            }
            break;
        }
        case 1: // QPlaceImage(const QPlaceContent & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceContent cppArg0_local;
            ::QPlaceContent *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPlaceImage(QPlaceContent)
                cptr = new ::QPlaceImageWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceImage >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceImage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceImage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceImageFunc_imageId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.imageId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageId()const
            QString cppResult = const_cast<const ::QPlaceImage *>(cppSelf)->imageId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceImageFunc_mimeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.mimeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeType()const
            QString cppResult = const_cast<const ::QPlaceImage *>(cppSelf)->mimeType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceImageFunc_setImageId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.setImageId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceImage::setImageId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setImageId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceImageFunc_setImageId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setImageId(QString)
            cppSelf->setImageId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceImageFunc_setImageId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceImageFunc_setMimeType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.setMimeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceImage::setMimeType(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setMimeType(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceImageFunc_setMimeType_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMimeType(QString)
            cppSelf->setMimeType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceImageFunc_setMimeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceImageFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceImage::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceImageFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceImageFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceImageFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceImage.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QPlaceImage *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPlaceImage_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceImage_methods[] = {
    {"imageId", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_imageId), METH_NOARGS},
    {"mimeType", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_mimeType), METH_NOARGS},
    {"setImageId", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_setImageId), METH_O},
    {"setMimeType", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_setMimeType), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_setUrl), METH_O},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QPlaceImageFunc_url), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPlaceImage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPlaceImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPlaceImageWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QPlaceImage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceImage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceImage_Type = nullptr;
static SbkObjectType *Sbk_QPlaceImage_TypeF(void)
{
    return _Sbk_QPlaceImage_Type;
}

static PyType_Slot Sbk_QPlaceImage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPlaceImage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceImage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceImage_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceImage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceImage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceImage_spec = {
    "2:PySide2.QtLocation.QPlaceImage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceImage_slots
};

} //extern "C"

static void *Sbk_QPlaceImage_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPlaceContent >()))
        return dynamic_cast< ::QPlaceImage *>(reinterpret_cast< ::QPlaceContent *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceImage_PythonToCpp_QPlaceImage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceImage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceImage_PythonToCpp_QPlaceImage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceImage_TypeF())))
        return QPlaceImage_PythonToCpp_QPlaceImage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceImage_PTR_CppToPython_QPlaceImage(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceImage *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceImage_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceImage_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceImage(self)",
    "0:PySide2.QtLocation.QPlaceImage(self,other:PySide2.QtLocation.QPlaceContent)",
    "PySide2.QtLocation.QPlaceImage.imageId(self)->QString",
    "PySide2.QtLocation.QPlaceImage.mimeType(self)->QString",
    "PySide2.QtLocation.QPlaceImage.setImageId(self,identifier:QString)",
    "PySide2.QtLocation.QPlaceImage.setMimeType(self,data:QString)",
    "PySide2.QtLocation.QPlaceImage.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtLocation.QPlaceImage.url(self)->PySide2.QtCore.QUrl",
    nullptr}; // Sentinel

void init_QPlaceImage(PyObject *module)
{
    _Sbk_QPlaceImage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceImage",
        "QPlaceImage*",
        &Sbk_QPlaceImage_spec,
        &Shiboken::callCppDestructor< ::QPlaceImage >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceImage_Type);
    InitSignatureStrings(pyType, QPlaceImage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceImage_Type), Sbk_QPlaceImage_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACEIMAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceImage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceImage_TypeF(),
        QPlaceImage_PythonToCpp_QPlaceImage_PTR,
        is_QPlaceImage_PythonToCpp_QPlaceImage_PTR_Convertible,
        QPlaceImage_PTR_CppToPython_QPlaceImage);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceImage");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceImage*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceImage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceImage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceImageWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QPlaceImage_TypeF(), &Sbk_QPlaceImage_typeDiscovery);

}
