/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplacecontentrequest_wrapper.h"

// inner classes

// Extra includes
#include <QtLocation/qplacecontentrequest.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceContentRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceContentRequest >()))
        return -1;

    ::QPlaceContentRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceContentRequest", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceContentRequest::QPlaceContentRequest()
    // 1: QPlaceContentRequest::QPlaceContentRequest(QPlaceContentRequest)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceContentRequest()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceContentRequest(QPlaceContentRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceContentRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceContentRequest()
        {

            if (!PyErr_Occurred()) {
                // QPlaceContentRequest()
                cptr = new ::QPlaceContentRequest();
            }
            break;
        }
        case 1: // QPlaceContentRequest(const QPlaceContentRequest & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceContentRequest cppArg0_local;
            ::QPlaceContentRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPlaceContentRequest(QPlaceContentRequest)
                cptr = new ::QPlaceContentRequest(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceContentRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceContentRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceContentRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceContentRequestFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPlaceContentRequestFunc_contentContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.contentContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentContext()const
            QVariant cppResult = const_cast<const ::QPlaceContentRequest *>(cppSelf)->contentContext();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceContentRequestFunc_contentType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.contentType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentType()const
            QPlaceContent::Type cppResult = const_cast<const ::QPlaceContentRequest *>(cppSelf)->contentType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceContentRequestFunc_limit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.limit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // limit()const
            int cppResult = const_cast<const ::QPlaceContentRequest *>(cppSelf)->limit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceContentRequestFunc_placeId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.placeId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placeId()const
            QString cppResult = const_cast<const ::QPlaceContentRequest *>(cppSelf)->placeId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceContentRequestFunc_setContentContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.setContentContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceContentRequest::setContentContext(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setContentContext(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceContentRequestFunc_setContentContext_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContentContext(QVariant)
            cppSelf->setContentContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceContentRequestFunc_setContentContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceContentRequestFunc_setContentType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.setContentType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceContentRequest::setContentType(QPlaceContent::Type)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENT_TYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setContentType(QPlaceContent::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceContentRequestFunc_setContentType_TypeError;

    // Call function/method
    {
        ::QPlaceContent::Type cppArg0{QPlaceContent::NoType};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContentType(QPlaceContent::Type)
            cppSelf->setContentType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceContentRequestFunc_setContentType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceContentRequestFunc_setLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.setLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceContentRequest::setLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceContentRequestFunc_setLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLimit(int)
            cppSelf->setLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceContentRequestFunc_setLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceContentRequestFunc_setPlaceId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceContentRequest.setPlaceId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceContentRequest::setPlaceId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPlaceId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceContentRequestFunc_setPlaceId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPlaceId(QString)
            cppSelf->setPlaceId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceContentRequestFunc_setPlaceId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceContentRequest___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPlaceContentRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceContentRequest_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_clear), METH_NOARGS},
    {"contentContext", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_contentContext), METH_NOARGS},
    {"contentType", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_contentType), METH_NOARGS},
    {"limit", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_limit), METH_NOARGS},
    {"placeId", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_placeId), METH_NOARGS},
    {"setContentContext", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_setContentContext), METH_O},
    {"setContentType", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_setContentType), METH_O},
    {"setLimit", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_setLimit), METH_O},
    {"setPlaceId", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequestFunc_setPlaceId), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPlaceContentRequest___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QPlaceContentRequest_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), (pyArg)))) {
                // operator!=(const QPlaceContentRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceContentRequest cppArg0_local;
                ::QPlaceContentRequest *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), (pyArg)))) {
                // operator==(const QPlaceContentRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceContentRequest cppArg0_local;
                ::QPlaceContentRequest *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPlaceContentRequest_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPlaceContentRequest_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPlaceContentRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceContentRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceContentRequest_Type = nullptr;
static SbkObjectType *Sbk_QPlaceContentRequest_TypeF(void)
{
    return _Sbk_QPlaceContentRequest_Type;
}

static PyType_Slot Sbk_QPlaceContentRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceContentRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceContentRequest_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPlaceContentRequest_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceContentRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceContentRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceContentRequest_spec = {
    "2:PySide2.QtLocation.QPlaceContentRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceContentRequest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceContentRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceContentRequest_TypeF())))
        return QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceContentRequest_PTR_CppToPython_QPlaceContentRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceContentRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceContentRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPlaceContentRequest_COPY_CppToPython_QPlaceContentRequest(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPlaceContentRequest_TypeF(), new ::QPlaceContentRequest(*reinterpret_cast<const ::QPlaceContentRequest *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPlaceContentRequest *>(cppOut) = *reinterpret_cast< ::QPlaceContentRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceContentRequest_TypeF())))
        return QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceContentRequest_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceContentRequest(self)",
    "0:PySide2.QtLocation.QPlaceContentRequest(self,other:PySide2.QtLocation.QPlaceContentRequest)",
    "PySide2.QtLocation.QPlaceContentRequest.clear(self)",
    "PySide2.QtLocation.QPlaceContentRequest.contentContext(self)->QVariant",
    "PySide2.QtLocation.QPlaceContentRequest.contentType(self)->PySide2.QtLocation.QPlaceContent.Type",
    "PySide2.QtLocation.QPlaceContentRequest.limit(self)->int",
    "PySide2.QtLocation.QPlaceContentRequest.placeId(self)->QString",
    "PySide2.QtLocation.QPlaceContentRequest.setContentContext(self,context:QVariant)",
    "PySide2.QtLocation.QPlaceContentRequest.setContentType(self,type:PySide2.QtLocation.QPlaceContent.Type)",
    "PySide2.QtLocation.QPlaceContentRequest.setLimit(self,limit:int)",
    "PySide2.QtLocation.QPlaceContentRequest.setPlaceId(self,identifier:QString)",
    "PySide2.QtLocation.QPlaceContentRequest.__copy__()",
    nullptr}; // Sentinel

void init_QPlaceContentRequest(PyObject *module)
{
    _Sbk_QPlaceContentRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceContentRequest",
        "QPlaceContentRequest",
        &Sbk_QPlaceContentRequest_spec,
        &Shiboken::callCppDestructor< ::QPlaceContentRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceContentRequest_Type);
    InitSignatureStrings(pyType, QPlaceContentRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceContentRequest_Type), Sbk_QPlaceContentRequest_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACECONTENTREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceContentRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceContentRequest_TypeF(),
        QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_PTR,
        is_QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_PTR_Convertible,
        QPlaceContentRequest_PTR_CppToPython_QPlaceContentRequest,
        QPlaceContentRequest_COPY_CppToPython_QPlaceContentRequest);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceContentRequest");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceContentRequest*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceContentRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceContentRequest).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_COPY,
        is_QPlaceContentRequest_PythonToCpp_QPlaceContentRequest_COPY_Convertible);

    qRegisterMetaType< ::QPlaceContentRequest >("QPlaceContentRequest");
}
