/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qthelp_python.h"

// main header
#include "qhelpsearchquery_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHelpSearchQuery_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHelpSearchQuery >()))
        return -1;

    ::QHelpSearchQuery *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpSearchQuery.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QHelpSearchQuery", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QHelpSearchQuery::QHelpSearchQuery()
    // 1: QHelpSearchQuery::QHelpSearchQuery(QHelpSearchQuery::FieldName,QStringList)
    // 2: QHelpSearchQuery::QHelpSearchQuery(QHelpSearchQuery)
    if (numArgs == 0) {
        overloadId = 0; // QHelpSearchQuery()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QHelpSearchQuery(QHelpSearchQuery)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
        overloadId = 1; // QHelpSearchQuery(QHelpSearchQuery::FieldName,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpSearchQuery_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QHelpSearchQuery()
        {

            if (!PyErr_Occurred()) {
                // QHelpSearchQuery()
                cptr = new ::QHelpSearchQuery();
            }
            break;
        }
        case 1: // QHelpSearchQuery(QHelpSearchQuery::FieldName field, const QStringList & wordList_)
        {
            ::QHelpSearchQuery::FieldName cppArg0{QHelpSearchQuery::DEFAULT};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QHelpSearchQuery(QHelpSearchQuery::FieldName,QStringList)
                cptr = new ::QHelpSearchQuery(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QHelpSearchQuery(const QHelpSearchQuery & QHelpSearchQuery)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QHelpSearchQuery cppArg0_local;
            ::QHelpSearchQuery *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QHelpSearchQuery(QHelpSearchQuery)
                cptr = new ::QHelpSearchQuery(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHelpSearchQuery >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHelpSearchQuery_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QHelpSearchQuery_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHelpSearchQuery___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QHelpSearchQuery_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHelpSearchQuery_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QHelpSearchQuery___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QHelpSearchQuery_get_fieldName(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QHelpSearchQuery::FieldName cppOut_local = cppSelf->fieldName;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QHelpSearchQuery_set_fieldName(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'fieldName' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'fieldName', 'FieldName' or convertible type expected");
        return -1;
    }

    ::QHelpSearchQuery::FieldName cppOut_local = cppSelf->fieldName;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->fieldName = cppOut_local;

    return 0;
}

static PyObject *Sbk_QHelpSearchQuery_get_wordList(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppSelf->wordList);
    return pyOut;
}
static int Sbk_QHelpSearchQuery_set_wordList(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'wordList' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'wordList', 'QStringList' or convertible type expected");
        return -1;
    }

    ::QStringList& cppOut_ptr = cppSelf->wordList;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QHelpSearchQuery
static PyGetSetDef Sbk_QHelpSearchQuery_getsetlist[] = {
    {const_cast<char *>("fieldName"), Sbk_QHelpSearchQuery_get_fieldName, Sbk_QHelpSearchQuery_set_fieldName},
    {const_cast<char *>("wordList"), Sbk_QHelpSearchQuery_get_wordList, Sbk_QHelpSearchQuery_set_wordList},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QHelpSearchQuery_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHelpSearchQuery_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHelpSearchQuery_Type = nullptr;
static SbkObjectType *Sbk_QHelpSearchQuery_TypeF(void)
{
    return _Sbk_QHelpSearchQuery_Type;
}

static PyType_Slot Sbk_QHelpSearchQuery_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHelpSearchQuery_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHelpSearchQuery_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHelpSearchQuery_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QHelpSearchQuery_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHelpSearchQuery_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHelpSearchQuery_spec = {
    "2:PySide2.QtHelp.QHelpSearchQuery",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHelpSearchQuery_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QHelpSearchQuery_FieldName_PythonToCpp_QHelpSearchQuery_FieldName(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHelpSearchQuery::FieldName *>(cppOut) =
        static_cast<::QHelpSearchQuery::FieldName>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QHelpSearchQuery_FieldName_PythonToCpp_QHelpSearchQuery_FieldName_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX]))
        return QHelpSearchQuery_FieldName_PythonToCpp_QHelpSearchQuery_FieldName;
    return {};
}
static PyObject *QHelpSearchQuery_FieldName_CppToPython_QHelpSearchQuery_FieldName(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QHelpSearchQuery::FieldName *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHelpSearchQuery_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHelpSearchQuery_TypeF())))
        return QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHelpSearchQuery_PTR_CppToPython_QHelpSearchQuery(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QHelpSearchQuery *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QHelpSearchQuery_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QHelpSearchQuery_COPY_CppToPython_QHelpSearchQuery(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QHelpSearchQuery_TypeF(), new ::QHelpSearchQuery(*reinterpret_cast<const ::QHelpSearchQuery *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHelpSearchQuery *>(cppOut) = *reinterpret_cast< ::QHelpSearchQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHelpSearchQuery_TypeF())))
        return QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHelpSearchQuery_SignatureStrings[] = {
    "2:PySide2.QtHelp.QHelpSearchQuery(self)",
    "1:PySide2.QtHelp.QHelpSearchQuery(self,field:PySide2.QtHelp.QHelpSearchQuery.FieldName,wordList_:QStringList)",
    "0:PySide2.QtHelp.QHelpSearchQuery(self,QHelpSearchQuery:PySide2.QtHelp.QHelpSearchQuery)",
    "PySide2.QtHelp.QHelpSearchQuery.__copy__()",
    nullptr}; // Sentinel

void init_QHelpSearchQuery(PyObject *module)
{
    _Sbk_QHelpSearchQuery_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHelpSearchQuery",
        "QHelpSearchQuery",
        &Sbk_QHelpSearchQuery_spec,
        &Shiboken::callCppDestructor< ::QHelpSearchQuery >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHelpSearchQuery_Type);
    InitSignatureStrings(pyType, QHelpSearchQuery_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHelpSearchQuery_Type), Sbk_QHelpSearchQuery_PropertyStrings);
    SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHelpSearchQuery_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHelpSearchQuery_TypeF(),
        QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_PTR,
        is_QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_PTR_Convertible,
        QHelpSearchQuery_PTR_CppToPython_QHelpSearchQuery,
        QHelpSearchQuery_COPY_CppToPython_QHelpSearchQuery);

    Shiboken::Conversions::registerConverterName(converter, "QHelpSearchQuery");
    Shiboken::Conversions::registerConverterName(converter, "QHelpSearchQuery*");
    Shiboken::Conversions::registerConverterName(converter, "QHelpSearchQuery&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHelpSearchQuery).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_COPY,
        is_QHelpSearchQuery_PythonToCpp_QHelpSearchQuery_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FieldName'.
    SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QHelpSearchQuery_TypeF(),
        "FieldName",
        "2:PySide2.QtHelp.QHelpSearchQuery.FieldName",
        "QHelpSearchQuery::FieldName");
    if (!SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "DEFAULT", (long) QHelpSearchQuery::FieldName::DEFAULT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "FUZZY", (long) QHelpSearchQuery::FieldName::FUZZY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "WITHOUT", (long) QHelpSearchQuery::FieldName::WITHOUT))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "PHRASE", (long) QHelpSearchQuery::FieldName::PHRASE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "ALL", (long) QHelpSearchQuery::FieldName::ALL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
        Sbk_QHelpSearchQuery_TypeF(), "ATLEAST", (long) QHelpSearchQuery::FieldName::ATLEAST))
        return;
    // Register converter for enum 'QHelpSearchQuery::FieldName'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX],
            QHelpSearchQuery_FieldName_CppToPython_QHelpSearchQuery_FieldName);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHelpSearchQuery_FieldName_PythonToCpp_QHelpSearchQuery_FieldName,
            is_QHelpSearchQuery_FieldName_PythonToCpp_QHelpSearchQuery_FieldName_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtHelpTypes[SBK_QHELPSEARCHQUERY_FIELDNAME_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHelpSearchQuery::FieldName");
        Shiboken::Conversions::registerConverterName(converter, "FieldName");
    }
    // End of 'FieldName' enum.

    qRegisterMetaType< ::QHelpSearchQuery >("QHelpSearchQuery");
    qRegisterMetaType< ::QHelpSearchQuery::FieldName >("QHelpSearchQuery::FieldName");
}
