/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qthelp_python.h"

// main header
#include "qcompressedhelpinfo_wrapper.h"

// inner classes

// Extra includes
#include <QtHelp/qcompressedhelpinfo.h>
#include <qversionnumber.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCompressedHelpInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCompressedHelpInfo >()))
        return -1;

    ::QCompressedHelpInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QCompressedHelpInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QCompressedHelpInfo::QCompressedHelpInfo()
    // 1: QCompressedHelpInfo::QCompressedHelpInfo(QCompressedHelpInfo)
    if (numArgs == 0) {
        overloadId = 0; // QCompressedHelpInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCompressedHelpInfo(QCompressedHelpInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompressedHelpInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCompressedHelpInfo()
        {

            if (!PyErr_Occurred()) {
                // QCompressedHelpInfo()
                cptr = new ::QCompressedHelpInfo();
            }
            break;
        }
        case 1: // QCompressedHelpInfo(const QCompressedHelpInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCompressedHelpInfo cppArg0_local;
            ::QCompressedHelpInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QCompressedHelpInfo(QCompressedHelpInfo)
                cptr = new ::QCompressedHelpInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCompressedHelpInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCompressedHelpInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QCompressedHelpInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCompressedHelpInfoFunc_component(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.component";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // component()const
            QString cppResult = const_cast<const ::QCompressedHelpInfo *>(cppSelf)->component();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompressedHelpInfoFunc_fromCompressedHelpFile(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.fromCompressedHelpFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCompressedHelpInfo::fromCompressedHelpFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromCompressedHelpFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompressedHelpInfoFunc_fromCompressedHelpFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromCompressedHelpFile(QString)
            QCompressedHelpInfo cppResult = ::QCompressedHelpInfo::fromCompressedHelpFile(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCompressedHelpInfoFunc_fromCompressedHelpFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompressedHelpInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QCompressedHelpInfo *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompressedHelpInfoFunc_namespaceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.namespaceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceName()const
            QString cppResult = const_cast<const ::QCompressedHelpInfo *>(cppSelf)->namespaceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompressedHelpInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCompressedHelpInfo::swap(QCompressedHelpInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QCompressedHelpInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCompressedHelpInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCompressedHelpInfo cppArg0_local;
        ::QCompressedHelpInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QCompressedHelpInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCompressedHelpInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCompressedHelpInfoFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QCompressedHelpInfo.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QVersionNumber cppResult = const_cast<const ::QCompressedHelpInfo *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QVERSIONNUMBER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCompressedHelpInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCompressedHelpInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCompressedHelpInfo_methods[] = {
    {"component", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_component), METH_NOARGS},
    {"fromCompressedHelpFile", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_fromCompressedHelpFile), METH_O|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_isNull), METH_NOARGS},
    {"namespaceName", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_namespaceName), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_swap), METH_O},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfoFunc_version), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QCompressedHelpInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCompressedHelpInfo___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QCompressedHelpInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCompressedHelpInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCompressedHelpInfo_Type = nullptr;
static SbkObjectType *Sbk_QCompressedHelpInfo_TypeF(void)
{
    return _Sbk_QCompressedHelpInfo_Type;
}

static PyType_Slot Sbk_QCompressedHelpInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCompressedHelpInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCompressedHelpInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCompressedHelpInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCompressedHelpInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QCompressedHelpInfo___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QCompressedHelpInfo___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QCompressedHelpInfo_spec = {
    "2:PySide2.QtHelp.QCompressedHelpInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCompressedHelpInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCompressedHelpInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCompressedHelpInfo_TypeF())))
        return QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCompressedHelpInfo_PTR_CppToPython_QCompressedHelpInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QCompressedHelpInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QCompressedHelpInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QCompressedHelpInfo_COPY_CppToPython_QCompressedHelpInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QCompressedHelpInfo_TypeF(), new ::QCompressedHelpInfo(*reinterpret_cast<const ::QCompressedHelpInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCompressedHelpInfo *>(cppOut) = *reinterpret_cast< ::QCompressedHelpInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCompressedHelpInfo_TypeF())))
        return QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCompressedHelpInfo_SignatureStrings[] = {
    "1:PySide2.QtHelp.QCompressedHelpInfo(self)",
    "0:PySide2.QtHelp.QCompressedHelpInfo(self,other:PySide2.QtHelp.QCompressedHelpInfo)",
    "PySide2.QtHelp.QCompressedHelpInfo.component(self)->QString",
    "PySide2.QtHelp.QCompressedHelpInfo.fromCompressedHelpFile(documentationFileName:QString)->PySide2.QtHelp.QCompressedHelpInfo",
    "PySide2.QtHelp.QCompressedHelpInfo.isNull(self)->bool",
    "PySide2.QtHelp.QCompressedHelpInfo.namespaceName(self)->QString",
    "PySide2.QtHelp.QCompressedHelpInfo.swap(self,other:PySide2.QtHelp.QCompressedHelpInfo)",
    "PySide2.QtHelp.QCompressedHelpInfo.version(self)->PySide2.QtCore.QVersionNumber",
    "PySide2.QtHelp.QCompressedHelpInfo.__copy__()",
    nullptr}; // Sentinel

void init_QCompressedHelpInfo(PyObject *module)
{
    _Sbk_QCompressedHelpInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCompressedHelpInfo",
        "QCompressedHelpInfo",
        &Sbk_QCompressedHelpInfo_spec,
        &Shiboken::callCppDestructor< ::QCompressedHelpInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCompressedHelpInfo_Type);
    InitSignatureStrings(pyType, QCompressedHelpInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCompressedHelpInfo_Type), Sbk_QCompressedHelpInfo_PropertyStrings);
    SbkPySide2_QtHelpTypes[SBK_QCOMPRESSEDHELPINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCompressedHelpInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCompressedHelpInfo_TypeF(),
        QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_PTR,
        is_QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_PTR_Convertible,
        QCompressedHelpInfo_PTR_CppToPython_QCompressedHelpInfo,
        QCompressedHelpInfo_COPY_CppToPython_QCompressedHelpInfo);

    Shiboken::Conversions::registerConverterName(converter, "QCompressedHelpInfo");
    Shiboken::Conversions::registerConverterName(converter, "QCompressedHelpInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QCompressedHelpInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCompressedHelpInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_COPY,
        is_QCompressedHelpInfo_PythonToCpp_QCompressedHelpInfo_COPY_Convertible);

    qRegisterMetaType< ::QCompressedHelpInfo >("QCompressedHelpInfo");
}
