/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtouchdevice_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtGui/qtouchdevice.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTouchDevice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTouchDevice >()))
        return -1;

    ::QTouchDevice *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTouchDevice()
            cptr = new ::QTouchDevice();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTouchDevice >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QTouchDeviceFunc_capabilities(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.capabilities";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capabilities()const
            QFlags<QTouchDevice::CapabilityFlag> cppResult = const_cast<const ::QTouchDevice *>(cppSelf)->capabilities();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchDeviceFunc_devices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.devices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devices()
            QList<const QTouchDevice* > cppResult = ::QTouchDevice::devices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_CONSTQTOUCHDEVICEPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchDeviceFunc_maximumTouchPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.maximumTouchPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumTouchPoints()const
            int cppResult = const_cast<const ::QTouchDevice *>(cppSelf)->maximumTouchPoints();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchDeviceFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QTouchDevice *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTouchDeviceFunc_setCapabilities(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.setCapabilities";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchDevice::setCapabilities(QFlags<QTouchDevice::CapabilityFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCapabilities(QFlags<QTouchDevice::CapabilityFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchDeviceFunc_setCapabilities_TypeError;

    // Call function/method
    {
        ::QFlags<QTouchDevice::CapabilityFlag> cppArg0 = QFlags<QTouchDevice::CapabilityFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCapabilities(QFlags<QTouchDevice::CapabilityFlag>)
            cppSelf->setCapabilities(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchDeviceFunc_setCapabilities_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchDeviceFunc_setMaximumTouchPoints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.setMaximumTouchPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchDevice::setMaximumTouchPoints(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaximumTouchPoints(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchDeviceFunc_setMaximumTouchPoints_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumTouchPoints(int)
            cppSelf->setMaximumTouchPoints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchDeviceFunc_setMaximumTouchPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchDeviceFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchDevice::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchDeviceFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchDeviceFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchDeviceFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTouchDevice::setType(QTouchDevice::DeviceType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QTouchDevice::DeviceType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTouchDeviceFunc_setType_TypeError;

    // Call function/method
    {
        ::QTouchDevice::DeviceType cppArg0{QTouchDevice::TouchScreen};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QTouchDevice::DeviceType)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTouchDeviceFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTouchDeviceFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTouchDevice.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QTouchDevice::DeviceType cppResult = const_cast<const ::QTouchDevice *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTouchDevice_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTouchDevice_methods[] = {
    {"capabilities", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_capabilities), METH_NOARGS},
    {"devices", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_devices), METH_NOARGS|METH_STATIC},
    {"maximumTouchPoints", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_maximumTouchPoints), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_name), METH_NOARGS},
    {"setCapabilities", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_setCapabilities), METH_O},
    {"setMaximumTouchPoints", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_setMaximumTouchPoints), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_setName), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_setType), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QTouchDeviceFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTouchDevice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTouchDevice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QTouchDevice__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTouchDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTouchDevice_Type = nullptr;
static SbkObjectType *Sbk_QTouchDevice_TypeF(void)
{
    return _Sbk_QTouchDevice_Type;
}

static PyType_Slot Sbk_QTouchDevice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QTouchDevice__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTouchDevice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTouchDevice_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTouchDevice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTouchDevice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTouchDevice_spec = {
    "2:PySide2.QtGui.QTouchDevice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTouchDevice_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTouchDevice::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTouchDevice::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTouchDevice::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTouchDevice::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTouchDevice::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTouchDevice::Capabilities cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, self, &cppSelf);
    ::QTouchDevice::Capabilities cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTouchDevice_CapabilityFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTouchDevice_DeviceType_PythonToCpp_QTouchDevice_DeviceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTouchDevice::DeviceType *>(cppOut) =
        static_cast<::QTouchDevice::DeviceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTouchDevice_DeviceType_PythonToCpp_QTouchDevice_DeviceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX]))
        return QTouchDevice_DeviceType_PythonToCpp_QTouchDevice_DeviceType;
    return {};
}
static PyObject *QTouchDevice_DeviceType_CppToPython_QTouchDevice_DeviceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTouchDevice::DeviceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX], castCppIn);

}

static void QTouchDevice_CapabilityFlag_PythonToCpp_QTouchDevice_CapabilityFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTouchDevice::CapabilityFlag *>(cppOut) =
        static_cast<::QTouchDevice::CapabilityFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTouchDevice_CapabilityFlag_PythonToCpp_QTouchDevice_CapabilityFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX]))
        return QTouchDevice_CapabilityFlag_PythonToCpp_QTouchDevice_CapabilityFlag;
    return {};
}
static PyObject *QTouchDevice_CapabilityFlag_CppToPython_QTouchDevice_CapabilityFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTouchDevice::CapabilityFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX], castCppIn);

}

static void QFlags_QTouchDevice_CapabilityFlag__PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTouchDevice::CapabilityFlag> *>(cppOut) =
        ::QFlags<QTouchDevice::CapabilityFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTouchDevice_CapabilityFlag__PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX]))
        return QFlags_QTouchDevice_CapabilityFlag__PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_;
    return {};
}
static PyObject *QFlags_QTouchDevice_CapabilityFlag__CppToPython_QFlags_QTouchDevice_CapabilityFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTouchDevice::CapabilityFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX]));

}

static void QTouchDevice_CapabilityFlag_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTouchDevice::CapabilityFlag> *>(cppOut) =
        ::QFlags<QTouchDevice::CapabilityFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTouchDevice_CapabilityFlag_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX]))
        return QTouchDevice_CapabilityFlag_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTouchDevice::CapabilityFlag> *>(cppOut) =
        ::QFlags<QTouchDevice::CapabilityFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTouchDevice_PythonToCpp_QTouchDevice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTouchDevice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTouchDevice_PythonToCpp_QTouchDevice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTouchDevice_TypeF())))
        return QTouchDevice_PythonToCpp_QTouchDevice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTouchDevice_PTR_CppToPython_QTouchDevice(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTouchDevice *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTouchDevice_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTouchDevice_SignatureStrings[] = {
    "PySide2.QtGui.QTouchDevice(self)",
    "PySide2.QtGui.QTouchDevice.capabilities(self)->PySide2.QtGui.QTouchDevice.Capabilities",
    "PySide2.QtGui.QTouchDevice.devices()->QList[PySide2.QtGui.QTouchDevice]",
    "PySide2.QtGui.QTouchDevice.maximumTouchPoints(self)->int",
    "PySide2.QtGui.QTouchDevice.name(self)->QString",
    "PySide2.QtGui.QTouchDevice.setCapabilities(self,caps:PySide2.QtGui.QTouchDevice.Capabilities)",
    "PySide2.QtGui.QTouchDevice.setMaximumTouchPoints(self,max:int)",
    "PySide2.QtGui.QTouchDevice.setName(self,name:QString)",
    "PySide2.QtGui.QTouchDevice.setType(self,devType:PySide2.QtGui.QTouchDevice.DeviceType)",
    "PySide2.QtGui.QTouchDevice.type(self)->PySide2.QtGui.QTouchDevice.DeviceType",
    nullptr}; // Sentinel

void init_QTouchDevice(PyObject *module)
{
    _Sbk_QTouchDevice_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTouchDevice",
        "QTouchDevice*",
        &Sbk_QTouchDevice_spec,
        &Shiboken::callCppDestructor< ::QTouchDevice >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTouchDevice_Type);
    InitSignatureStrings(pyType, QTouchDevice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTouchDevice_Type), Sbk_QTouchDevice_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTouchDevice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTouchDevice_TypeF(),
        QTouchDevice_PythonToCpp_QTouchDevice_PTR,
        is_QTouchDevice_PythonToCpp_QTouchDevice_PTR_Convertible,
        QTouchDevice_PTR_CppToPython_QTouchDevice);

    Shiboken::Conversions::registerConverterName(converter, "QTouchDevice");
    Shiboken::Conversions::registerConverterName(converter, "QTouchDevice*");
    Shiboken::Conversions::registerConverterName(converter, "QTouchDevice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTouchDevice).name());


    // Initialization of enums.

    // Initialization of enum 'DeviceType'.
    SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTouchDevice_TypeF(),
        "DeviceType",
        "2:PySide2.QtGui.QTouchDevice.DeviceType",
        "QTouchDevice::DeviceType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX],
        Sbk_QTouchDevice_TypeF(), "TouchScreen", (long) QTouchDevice::DeviceType::TouchScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX],
        Sbk_QTouchDevice_TypeF(), "TouchPad", (long) QTouchDevice::DeviceType::TouchPad))
        return;
    // Register converter for enum 'QTouchDevice::DeviceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX],
            QTouchDevice_DeviceType_CppToPython_QTouchDevice_DeviceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTouchDevice_DeviceType_PythonToCpp_QTouchDevice_DeviceType,
            is_QTouchDevice_DeviceType_PythonToCpp_QTouchDevice_DeviceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_DEVICETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTouchDevice::DeviceType");
        Shiboken::Conversions::registerConverterName(converter, "DeviceType");
    }
    // End of 'DeviceType' enum.

    // Initialization of enum 'CapabilityFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTouchDevice.Capabilities", SbkPySide2_QtGui_QTouchDevice_CapabilityFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTouchDevice_TypeF(),
        "CapabilityFlag",
        "2:PySide2.QtGui.QTouchDevice.CapabilityFlag",
        "QTouchDevice::CapabilityFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "Position", (long) QTouchDevice::CapabilityFlag::Position))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "Area", (long) QTouchDevice::CapabilityFlag::Area))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "Pressure", (long) QTouchDevice::CapabilityFlag::Pressure))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "Velocity", (long) QTouchDevice::CapabilityFlag::Velocity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "RawPositions", (long) QTouchDevice::CapabilityFlag::RawPositions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "NormalizedPosition", (long) QTouchDevice::CapabilityFlag::NormalizedPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
        Sbk_QTouchDevice_TypeF(), "MouseEmulation", (long) QTouchDevice::CapabilityFlag::MouseEmulation))
        return;
    // Register converter for enum 'QTouchDevice::CapabilityFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
            QTouchDevice_CapabilityFlag_CppToPython_QTouchDevice_CapabilityFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTouchDevice_CapabilityFlag_PythonToCpp_QTouchDevice_CapabilityFlag,
            is_QTouchDevice_CapabilityFlag_PythonToCpp_QTouchDevice_CapabilityFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_CAPABILITYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTouchDevice::CapabilityFlag");
        Shiboken::Conversions::registerConverterName(converter, "CapabilityFlag");
    }
    // Register converter for flag 'QFlags<QTouchDevice::CapabilityFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX],
            QFlags_QTouchDevice_CapabilityFlag__CppToPython_QFlags_QTouchDevice_CapabilityFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTouchDevice_CapabilityFlag_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_,
            is_QTouchDevice_CapabilityFlag_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTouchDevice_CapabilityFlag__PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_,
            is_QFlags_QTouchDevice_CapabilityFlag__PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag_,
            is_number_PythonToCpp_QFlags_QTouchDevice_CapabilityFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTOUCHDEVICE_CAPABILITYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTouchDevice::Capabilities");
        Shiboken::Conversions::registerConverterName(converter, "Capabilities");
    }
    // End of 'CapabilityFlag' enum/flags.

    qRegisterMetaType< ::QTouchDevice::DeviceType >("QTouchDevice::DeviceType");
    qRegisterMetaType< ::QTouchDevice::CapabilityFlag >("QTouchDevice::CapabilityFlag");
    qRegisterMetaType< ::QTouchDevice::Capabilities >("QTouchDevice::Capabilities");
}
