/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtgui_python.h"

#include <QtGui/qrgb.h>


// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtGuiTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtGuiModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtGuiTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtGui_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtGuiTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------
static PyObject *SbkQtGuiModule_qAlpha(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qAlpha(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // qAlpha(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qAlpha_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qAlpha(uint)
            int cppResult = qAlpha(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qBlue(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qBlue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qBlue(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // qBlue(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qBlue_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qBlue(uint)
            int cppResult = qBlue(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qBlue_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qGray(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qGray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto SbkQtGuiModule_qGray_TypeError;

    if (!PyArg_UnpackTuple(args, "qGray", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: qGray(int,int,int)
    // 1: qGray(uint)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 1; // qGray(uint)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // qGray(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qGray_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // qGray(int r, int g, int b)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // qGray(int,int,int)
                int cppResult = qGray(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // qGray(unsigned int rgb)
        {
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // qGray(uint)
                int cppResult = qGray(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qGray_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qGreen(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qGreen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qGreen(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // qGreen(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qGreen_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qGreen(uint)
            int cppResult = qGreen(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qGreen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qIsGray(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qIsGray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qIsGray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // qIsGray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qIsGray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qIsGray(uint)
            bool cppResult = qIsGray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qIsGray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qRed(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qRed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: qRed(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // qRed(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qRed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qRed(uint)
            int cppResult = qRed(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qRed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qRgb(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qRgb", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: qRgb(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // qRgb(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qRgb_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // qRgb(int,int,int)
            unsigned int cppResult = qRgb(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *SbkQtGuiModule_qRgba(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.qRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "qRgba", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: qRgba(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // qRgba(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto SbkQtGuiModule_qRgba_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // qRgba(int,int,int,int)
            unsigned int cppResult = qRgba(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    SbkQtGuiModule_qRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static PyMethodDef QtGui_methods[] = {
    {"qAlpha", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qAlpha), METH_O},
    {"qBlue", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qBlue), METH_O},
    {"qGray", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qGray), METH_VARARGS},
    {"qGreen", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qGreen), METH_O},
    {"qIsGray", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qIsGray), METH_O},
    {"qRed", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qRed), METH_O},
    {"qRgb", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qRgb), METH_VARARGS},
    {"qRgba", reinterpret_cast<PyCFunction>(SbkQtGuiModule_qRgba), METH_VARARGS},
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QtGuiQt(PyObject *module);
void init_QVector4D(PyObject *module);
void init_QVector3D(PyObject *module);
void init_QVector2D(PyObject *module);
void init_QTransform(PyObject *module);
void init_QTouchDevice(PyObject *module);
void init_QTextTableCell(PyObject *module);
void init_QTextOption(PyObject *module);
void init_QTextOption_Tab(PyObject *enclosingClass);
void init_QTextObjectInterface(PyObject *module);
void init_QTextLine(PyObject *module);
void init_QTextLength(PyObject *module);
void init_QTextItem(PyObject *module);
void init_QTextInlineObject(PyObject *module);
void init_QTextFragment(PyObject *module);
void init_QTextFormat(PyObject *module);
void init_QTextFrameFormat(PyObject *module);
void init_QTextTableFormat(PyObject *module);
void init_QTextListFormat(PyObject *module);
void init_QTextCursor(PyObject *module);
void init_QTextCharFormat(PyObject *module);
void init_QTextImageFormat(PyObject *module);
void init_QTextTableCellFormat(PyObject *module);
void init_QTextBlockUserData(PyObject *module);
void init_QTextBlockFormat(PyObject *module);
void init_QTextBlock(PyObject *module);
void init_QTextBlock_iterator(PyObject *enclosingClass);
void init_QSurfaceFormat(PyObject *module);
void init_QSurface(PyObject *module);
void init_QStandardItem(PyObject *module);
void init_QRegion(PyObject *module);
void init_QRawFont(PyObject *module);
void init_QQuaternion(PyObject *module);
void init_QPolygonF(PyObject *module);
void init_QPolygon(PyObject *module);
void init_QPointingDeviceUniqueId(PyObject *module);
void init_QPixmapCache(PyObject *module);
void init_QPixmapCache_Key(PyObject *enclosingClass);
void init_QPixelFormat(PyObject *module);
void init_QPictureIO(PyObject *module);
void init_QPen(PyObject *module);
void init_QPalette(PyObject *module);
void init_QPainterPathStroker(PyObject *module);
void init_QPainterPath(PyObject *module);
void init_QPainterPath_Element(PyObject *enclosingClass);
void init_QPaintEngineState(PyObject *module);
void init_QPaintEngine(PyObject *module);
void init_QPaintDevice(PyObject *module);
void init_QPicture(PyObject *module);
void init_QPagedPaintDevice(PyObject *module);
void init_QPagedPaintDevice_Margins(PyObject *enclosingClass);
void init_QPageSize(PyObject *module);
void init_QOpenGLVersionProfile(PyObject *module);
void init_QOpenGLTextureBlitter(PyObject *module);
void init_QOpenGLTexture(PyObject *module);
void init_QOpenGLPixelTransferOptions(PyObject *module);
void init_QOpenGLPaintDevice(PyObject *module);
void init_QOpenGLFunctions(PyObject *module);
void init_QOpenGLFramebufferObjectFormat(PyObject *module);
void init_QOpenGLFramebufferObject(PyObject *module);
void init_QOpenGLExtraFunctions(PyObject *module);
void init_QOpenGLDebugMessage(PyObject *module);
void init_QOpenGLBuffer(PyObject *module);
void init_QMatrix4x4(PyObject *module);
void init_QMatrix(PyObject *module);
void init_QKeySequence(PyObject *module);
void init_QImageIOHandler(PyObject *module);
void init_QIconEngine(PyObject *module);
void init_QGradient(PyObject *module);
void init_QLinearGradient(PyObject *module);
void init_QRadialGradient(PyObject *module);
void init_QMatrix3x2(PyObject *module);
void init_QMatrix2x4(PyObject *module);
void init_QMatrix2x3(PyObject *module);
void init_QMatrix2x2(PyObject *module);
void init_QMatrix4x3(PyObject *module);
void init_QMatrix4x2(PyObject *module);
void init_QMatrix3x4(PyObject *module);
void init_QMatrix3x3(PyObject *module);
void init_QFontMetricsF(PyObject *module);
void init_QFontMetrics(PyObject *module);
void init_QFontInfo(PyObject *module);
void init_QFontDatabase(PyObject *module);
void init_QFont(PyObject *module);
void init_QStaticText(PyObject *module);
void init_QDesktopServices(PyObject *module);
void init_QCursor(PyObject *module);
void init_QConicalGradient(PyObject *module);
void init_QColorSpace(PyObject *module);
void init_QColor(PyObject *module);
void init_QtGuiQColorConstants(PyObject *module);
void init_QtGuiQColorConstantsStaticFields();
void init_QtGuiQColorConstants_Svg(PyObject *enclosingClass);
void init_QtGuiQColorConstants_SvgStaticFields();
void init_QBrush(PyObject *module);
void init_QAccessibleValueInterface(PyObject *module);
void init_QAccessibleTextInterface(PyObject *module);
void init_QAccessibleTableCellInterface(PyObject *module);
void init_QAccessibleInterface(PyObject *module);
void init_QAccessibleObject(PyObject *module);
void init_QAccessibleEvent(PyObject *module);
void init_QAccessibleValueChangeEvent(PyObject *module);
void init_QAccessibleTextCursorEvent(PyObject *module);
void init_QAccessibleTextUpdateEvent(PyObject *module);
void init_QAccessibleTextSelectionEvent(PyObject *module);
void init_QAccessibleTextRemoveEvent(PyObject *module);
void init_QAccessibleTextInsertEvent(PyObject *module);
void init_QAccessibleTableModelChangeEvent(PyObject *module);
void init_QAccessibleStateChangeEvent(PyObject *module);
void init_QAccessibleEditableTextInterface(PyObject *module);
void init_QAccessible(PyObject *module);
void init_QAccessible_State(PyObject *enclosingClass);
void init_QAbstractOpenGLFunctions(PyObject *module);
void init_QIcon(PyObject *module);
void init_QIconEngine_AvailableSizesArgument(PyObject *enclosingClass);
void init_QTextLayout(PyObject *module);
void init_QTextLayout_FormatRange(PyObject *enclosingClass);
void init_QImage(PyObject *module);
void init_QPixmap(PyObject *module);
void init_QBitmap(PyObject *module);
void init_QBackingStore(PyObject *module);
void init_QPainter(PyObject *module);
void init_QPainter_PixmapFragment(PyObject *enclosingClass);
void init_QPageLayout(PyObject *module);
void init_QSyntaxHighlighter(PyObject *module);
void init_QOpenGLContextGroup(PyObject *module);
void init_QOpenGLContext(PyObject *module);
void init_QStyleHints(PyObject *module);
void init_QOffscreenSurface(PyObject *module);
void init_QSessionManager(PyObject *module);
void init_QScreen(PyObject *module);
void init_QWindow(PyObject *module);
void init_QPaintDeviceWindow(PyObject *module);
void init_QOpenGLWindow(PyObject *module);
void init_QRasterWindow(PyObject *module);
void init_QPyTextObject(PyObject *module);
void init_QAbstractTextDocumentLayout(PyObject *module);
void init_QAbstractTextDocumentLayout_Selection(PyObject *enclosingClass);
void init_QAbstractTextDocumentLayout_PaintContext(PyObject *enclosingClass);
void init_QInputMethod(PyObject *module);
void init_QValidator(PyObject *module);
void init_QRegularExpressionValidator(PyObject *module);
void init_QRegExpValidator(PyObject *module);
void init_QIntValidator(PyObject *module);
void init_QDoubleValidator(PyObject *module);
void init_QPdfWriter(PyObject *module);
void init_QTextObject(PyObject *module);
void init_QTextBlockGroup(PyObject *module);
void init_QTextList(PyObject *module);
void init_QTextFrame(PyObject *module);
void init_QTextFrame_iterator(PyObject *enclosingClass);
void init_QTextTable(PyObject *module);
void init_QOpenGLVertexArrayObject(PyObject *module);
void init_QOpenGLVertexArrayObject_Binder(PyObject *enclosingClass);
void init_QOpenGLTimerQuery(PyObject *module);
void init_QDrag(PyObject *module);
void init_QOpenGLTimeMonitor(PyObject *module);
void init_QOpenGLShaderProgram(PyObject *module);
void init_QOpenGLShader(PyObject *module);
void init_QClipboard(PyObject *module);
void init_QOpenGLDebugLogger(PyObject *module);
void init_QFocusEvent(PyObject *module);
void init_QToolBarChangeEvent(PyObject *module);
void init_QPaintEvent(PyObject *module);
void init_QFileOpenEvent(PyObject *module);
void init_QStatusTipEvent(PyObject *module);
void init_QExposeEvent(PyObject *module);
void init_QEnterEvent(PyObject *module);
void init_QDropEvent(PyObject *module);
void init_QDragMoveEvent(PyObject *module);
void init_QDragEnterEvent(PyObject *module);
void init_QShowEvent(PyObject *module);
void init_QDragLeaveEvent(PyObject *module);
void init_QShortcutEvent(PyObject *module);
void init_QScrollPrepareEvent(PyObject *module);
void init_QScrollEvent(PyObject *module);
void init_QResizeEvent(PyObject *module);
void init_QInputMethodQueryEvent(PyObject *module);
void init_QInputMethodEvent(PyObject *module);
void init_QInputMethodEvent_Attribute(PyObject *enclosingClass);
void init_QInputEvent(PyObject *module);
void init_QTouchEvent(PyObject *module);
void init_QTouchEvent_TouchPoint(PyObject *enclosingClass);
void init_QTabletEvent(PyObject *module);
void init_QHoverEvent(PyObject *module);
void init_QKeyEvent(PyObject *module);
void init_QNativeGestureEvent(PyObject *module);
void init_QMouseEvent(PyObject *module);
void init_QContextMenuEvent(PyObject *module);
void init_QWheelEvent(PyObject *module);
void init_QCloseEvent(PyObject *module);
void init_QActionEvent(PyObject *module);
void init_QIconDragEvent(PyObject *module);
void init_QWindowStateChangeEvent(PyObject *module);
void init_QHideEvent(PyObject *module);
void init_QHelpEvent(PyObject *module);
void init_QWhatsThisClickedEvent(PyObject *module);
void init_QMoveEvent(PyObject *module);
void init_QGuiApplication(PyObject *module);
void init_QMovie(PyObject *module);
void init_QTextDocumentWriter(PyObject *module);
void init_QTextDocumentFragment(PyObject *module);
void init_QTextDocument(PyObject *module);
void init_QImageWriter(PyObject *module);
void init_QImageReader(PyObject *module);
void init_QStandardItemModel(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------

// Extended Converters.

// Extended implicit conversions for PySide2.QtCore.QPointF.
static void QPainterPath_Element_PythonToCpp_PySide2_QtCore_QPointF(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPointF *>(cppOut) = ::QPointF(*reinterpret_cast< ::QPainterPath::Element *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_ELEMENT_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_QPainterPath_Element_PythonToCpp_PySide2_QtCore_QPointF_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_ELEMENT_IDX]))
        return QPainterPath_Element_PythonToCpp_PySide2_QtCore_QPointF;
    return {};
}


// Primitive Type converters.

// C++ to Python conversion for type 'WId'.
static PyObject *WId_CppToPython_WId(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::WId *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtgui.cpp (return-pylong-voidptr)]
    return PyLong_FromVoidPtr(reinterpret_cast<void *>(cppInRef));
    // END of custom code block [file: ../glue/qtgui.cpp (return-pylong-voidptr)]
    // ========================================================================

}
// Python to C++ conversions for type 'WId'.
static void PyLong_PythonToCpp_WId(PyObject *pyIn, void *cppOut) {
    // ========================================================================
    // START of custom code block [file: ../glue/qtgui.cpp (conversion-pylong)]
    *reinterpret_cast<::WId *>(cppOut) = reinterpret_cast<WId>(PyLong_AsVoidPtr(pyIn));
    // END of custom code block [file: ../glue/qtgui.cpp (conversion-pylong)]
    // ========================================================================

}
static PythonToCppFunc is_PyLong_PythonToCpp_WId_Convertible(PyObject *pyIn) {
    if (PyLong_Check(pyIn))
        return PyLong_PythonToCpp_WId;
    return {};
}


// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QPair<int,int >'.
static PyObject *_QPair_int_int__CppToPython__QPair_int_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<int,int > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_int_int__PythonToCpp__QPair_int_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<int,int > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, pyIn))
        return _QPair_int_int__PythonToCpp__QPair_int_int_;
    return {};
}

// C++ to Python conversion for type 'QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> >'.
static PyObject *_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___CppToPython__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX])->converter, true, *PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, false, pyIn))
        return _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__;
    return {};
}

// C++ to Python conversion for type 'QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >'.
static PyObject *_QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____CppToPython__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], pyIn))
        return _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___;
    return {};
}

// C++ to Python conversion for type 'QList<QAccessibleInterface* >'.
static PyObject *_QList_QAccessibleInterfacePTR__CppToPython__QList_QAccessibleInterfacePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAccessibleInterface* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAccessibleInterface* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAccessibleInterface* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAccessibleInterfacePTR__PythonToCpp__QList_QAccessibleInterfacePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAccessibleInterface* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAccessibleInterface* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAccessibleInterfacePTR__PythonToCpp__QList_QAccessibleInterfacePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX], pyIn))
        return _QList_QAccessibleInterfacePTR__PythonToCpp__QList_QAccessibleInterfacePTR_;
    return {};
}

// C++ to Python conversion for type 'QPair<qreal,QColor >'.
static PyObject *_QPair_qreal_QColor__CppToPython__QPair_qreal_QColor_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<qreal,QColor > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_qreal_QColor__PythonToCpp__QPair_qreal_QColor_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<qreal,QColor > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_qreal_QColor__PythonToCpp__QPair_qreal_QColor__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, *PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX])->converter, false, pyIn))
        return _QPair_qreal_QColor__PythonToCpp__QPair_qreal_QColor_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QPair< qreal,QColor > > &'.
static PyObject *_constQVector_QPair_qreal_QColor__REF_CppToPython__constQVector_QPair_qreal_QColor__REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPair< qreal,QColor > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPair< qreal,QColor > >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPair< qreal,QColor > >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPair<qreal,QColor > cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QPair_qreal_QColor__REF_PythonToCpp__constQVector_QPair_qreal_QColor__REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPair< qreal,QColor > > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<qreal,QColor > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX], pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QPair_qreal_QColor__REF_PythonToCpp__constQVector_QPair_qreal_QColor__REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX], pyIn))
        return _constQVector_QPair_qreal_QColor__REF_PythonToCpp__constQVector_QPair_qreal_QColor__REF;
    return {};
}

// C++ to Python conversion for type 'QList<int >'.
static PyObject *_QList_int__CppToPython__QList_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_int__PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_int__PythonToCpp__QList_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _QList_int__PythonToCpp__QList_int_;
    return {};
}

// C++ to Python conversion for type 'QList<QFontDatabase::WritingSystem >'.
static PyObject *_QList_QFontDatabase_WritingSystem__CppToPython__QList_QFontDatabase_WritingSystem_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QFontDatabase::WritingSystem > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QFontDatabase::WritingSystem >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QFontDatabase::WritingSystem cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QFontDatabase_WritingSystem__PythonToCpp__QList_QFontDatabase_WritingSystem_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QFontDatabase::WritingSystem > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QFontDatabase::WritingSystem cppItem{QFontDatabase::Any};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QFontDatabase_WritingSystem__PythonToCpp__QList_QFontDatabase_WritingSystem__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, pyIn))
        return _QList_QFontDatabase_WritingSystem__PythonToCpp__QList_QFontDatabase_WritingSystem_;
    return {};
}

// C++ to Python conversion for type 'QList<QWindow* >'.
static PyObject *_QList_QWindowPTR__CppToPython__QList_QWindowPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWindow* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWindow* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWindow* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWindow* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWindow* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QWindowPTR__PythonToCpp__QList_QWindowPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX], pyIn))
        return _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QScreen* >'.
static PyObject *_QList_QScreenPTR__CppToPython__QList_QScreenPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QScreen* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QScreen* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QScreen* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QScreen* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScreen* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QScreenPTR__PythonToCpp__QList_QScreenPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], pyIn))
        return _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QSize >'.
static PyObject *_QList_QSize__CppToPython__QList_QSize_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSize > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSize >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSize cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSize__PythonToCpp__QList_QSize_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSize > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSize cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSize__PythonToCpp__QList_QSize__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyIn))
        return _QList_QSize__PythonToCpp__QList_QSize_;
    return {};
}

// C++ to Python conversion for type 'QVector<unsigned int >'.
static PyObject *_QVector_unsignedint__CppToPython__QVector_unsignedint_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<unsigned int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<unsigned int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<unsigned int >::size_type idx = 0; idx < vectorSize; ++idx) {
        unsigned int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_unsignedint__PythonToCpp__QVector_unsignedint_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<unsigned int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        unsigned int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_unsignedint__PythonToCpp__QVector_unsignedint__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), pyIn))
        return _QVector_unsignedint__PythonToCpp__QVector_unsignedint_;
    return {};
}

// C++ to Python conversion for type 'const QList<QInputMethodEvent::Attribute > &'.
static PyObject *_constQList_QInputMethodEvent_Attribute_REF_CppToPython__constQList_QInputMethodEvent_Attribute_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QInputMethodEvent::Attribute > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QInputMethodEvent::Attribute >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QInputMethodEvent::Attribute cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QInputMethodEvent_Attribute_REF_PythonToCpp__constQList_QInputMethodEvent_Attribute_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QInputMethodEvent::Attribute > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QInputMethodEvent::Attribute cppItem = ::QInputMethodEvent::Attribute(QInputMethodEvent::TextFormat, int(0), int(0));
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QInputMethodEvent_Attribute_REF_PythonToCpp__constQList_QInputMethodEvent_Attribute_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_ATTRIBUTE_IDX]), pyIn))
        return _constQList_QInputMethodEvent_Attribute_REF_PythonToCpp__constQList_QInputMethodEvent_Attribute_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QKeySequence >'.
static PyObject *_QList_QKeySequence__CppToPython__QList_QKeySequence_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QKeySequence > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QKeySequence >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QKeySequence cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QKeySequence__PythonToCpp__QList_QKeySequence_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QKeySequence > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QKeySequence cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QKeySequence__PythonToCpp__QList_QKeySequence__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyIn))
        return _QList_QKeySequence__PythonToCpp__QList_QKeySequence_;
    return {};
}

// C++ to Python conversion for type 'QList<float >'.
static PyObject *_QList_float__CppToPython__QList_float_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<float > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<float >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        float cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_float__PythonToCpp__QList_float_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<float > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        float cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_float__PythonToCpp__QList_float__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyIn))
        return _QList_float__PythonToCpp__QList_float_;
    return {};
}

// C++ to Python conversion for type 'QSet<QByteArray >'.
static PyObject *_QSet_QByteArray__CppToPython__QSet_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QSet<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QSet<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QSet_QByteArray__PythonToCpp__QSet_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QSet<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QSet_QByteArray__PythonToCpp__QSet_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QSet_QByteArray__PythonToCpp__QSet_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QOpenGLContext* >'.
static PyObject *_QList_QOpenGLContextPTR__CppToPython__QList_QOpenGLContextPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QOpenGLContext* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QOpenGLContext* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QOpenGLContext* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QOpenGLContextPTR__PythonToCpp__QList_QOpenGLContextPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QOpenGLContext* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QOpenGLContext* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QOpenGLContextPTR__PythonToCpp__QList_QOpenGLContextPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX], pyIn))
        return _QList_QOpenGLContextPTR__PythonToCpp__QList_QOpenGLContextPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QOpenGLDebugMessage >'.
static PyObject *_QList_QOpenGLDebugMessage__CppToPython__QList_QOpenGLDebugMessage_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QOpenGLDebugMessage > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QOpenGLDebugMessage >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QOpenGLDebugMessage cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QOpenGLDebugMessage__PythonToCpp__QList_QOpenGLDebugMessage_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QOpenGLDebugMessage > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QOpenGLDebugMessage cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QOpenGLDebugMessage__PythonToCpp__QList_QOpenGLDebugMessage__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLDEBUGMESSAGE_IDX]), pyIn))
        return _QList_QOpenGLDebugMessage__PythonToCpp__QList_QOpenGLDebugMessage_;
    return {};
}

// C++ to Python conversion for type 'QVector<QSize >'.
static PyObject *_QVector_QSize__CppToPython__QVector_QSize_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QSize > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QSize >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QSize >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QSize cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QSize__PythonToCpp__QVector_QSize_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QSize > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSize cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QSize__PythonToCpp__QVector_QSize__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyIn))
        return _QVector_QSize__PythonToCpp__QVector_QSize_;
    return {};
}

// C++ to Python conversion for type 'QVector<float >'.
static PyObject *_QVector_float__CppToPython__QVector_float_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<float > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<float >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<float >::size_type idx = 0; idx < vectorSize; ++idx) {
        float cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_float__PythonToCpp__QVector_float_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<float > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        float cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_float__PythonToCpp__QVector_float__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<float>(), pyIn))
        return _QVector_float__PythonToCpp__QVector_float_;
    return {};
}

// C++ to Python conversion for type 'QList<QOpenGLShader* >'.
static PyObject *_QList_QOpenGLShaderPTR__CppToPython__QList_QOpenGLShaderPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QOpenGLShader* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QOpenGLShader* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QOpenGLShader* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QOpenGLShaderPTR__PythonToCpp__QList_QOpenGLShaderPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QOpenGLShader* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QOpenGLShader* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QOpenGLShaderPTR__PythonToCpp__QList_QOpenGLShaderPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QOPENGLSHADER_IDX], pyIn))
        return _QList_QOpenGLShaderPTR__PythonToCpp__QList_QOpenGLShaderPTR_;
    return {};
}

// C++ to Python conversion for type 'QPair<float,float >'.
static PyObject *_QPair_float_float__CppToPython__QPair_float_float_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<float,float > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_float_float__PythonToCpp__QPair_float_float_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<float,float > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<float>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_float_float__PythonToCpp__QPair_float_float__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<float>(), false, Shiboken::Conversions::PrimitiveTypeConverter<float>(), false, pyIn))
        return _QPair_float_float__PythonToCpp__QPair_float_float_;
    return {};
}

// C++ to Python conversion for type 'QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter >'.
static PyObject *_QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__CppToPython__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__PythonToCpp__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__PythonToCpp__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, false, *PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTURE_FILTER_IDX])->converter, false, pyIn))
        return _QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__PythonToCpp__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter_;
    return {};
}

// C++ to Python conversion for type 'QVector<QPoint >'.
static PyObject *_QVector_QPoint__CppToPython__QVector_QPoint_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPoint > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPoint >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPoint >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPoint cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QPoint__PythonToCpp__QVector_QPoint_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPoint > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPoint cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QPoint__PythonToCpp__QVector_QPoint__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyIn))
        return _QVector_QPoint__PythonToCpp__QVector_QPoint_;
    return {};
}

// C++ to Python conversion for type 'QVector<QPointF >'.
static PyObject *_QVector_QPointF__CppToPython__QVector_QPointF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPointF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPointF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPointF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QPointF__PythonToCpp__QVector_QPointF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QPointF__PythonToCpp__QVector_QPointF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return _QVector_QPointF__PythonToCpp__QVector_QPointF_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QLine > &'.
static PyObject *_constQVector_QLine_REF_CppToPython__constQVector_QLine_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QLine > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QLine >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QLine >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QLine cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QLine > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLine cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pyIn))
        return _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QLineF > &'.
static PyObject *_constQVector_QLineF_REF_CppToPython__constQVector_QLineF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QLineF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QLineF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QLineF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QLineF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QLineF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLineF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pyIn))
        return _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QRect > &'.
static PyObject *_constQVector_QRect_REF_CppToPython__constQVector_QRect_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QRect > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QRect >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QRect >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QRect cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QRect > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRect cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyIn))
        return _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QRectF > &'.
static PyObject *_constQVector_QRectF_REF_CppToPython__constQVector_QRectF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QRectF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QRectF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QRectF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QRectF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QRectF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRectF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyIn))
        return _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QPolygonF >'.
static PyObject *_QList_QPolygonF__CppToPython__QList_QPolygonF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPolygonF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPolygonF >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPolygonF cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPolygonF__PythonToCpp__QList_QPolygonF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPolygonF > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPolygonF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPolygonF__PythonToCpp__QList_QPolygonF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOLYGONF_IDX]), pyIn))
        return _QList_QPolygonF__PythonToCpp__QList_QPolygonF_;
    return {};
}

// C++ to Python conversion for type 'QVector<qreal >'.
static PyObject *_QVector_qreal__CppToPython__QVector_qreal_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<qreal >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<qreal >::size_type idx = 0; idx < vectorSize; ++idx) {
        qreal cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_qreal__PythonToCpp__QVector_qreal_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_qreal__PythonToCpp__QVector_qreal__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _QVector_qreal__PythonToCpp__QVector_qreal_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPoint > &'.
static PyObject *_constQList_QPoint_REF_CppToPython__constQList_QPoint_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPoint > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPoint >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPoint cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPoint_REF_PythonToCpp__constQList_QPoint_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPoint > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPoint cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPoint_REF_PythonToCpp__constQList_QPoint_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyIn))
        return _constQList_QPoint_REF_PythonToCpp__constQList_QPoint_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QPointF > &'.
static PyObject *_constQList_QPointF_REF_CppToPython__constQList_QPointF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPointF >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPointF cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<quint32 > &'.
static PyObject *_constQVector_quint32_REF_CppToPython__constQVector_quint32_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<quint32 > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<quint32 >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<quint32 >::size_type idx = 0; idx < vectorSize; ++idx) {
        quint32 cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_quint32_REF_PythonToCpp__constQVector_quint32_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<quint32 > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        quint32 cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_quint32_REF_PythonToCpp__constQVector_quint32_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), pyIn))
        return _constQVector_quint32_REF_PythonToCpp__constQVector_quint32_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QStandardItem* > &'.
static PyObject *_constQList_QStandardItemPTR_REF_CppToPython__constQList_QStandardItemPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QStandardItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QStandardItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QStandardItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTANDARDITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QStandardItemPTR_REF_PythonToCpp__constQList_QStandardItemPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QStandardItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QStandardItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTANDARDITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QStandardItemPTR_REF_PythonToCpp__constQList_QStandardItemPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QSTANDARDITEM_IDX], pyIn))
        return _constQList_QStandardItemPTR_REF_PythonToCpp__constQList_QStandardItemPTR_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<int > &'.
static PyObject *_constQVector_int_REF_CppToPython__constQVector_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_int_REF_PythonToCpp__constQVector_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _constQVector_int_REF_PythonToCpp__constQVector_int_REF;
    return {};
}

// C++ to Python conversion for type 'const QHash<int,QByteArray > &'.
static PyObject *_constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<int,QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<int,QByteArray >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QByteArray value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, pyIn))
        return _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF;
    return {};
}

// C++ to Python conversion for type 'QMap<int,QVariant >'.
static PyObject *_QMap_int_QVariant__CppToPython__QMap_int_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<int,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<int,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPersistentModelIndex > &'.
static PyObject *_constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPersistentModelIndex >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPersistentModelIndex cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPersistentModelIndex cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyIn))
        return _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF;
    return {};
}

// C++ to Python conversion for type 'QVector<QTextLayout::FormatRange >'.
static PyObject *_QVector_QTextLayout_FormatRange__CppToPython__QVector_QTextLayout_FormatRange_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QTextLayout::FormatRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QTextLayout::FormatRange >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QTextLayout::FormatRange >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QTextLayout::FormatRange cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QTextLayout_FormatRange__PythonToCpp__QVector_QTextLayout_FormatRange_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QTextLayout::FormatRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextLayout::FormatRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QTextLayout_FormatRange__PythonToCpp__QVector_QTextLayout_FormatRange__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyIn))
        return _QVector_QTextLayout_FormatRange__PythonToCpp__QVector_QTextLayout_FormatRange_;
    return {};
}

// C++ to Python conversion for type 'QVector<QTextLength >'.
static PyObject *_QVector_QTextLength__CppToPython__QVector_QTextLength_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QTextLength > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QTextLength >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QTextLength >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QTextLength cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QTextLength__PythonToCpp__QVector_QTextLength_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QTextLength > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextLength cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QTextLength__PythonToCpp__QVector_QTextLength__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), pyIn))
        return _QVector_QTextLength__PythonToCpp__QVector_QTextLength_;
    return {};
}

// C++ to Python conversion for type 'const QList<QTextOption::Tab > &'.
static PyObject *_constQList_QTextOption_Tab_REF_CppToPython__constQList_QTextOption_Tab_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextOption::Tab > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextOption::Tab >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextOption::Tab cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QTextOption_Tab_REF_PythonToCpp__constQList_QTextOption_Tab_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextOption::Tab > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextOption::Tab cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QTextOption_Tab_REF_PythonToCpp__constQList_QTextOption_Tab_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), pyIn))
        return _constQList_QTextOption_Tab_REF_PythonToCpp__constQList_QTextOption_Tab_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QTextBlock >'.
static PyObject *_QList_QTextBlock__CppToPython__QList_QTextBlock_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextBlock > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextBlock >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextBlock cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTextBlock__PythonToCpp__QList_QTextBlock_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextBlock > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextBlock cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTextBlock__PythonToCpp__QList_QTextBlock__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pyIn))
        return _QList_QTextBlock__PythonToCpp__QList_QTextBlock_;
    return {};
}

// C++ to Python conversion for type 'QVector<QTextFormat >'.
static PyObject *_QVector_QTextFormat__CppToPython__QVector_QTextFormat_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QTextFormat > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QTextFormat >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QTextFormat >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QTextFormat cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QTextFormat__PythonToCpp__QVector_QTextFormat_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QTextFormat > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextFormat cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QTextFormat__PythonToCpp__QVector_QTextFormat__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pyIn))
        return _QVector_QTextFormat__PythonToCpp__QVector_QTextFormat_;
    return {};
}

// C++ to Python conversion for type 'QList<QTextFrame* >'.
static PyObject *_QList_QTextFramePTR__CppToPython__QList_QTextFramePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextFrame* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextFrame* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextFrame* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTextFramePTR__PythonToCpp__QList_QTextFramePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextFrame* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextFrame* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTextFramePTR__PythonToCpp__QList_QTextFramePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX], pyIn))
        return _QList_QTextFramePTR__PythonToCpp__QList_QTextFramePTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QTextLayout::FormatRange >'.
static PyObject *_QList_QTextLayout_FormatRange__CppToPython__QList_QTextLayout_FormatRange_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextLayout::FormatRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextLayout::FormatRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextLayout::FormatRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTextLayout_FormatRange__PythonToCpp__QList_QTextLayout_FormatRange_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextLayout::FormatRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextLayout::FormatRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTextLayout_FormatRange__PythonToCpp__QList_QTextLayout_FormatRange__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_FORMATRANGE_IDX]), pyIn))
        return _QList_QTextLayout_FormatRange__PythonToCpp__QList_QTextLayout_FormatRange_;
    return {};
}

// C++ to Python conversion for type 'const QList<qreal > &'.
static PyObject *_constQList_qreal_REF_CppToPython__constQList_qreal_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<qreal >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        qreal cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF;
    return {};
}

// C++ to Python conversion for type 'QList<const QTouchDevice* >'.
static PyObject *_QList_constQTouchDevicePTR__CppToPython__QList_constQTouchDevicePTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<const QTouchDevice* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<const QTouchDevice* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        const ::QTouchDevice* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_constQTouchDevicePTR__PythonToCpp__QList_constQTouchDevicePTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<const QTouchDevice* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTouchDevice* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_constQTouchDevicePTR__PythonToCpp__QList_constQTouchDevicePTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QTOUCHDEVICE_IDX], pyIn))
        return _QList_constQTouchDevicePTR__PythonToCpp__QList_constQTouchDevicePTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QTouchEvent::TouchPoint > &'.
static PyObject *_constQList_QTouchEvent_TouchPoint_REF_CppToPython__constQList_QTouchEvent_TouchPoint_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTouchEvent::TouchPoint > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTouchEvent::TouchPoint >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTouchEvent::TouchPoint cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QTouchEvent_TouchPoint_REF_PythonToCpp__constQList_QTouchEvent_TouchPoint_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTouchEvent::TouchPoint > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTouchEvent::TouchPoint cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QTouchEvent_TouchPoint_REF_PythonToCpp__constQList_QTouchEvent_TouchPoint_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_TOUCHPOINT_IDX]), pyIn))
        return _constQList_QTouchEvent_TouchPoint_REF_PythonToCpp__constQList_QTouchEvent_TouchPoint_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtGui",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtGui_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtGui_SignatureStrings[] = {
    "PySide2.QtGui.qAlpha(rgb:unsigned int)->int",
    "PySide2.QtGui.qBlue(rgb:unsigned int)->int",
    "1:PySide2.QtGui.qGray(r:int,g:int,b:int)->int",
    "0:PySide2.QtGui.qGray(rgb:unsigned int)->int",
    "PySide2.QtGui.qGreen(rgb:unsigned int)->int",
    "PySide2.QtGui.qIsGray(rgb:unsigned int)->bool",
    "PySide2.QtGui.qRed(rgb:unsigned int)->int",
    "PySide2.QtGui.qRgb(r:int,g:int,b:int)->unsigned int",
    "PySide2.QtGui.qRgba(r:int,g:int,b:int,a:int)->unsigned int",
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtGui)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtGui_IDX_COUNT];
    SbkPySide2_QtGuiTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtGui_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtGuiTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtGui", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtGui", QtGui_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtGuiModuleObject = module;

    // Initialize classes in the type system
    init_QtGuiQt(module);
    init_QVector4D(module);
    init_QVector3D(module);
    init_QVector2D(module);
    init_QTransform(module);
    init_QTouchDevice(module);
    init_QTextTableCell(module);
    init_QTextOption(module);
    init_QTextOption_Tab(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX])->tp_dict);
    init_QTextObjectInterface(module);
    init_QTextLine(module);
    init_QTextLength(module);
    init_QTextItem(module);
    init_QTextInlineObject(module);
    init_QTextFragment(module);
    init_QTextFormat(module);
    init_QTextFrameFormat(module);
    init_QTextTableFormat(module);
    init_QTextListFormat(module);
    init_QTextCursor(module);
    init_QTextCharFormat(module);
    init_QTextImageFormat(module);
    init_QTextTableCellFormat(module);
    init_QTextBlockUserData(module);
    init_QTextBlockFormat(module);
    init_QTextBlock(module);
    init_QTextBlock_iterator(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX])->tp_dict);
    init_QSurfaceFormat(module);
    init_QSurface(module);
    init_QStandardItem(module);
    init_QRegion(module);
    init_QRawFont(module);
    init_QQuaternion(module);
    init_QPolygonF(module);
    init_QPolygon(module);
    init_QPointingDeviceUniqueId(module);
    init_QPixmapCache(module);
    init_QPixmapCache_Key(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAPCACHE_IDX])->tp_dict);
    init_QPixelFormat(module);
    init_QPictureIO(module);
    init_QPen(module);
    init_QPalette(module);
    init_QPainterPathStroker(module);
    init_QPainterPath(module);
    init_QPainterPath_Element(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX])->tp_dict);
    init_QPaintEngineState(module);
    init_QPaintEngine(module);
    init_QPaintDevice(module);
    init_QPicture(module);
    init_QPagedPaintDevice(module);
    init_QPagedPaintDevice_Margins(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX])->tp_dict);
    init_QPageSize(module);
    init_QOpenGLVersionProfile(module);
    init_QOpenGLTextureBlitter(module);
    init_QOpenGLTexture(module);
    init_QOpenGLPixelTransferOptions(module);
    init_QOpenGLPaintDevice(module);
    init_QOpenGLFunctions(module);
    init_QOpenGLFramebufferObjectFormat(module);
    init_QOpenGLFramebufferObject(module);
    init_QOpenGLExtraFunctions(module);
    init_QOpenGLDebugMessage(module);
    init_QOpenGLBuffer(module);
    init_QMatrix4x4(module);
    init_QMatrix(module);
    init_QKeySequence(module);
    init_QImageIOHandler(module);
    init_QIconEngine(module);
    init_QGradient(module);
    init_QLinearGradient(module);
    init_QRadialGradient(module);
    init_QMatrix3x2(module);
    init_QMatrix2x4(module);
    init_QMatrix2x3(module);
    init_QMatrix2x2(module);
    init_QMatrix4x3(module);
    init_QMatrix4x2(module);
    init_QMatrix3x4(module);
    init_QMatrix3x3(module);
    init_QFontMetricsF(module);
    init_QFontMetrics(module);
    init_QFontInfo(module);
    init_QFontDatabase(module);
    init_QFont(module);
    init_QStaticText(module);
    init_QDesktopServices(module);
    init_QCursor(module);
    init_QConicalGradient(module);
    init_QColorSpace(module);
    init_QColor(module);
    init_QtGuiQColorConstants(module);
    init_QtGuiQColorConstants_Svg(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QtGuiQCOLORCONSTANTS_IDX])->tp_dict);
    init_QBrush(module);
    init_QAccessibleValueInterface(module);
    init_QAccessibleTextInterface(module);
    init_QAccessibleTableCellInterface(module);
    init_QAccessibleInterface(module);
    init_QAccessibleObject(module);
    init_QAccessibleEvent(module);
    init_QAccessibleValueChangeEvent(module);
    init_QAccessibleTextCursorEvent(module);
    init_QAccessibleTextUpdateEvent(module);
    init_QAccessibleTextSelectionEvent(module);
    init_QAccessibleTextRemoveEvent(module);
    init_QAccessibleTextInsertEvent(module);
    init_QAccessibleTableModelChangeEvent(module);
    init_QAccessibleStateChangeEvent(module);
    init_QAccessibleEditableTextInterface(module);
    init_QAccessible(module);
    init_QAccessible_State(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLE_IDX])->tp_dict);
    init_QAbstractOpenGLFunctions(module);
    init_QIcon(module);
    init_QIconEngine_AvailableSizesArgument(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QICONENGINE_IDX])->tp_dict);
    init_QTextLayout(module);
    init_QTextLayout_FormatRange(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLAYOUT_IDX])->tp_dict);
    init_QImage(module);
    init_QPixmap(module);
    init_QBitmap(module);
    init_QBackingStore(module);
    init_QPainter(module);
    init_QPainter_PixmapFragment(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX])->tp_dict);
    init_QPageLayout(module);
    init_QSyntaxHighlighter(module);
    init_QOpenGLContextGroup(module);
    init_QOpenGLContext(module);
    init_QStyleHints(module);
    init_QOffscreenSurface(module);
    init_QSessionManager(module);
    init_QScreen(module);
    init_QWindow(module);
    init_QPaintDeviceWindow(module);
    init_QOpenGLWindow(module);
    init_QRasterWindow(module);
    init_QPyTextObject(module);
    init_QAbstractTextDocumentLayout(module);
    init_QAbstractTextDocumentLayout_Selection(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX])->tp_dict);
    init_QAbstractTextDocumentLayout_PaintContext(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX])->tp_dict);
    init_QInputMethod(module);
    init_QValidator(module);
    init_QRegularExpressionValidator(module);
    init_QRegExpValidator(module);
    init_QIntValidator(module);
    init_QDoubleValidator(module);
    init_QPdfWriter(module);
    init_QTextObject(module);
    init_QTextBlockGroup(module);
    init_QTextList(module);
    init_QTextFrame(module);
    init_QTextFrame_iterator(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX])->tp_dict);
    init_QTextTable(module);
    init_QOpenGLVertexArrayObject(module);
    init_QOpenGLVertexArrayObject_Binder(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERTEXARRAYOBJECT_IDX])->tp_dict);
    init_QOpenGLTimerQuery(module);
    init_QDrag(module);
    init_QOpenGLTimeMonitor(module);
    init_QOpenGLShaderProgram(module);
    init_QOpenGLShader(module);
    init_QClipboard(module);
    init_QOpenGLDebugLogger(module);
    init_QFocusEvent(module);
    init_QToolBarChangeEvent(module);
    init_QPaintEvent(module);
    init_QFileOpenEvent(module);
    init_QStatusTipEvent(module);
    init_QExposeEvent(module);
    init_QEnterEvent(module);
    init_QDropEvent(module);
    init_QDragMoveEvent(module);
    init_QDragEnterEvent(module);
    init_QShowEvent(module);
    init_QDragLeaveEvent(module);
    init_QShortcutEvent(module);
    init_QScrollPrepareEvent(module);
    init_QScrollEvent(module);
    init_QResizeEvent(module);
    init_QInputMethodQueryEvent(module);
    init_QInputMethodEvent(module);
    init_QInputMethodEvent_Attribute(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX])->tp_dict);
    init_QInputEvent(module);
    init_QTouchEvent(module);
    init_QTouchEvent_TouchPoint(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX])->tp_dict);
    init_QTabletEvent(module);
    init_QHoverEvent(module);
    init_QKeyEvent(module);
    init_QNativeGestureEvent(module);
    init_QMouseEvent(module);
    init_QContextMenuEvent(module);
    init_QWheelEvent(module);
    init_QCloseEvent(module);
    init_QActionEvent(module);
    init_QIconDragEvent(module);
    init_QWindowStateChangeEvent(module);
    init_QHideEvent(module);
    init_QHelpEvent(module);
    init_QWhatsThisClickedEvent(module);
    init_QMoveEvent(module);
    init_QGuiApplication(module);
    init_QMovie(module);
    init_QTextDocumentWriter(module);
    init_QTextDocumentFragment(module);
    init_QTextDocument(module);
    init_QImageWriter(module);
    init_QImageReader(module);
    init_QStandardItemModel(module);

    // Register converter for type 'PySide2.QtGui.WId'.
    SbkPySide2_QtGuiTypeConverters[SBK_WID_IDX] = Shiboken::Conversions::createConverter(&PyLong_Type, WId_CppToPython_WId);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_WID_IDX], "WId");
    // Add user defined implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_WID_IDX],
        PyLong_PythonToCpp_WId,
        is_PyLong_PythonToCpp_WId_Convertible);


    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QPair<int,int>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_int_int__CppToPython__QPair_int_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX], "QPair<int,int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX],
        _QPair_int_int__PythonToCpp__QPair_int_int_,
        is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible);

    // Register converter for type 'QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___CppToPython__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], "QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX],
        _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__,
        is__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___Convertible);

    // Register converter for type 'QVector<QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____CppToPython__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], "QVector<QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX],
        _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___,
        is__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____Convertible);

    // Register converter for type 'QList<QAccessibleInterface*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QACCESSIBLEINTERFACEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAccessibleInterfacePTR__CppToPython__QList_QAccessibleInterfacePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QACCESSIBLEINTERFACEPTR_IDX], "QList<QAccessibleInterface*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QACCESSIBLEINTERFACEPTR_IDX],
        _QList_QAccessibleInterfacePTR__PythonToCpp__QList_QAccessibleInterfacePTR_,
        is__QList_QAccessibleInterfacePTR__PythonToCpp__QList_QAccessibleInterfacePTR__Convertible);

    // Register converter for type 'QPair<qreal,QColor>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_qreal_QColor__CppToPython__QPair_qreal_QColor_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX], "QPair<qreal,QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QREAL_QCOLOR_IDX],
        _QPair_qreal_QColor__PythonToCpp__QPair_qreal_QColor_,
        is__QPair_qreal_QColor__PythonToCpp__QPair_qreal_QColor__Convertible);

    // Register converter for type 'const QVector<QPair<qreal,QColor>>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QPair_qreal_QColor__REF_CppToPython__constQVector_QPair_qreal_QColor__REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX], "const QVector<QPair<qreal,QColor>>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX], "QVector<QPair<qreal,QColor>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPAIR_QREAL_QCOLOR_IDX],
        _constQVector_QPair_qreal_QColor__REF_PythonToCpp__constQVector_QPair_qreal_QColor__REF,
        is__constQVector_QPair_qreal_QColor__REF_PythonToCpp__constQVector_QPair_qreal_QColor__REF_Convertible);

    // Register converter for type 'QList<int>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython__QList_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_INT_IDX],
        _QList_int__PythonToCpp__QList_int_,
        is__QList_int__PythonToCpp__QList_int__Convertible);

    // Register converter for type 'QList<QFontDatabase::WritingSystem>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QFontDatabase_WritingSystem__CppToPython__QList_QFontDatabase_WritingSystem_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX], "QList<QFontDatabase::WritingSystem>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX],
        _QList_QFontDatabase_WritingSystem__PythonToCpp__QList_QFontDatabase_WritingSystem_,
        is__QList_QFontDatabase_WritingSystem__PythonToCpp__QList_QFontDatabase_WritingSystem__Convertible);

    // Register converter for type 'QList<QWindow*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QWINDOWPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWindowPTR__CppToPython__QList_QWindowPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QWINDOWPTR_IDX], "QList<QWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QWINDOWPTR_IDX],
        _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_,
        is__QList_QWindowPTR__PythonToCpp__QList_QWindowPTR__Convertible);

    // Register converter for type 'QList<QScreen*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSCREENPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QScreenPTR__CppToPython__QList_QScreenPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSCREENPTR_IDX], "QList<QScreen*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSCREENPTR_IDX],
        _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_,
        is__QList_QScreenPTR__PythonToCpp__QList_QScreenPTR__Convertible);

    // Register converter for type 'QList<QSize>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSize__CppToPython__QList_QSize_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX], "QList<QSize>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSIZE_IDX],
        _QList_QSize__PythonToCpp__QList_QSize_,
        is__QList_QSize__PythonToCpp__QList_QSize__Convertible);

    // Register converter for type 'QVector<unsigned int>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_unsignedint__CppToPython__QVector_unsignedint_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX], "QVector<unsigned int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_UNSIGNEDINT_IDX],
        _QVector_unsignedint__PythonToCpp__QVector_unsignedint_,
        is__QVector_unsignedint__PythonToCpp__QVector_unsignedint__Convertible);

    // Register converter for type 'const QList<QInputMethodEvent::Attribute>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QInputMethodEvent_Attribute_REF_CppToPython__constQList_QInputMethodEvent_Attribute_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX], "const QList<QInputMethodEvent::Attribute>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX], "QList<QInputMethodEvent::Attribute>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QINPUTMETHODEVENT_ATTRIBUTE_IDX],
        _constQList_QInputMethodEvent_Attribute_REF_PythonToCpp__constQList_QInputMethodEvent_Attribute_REF,
        is__constQList_QInputMethodEvent_Attribute_REF_PythonToCpp__constQList_QInputMethodEvent_Attribute_REF_Convertible);

    // Register converter for type 'QList<QKeySequence>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QKeySequence__CppToPython__QList_QKeySequence_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX], "QList<QKeySequence>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QKEYSEQUENCE_IDX],
        _QList_QKeySequence__PythonToCpp__QList_QKeySequence_,
        is__QList_QKeySequence__PythonToCpp__QList_QKeySequence__Convertible);

    // Register converter for type 'QList<float>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_float__CppToPython__QList_float_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX], "QList<float>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_FLOAT_IDX],
        _QList_float__PythonToCpp__QList_float_,
        is__QList_float__PythonToCpp__QList_float__Convertible);

    // Register converter for type 'QSet<QByteArray>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QSET_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PySet_Type, _QSet_QByteArray__CppToPython__QSet_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QSET_QBYTEARRAY_IDX], "QSet<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QSET_QBYTEARRAY_IDX],
        _QSet_QByteArray__PythonToCpp__QSet_QByteArray_,
        is__QSet_QByteArray__PythonToCpp__QSet_QByteArray__Convertible);

    // Register converter for type 'QList<QOpenGLContext*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLCONTEXTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QOpenGLContextPTR__CppToPython__QList_QOpenGLContextPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLCONTEXTPTR_IDX], "QList<QOpenGLContext*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLCONTEXTPTR_IDX],
        _QList_QOpenGLContextPTR__PythonToCpp__QList_QOpenGLContextPTR_,
        is__QList_QOpenGLContextPTR__PythonToCpp__QList_QOpenGLContextPTR__Convertible);

    // Register converter for type 'QList<QOpenGLDebugMessage>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLDEBUGMESSAGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QOpenGLDebugMessage__CppToPython__QList_QOpenGLDebugMessage_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLDEBUGMESSAGE_IDX], "QList<QOpenGLDebugMessage>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLDEBUGMESSAGE_IDX],
        _QList_QOpenGLDebugMessage__PythonToCpp__QList_QOpenGLDebugMessage_,
        is__QList_QOpenGLDebugMessage__PythonToCpp__QList_QOpenGLDebugMessage__Convertible);

    // Register converter for type 'QVector<QSize>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QSIZE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QSize__CppToPython__QVector_QSize_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QSIZE_IDX], "QVector<QSize>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QSIZE_IDX],
        _QVector_QSize__PythonToCpp__QVector_QSize_,
        is__QVector_QSize__PythonToCpp__QVector_QSize__Convertible);

    // Register converter for type 'QVector<float>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_float__CppToPython__QVector_float_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX], "QVector<float>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_FLOAT_IDX],
        _QVector_float__PythonToCpp__QVector_float_,
        is__QVector_float__PythonToCpp__QVector_float__Convertible);

    // Register converter for type 'QList<QOpenGLShader*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLSHADERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QOpenGLShaderPTR__CppToPython__QList_QOpenGLShaderPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLSHADERPTR_IDX], "QList<QOpenGLShader*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QOPENGLSHADERPTR_IDX],
        _QList_QOpenGLShaderPTR__PythonToCpp__QList_QOpenGLShaderPTR_,
        is__QList_QOpenGLShaderPTR__PythonToCpp__QList_QOpenGLShaderPTR__Convertible);

    // Register converter for type 'QPair<float,float>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_FLOAT_FLOAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_float_float__CppToPython__QPair_float_float_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_FLOAT_FLOAT_IDX], "QPair<float,float>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_FLOAT_FLOAT_IDX],
        _QPair_float_float__PythonToCpp__QPair_float_float_,
        is__QPair_float_float__PythonToCpp__QPair_float_float__Convertible);

    // Register converter for type 'QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QOPENGLTEXTURE_FILTER_QOPENGLTEXTURE_FILTER_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__CppToPython__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QOPENGLTEXTURE_FILTER_QOPENGLTEXTURE_FILTER_IDX], "QPair<QOpenGLTexture::Filter,QOpenGLTexture::Filter>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_QOPENGLTEXTURE_FILTER_QOPENGLTEXTURE_FILTER_IDX],
        _QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__PythonToCpp__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter_,
        is__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__PythonToCpp__QPair_QOpenGLTexture_Filter_QOpenGLTexture_Filter__Convertible);

    // Register converter for type 'QVector<QPoint>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QPoint__CppToPython__QVector_QPoint_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX], "QVector<QPoint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINT_IDX],
        _QVector_QPoint__PythonToCpp__QVector_QPoint_,
        is__QVector_QPoint__PythonToCpp__QVector_QPoint__Convertible);

    // Register converter for type 'QVector<QPointF>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QPointF__CppToPython__QVector_QPointF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], "QVector<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX],
        _QVector_QPointF__PythonToCpp__QVector_QPointF_,
        is__QVector_QPointF__PythonToCpp__QVector_QPointF__Convertible);

    // Register converter for type 'const QVector<QLine>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QLine_REF_CppToPython__constQVector_QLine_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINE_IDX], "const QVector<QLine>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINE_IDX], "QVector<QLine>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINE_IDX],
        _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF,
        is__constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF_Convertible);

    // Register converter for type 'const QVector<QLineF>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINEF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QLineF_REF_CppToPython__constQVector_QLineF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINEF_IDX], "const QVector<QLineF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINEF_IDX], "QVector<QLineF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QLINEF_IDX],
        _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF,
        is__constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF_Convertible);

    // Register converter for type 'const QVector<QRect>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QRect_REF_CppToPython__constQVector_QRect_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECT_IDX], "const QVector<QRect>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECT_IDX], "QVector<QRect>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECT_IDX],
        _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF,
        is__constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF_Convertible);

    // Register converter for type 'const QVector<QRectF>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QRectF_REF_CppToPython__constQVector_QRectF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECTF_IDX], "const QVector<QRectF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECTF_IDX], "QVector<QRectF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QRECTF_IDX],
        _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF,
        is__constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF_Convertible);

    // Register converter for type 'QList<QPolygonF>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOLYGONF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPolygonF__CppToPython__QList_QPolygonF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOLYGONF_IDX], "QList<QPolygonF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOLYGONF_IDX],
        _QList_QPolygonF__PythonToCpp__QList_QPolygonF_,
        is__QList_QPolygonF__PythonToCpp__QList_QPolygonF__Convertible);

    // Register converter for type 'QVector<qreal>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_qreal__CppToPython__QVector_qreal_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX], "QVector<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX],
        _QVector_qreal__PythonToCpp__QVector_qreal_,
        is__QVector_qreal__PythonToCpp__QVector_qreal__Convertible);

    // Register converter for type 'const QList<QPoint>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPoint_REF_CppToPython__constQList_QPoint_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINT_IDX], "const QList<QPoint>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINT_IDX], "QList<QPoint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINT_IDX],
        _constQList_QPoint_REF_PythonToCpp__constQList_QPoint_REF,
        is__constQList_QPoint_REF_PythonToCpp__constQList_QPoint_REF_Convertible);

    // Register converter for type 'const QList<QPointF>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPointF_REF_CppToPython__constQList_QPointF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINTF_IDX], "const QList<QPointF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINTF_IDX], "QList<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPOINTF_IDX],
        _constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF,
        is__constQList_QPointF_REF_PythonToCpp__constQList_QPointF_REF_Convertible);

    // Register converter for type 'const QVector<quint32>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_quint32_REF_CppToPython__constQVector_quint32_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX], "const QVector<quint32>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX], "QVector<quint32>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX],
        _constQVector_quint32_REF_PythonToCpp__constQVector_quint32_REF,
        is__constQVector_quint32_REF_PythonToCpp__constQVector_quint32_REF_Convertible);

    // Register converter for type 'const QList<QStandardItem*>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTANDARDITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QStandardItemPTR_REF_CppToPython__constQList_QStandardItemPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTANDARDITEMPTR_IDX], "const QList<QStandardItem*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTANDARDITEMPTR_IDX], "QList<QStandardItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTANDARDITEMPTR_IDX],
        _constQList_QStandardItemPTR_REF_PythonToCpp__constQList_QStandardItemPTR_REF,
        is__constQList_QStandardItemPTR_REF_PythonToCpp__constQList_QStandardItemPTR_REF_Convertible);

    // Register converter for type 'const QVector<int>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_int_REF_CppToPython__constQVector_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_INT_IDX], "const QVector<int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_INT_IDX],
        _constQVector_int_REF_PythonToCpp__constQVector_int_REF,
        is__constQVector_int_REF_PythonToCpp__constQVector_int_REF_Convertible);

    // Register converter for type 'const QHash<int,QByteArray>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QHASH_INT_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QHASH_INT_QBYTEARRAY_IDX], "const QHash<int,QByteArray>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QHASH_INT_QBYTEARRAY_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QHASH_INT_QBYTEARRAY_IDX],
        _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF,
        is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible);

    // Register converter for type 'QMap<int,QVariant>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_INT_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QVariant__CppToPython__QMap_int_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_INT_QVARIANT_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_INT_QVARIANT_IDX],
        _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_,
        is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible);

    // Register converter for type 'const QList<QPersistentModelIndex>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPERSISTENTMODELINDEX_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPERSISTENTMODELINDEX_IDX], "const QList<QPersistentModelIndex>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPERSISTENTMODELINDEX_IDX], "QList<QPersistentModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QPERSISTENTMODELINDEX_IDX],
        _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF,
        is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible);

    // Register converter for type 'QVector<QTextLayout::FormatRange>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLAYOUT_FORMATRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QTextLayout_FormatRange__CppToPython__QVector_QTextLayout_FormatRange_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLAYOUT_FORMATRANGE_IDX], "QVector<QTextLayout::FormatRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLAYOUT_FORMATRANGE_IDX],
        _QVector_QTextLayout_FormatRange__PythonToCpp__QVector_QTextLayout_FormatRange_,
        is__QVector_QTextLayout_FormatRange__PythonToCpp__QVector_QTextLayout_FormatRange__Convertible);

    // Register converter for type 'QVector<QTextLength>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLENGTH_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QTextLength__CppToPython__QVector_QTextLength_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLENGTH_IDX], "QVector<QTextLength>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLENGTH_IDX],
        _QVector_QTextLength__PythonToCpp__QVector_QTextLength_,
        is__QVector_QTextLength__PythonToCpp__QVector_QTextLength__Convertible);

    // Register converter for type 'const QList<QTextOption::Tab>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QTextOption_Tab_REF_CppToPython__constQList_QTextOption_Tab_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], "const QList<QTextOption::Tab>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], "QList<QTextOption::Tab>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX],
        _constQList_QTextOption_Tab_REF_PythonToCpp__constQList_QTextOption_Tab_REF,
        is__constQList_QTextOption_Tab_REF_PythonToCpp__constQList_QTextOption_Tab_REF_Convertible);

    // Register converter for type 'QList<QTextBlock>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTBLOCK_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTextBlock__CppToPython__QList_QTextBlock_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTBLOCK_IDX], "QList<QTextBlock>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTBLOCK_IDX],
        _QList_QTextBlock__PythonToCpp__QList_QTextBlock_,
        is__QList_QTextBlock__PythonToCpp__QList_QTextBlock__Convertible);

    // Register converter for type 'QVector<QTextFormat>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTFORMAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QTextFormat__CppToPython__QVector_QTextFormat_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTFORMAT_IDX], "QVector<QTextFormat>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTFORMAT_IDX],
        _QVector_QTextFormat__PythonToCpp__QVector_QTextFormat_,
        is__QVector_QTextFormat__PythonToCpp__QVector_QTextFormat__Convertible);

    // Register converter for type 'QList<QTextFrame*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTFRAMEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTextFramePTR__CppToPython__QList_QTextFramePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTFRAMEPTR_IDX], "QList<QTextFrame*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTFRAMEPTR_IDX],
        _QList_QTextFramePTR__PythonToCpp__QList_QTextFramePTR_,
        is__QList_QTextFramePTR__PythonToCpp__QList_QTextFramePTR__Convertible);

    // Register converter for type 'QList<QTextLayout::FormatRange>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTextLayout_FormatRange__CppToPython__QList_QTextLayout_FormatRange_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX], "QList<QTextLayout::FormatRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTLAYOUT_FORMATRANGE_IDX],
        _QList_QTextLayout_FormatRange__PythonToCpp__QList_QTextLayout_FormatRange_,
        is__QList_QTextLayout_FormatRange__PythonToCpp__QList_QTextLayout_FormatRange__Convertible);

    // Register converter for type 'const QList<qreal>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_qreal_REF_CppToPython__constQList_qreal_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX], "const QList<qreal>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX], "QList<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QREAL_IDX],
        _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF,
        is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible);

    // Register converter for type 'QList<const QTouchDevice*>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_CONSTQTOUCHDEVICEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_constQTouchDevicePTR__CppToPython__QList_constQTouchDevicePTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_CONSTQTOUCHDEVICEPTR_IDX], "QList<const QTouchDevice*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_CONSTQTOUCHDEVICEPTR_IDX],
        _QList_constQTouchDevicePTR__PythonToCpp__QList_constQTouchDevicePTR_,
        is__QList_constQTouchDevicePTR__PythonToCpp__QList_constQTouchDevicePTR__Convertible);

    // Register converter for type 'const QList<QTouchEvent::TouchPoint>&'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QTouchEvent_TouchPoint_REF_CppToPython__constQList_QTouchEvent_TouchPoint_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], "const QList<QTouchEvent::TouchPoint>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX], "QList<QTouchEvent::TouchPoint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTOUCHEVENT_TOUCHPOINT_IDX],
        _constQList_QTouchEvent_TouchPoint_REF_PythonToCpp__constQList_QTouchEvent_TouchPoint_REF,
        is__constQList_QTouchEvent_TouchPoint_REF_PythonToCpp__constQList_QTouchEvent_TouchPoint_REF_Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);


    // Extended implicit conversions for PySide2.QtCore.QPointF.
    Shiboken::Conversions::addPythonToCppValueConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]),
        QPainterPath_Element_PythonToCpp_PySide2_QtCore_QPointF,
        is_QPainterPath_Element_PythonToCpp_PySide2_QtCore_QPointF_Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtGuiTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtGuiTypeConverters);

// Static field initialization
init_QtGuiQColorConstantsStaticFields();
init_QtGuiQColorConstants_SvgStaticFields();

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtGui");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtGui_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
