/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtexttablecellformat_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qfont.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextTableCellFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextTableCellFormat >()))
        return -1;

    ::QTextTableCellFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextTableCellFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextTableCellFormat::QTextTableCellFormat()
    // 1: QTextTableCellFormat::QTextTableCellFormat(QTextFormat)
    // 2: QTextTableCellFormat::QTextTableCellFormat(QTextTableCellFormat)
    if (numArgs == 0) {
        overloadId = 0; // QTextTableCellFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextTableCellFormat(QTextTableCellFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextTableCellFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextTableCellFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextTableCellFormat()
                cptr = new ::QTextTableCellFormat();
            }
            break;
        }
        case 1: // QTextTableCellFormat(const QTextFormat & fmt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextTableCellFormat(QTextFormat)
                cptr = new ::QTextTableCellFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextTableCellFormat(const QTextTableCellFormat & QTextTableCellFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextTableCellFormat cppArg0_local;
            ::QTextTableCellFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextTableCellFormat(QTextTableCellFormat)
                cptr = new ::QTextTableCellFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextTableCellFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextTableCellFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextTableCellFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextTableCellFormatFunc_bottomBorder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.bottomBorder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomBorder()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->bottomBorder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_bottomBorderBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.bottomBorderBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomBorderBrush()const
            QBrush cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->bottomBorderBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_bottomBorderStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.bottomBorderStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomBorderStyle()const
            QTextFrameFormat::BorderStyle cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->bottomBorderStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_bottomPadding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.bottomPadding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomPadding()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->bottomPadding();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_leftBorder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.leftBorder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftBorder()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->leftBorder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_leftBorderBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.leftBorderBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftBorderBrush()const
            QBrush cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->leftBorderBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_leftBorderStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.leftBorderStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftBorderStyle()const
            QTextFrameFormat::BorderStyle cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->leftBorderStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_leftPadding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.leftPadding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftPadding()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->leftPadding();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_rightBorder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.rightBorder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightBorder()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->rightBorder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_rightBorderBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.rightBorderBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightBorderBrush()const
            QBrush cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->rightBorderBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_rightBorderStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.rightBorderStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightBorderStyle()const
            QTextFrameFormat::BorderStyle cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->rightBorderStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_rightPadding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.rightPadding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightPadding()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->rightPadding();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorder(qreal)
            cppSelf->setBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBorderBrush(QBrush)
            cppSelf->setBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBottomBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBottomBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBottomBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottomBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBottomBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomBorder(qreal)
            cppSelf->setBottomBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBottomBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBottomBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBottomBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBottomBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBottomBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBottomBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBottomBorderBrush(QBrush)
            cppSelf->setBottomBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBottomBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBottomBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBottomBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBottomBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBottomBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBottomBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setBottomBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBottomBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setBottomPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setBottomPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setBottomPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottomPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setBottomPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomPadding(qreal)
            cppSelf->setBottomPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setBottomPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setLeftBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setLeftBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setLeftBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeftBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setLeftBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftBorder(qreal)
            cppSelf->setLeftBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setLeftBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setLeftBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setLeftBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setLeftBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setLeftBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setLeftBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLeftBorderBrush(QBrush)
            cppSelf->setLeftBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setLeftBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setLeftBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setLeftBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setLeftBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLeftBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setLeftBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setLeftBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setLeftBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setLeftPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setLeftPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setLeftPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeftPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setLeftPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftPadding(qreal)
            cppSelf->setLeftPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setLeftPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPadding(qreal)
            cppSelf->setPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setRightBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setRightBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setRightBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRightBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setRightBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightBorder(qreal)
            cppSelf->setRightBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setRightBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setRightBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setRightBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setRightBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setRightBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setRightBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setRightBorderBrush(QBrush)
            cppSelf->setRightBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setRightBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setRightBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setRightBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setRightBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRightBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setRightBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setRightBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setRightBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setRightPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setRightPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setRightPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRightPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setRightPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightPadding(qreal)
            cppSelf->setRightPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setRightPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setTopBorder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setTopBorder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setTopBorder(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTopBorder(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setTopBorder_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopBorder(qreal)
            cppSelf->setTopBorder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setTopBorder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setTopBorderBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setTopBorderBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setTopBorderBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setTopBorderBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setTopBorderBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTopBorderBrush(QBrush)
            cppSelf->setTopBorderBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setTopBorderBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setTopBorderStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setTopBorderStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setTopBorderStyle(QTextFrameFormat::BorderStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTopBorderStyle(QTextFrameFormat::BorderStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setTopBorderStyle_TypeError;

    // Call function/method
    {
        ::QTextFrameFormat::BorderStyle cppArg0{QTextFrameFormat::BorderStyle_None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopBorderStyle(QTextFrameFormat::BorderStyle)
            cppSelf->setTopBorderStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setTopBorderStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_setTopPadding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.setTopPadding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextTableCellFormat::setTopPadding(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTopPadding(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextTableCellFormatFunc_setTopPadding_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopPadding(qreal)
            cppSelf->setTopPadding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextTableCellFormatFunc_setTopPadding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextTableCellFormatFunc_topBorder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.topBorder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topBorder()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->topBorder();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_topBorderBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.topBorderBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topBorderBrush()const
            QBrush cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->topBorderBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_topBorderStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.topBorderStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topBorderStyle()const
            QTextFrameFormat::BorderStyle cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->topBorderStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_BORDERSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormatFunc_topPadding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextTableCellFormat.topPadding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topPadding()const
            qreal cppResult = const_cast<const ::QTextTableCellFormat *>(cppSelf)->topPadding();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextTableCellFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextTableCellFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextTableCellFormat_methods[] = {
    {"bottomBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_bottomBorder), METH_NOARGS},
    {"bottomBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_bottomBorderBrush), METH_NOARGS},
    {"bottomBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_bottomBorderStyle), METH_NOARGS},
    {"bottomPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_bottomPadding), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_isValid), METH_NOARGS},
    {"leftBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_leftBorder), METH_NOARGS},
    {"leftBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_leftBorderBrush), METH_NOARGS},
    {"leftBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_leftBorderStyle), METH_NOARGS},
    {"leftPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_leftPadding), METH_NOARGS},
    {"rightBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_rightBorder), METH_NOARGS},
    {"rightBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_rightBorderBrush), METH_NOARGS},
    {"rightBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_rightBorderStyle), METH_NOARGS},
    {"rightPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_rightPadding), METH_NOARGS},
    {"setBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBorder), METH_O},
    {"setBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBorderBrush), METH_O},
    {"setBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBorderStyle), METH_O},
    {"setBottomBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBottomBorder), METH_O},
    {"setBottomBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBottomBorderBrush), METH_O},
    {"setBottomBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBottomBorderStyle), METH_O},
    {"setBottomPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setBottomPadding), METH_O},
    {"setLeftBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setLeftBorder), METH_O},
    {"setLeftBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setLeftBorderBrush), METH_O},
    {"setLeftBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setLeftBorderStyle), METH_O},
    {"setLeftPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setLeftPadding), METH_O},
    {"setPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setPadding), METH_O},
    {"setRightBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setRightBorder), METH_O},
    {"setRightBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setRightBorderBrush), METH_O},
    {"setRightBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setRightBorderStyle), METH_O},
    {"setRightPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setRightPadding), METH_O},
    {"setTopBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setTopBorder), METH_O},
    {"setTopBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setTopBorderBrush), METH_O},
    {"setTopBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setTopBorderStyle), METH_O},
    {"setTopPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_setTopPadding), METH_O},
    {"topBorder", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_topBorder), METH_NOARGS},
    {"topBorderBrush", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_topBorderBrush), METH_NOARGS},
    {"topBorderStyle", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_topBorderStyle), METH_NOARGS},
    {"topPadding", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormatFunc_topPadding), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextTableCellFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextTableCellFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextTableCellFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextTableCellFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextTableCellFormat_TypeF(void)
{
    return _Sbk_QTextTableCellFormat_Type;
}

static PyType_Slot Sbk_QTextTableCellFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextTableCellFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextTableCellFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextTableCellFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextTableCellFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextTableCellFormat_spec = {
    "2:PySide2.QtGui.QTextTableCellFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextTableCellFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextTableCellFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextTableCellFormat_TypeF())))
        return QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextTableCellFormat_PTR_CppToPython_QTextTableCellFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextTableCellFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextTableCellFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextTableCellFormat_COPY_CppToPython_QTextTableCellFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextTableCellFormat_TypeF(), new ::QTextTableCellFormat(*reinterpret_cast<const ::QTextTableCellFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextTableCellFormat *>(cppOut) = *reinterpret_cast< ::QTextTableCellFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextTableCellFormat_TypeF())))
        return QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextTableCellFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextTableCellFormat(self)",
    "1:PySide2.QtGui.QTextTableCellFormat(self,fmt:PySide2.QtGui.QTextFormat)",
    "0:PySide2.QtGui.QTextTableCellFormat(self,QTextTableCellFormat:PySide2.QtGui.QTextTableCellFormat)",
    "PySide2.QtGui.QTextTableCellFormat.bottomBorder(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.bottomBorderBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextTableCellFormat.bottomBorderStyle(self)->PySide2.QtGui.QTextFrameFormat.BorderStyle",
    "PySide2.QtGui.QTextTableCellFormat.bottomPadding(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextTableCellFormat.leftBorder(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.leftBorderBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextTableCellFormat.leftBorderStyle(self)->PySide2.QtGui.QTextFrameFormat.BorderStyle",
    "PySide2.QtGui.QTextTableCellFormat.leftPadding(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.rightBorder(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.rightBorderBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextTableCellFormat.rightBorderStyle(self)->PySide2.QtGui.QTextFrameFormat.BorderStyle",
    "PySide2.QtGui.QTextTableCellFormat.rightPadding(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.setBorder(self,width:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextTableCellFormat.setBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorder(self,width:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextTableCellFormat.setBottomBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextTableCellFormat.setBottomPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorder(self,width:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextTableCellFormat.setLeftBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextTableCellFormat.setLeftPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setRightBorder(self,width:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setRightBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextTableCellFormat.setRightBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextTableCellFormat.setRightPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setTopBorder(self,width:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.setTopBorderBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextTableCellFormat.setTopBorderStyle(self,style:PySide2.QtGui.QTextFrameFormat.BorderStyle)",
    "PySide2.QtGui.QTextTableCellFormat.setTopPadding(self,padding:qreal)",
    "PySide2.QtGui.QTextTableCellFormat.topBorder(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.topBorderBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextTableCellFormat.topBorderStyle(self)->PySide2.QtGui.QTextFrameFormat.BorderStyle",
    "PySide2.QtGui.QTextTableCellFormat.topPadding(self)->qreal",
    "PySide2.QtGui.QTextTableCellFormat.__copy__()",
    nullptr}; // Sentinel

void init_QTextTableCellFormat(PyObject *module)
{
    _Sbk_QTextTableCellFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextTableCellFormat",
        "QTextTableCellFormat",
        &Sbk_QTextTableCellFormat_spec,
        &Shiboken::callCppDestructor< ::QTextTableCellFormat >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextTableCellFormat_Type);
    InitSignatureStrings(pyType, QTextTableCellFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextTableCellFormat_Type), Sbk_QTextTableCellFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextTableCellFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextTableCellFormat_TypeF(),
        QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_PTR,
        is_QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_PTR_Convertible,
        QTextTableCellFormat_PTR_CppToPython_QTextTableCellFormat,
        QTextTableCellFormat_COPY_CppToPython_QTextTableCellFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextTableCellFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextTableCellFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextTableCellFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextTableCellFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_COPY,
        is_QTextTableCellFormat_PythonToCpp_QTextTableCellFormat_COPY_Convertible);

    qRegisterMetaType< ::QTextTableCellFormat >("QTextTableCellFormat");
}
