/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextdocumentfragment_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qtextcursor.h>
#include <QtGui/qtextdocument.h>
#include <QtGui/qtextdocumentfragment.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextDocumentFragment_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextDocumentFragment >()))
        return -1;

    ::QTextDocumentFragment *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextDocumentFragment", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextDocumentFragment::QTextDocumentFragment()
    // 1: QTextDocumentFragment::QTextDocumentFragment(QTextCursor)
    // 2: QTextDocumentFragment::QTextDocumentFragment(const QTextDocument*)
    // 3: QTextDocumentFragment::QTextDocumentFragment(QTextDocumentFragment)
    if (numArgs == 0) {
        overloadId = 0; // QTextDocumentFragment()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QTextDocumentFragment(QTextDocumentFragment)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextDocumentFragment(const QTextDocument*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextDocumentFragment(QTextCursor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFragment_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextDocumentFragment()
        {

            if (!PyErr_Occurred()) {
                // QTextDocumentFragment()
                cptr = new ::QTextDocumentFragment();
            }
            break;
        }
        case 1: // QTextDocumentFragment(const QTextCursor & range)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextCursor cppArg0_local;
            ::QTextCursor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextDocumentFragment(QTextCursor)
                cptr = new ::QTextDocumentFragment(*cppArg0);
            }
            break;
        }
        case 2: // QTextDocumentFragment(const QTextDocument * document)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextDocument *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextDocumentFragment(const QTextDocument*)
                cptr = new ::QTextDocumentFragment(cppArg0);
            }
            break;
        }
        case 3: // QTextDocumentFragment(const QTextDocumentFragment & rhs)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextDocumentFragment cppArg0_local;
            ::QTextDocumentFragment *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextDocumentFragment(QTextDocumentFragment)
                cptr = new ::QTextDocumentFragment(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextDocumentFragment >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextDocumentFragment_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextDocumentFragment_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextDocumentFragmentFunc_fromHtml(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.fromHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fromHtml", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QTextDocumentFragment::fromHtml(QString)
    // 1: static QTextDocumentFragment::fromHtml(QString,const QTextDocument*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromHtml(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // fromHtml(QString,const QTextDocument*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFragmentFunc_fromHtml_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromHtml(const QString & html)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fromHtml(QString)
                QTextDocumentFragment cppResult = ::QTextDocumentFragment::fromHtml(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromHtml(const QString & html, const QTextDocument * resourceProvider)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextDocument *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromHtml(QString,const QTextDocument*)
                QTextDocumentFragment cppResult = ::QTextDocumentFragment::fromHtml(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFragmentFunc_fromHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFragmentFunc_fromPlainText(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.fromPlainText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QTextDocumentFragment::fromPlainText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromPlainText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFragmentFunc_fromPlainText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromPlainText(QString)
            QTextDocumentFragment cppResult = ::QTextDocumentFragment::fromPlainText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFragmentFunc_fromPlainText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFragmentFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocumentFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QTextDocumentFragment *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFragmentFunc_toHtml(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocumentFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.toHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFragmentFunc_toHtml_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toHtml", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocumentFragment::toHtml(QByteArray)const
    if (numArgs == 0) {
        overloadId = 0; // toHtml(QByteArray)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toHtml(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFragmentFunc_toHtml_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[0]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFragmentFunc_toHtml_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                        goto Sbk_QTextDocumentFragmentFunc_toHtml_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFragmentFunc_toHtml_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local = QByteArray();
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toHtml(QByteArray)const
            QString cppResult = const_cast<const ::QTextDocumentFragment *>(cppSelf)->toHtml(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFragmentFunc_toHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFragmentFunc_toPlainText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocumentFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocumentFragment.toPlainText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPlainText()const
            QString cppResult = const_cast<const ::QTextDocumentFragment *>(cppSelf)->toPlainText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFragment___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextDocumentFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextDocumentFragment_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextDocumentFragment_methods[] = {
    {"fromHtml", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragmentFunc_fromHtml), METH_VARARGS|METH_STATIC},
    {"fromPlainText", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragmentFunc_fromPlainText), METH_O|METH_STATIC},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragmentFunc_isEmpty), METH_NOARGS},
    {"toHtml", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragmentFunc_toHtml), METH_VARARGS|METH_KEYWORDS},
    {"toPlainText", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragmentFunc_toPlainText), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFragment___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextDocumentFragment_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextDocumentFragment_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextDocumentFragment_Type = nullptr;
static SbkObjectType *Sbk_QTextDocumentFragment_TypeF(void)
{
    return _Sbk_QTextDocumentFragment_Type;
}

static PyType_Slot Sbk_QTextDocumentFragment_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextDocumentFragment_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextDocumentFragment_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextDocumentFragment_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextDocumentFragment_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextDocumentFragment_spec = {
    "2:PySide2.QtGui.QTextDocumentFragment",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextDocumentFragment_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextDocumentFragment_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextDocumentFragment_TypeF())))
        return QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextDocumentFragment_PTR_CppToPython_QTextDocumentFragment(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextDocumentFragment *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextDocumentFragment_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextDocumentFragment_COPY_CppToPython_QTextDocumentFragment(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextDocumentFragment_TypeF(), new ::QTextDocumentFragment(*reinterpret_cast<const ::QTextDocumentFragment *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocumentFragment *>(cppOut) = *reinterpret_cast< ::QTextDocumentFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextDocumentFragment_TypeF())))
        return QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextDocumentFragment_SignatureStrings[] = {
    "3:PySide2.QtGui.QTextDocumentFragment(self)",
    "2:PySide2.QtGui.QTextDocumentFragment(self,range:PySide2.QtGui.QTextCursor)",
    "1:PySide2.QtGui.QTextDocumentFragment(self,document:PySide2.QtGui.QTextDocument)",
    "0:PySide2.QtGui.QTextDocumentFragment(self,rhs:PySide2.QtGui.QTextDocumentFragment)",
    "1:PySide2.QtGui.QTextDocumentFragment.fromHtml(html:QString)->PySide2.QtGui.QTextDocumentFragment",
    "0:PySide2.QtGui.QTextDocumentFragment.fromHtml(html:QString,resourceProvider:PySide2.QtGui.QTextDocument)->PySide2.QtGui.QTextDocumentFragment",
    "PySide2.QtGui.QTextDocumentFragment.fromPlainText(plainText:QString)->PySide2.QtGui.QTextDocumentFragment",
    "PySide2.QtGui.QTextDocumentFragment.isEmpty(self)->bool",
    "PySide2.QtGui.QTextDocumentFragment.toHtml(self,encoding:PySide2.QtCore.QByteArray=QByteArray())->QString",
    "PySide2.QtGui.QTextDocumentFragment.toPlainText(self)->QString",
    "PySide2.QtGui.QTextDocumentFragment.__copy__()",
    nullptr}; // Sentinel

void init_QTextDocumentFragment(PyObject *module)
{
    _Sbk_QTextDocumentFragment_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextDocumentFragment",
        "QTextDocumentFragment",
        &Sbk_QTextDocumentFragment_spec,
        &Shiboken::callCppDestructor< ::QTextDocumentFragment >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextDocumentFragment_Type);
    InitSignatureStrings(pyType, QTextDocumentFragment_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextDocumentFragment_Type), Sbk_QTextDocumentFragment_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextDocumentFragment_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextDocumentFragment_TypeF(),
        QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_PTR,
        is_QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_PTR_Convertible,
        QTextDocumentFragment_PTR_CppToPython_QTextDocumentFragment,
        QTextDocumentFragment_COPY_CppToPython_QTextDocumentFragment);

    Shiboken::Conversions::registerConverterName(converter, "QTextDocumentFragment");
    Shiboken::Conversions::registerConverterName(converter, "QTextDocumentFragment*");
    Shiboken::Conversions::registerConverterName(converter, "QTextDocumentFragment&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextDocumentFragment).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_COPY,
        is_QTextDocumentFragment_PythonToCpp_QTextDocumentFragment_COPY_Convertible);

    qRegisterMetaType< ::QTextDocumentFragment >("QTextDocumentFragment");
}
