/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextdocument_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTextDocumentWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTextDocumentWrapper::QTextDocumentWrapper(::QObject * parent) : QTextDocument(parent)
{
    resetPyMethodCache();
    // ... middle
}

QTextDocumentWrapper::QTextDocumentWrapper(const ::QString & text, ::QObject * parent) : QTextDocument(text, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTextDocumentWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTextDocumentWrapper::clear()
{
    if (m_PyMethodCache[1]) {
        return this->::QTextDocument::clear();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "clear";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QTextDocument::clear();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTextDocumentWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QTextObject * QTextDocumentWrapper::createObject(const ::QTextFormat & f)
{
    if (m_PyMethodCache[3])
        return this->::QTextDocument::createObject(f);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QTextDocument::createObject(f);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), &f)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextDocument.createObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QTextObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QTextObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

void QTextDocumentWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTextDocumentWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTextDocumentWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextDocument.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTextDocumentWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextDocument.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QVariant QTextDocumentWrapper::loadResource(int type, const ::QUrl & name)
{
    if (m_PyMethodCache[8])
        return this->::QTextDocument::loadResource(type, name);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "loadResource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QTextDocument::loadResource(type, name);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iN)",
    type,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &name)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextDocument.loadResource", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QTextDocumentWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QTextDocumentWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QTextDocument::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTextDocumentWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QTextDocument::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTextDocumentWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTextDocumentWrapper *>(this));
        return QTextDocument::qt_metacast(_clname);
}

QTextDocumentWrapper::~QTextDocumentWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextDocument_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextDocument >()))
        return -1;

    ::QTextDocumentWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QTextDocument", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTextDocument::QTextDocument(QObject*)
    // 1: QTextDocument::QTextDocument(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QTextDocument(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QTextDocument(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTextDocument(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QTextDocument(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocument_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextDocument(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QTextDocument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextDocument(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QTextDocumentWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QTextDocumentWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QTextDocument(const QString & text, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocument_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QTextDocument_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTextDocument(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QTextDocumentWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QTextDocumentWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextDocument >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextDocument_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QTextDocument_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QTextDocument_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextDocumentFunc_addResource(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.addResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addResource", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::addResource(int,QUrl,QVariant)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[2])))) {
        overloadId = 0; // addResource(int,QUrl,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_addResource_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QVariant cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // addResource(int,QUrl,QVariant)
            cppSelf->addResource(cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_addResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_adjustSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.adjustSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // adjustSize()
            cppSelf->adjustSize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextDocumentFunc_allFormats(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.allFormats";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allFormats()const
            QVector<QTextFormat > cppResult = const_cast<const ::QTextDocument *>(cppSelf)->allFormats();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTFORMAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_availableRedoSteps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.availableRedoSteps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableRedoSteps()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->availableRedoSteps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_availableUndoSteps(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.availableUndoSteps";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableUndoSteps()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->availableUndoSteps();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_baseUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.baseUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baseUrl()const
            QUrl cppResult = const_cast<const ::QTextDocument *>(cppSelf)->baseUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_begin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.begin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // begin()const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->begin();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_blockCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.blockCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockCount()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->blockCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_characterAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.characterAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::characterAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // characterAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_characterAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // characterAt(int)const
            QChar cppResult = const_cast<const ::QTextDocument *>(cppSelf)->characterAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_characterAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_characterCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.characterCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // characterCount()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->characterCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTextDocument::clear()
                : cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextDocumentFunc_clearUndoRedoStacks(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.clearUndoRedoStacks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:clearUndoRedoStacks", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::clearUndoRedoStacks(QTextDocument::Stacks)
    if (numArgs == 0) {
        overloadId = 0; // clearUndoRedoStacks(QTextDocument::Stacks)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // clearUndoRedoStacks(QTextDocument::Stacks)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_historyToClear = Shiboken::String::createStaticString("historyToClear");
            if (PyDict_Contains(kwds, key_historyToClear)) {
                value = PyDict_GetItem(kwds, key_historyToClear);
                if (value && pyArgs[0]) {
                    errInfo = key_historyToClear;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_historyToClear);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError;
            }
        }
        ::QTextDocument::Stacks cppArg0 = QTextDocument::Stacks::UndoAndRedoStacks;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // clearUndoRedoStacks(QTextDocument::Stacks)
            cppSelf->clearUndoRedoStacks(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_clearUndoRedoStacks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_clone(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.clone";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_clone_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:clone", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::clone(QObject*)const
    if (numArgs == 0) {
        overloadId = 0; // clone(QObject*)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // clone(QObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_clone_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_clone_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QTextDocumentFunc_clone_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_clone_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // clone(QObject*)const
            QTextDocument * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->clone(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_clone_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_createObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.createObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::createObject(QTextFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // createObject(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_createObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextFormat cppArg0_local;
        ::QTextFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // createObject(QTextFormat)
            QTextObject * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTextDocument::createObject(*cppArg0)
                : cppSelf->createObject(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECT_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::getOwnership(pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_createObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_defaultCursorMoveStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.defaultCursorMoveStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultCursorMoveStyle()const
            Qt::CursorMoveStyle cppResult = const_cast<const ::QTextDocument *>(cppSelf)->defaultCursorMoveStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_defaultFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.defaultFont";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFont()const
            QFont cppResult = const_cast<const ::QTextDocument *>(cppSelf)->defaultFont();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_defaultStyleSheet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.defaultStyleSheet";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultStyleSheet()const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->defaultStyleSheet();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_defaultTextOption(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.defaultTextOption";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTextOption()const
            QTextOption cppResult = const_cast<const ::QTextDocument *>(cppSelf)->defaultTextOption();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_documentLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.documentLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // documentLayout()const
            QAbstractTextDocumentLayout * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->documentLayout();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_documentMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.documentMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // documentMargin()const
            qreal cppResult = const_cast<const ::QTextDocument *>(cppSelf)->documentMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_drawContents(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.drawContents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_drawContents_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_drawContents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:drawContents", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::drawContents(QPainter*,QRectF)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // drawContents(QPainter*,QRectF)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
            overloadId = 0; // drawContents(QPainter*,QRectF)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_drawContents_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_rect = Shiboken::String::createStaticString("rect");
            if (PyDict_Contains(kwds, key_rect)) {
                value = PyDict_GetItem(kwds, key_rect);
                if (value && pyArgs[1]) {
                    errInfo = key_rect;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_drawContents_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1]))))
                        goto Sbk_QTextDocumentFunc_drawContents_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_rect);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_drawContents_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local = QRectF();
        ::QRectF *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // drawContents(QPainter*,QRectF)
            cppSelf->drawContents(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_drawContents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_end(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.end";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // end()const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->end();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_find(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.find";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_find_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_find_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:find", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
    // 1: QTextDocument::find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
    // 2: QTextDocument::find(QRegularExpression,QTextCursor,QFlags<QTextDocument::FindFlag>)const
    // 3: QTextDocument::find(QRegularExpression,int,QFlags<QTextDocument::FindFlag>)const
    // 4: QTextDocument::find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
    // 5: QTextDocument::find(QString,int,QFlags<QTextDocument::FindFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 5; // find(QString,int,QFlags<QTextDocument::FindFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 5; // find(QString,int,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 5; // find(QString,int,QFlags<QTextDocument::FindFlag>)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 4; // find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // find(QRegularExpression,int,QFlags<QTextDocument::FindFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // find(QRegularExpression,int,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 3; // find(QRegularExpression,int,QFlags<QTextDocument::FindFlag>)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // find(QRegularExpression,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // find(QRegularExpression,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_find_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // find(const QRegExp & expr, const QTextCursor & cursor, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegExp cppArg0_local;
            ::QRegExp *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCursor cppArg1_local;
            ::QTextCursor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QRegExp,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(*cppArg0, *cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
        case 1: // find(const QRegExp & expr, int from, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_from = Shiboken::String::createStaticString("from");
                if (PyDict_Contains(kwds, key_from)) {
                    value = PyDict_GetItem(kwds, key_from);
                    if (value && pyArgs[1]) {
                        errInfo = key_from;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_from);
                }
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegExp cppArg0_local;
            ::QRegExp *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGEXP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QRegExp,int,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
        case 2: // find(const QRegularExpression & expr, const QTextCursor & cursor, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegularExpression cppArg0_local;
            ::QRegularExpression *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCursor cppArg1_local;
            ::QTextCursor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QRegularExpression,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(*cppArg0, *cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
        case 3: // find(const QRegularExpression & expr, int from, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_from = Shiboken::String::createStaticString("from");
                if (PyDict_Contains(kwds, key_from)) {
                    value = PyDict_GetItem(kwds, key_from);
                    if (value && pyArgs[1]) {
                        errInfo = key_from;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_from);
                }
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegularExpression cppArg0_local;
            ::QRegularExpression *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QREGULAREXPRESSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QRegularExpression,int,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
        case 4: // find(const QString & subString, const QTextCursor & cursor, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCursor cppArg1_local;
            ::QTextCursor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QString,QTextCursor,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(cppArg0, *cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
        case 5: // find(const QString & subString, int from, QFlags<QTextDocument::FindFlag> options) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_from = Shiboken::String::createStaticString("from");
                if (PyDict_Contains(kwds, key_from)) {
                    value = PyDict_GetItem(kwds, key_from);
                    if (value && pyArgs[1]) {
                        errInfo = key_from;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_from);
                }
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[2]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QTextDocumentFunc_find_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextDocumentFunc_find_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<QTextDocument::FindFlag> cppArg2 = QTextDocument::FindFlags();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // find(QString,int,QFlags<QTextDocument::FindFlag>)const
                QTextCursor cppResult = const_cast<const ::QTextDocument *>(cppSelf)->find(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_find_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_findBlock(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.findBlock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::findBlock(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // findBlock(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_findBlock_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findBlock(int)const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->findBlock(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_findBlock_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_findBlockByLineNumber(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.findBlockByLineNumber";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::findBlockByLineNumber(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // findBlockByLineNumber(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_findBlockByLineNumber_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findBlockByLineNumber(int)const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->findBlockByLineNumber(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_findBlockByLineNumber_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_findBlockByNumber(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.findBlockByNumber";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::findBlockByNumber(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // findBlockByNumber(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_findBlockByNumber_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findBlockByNumber(int)const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->findBlockByNumber(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_findBlockByNumber_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_firstBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.firstBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // firstBlock()const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->firstBlock();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_frameAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.frameAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::frameAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // frameAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_frameAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // frameAt(int)const
            QTextFrame * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->frameAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_frameAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_idealWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.idealWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // idealWidth()const
            qreal cppResult = const_cast<const ::QTextDocument *>(cppSelf)->idealWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_indentWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.indentWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indentWidth()const
            qreal cppResult = const_cast<const ::QTextDocument *>(cppSelf)->indentWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_isModified(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.isModified";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isModified()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->isModified();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_isRedoAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.isRedoAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRedoAvailable()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->isRedoAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_isUndoAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.isUndoAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndoAvailable()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->isUndoAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_isUndoRedoEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.isUndoRedoEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndoRedoEnabled()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->isUndoRedoEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_lastBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.lastBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lastBlock()const
            QTextBlock cppResult = const_cast<const ::QTextDocument *>(cppSelf)->lastBlock();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_lineCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.lineCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineCount()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->lineCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_loadResource(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.loadResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "loadResource", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::loadResource(int,QUrl)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
        overloadId = 0; // loadResource(int,QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_loadResource_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // loadResource(int,QUrl)
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTextDocument::loadResource(cppArg0, *cppArg1)
                : cppSelf->loadResource(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_loadResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_markContentsDirty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.markContentsDirty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "markContentsDirty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::markContentsDirty(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // markContentsDirty(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_markContentsDirty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // markContentsDirty(int,int)
            cppSelf->markContentsDirty(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_markContentsDirty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_maximumBlockCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.maximumBlockCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumBlockCount()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->maximumBlockCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_metaInformation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.metaInformation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::metaInformation(QTextDocument::MetaInformation)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metaInformation(QTextDocument::MetaInformation)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_metaInformation_TypeError;

    // Call function/method
    {
        ::QTextDocument::MetaInformation cppArg0{QTextDocument::DocumentTitle};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metaInformation(QTextDocument::MetaInformation)const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->metaInformation(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_metaInformation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_object(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.object";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::object(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // object(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_object_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // object(int)const
            QTextObject * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->object(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_object_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_objectForFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.objectForFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::objectForFormat(QTextFormat)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // objectForFormat(QTextFormat)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_objectForFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextFormat cppArg0_local;
        ::QTextFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // objectForFormat(QTextFormat)const
            QTextObject * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->objectForFormat(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_objectForFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_pageCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.pageCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageCount()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->pageCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_pageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.pageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageSize()const
            QSizeF cppResult = const_cast<const ::QTextDocument *>(cppSelf)->pageSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_print_(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.print_";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::print(QPagedPaintDevice*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // print(QPagedPaintDevice*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_print__TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPagedPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // print(QPagedPaintDevice*)const
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            const_cast<const ::QTextDocument *>(cppSelf)->print(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_print__TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_redo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.redo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "redo", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::redo()
    // 1: QTextDocument::redo(QTextCursor*)
    if (numArgs == 0) {
        overloadId = 0; // redo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // redo(QTextCursor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_redo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // redo()
        {

            if (!PyErr_Occurred()) {
                // redo()
                cppSelf->redo();
            }
            break;
        }
        case 1: // redo(QTextCursor * cursor)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextCursor *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // redo(QTextCursor*)
                cppSelf->redo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_redo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_resource(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.resource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "resource", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::resource(int,QUrl)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
        overloadId = 0; // resource(int,QUrl)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_resource_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // resource(int,QUrl)const
            QVariant cppResult = const_cast<const ::QTextDocument *>(cppSelf)->resource(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_resource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_revision(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.revision";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // revision()const
            int cppResult = const_cast<const ::QTextDocument *>(cppSelf)->revision();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_rootFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.rootFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rootFrame()const
            QTextFrame * cppResult = const_cast<const ::QTextDocument *>(cppSelf)->rootFrame();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_setBaseUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setBaseUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setBaseUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setBaseUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setBaseUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBaseUrl(QUrl)
            cppSelf->setBaseUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setBaseUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDefaultCursorMoveStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDefaultCursorMoveStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDefaultCursorMoveStyle(Qt::CursorMoveStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CURSORMOVESTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDefaultCursorMoveStyle(Qt::CursorMoveStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDefaultCursorMoveStyle_TypeError;

    // Call function/method
    {
        ::Qt::CursorMoveStyle cppArg0{Qt::LogicalMoveStyle};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultCursorMoveStyle(Qt::CursorMoveStyle)
            cppSelf->setDefaultCursorMoveStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDefaultCursorMoveStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDefaultFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDefaultFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDefaultFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDefaultFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultFont(QFont)
            cppSelf->setDefaultFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDefaultFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDefaultStyleSheet(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDefaultStyleSheet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDefaultStyleSheet(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultStyleSheet(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDefaultStyleSheet_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultStyleSheet(QString)
            cppSelf->setDefaultStyleSheet(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDefaultStyleSheet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDefaultTextOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDefaultTextOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDefaultTextOption(QTextOption)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultTextOption(QTextOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDefaultTextOption_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextOption cppArg0_local;
        ::QTextOption *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultTextOption(QTextOption)
            cppSelf->setDefaultTextOption(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDefaultTextOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDocumentLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDocumentLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QABSTRACTTEXTDOCUMENTLAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // setDocumentLayout(QAbstractTextDocumentLayout*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDocumentLayout_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractTextDocumentLayout *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDocumentLayout(QAbstractTextDocumentLayout*)
            cppSelf->setDocumentLayout(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDocumentLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setDocumentMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setDocumentMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setDocumentMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDocumentMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setDocumentMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDocumentMargin(qreal)
            cppSelf->setDocumentMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setDocumentMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setHtml(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setHtml(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHtml(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setHtml_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHtml(QString)
            cppSelf->setHtml(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setIndentWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setIndentWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setIndentWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setIndentWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setIndentWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIndentWidth(qreal)
            cppSelf->setIndentWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setIndentWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setMarkdown(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setMarkdown";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setMarkdown", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::setMarkdown(QString,QFlags<QTextDocument::MarkdownFeature>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMarkdown(QString,QFlags<QTextDocument::MarkdownFeature>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setMarkdown(QString,QFlags<QTextDocument::MarkdownFeature>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_features = Shiboken::String::createStaticString("features");
            if (PyDict_Contains(kwds, key_features)) {
                value = PyDict_GetItem(kwds, key_features);
                if (value && pyArgs[1]) {
                    errInfo = key_features;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_features);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_setMarkdown_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QTextDocument::MarkdownFeature> cppArg1 = QTextDocument::MarkdownDialectGitHub;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMarkdown(QString,QFlags<QTextDocument::MarkdownFeature>)
            cppSelf->setMarkdown(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setMarkdown_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setMaximumBlockCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setMaximumBlockCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setMaximumBlockCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaximumBlockCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setMaximumBlockCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumBlockCount(int)
            cppSelf->setMaximumBlockCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setMaximumBlockCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setMetaInformation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setMetaInformation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMetaInformation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::setMetaInformation(QTextDocument::MetaInformation,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setMetaInformation(QTextDocument::MetaInformation,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setMetaInformation_TypeError;

    // Call function/method
    {
        ::QTextDocument::MetaInformation cppArg0{QTextDocument::DocumentTitle};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMetaInformation(QTextDocument::MetaInformation,QString)
            cppSelf->setMetaInformation(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setMetaInformation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setModified(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setModified";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_setModified_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setModified", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::setModified(bool)
    if (numArgs == 0) {
        overloadId = 0; // setModified(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setModified(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setModified_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_m = Shiboken::String::createStaticString("m");
            if (PyDict_Contains(kwds, key_m)) {
                value = PyDict_GetItem(kwds, key_m);
                if (value && pyArgs[0]) {
                    errInfo = key_m;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_setModified_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QTextDocumentFunc_setModified_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_m);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_setModified_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setModified(bool)
            cppSelf->setModified(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setModified_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setPageSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setPageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setPageSize(QSizeF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
        overloadId = 0; // setPageSize(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setPageSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSizeF cppArg0_local;
        ::QSizeF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPageSize(QSizeF)
            cppSelf->setPageSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setPageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setPlainText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setPlainText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setPlainText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPlainText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setPlainText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPlainText(QString)
            cppSelf->setPlainText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setPlainText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setTextWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setTextWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setTextWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTextWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setTextWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextWidth(qreal)
            cppSelf->setTextWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setTextWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setUndoRedoEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setUndoRedoEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setUndoRedoEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUndoRedoEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setUndoRedoEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUndoRedoEnabled(bool)
            cppSelf->setUndoRedoEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setUndoRedoEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_setUseDesignMetrics(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.setUseDesignMetrics";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextDocument::setUseDesignMetrics(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseDesignMetrics(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_setUseDesignMetrics_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseDesignMetrics(bool)
            cppSelf->setUseDesignMetrics(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_setUseDesignMetrics_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSizeF cppResult = const_cast<const ::QTextDocument *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_textWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.textWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textWidth()const
            qreal cppResult = const_cast<const ::QTextDocument *>(cppSelf)->textWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_toHtml(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.toHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_toHtml_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toHtml", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::toHtml(QByteArray)const
    if (numArgs == 0) {
        overloadId = 0; // toHtml(QByteArray)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // toHtml(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_toHtml_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_encoding = Shiboken::String::createStaticString("encoding");
            if (PyDict_Contains(kwds, key_encoding)) {
                value = PyDict_GetItem(kwds, key_encoding);
                if (value && pyArgs[0]) {
                    errInfo = key_encoding;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_toHtml_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                        goto Sbk_QTextDocumentFunc_toHtml_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_encoding);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_toHtml_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local = QByteArray();
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // toHtml(QByteArray)const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->toHtml(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_toHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_toMarkdown(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.toMarkdown";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextDocumentFunc_toMarkdown_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:toMarkdown", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::toMarkdown(QFlags<QTextDocument::MarkdownFeature>)const
    if (numArgs == 0) {
        overloadId = 0; // toMarkdown(QFlags<QTextDocument::MarkdownFeature>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // toMarkdown(QFlags<QTextDocument::MarkdownFeature>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_toMarkdown_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_features = Shiboken::String::createStaticString("features");
            if (PyDict_Contains(kwds, key_features)) {
                value = PyDict_GetItem(kwds, key_features);
                if (value && pyArgs[0]) {
                    errInfo = key_features;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextDocumentFunc_toMarkdown_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QTextDocumentFunc_toMarkdown_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_features);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextDocumentFunc_toMarkdown_TypeError;
            }
        }
        ::QFlags<QTextDocument::MarkdownFeature> cppArg0 = QTextDocument::MarkdownDialectGitHub;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // toMarkdown(QFlags<QTextDocument::MarkdownFeature>)const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->toMarkdown(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextDocumentFunc_toMarkdown_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_toPlainText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.toPlainText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPlainText()const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->toPlainText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_toRawText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.toRawText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toRawText()const
            QString cppResult = const_cast<const ::QTextDocument *>(cppSelf)->toRawText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextDocumentFunc_undo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.undo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "undo", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QTextDocument::undo()
    // 1: QTextDocument::undo(QTextCursor*)
    if (numArgs == 0) {
        overloadId = 0; // undo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // undo(QTextCursor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextDocumentFunc_undo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // undo()
        {

            if (!PyErr_Occurred()) {
                // undo()
                cppSelf->undo();
            }
            break;
        }
        case 1: // undo(QTextCursor * cursor)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextCursor *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // undo(QTextCursor*)
                cppSelf->undo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextDocumentFunc_undo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextDocumentFunc_useDesignMetrics(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextDocument.useDesignMetrics";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useDesignMetrics()const
            bool cppResult = const_cast<const ::QTextDocument *>(cppSelf)->useDesignMetrics();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextDocument_PropertyStrings[] = {
    "baseUrl::",
    "blockCount:",
    "defaultFont::",
    "defaultStyleSheet::",
    "documentMargin::",
    "indentWidth::",
    "maximumBlockCount::",
    "modified:isModified:",
    "pageSize::",
    "size:",
    "textWidth::",
    "undoRedoEnabled:isUndoRedoEnabled:",
    "useDesignMetrics::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextDocument_methods[] = {
    {"addResource", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_addResource), METH_VARARGS},
    {"adjustSize", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_adjustSize), METH_NOARGS},
    {"allFormats", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_allFormats), METH_NOARGS},
    {"availableRedoSteps", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_availableRedoSteps), METH_NOARGS},
    {"availableUndoSteps", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_availableUndoSteps), METH_NOARGS},
    {"baseUrl", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_baseUrl), METH_NOARGS},
    {"begin", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_begin), METH_NOARGS},
    {"blockCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_blockCount), METH_NOARGS},
    {"characterAt", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_characterAt), METH_O},
    {"characterCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_characterCount), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_clear), METH_NOARGS},
    {"clearUndoRedoStacks", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_clearUndoRedoStacks), METH_VARARGS|METH_KEYWORDS},
    {"clone", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_clone), METH_VARARGS|METH_KEYWORDS},
    {"createObject", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_createObject), METH_O},
    {"defaultCursorMoveStyle", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_defaultCursorMoveStyle), METH_NOARGS},
    {"defaultFont", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_defaultFont), METH_NOARGS},
    {"defaultStyleSheet", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_defaultStyleSheet), METH_NOARGS},
    {"defaultTextOption", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_defaultTextOption), METH_NOARGS},
    {"documentLayout", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_documentLayout), METH_NOARGS},
    {"documentMargin", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_documentMargin), METH_NOARGS},
    {"drawContents", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_drawContents), METH_VARARGS|METH_KEYWORDS},
    {"end", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_end), METH_NOARGS},
    {"find", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_find), METH_VARARGS|METH_KEYWORDS},
    {"findBlock", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_findBlock), METH_O},
    {"findBlockByLineNumber", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_findBlockByLineNumber), METH_O},
    {"findBlockByNumber", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_findBlockByNumber), METH_O},
    {"firstBlock", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_firstBlock), METH_NOARGS},
    {"frameAt", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_frameAt), METH_O},
    {"idealWidth", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_idealWidth), METH_NOARGS},
    {"indentWidth", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_indentWidth), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_isEmpty), METH_NOARGS},
    {"isModified", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_isModified), METH_NOARGS},
    {"isRedoAvailable", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_isRedoAvailable), METH_NOARGS},
    {"isUndoAvailable", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_isUndoAvailable), METH_NOARGS},
    {"isUndoRedoEnabled", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_isUndoRedoEnabled), METH_NOARGS},
    {"lastBlock", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_lastBlock), METH_NOARGS},
    {"lineCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_lineCount), METH_NOARGS},
    {"loadResource", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_loadResource), METH_VARARGS},
    {"markContentsDirty", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_markContentsDirty), METH_VARARGS},
    {"maximumBlockCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_maximumBlockCount), METH_NOARGS},
    {"metaInformation", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_metaInformation), METH_O},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_object), METH_O},
    {"objectForFormat", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_objectForFormat), METH_O},
    {"pageCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_pageCount), METH_NOARGS},
    {"pageSize", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_pageSize), METH_NOARGS},
    {"print_", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_print_), METH_O},
    {"redo", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_redo), METH_VARARGS},
    {"resource", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_resource), METH_VARARGS},
    {"revision", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_revision), METH_NOARGS},
    {"rootFrame", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_rootFrame), METH_NOARGS},
    {"setBaseUrl", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setBaseUrl), METH_O},
    {"setDefaultCursorMoveStyle", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDefaultCursorMoveStyle), METH_O},
    {"setDefaultFont", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDefaultFont), METH_O},
    {"setDefaultStyleSheet", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDefaultStyleSheet), METH_O},
    {"setDefaultTextOption", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDefaultTextOption), METH_O},
    {"setDocumentLayout", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDocumentLayout), METH_O},
    {"setDocumentMargin", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setDocumentMargin), METH_O},
    {"setHtml", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setHtml), METH_O},
    {"setIndentWidth", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setIndentWidth), METH_O},
    {"setMarkdown", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setMarkdown), METH_VARARGS|METH_KEYWORDS},
    {"setMaximumBlockCount", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setMaximumBlockCount), METH_O},
    {"setMetaInformation", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setMetaInformation), METH_VARARGS},
    {"setModified", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setModified), METH_VARARGS|METH_KEYWORDS},
    {"setPageSize", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setPageSize), METH_O},
    {"setPlainText", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setPlainText), METH_O},
    {"setTextWidth", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setTextWidth), METH_O},
    {"setUndoRedoEnabled", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setUndoRedoEnabled), METH_O},
    {"setUseDesignMetrics", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_setUseDesignMetrics), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_size), METH_NOARGS},
    {"textWidth", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_textWidth), METH_NOARGS},
    {"toHtml", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_toHtml), METH_VARARGS|METH_KEYWORDS},
    {"toMarkdown", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_toMarkdown), METH_VARARGS|METH_KEYWORDS},
    {"toPlainText", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_toPlainText), METH_NOARGS},
    {"toRawText", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_toRawText), METH_NOARGS},
    {"undo", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_undo), METH_VARARGS},
    {"useDesignMetrics", reinterpret_cast<PyCFunction>(Sbk_QTextDocumentFunc_useDesignMetrics), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextDocument_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTextDocument *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTextDocumentWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTextDocument_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextDocument_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextDocument_Type = nullptr;
static SbkObjectType *Sbk_QTextDocument_TypeF(void)
{
    return _Sbk_QTextDocument_Type;
}

static PyType_Slot Sbk_QTextDocument_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTextDocument_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextDocument_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextDocument_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextDocument_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextDocument_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextDocument_spec = {
    "2:PySide2.QtGui.QTextDocument",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextDocument_slots
};

} //extern "C"

static void *Sbk_QTextDocument_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QTextDocument *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtGui_QTextDocument_MarkdownFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::MarkdownFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_MarkdownFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::MarkdownFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_MarkdownFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::MarkdownFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::MarkdownFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_MarkdownFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::MarkdownFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, self, &cppSelf);
    ::QTextDocument::MarkdownFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTextDocument_MarkdownFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTextDocument_MarkdownFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTextDocument_MarkdownFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_MarkdownFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtGui_QTextDocument_FindFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_FindFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_FindFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextDocument::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextDocument::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextDocument_FindFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextDocument::FindFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, self, &cppSelf);
    ::QTextDocument::FindFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTextDocument_FindFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTextDocument_FindFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTextDocument_FindFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextDocument_FindFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextDocument_MetaInformation_PythonToCpp_QTextDocument_MetaInformation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocument::MetaInformation *>(cppOut) =
        static_cast<::QTextDocument::MetaInformation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextDocument_MetaInformation_PythonToCpp_QTextDocument_MetaInformation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX]))
        return QTextDocument_MetaInformation_PythonToCpp_QTextDocument_MetaInformation;
    return {};
}
static PyObject *QTextDocument_MetaInformation_CppToPython_QTextDocument_MetaInformation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextDocument::MetaInformation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX], castCppIn);

}

static void QTextDocument_MarkdownFeature_PythonToCpp_QTextDocument_MarkdownFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocument::MarkdownFeature *>(cppOut) =
        static_cast<::QTextDocument::MarkdownFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextDocument_MarkdownFeature_PythonToCpp_QTextDocument_MarkdownFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]))
        return QTextDocument_MarkdownFeature_PythonToCpp_QTextDocument_MarkdownFeature;
    return {};
}
static PyObject *QTextDocument_MarkdownFeature_CppToPython_QTextDocument_MarkdownFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextDocument::MarkdownFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX], castCppIn);

}

static void QFlags_QTextDocument_MarkdownFeature__PythonToCpp_QFlags_QTextDocument_MarkdownFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextDocument::MarkdownFeature> *>(cppOut) =
        ::QFlags<QTextDocument::MarkdownFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextDocument_MarkdownFeature__PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]))
        return QFlags_QTextDocument_MarkdownFeature__PythonToCpp_QFlags_QTextDocument_MarkdownFeature_;
    return {};
}
static PyObject *QFlags_QTextDocument_MarkdownFeature__CppToPython_QFlags_QTextDocument_MarkdownFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextDocument::MarkdownFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]));

}

static void QTextDocument_MarkdownFeature_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextDocument::MarkdownFeature> *>(cppOut) =
        ::QFlags<QTextDocument::MarkdownFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextDocument_MarkdownFeature_PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]))
        return QTextDocument_MarkdownFeature_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextDocument::MarkdownFeature> *>(cppOut) =
        ::QFlags<QTextDocument::MarkdownFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_;
    return {};
}
static void QTextDocument_FindFlag_PythonToCpp_QTextDocument_FindFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocument::FindFlag *>(cppOut) =
        static_cast<::QTextDocument::FindFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextDocument_FindFlag_PythonToCpp_QTextDocument_FindFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX]))
        return QTextDocument_FindFlag_PythonToCpp_QTextDocument_FindFlag;
    return {};
}
static PyObject *QTextDocument_FindFlag_CppToPython_QTextDocument_FindFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextDocument::FindFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX], castCppIn);

}

static void QFlags_QTextDocument_FindFlag__PythonToCpp_QFlags_QTextDocument_FindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextDocument::FindFlag> *>(cppOut) =
        ::QFlags<QTextDocument::FindFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextDocument_FindFlag__PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX]))
        return QFlags_QTextDocument_FindFlag__PythonToCpp_QFlags_QTextDocument_FindFlag_;
    return {};
}
static PyObject *QFlags_QTextDocument_FindFlag__CppToPython_QFlags_QTextDocument_FindFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextDocument::FindFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX]));

}

static void QTextDocument_FindFlag_PythonToCpp_QFlags_QTextDocument_FindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextDocument::FindFlag> *>(cppOut) =
        ::QFlags<QTextDocument::FindFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextDocument_FindFlag_PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX]))
        return QTextDocument_FindFlag_PythonToCpp_QFlags_QTextDocument_FindFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextDocument_FindFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextDocument::FindFlag> *>(cppOut) =
        ::QFlags<QTextDocument::FindFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextDocument_FindFlag_;
    return {};
}
static void QTextDocument_ResourceType_PythonToCpp_QTextDocument_ResourceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocument::ResourceType *>(cppOut) =
        static_cast<::QTextDocument::ResourceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextDocument_ResourceType_PythonToCpp_QTextDocument_ResourceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX]))
        return QTextDocument_ResourceType_PythonToCpp_QTextDocument_ResourceType;
    return {};
}
static PyObject *QTextDocument_ResourceType_CppToPython_QTextDocument_ResourceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextDocument::ResourceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX], castCppIn);

}

static void QTextDocument_Stacks_PythonToCpp_QTextDocument_Stacks(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextDocument::Stacks *>(cppOut) =
        static_cast<::QTextDocument::Stacks>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextDocument_Stacks_PythonToCpp_QTextDocument_Stacks_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX]))
        return QTextDocument_Stacks_PythonToCpp_QTextDocument_Stacks;
    return {};
}
static PyObject *QTextDocument_Stacks_CppToPython_QTextDocument_Stacks(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextDocument::Stacks *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextDocument_PythonToCpp_QTextDocument_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextDocument_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextDocument_PythonToCpp_QTextDocument_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextDocument_TypeF())))
        return QTextDocument_PythonToCpp_QTextDocument_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextDocument_PTR_CppToPython_QTextDocument(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QTextDocument *>(const_cast<void *>(cppIn)), Sbk_QTextDocument_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextDocument_SignatureStrings[] = {
    "1:PySide2.QtGui.QTextDocument(self,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtGui.QTextDocument(self,text:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtGui.QTextDocument.addResource(self,type:int,name:PySide2.QtCore.QUrl,resource:QVariant)",
    "PySide2.QtGui.QTextDocument.adjustSize(self)",
    "PySide2.QtGui.QTextDocument.allFormats(self)->QVector[PySide2.QtGui.QTextFormat]",
    "PySide2.QtGui.QTextDocument.availableRedoSteps(self)->int",
    "PySide2.QtGui.QTextDocument.availableUndoSteps(self)->int",
    "PySide2.QtGui.QTextDocument.baseUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtGui.QTextDocument.begin(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.blockCount(self)->int",
    "PySide2.QtGui.QTextDocument.characterAt(self,pos:int)->QChar",
    "PySide2.QtGui.QTextDocument.characterCount(self)->int",
    "PySide2.QtGui.QTextDocument.clear(self)",
    "PySide2.QtGui.QTextDocument.clearUndoRedoStacks(self,historyToClear:PySide2.QtGui.QTextDocument.Stacks=UndoAndRedoStacks)",
    "PySide2.QtGui.QTextDocument.clone(self,parent:PySide2.QtCore.QObject=nullptr)->PySide2.QtGui.QTextDocument",
    "PySide2.QtGui.QTextDocument.createObject(self,f:PySide2.QtGui.QTextFormat)->PySide2.QtGui.QTextObject",
    "PySide2.QtGui.QTextDocument.defaultCursorMoveStyle(self)->PySide2.QtCore.Qt.CursorMoveStyle",
    "PySide2.QtGui.QTextDocument.defaultFont(self)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QTextDocument.defaultStyleSheet(self)->QString",
    "PySide2.QtGui.QTextDocument.defaultTextOption(self)->PySide2.QtGui.QTextOption",
    "PySide2.QtGui.QTextDocument.documentLayout(self)->PySide2.QtGui.QAbstractTextDocumentLayout",
    "PySide2.QtGui.QTextDocument.documentMargin(self)->qreal",
    "PySide2.QtGui.QTextDocument.drawContents(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRectF=QRectF())",
    "PySide2.QtGui.QTextDocument.end(self)->PySide2.QtGui.QTextBlock",
    "5:PySide2.QtGui.QTextDocument.find(self,expr:PySide2.QtCore.QRegExp,cursor:PySide2.QtGui.QTextCursor,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "4:PySide2.QtGui.QTextDocument.find(self,expr:PySide2.QtCore.QRegExp,from:int=0,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "3:PySide2.QtGui.QTextDocument.find(self,expr:PySide2.QtCore.QRegularExpression,cursor:PySide2.QtGui.QTextCursor,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "2:PySide2.QtGui.QTextDocument.find(self,expr:PySide2.QtCore.QRegularExpression,from:int=0,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "1:PySide2.QtGui.QTextDocument.find(self,subString:QString,cursor:PySide2.QtGui.QTextCursor,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "0:PySide2.QtGui.QTextDocument.find(self,subString:QString,from:int=0,options:PySide2.QtGui.QTextDocument.FindFlags=QTextDocument.FindFlags())->PySide2.QtGui.QTextCursor",
    "PySide2.QtGui.QTextDocument.findBlock(self,pos:int)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.findBlockByLineNumber(self,blockNumber:int)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.findBlockByNumber(self,blockNumber:int)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.firstBlock(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.frameAt(self,pos:int)->PySide2.QtGui.QTextFrame",
    "PySide2.QtGui.QTextDocument.idealWidth(self)->qreal",
    "PySide2.QtGui.QTextDocument.indentWidth(self)->qreal",
    "PySide2.QtGui.QTextDocument.isEmpty(self)->bool",
    "PySide2.QtGui.QTextDocument.isModified(self)->bool",
    "PySide2.QtGui.QTextDocument.isRedoAvailable(self)->bool",
    "PySide2.QtGui.QTextDocument.isUndoAvailable(self)->bool",
    "PySide2.QtGui.QTextDocument.isUndoRedoEnabled(self)->bool",
    "PySide2.QtGui.QTextDocument.lastBlock(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextDocument.lineCount(self)->int",
    "PySide2.QtGui.QTextDocument.loadResource(self,type:int,name:PySide2.QtCore.QUrl)->QVariant",
    "PySide2.QtGui.QTextDocument.markContentsDirty(self,from:int,length:int)",
    "PySide2.QtGui.QTextDocument.maximumBlockCount(self)->int",
    "PySide2.QtGui.QTextDocument.metaInformation(self,info:PySide2.QtGui.QTextDocument.MetaInformation)->QString",
    "PySide2.QtGui.QTextDocument.object(self,objectIndex:int)->PySide2.QtGui.QTextObject",
    "PySide2.QtGui.QTextDocument.objectForFormat(self,arg__1:PySide2.QtGui.QTextFormat)->PySide2.QtGui.QTextObject",
    "PySide2.QtGui.QTextDocument.pageCount(self)->int",
    "PySide2.QtGui.QTextDocument.pageSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QTextDocument.print_(self,printer:PySide2.QtGui.QPagedPaintDevice)",
    "1:PySide2.QtGui.QTextDocument.redo(self)",
    "0:PySide2.QtGui.QTextDocument.redo(self,cursor:PySide2.QtGui.QTextCursor)",
    "PySide2.QtGui.QTextDocument.resource(self,type:int,name:PySide2.QtCore.QUrl)->QVariant",
    "PySide2.QtGui.QTextDocument.revision(self)->int",
    "PySide2.QtGui.QTextDocument.rootFrame(self)->PySide2.QtGui.QTextFrame",
    "PySide2.QtGui.QTextDocument.setBaseUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtGui.QTextDocument.setDefaultCursorMoveStyle(self,style:PySide2.QtCore.Qt.CursorMoveStyle)",
    "PySide2.QtGui.QTextDocument.setDefaultFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtGui.QTextDocument.setDefaultStyleSheet(self,sheet:QString)",
    "PySide2.QtGui.QTextDocument.setDefaultTextOption(self,option:PySide2.QtGui.QTextOption)",
    "PySide2.QtGui.QTextDocument.setDocumentLayout(self,layout:PySide2.QtGui.QAbstractTextDocumentLayout)",
    "PySide2.QtGui.QTextDocument.setDocumentMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextDocument.setHtml(self,html:QString)",
    "PySide2.QtGui.QTextDocument.setIndentWidth(self,width:qreal)",
    "PySide2.QtGui.QTextDocument.setMarkdown(self,markdown:QString,features:PySide2.QtGui.QTextDocument.MarkdownFeatures=QTextDocument.MarkdownDialectGitHub)",
    "PySide2.QtGui.QTextDocument.setMaximumBlockCount(self,maximum:int)",
    "PySide2.QtGui.QTextDocument.setMetaInformation(self,info:PySide2.QtGui.QTextDocument.MetaInformation,arg__2:QString)",
    "PySide2.QtGui.QTextDocument.setModified(self,m:bool=true)",
    "PySide2.QtGui.QTextDocument.setPageSize(self,size:PySide2.QtCore.QSizeF)",
    "PySide2.QtGui.QTextDocument.setPlainText(self,text:QString)",
    "PySide2.QtGui.QTextDocument.setTextWidth(self,width:qreal)",
    "PySide2.QtGui.QTextDocument.setUndoRedoEnabled(self,enable:bool)",
    "PySide2.QtGui.QTextDocument.setUseDesignMetrics(self,b:bool)",
    "PySide2.QtGui.QTextDocument.size(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QTextDocument.textWidth(self)->qreal",
    "PySide2.QtGui.QTextDocument.toHtml(self,encoding:PySide2.QtCore.QByteArray=QByteArray())->QString",
    "PySide2.QtGui.QTextDocument.toMarkdown(self,features:PySide2.QtGui.QTextDocument.MarkdownFeatures=QTextDocument.MarkdownDialectGitHub)->QString",
    "PySide2.QtGui.QTextDocument.toPlainText(self)->QString",
    "PySide2.QtGui.QTextDocument.toRawText(self)->QString",
    "1:PySide2.QtGui.QTextDocument.undo(self)",
    "0:PySide2.QtGui.QTextDocument.undo(self,cursor:PySide2.QtGui.QTextCursor)",
    "PySide2.QtGui.QTextDocument.useDesignMetrics(self)->bool",
    nullptr}; // Sentinel

void init_QTextDocument(PyObject *module)
{
    _Sbk_QTextDocument_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextDocument",
        "QTextDocument*",
        &Sbk_QTextDocument_spec,
        &Shiboken::callCppDestructor< ::QTextDocument >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextDocument_Type);
    InitSignatureStrings(pyType, QTextDocument_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextDocument_Type), Sbk_QTextDocument_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextDocument_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextDocument_TypeF(),
        QTextDocument_PythonToCpp_QTextDocument_PTR,
        is_QTextDocument_PythonToCpp_QTextDocument_PTR_Convertible,
        QTextDocument_PTR_CppToPython_QTextDocument);

    Shiboken::Conversions::registerConverterName(converter, "QTextDocument");
    Shiboken::Conversions::registerConverterName(converter, "QTextDocument*");
    Shiboken::Conversions::registerConverterName(converter, "QTextDocument&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextDocument).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextDocumentWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTextDocument_TypeF(), &Sbk_QTextDocument_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'MetaInformation'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextDocument_TypeF(),
        "MetaInformation",
        "2:PySide2.QtGui.QTextDocument.MetaInformation",
        "QTextDocument::MetaInformation");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX],
        Sbk_QTextDocument_TypeF(), "DocumentTitle", (long) QTextDocument::MetaInformation::DocumentTitle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX],
        Sbk_QTextDocument_TypeF(), "DocumentUrl", (long) QTextDocument::MetaInformation::DocumentUrl))
        return;
    // Register converter for enum 'QTextDocument::MetaInformation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX],
            QTextDocument_MetaInformation_CppToPython_QTextDocument_MetaInformation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_MetaInformation_PythonToCpp_QTextDocument_MetaInformation,
            is_QTextDocument_MetaInformation_PythonToCpp_QTextDocument_MetaInformation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_METAINFORMATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::MetaInformation");
        Shiboken::Conversions::registerConverterName(converter, "MetaInformation");
    }
    // End of 'MetaInformation' enum.

    // Initialization of enum 'MarkdownFeature'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTextDocument.MarkdownFeatures", SbkPySide2_QtGui_QTextDocument_MarkdownFeature_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextDocument_TypeF(),
        "MarkdownFeature",
        "2:PySide2.QtGui.QTextDocument.MarkdownFeature",
        "QTextDocument::MarkdownFeature",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX],
        Sbk_QTextDocument_TypeF(), "MarkdownNoHTML", (long) QTextDocument::MarkdownFeature::MarkdownNoHTML))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX],
        Sbk_QTextDocument_TypeF(), "MarkdownDialectCommonMark", (long) QTextDocument::MarkdownFeature::MarkdownDialectCommonMark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX],
        Sbk_QTextDocument_TypeF(), "MarkdownDialectGitHub", (long) QTextDocument::MarkdownFeature::MarkdownDialectGitHub))
        return;
    // Register converter for enum 'QTextDocument::MarkdownFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX],
            QTextDocument_MarkdownFeature_CppToPython_QTextDocument_MarkdownFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_MarkdownFeature_PythonToCpp_QTextDocument_MarkdownFeature,
            is_QTextDocument_MarkdownFeature_PythonToCpp_QTextDocument_MarkdownFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::MarkdownFeature");
        Shiboken::Conversions::registerConverterName(converter, "MarkdownFeature");
    }
    // Register converter for flag 'QFlags<QTextDocument::MarkdownFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX],
            QFlags_QTextDocument_MarkdownFeature__CppToPython_QFlags_QTextDocument_MarkdownFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_MarkdownFeature_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_,
            is_QTextDocument_MarkdownFeature_PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextDocument_MarkdownFeature__PythonToCpp_QFlags_QTextDocument_MarkdownFeature_,
            is_QFlags_QTextDocument_MarkdownFeature__PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextDocument_MarkdownFeature_,
            is_number_PythonToCpp_QFlags_QTextDocument_MarkdownFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_MARKDOWNFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::MarkdownFeatures");
        Shiboken::Conversions::registerConverterName(converter, "MarkdownFeatures");
    }
    // End of 'MarkdownFeature' enum/flags.

    // Initialization of enum 'FindFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTextDocument.FindFlags", SbkPySide2_QtGui_QTextDocument_FindFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextDocument_TypeF(),
        "FindFlag",
        "2:PySide2.QtGui.QTextDocument.FindFlag",
        "QTextDocument::FindFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX],
        Sbk_QTextDocument_TypeF(), "FindBackward", (long) QTextDocument::FindFlag::FindBackward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX],
        Sbk_QTextDocument_TypeF(), "FindCaseSensitively", (long) QTextDocument::FindFlag::FindCaseSensitively))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX],
        Sbk_QTextDocument_TypeF(), "FindWholeWords", (long) QTextDocument::FindFlag::FindWholeWords))
        return;
    // Register converter for enum 'QTextDocument::FindFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX],
            QTextDocument_FindFlag_CppToPython_QTextDocument_FindFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_FindFlag_PythonToCpp_QTextDocument_FindFlag,
            is_QTextDocument_FindFlag_PythonToCpp_QTextDocument_FindFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_FINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::FindFlag");
        Shiboken::Conversions::registerConverterName(converter, "FindFlag");
    }
    // Register converter for flag 'QFlags<QTextDocument::FindFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX],
            QFlags_QTextDocument_FindFlag__CppToPython_QFlags_QTextDocument_FindFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_FindFlag_PythonToCpp_QFlags_QTextDocument_FindFlag_,
            is_QTextDocument_FindFlag_PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextDocument_FindFlag__PythonToCpp_QFlags_QTextDocument_FindFlag_,
            is_QFlags_QTextDocument_FindFlag__PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextDocument_FindFlag_,
            is_number_PythonToCpp_QFlags_QTextDocument_FindFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTDOCUMENT_FINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::FindFlags");
        Shiboken::Conversions::registerConverterName(converter, "FindFlags");
    }
    // End of 'FindFlag' enum/flags.

    // Initialization of enum 'ResourceType'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextDocument_TypeF(),
        "ResourceType",
        "2:PySide2.QtGui.QTextDocument.ResourceType",
        "QTextDocument::ResourceType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "UnknownResource", (long) QTextDocument::ResourceType::UnknownResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "HtmlResource", (long) QTextDocument::ResourceType::HtmlResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "ImageResource", (long) QTextDocument::ResourceType::ImageResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "StyleSheetResource", (long) QTextDocument::ResourceType::StyleSheetResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "MarkdownResource", (long) QTextDocument::ResourceType::MarkdownResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
        Sbk_QTextDocument_TypeF(), "UserResource", (long) QTextDocument::ResourceType::UserResource))
        return;
    // Register converter for enum 'QTextDocument::ResourceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX],
            QTextDocument_ResourceType_CppToPython_QTextDocument_ResourceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_ResourceType_PythonToCpp_QTextDocument_ResourceType,
            is_QTextDocument_ResourceType_PythonToCpp_QTextDocument_ResourceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_RESOURCETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::ResourceType");
        Shiboken::Conversions::registerConverterName(converter, "ResourceType");
    }
    // End of 'ResourceType' enum.

    // Initialization of enum 'Stacks'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextDocument_TypeF(),
        "Stacks",
        "2:PySide2.QtGui.QTextDocument.Stacks",
        "QTextDocument::Stacks");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX],
        Sbk_QTextDocument_TypeF(), "UndoStack", (long) QTextDocument::Stacks::UndoStack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX],
        Sbk_QTextDocument_TypeF(), "RedoStack", (long) QTextDocument::Stacks::RedoStack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX],
        Sbk_QTextDocument_TypeF(), "UndoAndRedoStacks", (long) QTextDocument::Stacks::UndoAndRedoStacks))
        return;
    // Register converter for enum 'QTextDocument::Stacks'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX],
            QTextDocument_Stacks_CppToPython_QTextDocument_Stacks);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextDocument_Stacks_PythonToCpp_QTextDocument_Stacks,
            is_QTextDocument_Stacks_PythonToCpp_QTextDocument_Stacks_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_STACKS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextDocument::Stacks");
        Shiboken::Conversions::registerConverterName(converter, "Stacks");
    }
    // End of 'Stacks' enum.

    PySide::Signal::registerSignals(Sbk_QTextDocument_TypeF(), &::QTextDocument::staticMetaObject);
    qRegisterMetaType< ::QTextDocument::MetaInformation >("QTextDocument::MetaInformation");
    qRegisterMetaType< ::QTextDocument::MarkdownFeature >("QTextDocument::MarkdownFeature");
    qRegisterMetaType< ::QTextDocument::MarkdownFeatures >("QTextDocument::MarkdownFeatures");
    qRegisterMetaType< ::QTextDocument::FindFlag >("QTextDocument::FindFlag");
    qRegisterMetaType< ::QTextDocument::FindFlags >("QTextDocument::FindFlags");
    qRegisterMetaType< ::QTextDocument::ResourceType >("QTextDocument::ResourceType");
    qRegisterMetaType< ::QTextDocument::Stacks >("QTextDocument::Stacks");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QTextDocument_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QTextDocument_TypeF(), &::QTextDocument::staticMetaObject, sizeof(QTextDocumentWrapper));
}
