/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qsurfaceformat_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QtGui/qsurfaceformat.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSurfaceFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSurfaceFormat >()))
        return -1;

    ::QSurfaceFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSurfaceFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSurfaceFormat::QSurfaceFormat()
    // 1: QSurfaceFormat::QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption>)
    // 2: QSurfaceFormat::QSurfaceFormat(QSurfaceFormat)
    if (numArgs == 0) {
        overloadId = 0; // QSurfaceFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QSurfaceFormat(QSurfaceFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSurfaceFormat()
        {

            if (!PyErr_Occurred()) {
                // QSurfaceFormat()
                cptr = new ::QSurfaceFormat();
            }
            break;
        }
        case 1: // QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption> options)
        {
            ::QFlags<QSurfaceFormat::FormatOption> cppArg0 = QFlags<QSurfaceFormat::FormatOption>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption>)
                cptr = new ::QSurfaceFormat(cppArg0);
            }
            break;
        }
        case 2: // QSurfaceFormat(const QSurfaceFormat & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSurfaceFormat cppArg0_local;
            ::QSurfaceFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSurfaceFormat(QSurfaceFormat)
                cptr = new ::QSurfaceFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSurfaceFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSurfaceFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSurfaceFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSurfaceFormatFunc_alphaBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.alphaBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->alphaBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_blueBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.blueBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blueBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->blueBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_colorSpace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.colorSpace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorSpace()const
            QSurfaceFormat::ColorSpace cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->colorSpace();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_defaultFormat(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.defaultFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFormat()
            QSurfaceFormat cppResult = ::QSurfaceFormat::defaultFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_depthBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.depthBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depthBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->depthBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_greenBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.greenBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // greenBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->greenBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_hasAlpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.hasAlpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAlpha()const
            bool cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->hasAlpha();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.options";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // options()const
            QFlags<QSurfaceFormat::FormatOption> cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->options();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            QSurfaceFormat::OpenGLContextProfile cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_redBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.redBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // redBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->redBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_renderableType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.renderableType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderableType()const
            QSurfaceFormat::RenderableType cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->renderableType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_samples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.samples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // samples()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->samples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_setAlphaBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setAlphaBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setAlphaBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAlphaBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setAlphaBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlphaBufferSize(int)
            cppSelf->setAlphaBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setAlphaBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setBlueBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setBlueBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setBlueBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBlueBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setBlueBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlueBufferSize(int)
            cppSelf->setBlueBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setBlueBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setColorSpace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setColorSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setColorSpace(QSurfaceFormat::ColorSpace)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColorSpace(QSurfaceFormat::ColorSpace)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setColorSpace_TypeError;

    // Call function/method
    {
        ::QSurfaceFormat::ColorSpace cppArg0{QSurfaceFormat::DefaultColorSpace};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorSpace(QSurfaceFormat::ColorSpace)
            cppSelf->setColorSpace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setColorSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setDefaultFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setDefaultFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSurfaceFormat::setDefaultFormat(QSurfaceFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultFormat(QSurfaceFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setDefaultFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurfaceFormat cppArg0_local;
        ::QSurfaceFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultFormat(QSurfaceFormat)
            ::QSurfaceFormat::setDefaultFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setDefaultFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setDepthBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setDepthBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setDepthBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDepthBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setDepthBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepthBufferSize(int)
            cppSelf->setDepthBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setDepthBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setGreenBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setGreenBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setGreenBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGreenBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setGreenBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGreenBufferSize(int)
            cppSelf->setGreenBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setGreenBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setMajorVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setMajorVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setMajorVersion(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMajorVersion(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setMajorVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMajorVersion(int)
            cppSelf->setMajorVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setMajorVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setMinorVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setMinorVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setMinorVersion(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinorVersion(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setMinorVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinorVersion(int)
            cppSelf->setMinorVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setMinorVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setOption(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setOption", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSurfaceFormat::setOption(QFlags<QSurfaceFormat::FormatOption>)
    // 1: QSurfaceFormat::setOption(QSurfaceFormat::FormatOption,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setOption(QSurfaceFormat::FormatOption,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 1; // setOption(QSurfaceFormat::FormatOption,bool)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setOption(QFlags<QSurfaceFormat::FormatOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setOption_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setOption(QFlags<QSurfaceFormat::FormatOption> opt)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
            }
            ::QFlags<QSurfaceFormat::FormatOption> cppArg0 = QFlags<QSurfaceFormat::FormatOption>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setOption(QFlags<QSurfaceFormat::FormatOption>)
                cppSelf->setOption(cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QSurfaceFormat.setOption(QFlags<QSurfaceFormat::FormatOption> opt) is deprecated", 1);
            break;
        }
        case 1: // setOption(QSurfaceFormat::FormatOption option, bool on)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_on = Shiboken::String::createStaticString("on");
                if (PyDict_Contains(kwds, key_on)) {
                    value = PyDict_GetItem(kwds, key_on);
                    if (value && pyArgs[1]) {
                        errInfo = key_on;
                        Py_INCREF(errInfo);
                        goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                            goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_on);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSurfaceFormatFunc_setOption_TypeError;
                }
            }
            ::QSurfaceFormat::FormatOption cppArg0 = static_cast< ::QSurfaceFormat::FormatOption>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1 = true;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setOption(QSurfaceFormat::FormatOption,bool)
                cppSelf->setOption(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setOptions(QFlags<QSurfaceFormat::FormatOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<QSurfaceFormat::FormatOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QSurfaceFormat::FormatOption> cppArg0 = QFlags<QSurfaceFormat::FormatOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptions(QFlags<QSurfaceFormat::FormatOption>)
            cppSelf->setOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setProfile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setProfile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setProfile(QSurfaceFormat::OpenGLContextProfile)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProfile(QSurfaceFormat::OpenGLContextProfile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setProfile_TypeError;

    // Call function/method
    {
        ::QSurfaceFormat::OpenGLContextProfile cppArg0{QSurfaceFormat::NoProfile};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProfile(QSurfaceFormat::OpenGLContextProfile)
            cppSelf->setProfile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setProfile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setRedBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setRedBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setRedBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRedBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setRedBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRedBufferSize(int)
            cppSelf->setRedBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setRedBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setRenderableType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setRenderableType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setRenderableType(QSurfaceFormat::RenderableType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRenderableType(QSurfaceFormat::RenderableType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setRenderableType_TypeError;

    // Call function/method
    {
        ::QSurfaceFormat::RenderableType cppArg0{QSurfaceFormat::DefaultRenderableType};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRenderableType(QSurfaceFormat::RenderableType)
            cppSelf->setRenderableType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setRenderableType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setSamples(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setSamples";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setSamples(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSamples(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setSamples_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSamples(int)
            cppSelf->setSamples(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setSamples_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setStencilBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setStencilBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setStencilBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStencilBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setStencilBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStencilBufferSize(int)
            cppSelf->setStencilBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setStencilBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setStereo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setStereo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setStereo(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStereo(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setStereo_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStereo(bool)
            cppSelf->setStereo(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setStereo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setSwapBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setSwapBehavior";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setSwapBehavior(QSurfaceFormat::SwapBehavior)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSwapBehavior(QSurfaceFormat::SwapBehavior)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setSwapBehavior_TypeError;

    // Call function/method
    {
        ::QSurfaceFormat::SwapBehavior cppArg0{QSurfaceFormat::DefaultSwapBehavior};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSwapBehavior(QSurfaceFormat::SwapBehavior)
            cppSelf->setSwapBehavior(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setSwapBehavior_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setSwapInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setSwapInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::setSwapInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSwapInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setSwapInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSwapInterval(int)
            cppSelf->setSwapInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setSwapInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_setVersion(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.setVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setVersion", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSurfaceFormat::setVersion(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setVersion(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_setVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setVersion(int,int)
            cppSelf->setVersion(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSurfaceFormatFunc_setVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_stencilBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.stencilBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stencilBufferSize()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->stencilBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_stereo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.stereo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stereo()const
            bool cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->stereo();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_swapBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.swapBehavior";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // swapBehavior()const
            QSurfaceFormat::SwapBehavior cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->swapBehavior();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_swapInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.swapInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // swapInterval()const
            int cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->swapInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormatFunc_testOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.testOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSurfaceFormat::testOption(QFlags<QSurfaceFormat::FormatOption>)const
    // 1: QSurfaceFormat::testOption(QSurfaceFormat::FormatOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 1; // testOption(QSurfaceFormat::FormatOption)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testOption(QFlags<QSurfaceFormat::FormatOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSurfaceFormatFunc_testOption_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // testOption(QFlags<QSurfaceFormat::FormatOption> opt) const
        {
            ::QFlags<QSurfaceFormat::FormatOption> cppArg0 = QFlags<QSurfaceFormat::FormatOption>(0);
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // testOption(QFlags<QSurfaceFormat::FormatOption>)const
                bool cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->testOption(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QSurfaceFormat.testOption(QFlags<QSurfaceFormat::FormatOption> opt) const is deprecated", 1);
            break;
        }
        case 1: // testOption(QSurfaceFormat::FormatOption option) const
        {
            ::QSurfaceFormat::FormatOption cppArg0 = static_cast< ::QSurfaceFormat::FormatOption>(0);
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // testOption(QSurfaceFormat::FormatOption)const
                bool cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->testOption(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSurfaceFormatFunc_testOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSurfaceFormatFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QSurfaceFormat.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QPair<int,int > cppResult = const_cast<const ::QSurfaceFormat *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSurfaceFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSurfaceFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSurfaceFormat_methods[] = {
    {"alphaBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_alphaBufferSize), METH_NOARGS},
    {"blueBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_blueBufferSize), METH_NOARGS},
    {"colorSpace", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_colorSpace), METH_NOARGS},
    {"defaultFormat", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_defaultFormat), METH_NOARGS|METH_STATIC},
    {"depthBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_depthBufferSize), METH_NOARGS},
    {"greenBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_greenBufferSize), METH_NOARGS},
    {"hasAlpha", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_hasAlpha), METH_NOARGS},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_majorVersion), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_minorVersion), METH_NOARGS},
    {"options", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_options), METH_NOARGS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_profile), METH_NOARGS},
    {"redBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_redBufferSize), METH_NOARGS},
    {"renderableType", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_renderableType), METH_NOARGS},
    {"samples", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_samples), METH_NOARGS},
    {"setAlphaBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setAlphaBufferSize), METH_O},
    {"setBlueBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setBlueBufferSize), METH_O},
    {"setColorSpace", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setColorSpace), METH_O},
    {"setDefaultFormat", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setDefaultFormat), METH_O|METH_STATIC},
    {"setDepthBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setDepthBufferSize), METH_O},
    {"setGreenBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setGreenBufferSize), METH_O},
    {"setMajorVersion", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setMajorVersion), METH_O},
    {"setMinorVersion", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setMinorVersion), METH_O},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setOption), METH_VARARGS|METH_KEYWORDS},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setOptions), METH_O},
    {"setProfile", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setProfile), METH_O},
    {"setRedBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setRedBufferSize), METH_O},
    {"setRenderableType", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setRenderableType), METH_O},
    {"setSamples", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setSamples), METH_O},
    {"setStencilBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setStencilBufferSize), METH_O},
    {"setStereo", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setStereo), METH_O},
    {"setSwapBehavior", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setSwapBehavior), METH_O},
    {"setSwapInterval", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setSwapInterval), METH_O},
    {"setVersion", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_setVersion), METH_VARARGS},
    {"stencilBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_stencilBufferSize), METH_NOARGS},
    {"stereo", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_stereo), METH_NOARGS},
    {"swapBehavior", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_swapBehavior), METH_NOARGS},
    {"swapInterval", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_swapInterval), METH_NOARGS},
    {"testOption", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_testOption), METH_O},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormatFunc_version), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSurfaceFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QSurfaceFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QSurfaceFormat & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSurfaceFormat cppArg0_local;
                ::QSurfaceFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
                // operator==(const QSurfaceFormat & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSurfaceFormat cppArg0_local;
                ::QSurfaceFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSurfaceFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSurfaceFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSurfaceFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSurfaceFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSurfaceFormat__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSurfaceFormat_Type = nullptr;
static SbkObjectType *Sbk_QSurfaceFormat_TypeF(void)
{
    return _Sbk_QSurfaceFormat_Type;
}

static PyType_Slot Sbk_QSurfaceFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSurfaceFormat__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSurfaceFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSurfaceFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSurfaceFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSurfaceFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSurfaceFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSurfaceFormat_spec = {
    "2:PySide2.QtGui.QSurfaceFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSurfaceFormat_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QSurfaceFormat_FormatOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QSurfaceFormat::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QSurfaceFormat_FormatOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QSurfaceFormat::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QSurfaceFormat_FormatOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSurfaceFormat::FormatOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSurfaceFormat::FormatOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QSurfaceFormat_FormatOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSurfaceFormat::FormatOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, self, &cppSelf);
    ::QSurfaceFormat::FormatOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QSurfaceFormat_FormatOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QSurfaceFormat_FormatOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QSurfaceFormat_FormatOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QSurfaceFormat_FormatOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSurfaceFormat_FormatOption_PythonToCpp_QSurfaceFormat_FormatOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat::FormatOption *>(cppOut) =
        static_cast<::QSurfaceFormat::FormatOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurfaceFormat_FormatOption_PythonToCpp_QSurfaceFormat_FormatOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX]))
        return QSurfaceFormat_FormatOption_PythonToCpp_QSurfaceFormat_FormatOption;
    return {};
}
static PyObject *QSurfaceFormat_FormatOption_CppToPython_QSurfaceFormat_FormatOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurfaceFormat::FormatOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX], castCppIn);

}

static void QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QFlags_QSurfaceFormat_FormatOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSurfaceFormat::FormatOption> *>(cppOut) =
        ::QFlags<QSurfaceFormat::FormatOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX]))
        return QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QFlags_QSurfaceFormat_FormatOption_;
    return {};
}
static PyObject *QFlags_QSurfaceFormat_FormatOption__CppToPython_QFlags_QSurfaceFormat_FormatOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSurfaceFormat::FormatOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX]));

}

static void QSurfaceFormat_FormatOption_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSurfaceFormat::FormatOption> *>(cppOut) =
        ::QFlags<QSurfaceFormat::FormatOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSurfaceFormat_FormatOption_PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX]))
        return QSurfaceFormat_FormatOption_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSurfaceFormat::FormatOption> *>(cppOut) =
        ::QFlags<QSurfaceFormat::FormatOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX]))
        return number_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_;
    return {};
}
static void QSurfaceFormat_SwapBehavior_PythonToCpp_QSurfaceFormat_SwapBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat::SwapBehavior *>(cppOut) =
        static_cast<::QSurfaceFormat::SwapBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurfaceFormat_SwapBehavior_PythonToCpp_QSurfaceFormat_SwapBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX]))
        return QSurfaceFormat_SwapBehavior_PythonToCpp_QSurfaceFormat_SwapBehavior;
    return {};
}
static PyObject *QSurfaceFormat_SwapBehavior_CppToPython_QSurfaceFormat_SwapBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurfaceFormat::SwapBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX], castCppIn);

}

static void QSurfaceFormat_RenderableType_PythonToCpp_QSurfaceFormat_RenderableType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat::RenderableType *>(cppOut) =
        static_cast<::QSurfaceFormat::RenderableType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurfaceFormat_RenderableType_PythonToCpp_QSurfaceFormat_RenderableType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX]))
        return QSurfaceFormat_RenderableType_PythonToCpp_QSurfaceFormat_RenderableType;
    return {};
}
static PyObject *QSurfaceFormat_RenderableType_CppToPython_QSurfaceFormat_RenderableType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurfaceFormat::RenderableType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX], castCppIn);

}

static void QSurfaceFormat_OpenGLContextProfile_PythonToCpp_QSurfaceFormat_OpenGLContextProfile(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat::OpenGLContextProfile *>(cppOut) =
        static_cast<::QSurfaceFormat::OpenGLContextProfile>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurfaceFormat_OpenGLContextProfile_PythonToCpp_QSurfaceFormat_OpenGLContextProfile_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX]))
        return QSurfaceFormat_OpenGLContextProfile_PythonToCpp_QSurfaceFormat_OpenGLContextProfile;
    return {};
}
static PyObject *QSurfaceFormat_OpenGLContextProfile_CppToPython_QSurfaceFormat_OpenGLContextProfile(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurfaceFormat::OpenGLContextProfile *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX], castCppIn);

}

static void QSurfaceFormat_ColorSpace_PythonToCpp_QSurfaceFormat_ColorSpace(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat::ColorSpace *>(cppOut) =
        static_cast<::QSurfaceFormat::ColorSpace>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSurfaceFormat_ColorSpace_PythonToCpp_QSurfaceFormat_ColorSpace_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX]))
        return QSurfaceFormat_ColorSpace_PythonToCpp_QSurfaceFormat_ColorSpace;
    return {};
}
static PyObject *QSurfaceFormat_ColorSpace_CppToPython_QSurfaceFormat_ColorSpace(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSurfaceFormat::ColorSpace *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSurfaceFormat_PythonToCpp_QSurfaceFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSurfaceFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSurfaceFormat_PythonToCpp_QSurfaceFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSurfaceFormat_TypeF())))
        return QSurfaceFormat_PythonToCpp_QSurfaceFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSurfaceFormat_PTR_CppToPython_QSurfaceFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSurfaceFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSurfaceFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSurfaceFormat_COPY_CppToPython_QSurfaceFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSurfaceFormat_TypeF(), new ::QSurfaceFormat(*reinterpret_cast<const ::QSurfaceFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSurfaceFormat_PythonToCpp_QSurfaceFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSurfaceFormat *>(cppOut) = *reinterpret_cast< ::QSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSurfaceFormat_PythonToCpp_QSurfaceFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSurfaceFormat_TypeF())))
        return QSurfaceFormat_PythonToCpp_QSurfaceFormat_COPY;
    return {};
}

// Implicit conversions.
static void QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QSurfaceFormat(PyObject *pyIn, void *cppOut) {
    ::QFlags<QSurfaceFormat::FormatOption> cppIn = QFlags<QSurfaceFormat::FormatOption>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QSurfaceFormat *>(cppOut) = ::QSurfaceFormat(cppIn);
}
static PythonToCppFunc is_QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QSurfaceFormat_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX], pyIn))
        return QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QSurfaceFormat;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSurfaceFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QSurfaceFormat(self)",
    "1:PySide2.QtGui.QSurfaceFormat(self,options:PySide2.QtGui.QSurfaceFormat.FormatOptions)",
    "0:PySide2.QtGui.QSurfaceFormat(self,other:PySide2.QtGui.QSurfaceFormat)",
    "PySide2.QtGui.QSurfaceFormat.alphaBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.blueBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.colorSpace(self)->PySide2.QtGui.QSurfaceFormat.ColorSpace",
    "PySide2.QtGui.QSurfaceFormat.defaultFormat()->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtGui.QSurfaceFormat.depthBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.greenBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.hasAlpha(self)->bool",
    "PySide2.QtGui.QSurfaceFormat.majorVersion(self)->int",
    "PySide2.QtGui.QSurfaceFormat.minorVersion(self)->int",
    "PySide2.QtGui.QSurfaceFormat.options(self)->PySide2.QtGui.QSurfaceFormat.FormatOptions",
    "PySide2.QtGui.QSurfaceFormat.profile(self)->PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile",
    "PySide2.QtGui.QSurfaceFormat.redBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.renderableType(self)->PySide2.QtGui.QSurfaceFormat.RenderableType",
    "PySide2.QtGui.QSurfaceFormat.samples(self)->int",
    "PySide2.QtGui.QSurfaceFormat.setAlphaBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setBlueBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setColorSpace(self,colorSpace:PySide2.QtGui.QSurfaceFormat.ColorSpace)",
    "PySide2.QtGui.QSurfaceFormat.setDefaultFormat(format:PySide2.QtGui.QSurfaceFormat)",
    "PySide2.QtGui.QSurfaceFormat.setDepthBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setGreenBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setMajorVersion(self,majorVersion:int)",
    "PySide2.QtGui.QSurfaceFormat.setMinorVersion(self,minorVersion:int)",
    "1:PySide2.QtGui.QSurfaceFormat.setOption(self,opt:PySide2.QtGui.QSurfaceFormat.FormatOptions)",
    "0:PySide2.QtGui.QSurfaceFormat.setOption(self,option:PySide2.QtGui.QSurfaceFormat.FormatOption,on:bool=true)",
    "PySide2.QtGui.QSurfaceFormat.setOptions(self,options:PySide2.QtGui.QSurfaceFormat.FormatOptions)",
    "PySide2.QtGui.QSurfaceFormat.setProfile(self,profile:PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile)",
    "PySide2.QtGui.QSurfaceFormat.setRedBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setRenderableType(self,type:PySide2.QtGui.QSurfaceFormat.RenderableType)",
    "PySide2.QtGui.QSurfaceFormat.setSamples(self,numSamples:int)",
    "PySide2.QtGui.QSurfaceFormat.setStencilBufferSize(self,size:int)",
    "PySide2.QtGui.QSurfaceFormat.setStereo(self,enable:bool)",
    "PySide2.QtGui.QSurfaceFormat.setSwapBehavior(self,behavior:PySide2.QtGui.QSurfaceFormat.SwapBehavior)",
    "PySide2.QtGui.QSurfaceFormat.setSwapInterval(self,interval:int)",
    "PySide2.QtGui.QSurfaceFormat.setVersion(self,major:int,minor:int)",
    "PySide2.QtGui.QSurfaceFormat.stencilBufferSize(self)->int",
    "PySide2.QtGui.QSurfaceFormat.stereo(self)->bool",
    "PySide2.QtGui.QSurfaceFormat.swapBehavior(self)->PySide2.QtGui.QSurfaceFormat.SwapBehavior",
    "PySide2.QtGui.QSurfaceFormat.swapInterval(self)->int",
    "1:PySide2.QtGui.QSurfaceFormat.testOption(self,opt:PySide2.QtGui.QSurfaceFormat.FormatOptions)->bool",
    "0:PySide2.QtGui.QSurfaceFormat.testOption(self,option:PySide2.QtGui.QSurfaceFormat.FormatOption)->bool",
    "PySide2.QtGui.QSurfaceFormat.version(self)->QPair[int, int]",
    "PySide2.QtGui.QSurfaceFormat.__copy__()",
    nullptr}; // Sentinel

void init_QSurfaceFormat(PyObject *module)
{
    _Sbk_QSurfaceFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSurfaceFormat",
        "QSurfaceFormat",
        &Sbk_QSurfaceFormat_spec,
        &Shiboken::callCppDestructor< ::QSurfaceFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSurfaceFormat_Type);
    InitSignatureStrings(pyType, QSurfaceFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSurfaceFormat_Type), Sbk_QSurfaceFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSurfaceFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSurfaceFormat_TypeF(),
        QSurfaceFormat_PythonToCpp_QSurfaceFormat_PTR,
        is_QSurfaceFormat_PythonToCpp_QSurfaceFormat_PTR_Convertible,
        QSurfaceFormat_PTR_CppToPython_QSurfaceFormat,
        QSurfaceFormat_COPY_CppToPython_QSurfaceFormat);

    Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat");
    Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSurfaceFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSurfaceFormat_PythonToCpp_QSurfaceFormat_COPY,
        is_QSurfaceFormat_PythonToCpp_QSurfaceFormat_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QSurfaceFormat,
        is_QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QSurfaceFormat_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FormatOption'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QSurfaceFormat.FormatOptions", SbkPySide2_QtGui_QSurfaceFormat_FormatOption_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurfaceFormat_TypeF(),
        "FormatOption",
        "2:PySide2.QtGui.QSurfaceFormat.FormatOption",
        "QSurfaceFormat::FormatOption",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX],
        Sbk_QSurfaceFormat_TypeF(), "StereoBuffers", (long) QSurfaceFormat::FormatOption::StereoBuffers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DebugContext", (long) QSurfaceFormat::FormatOption::DebugContext))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DeprecatedFunctions", (long) QSurfaceFormat::FormatOption::DeprecatedFunctions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX],
        Sbk_QSurfaceFormat_TypeF(), "ResetNotification", (long) QSurfaceFormat::FormatOption::ResetNotification))
        return;
    // Register converter for enum 'QSurfaceFormat::FormatOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX],
            QSurfaceFormat_FormatOption_CppToPython_QSurfaceFormat_FormatOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_FormatOption_PythonToCpp_QSurfaceFormat_FormatOption,
            is_QSurfaceFormat_FormatOption_PythonToCpp_QSurfaceFormat_FormatOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_FORMATOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::FormatOption");
        Shiboken::Conversions::registerConverterName(converter, "FormatOption");
    }
    // Register converter for flag 'QFlags<QSurfaceFormat::FormatOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX],
            QFlags_QSurfaceFormat_FormatOption__CppToPython_QFlags_QSurfaceFormat_FormatOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_FormatOption_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_,
            is_QSurfaceFormat_FormatOption_PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QFlags_QSurfaceFormat_FormatOption_,
            is_QFlags_QSurfaceFormat_FormatOption__PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSurfaceFormat_FormatOption_,
            is_number_PythonToCpp_QFlags_QSurfaceFormat_FormatOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QSURFACEFORMAT_FORMATOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::FormatOptions");
        Shiboken::Conversions::registerConverterName(converter, "FormatOptions");
    }
    // End of 'FormatOption' enum/flags.

    // Initialization of enum 'SwapBehavior'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurfaceFormat_TypeF(),
        "SwapBehavior",
        "2:PySide2.QtGui.QSurfaceFormat.SwapBehavior",
        "QSurfaceFormat::SwapBehavior");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DefaultSwapBehavior", (long) QSurfaceFormat::SwapBehavior::DefaultSwapBehavior))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX],
        Sbk_QSurfaceFormat_TypeF(), "SingleBuffer", (long) QSurfaceFormat::SwapBehavior::SingleBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DoubleBuffer", (long) QSurfaceFormat::SwapBehavior::DoubleBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX],
        Sbk_QSurfaceFormat_TypeF(), "TripleBuffer", (long) QSurfaceFormat::SwapBehavior::TripleBuffer))
        return;
    // Register converter for enum 'QSurfaceFormat::SwapBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX],
            QSurfaceFormat_SwapBehavior_CppToPython_QSurfaceFormat_SwapBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_SwapBehavior_PythonToCpp_QSurfaceFormat_SwapBehavior,
            is_QSurfaceFormat_SwapBehavior_PythonToCpp_QSurfaceFormat_SwapBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_SWAPBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::SwapBehavior");
        Shiboken::Conversions::registerConverterName(converter, "SwapBehavior");
    }
    // End of 'SwapBehavior' enum.

    // Initialization of enum 'RenderableType'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurfaceFormat_TypeF(),
        "RenderableType",
        "2:PySide2.QtGui.QSurfaceFormat.RenderableType",
        "QSurfaceFormat::RenderableType");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DefaultRenderableType", (long) QSurfaceFormat::RenderableType::DefaultRenderableType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "OpenGL", (long) QSurfaceFormat::RenderableType::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "OpenGLES", (long) QSurfaceFormat::RenderableType::OpenGLES))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "OpenVG", (long) QSurfaceFormat::RenderableType::OpenVG))
        return;
    // Register converter for enum 'QSurfaceFormat::RenderableType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX],
            QSurfaceFormat_RenderableType_CppToPython_QSurfaceFormat_RenderableType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_RenderableType_PythonToCpp_QSurfaceFormat_RenderableType,
            is_QSurfaceFormat_RenderableType_PythonToCpp_QSurfaceFormat_RenderableType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_RENDERABLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::RenderableType");
        Shiboken::Conversions::registerConverterName(converter, "RenderableType");
    }
    // End of 'RenderableType' enum.

    // Initialization of enum 'OpenGLContextProfile'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurfaceFormat_TypeF(),
        "OpenGLContextProfile",
        "2:PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile",
        "QSurfaceFormat::OpenGLContextProfile");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "NoProfile", (long) QSurfaceFormat::OpenGLContextProfile::NoProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "CoreProfile", (long) QSurfaceFormat::OpenGLContextProfile::CoreProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "CompatibilityProfile", (long) QSurfaceFormat::OpenGLContextProfile::CompatibilityProfile))
        return;
    // Register converter for enum 'QSurfaceFormat::OpenGLContextProfile'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX],
            QSurfaceFormat_OpenGLContextProfile_CppToPython_QSurfaceFormat_OpenGLContextProfile);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_OpenGLContextProfile_PythonToCpp_QSurfaceFormat_OpenGLContextProfile,
            is_QSurfaceFormat_OpenGLContextProfile_PythonToCpp_QSurfaceFormat_OpenGLContextProfile_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::OpenGLContextProfile");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLContextProfile");
    }
    // End of 'OpenGLContextProfile' enum.

    // Initialization of enum 'ColorSpace'.
    SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSurfaceFormat_TypeF(),
        "ColorSpace",
        "2:PySide2.QtGui.QSurfaceFormat.ColorSpace",
        "QSurfaceFormat::ColorSpace");
    if (!SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "DefaultColorSpace", (long) QSurfaceFormat::ColorSpace::DefaultColorSpace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX],
        Sbk_QSurfaceFormat_TypeF(), "sRGBColorSpace", (long) QSurfaceFormat::ColorSpace::sRGBColorSpace))
        return;
    // Register converter for enum 'QSurfaceFormat::ColorSpace'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX],
            QSurfaceFormat_ColorSpace_CppToPython_QSurfaceFormat_ColorSpace);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSurfaceFormat_ColorSpace_PythonToCpp_QSurfaceFormat_ColorSpace,
            is_QSurfaceFormat_ColorSpace_PythonToCpp_QSurfaceFormat_ColorSpace_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_COLORSPACE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSurfaceFormat::ColorSpace");
        Shiboken::Conversions::registerConverterName(converter, "ColorSpace");
    }
    // End of 'ColorSpace' enum.

    qRegisterMetaType< ::QSurfaceFormat >("QSurfaceFormat");
    qRegisterMetaType< ::QSurfaceFormat::FormatOption >("QSurfaceFormat::FormatOption");
    qRegisterMetaType< ::QSurfaceFormat::FormatOptions >("QSurfaceFormat::FormatOptions");
    qRegisterMetaType< ::QSurfaceFormat::SwapBehavior >("QSurfaceFormat::SwapBehavior");
    qRegisterMetaType< ::QSurfaceFormat::RenderableType >("QSurfaceFormat::RenderableType");
    qRegisterMetaType< ::QSurfaceFormat::OpenGLContextProfile >("QSurfaceFormat::OpenGLContextProfile");
    qRegisterMetaType< ::QSurfaceFormat::ColorSpace >("QSurfaceFormat::ColorSpace");
}
