/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qstylehints_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStyleHintsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void QStyleHintsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleHintsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleHintsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleHintsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QStyleHintsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyleHints.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStyleHintsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyleHints.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QStyleHintsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QStyleHintsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QStyleHints::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStyleHintsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QStyleHints::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStyleHintsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStyleHintsWrapper *>(this));
        return QStyleHints::qt_metacast(_clname);
}

QStyleHintsWrapper::~QStyleHintsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QStyleHintsFunc_cursorFlashTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.cursorFlashTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cursorFlashTime()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->cursorFlashTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_fontSmoothingGamma(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.fontSmoothingGamma";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontSmoothingGamma()const
            qreal cppResult = const_cast<const ::QStyleHints *>(cppSelf)->fontSmoothingGamma();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_keyboardAutoRepeatRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.keyboardAutoRepeatRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardAutoRepeatRate()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->keyboardAutoRepeatRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_keyboardInputInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.keyboardInputInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardInputInterval()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->keyboardInputInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_mouseDoubleClickDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.mouseDoubleClickDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseDoubleClickDistance()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->mouseDoubleClickDistance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_mouseDoubleClickInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.mouseDoubleClickInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseDoubleClickInterval()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->mouseDoubleClickInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_mousePressAndHoldInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.mousePressAndHoldInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mousePressAndHoldInterval()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->mousePressAndHoldInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_mouseQuickSelectionThreshold(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.mouseQuickSelectionThreshold";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseQuickSelectionThreshold()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->mouseQuickSelectionThreshold();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_passwordMaskCharacter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.passwordMaskCharacter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // passwordMaskCharacter()const
            QChar cppResult = const_cast<const ::QStyleHints *>(cppSelf)->passwordMaskCharacter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_passwordMaskDelay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.passwordMaskDelay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // passwordMaskDelay()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->passwordMaskDelay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_setCursorFlashTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setCursorFlashTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setCursorFlashTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCursorFlashTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setCursorFlashTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCursorFlashTime(int)
            cppSelf->setCursorFlashTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setCursorFlashTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setFocusOnTouchRelease(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setFocusOnTouchRelease";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // setFocusOnTouchRelease()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->setFocusOnTouchRelease();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_setKeyboardInputInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setKeyboardInputInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setKeyboardInputInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setKeyboardInputInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setKeyboardInputInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeyboardInputInterval(int)
            cppSelf->setKeyboardInputInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setKeyboardInputInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setMouseDoubleClickInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setMouseDoubleClickInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setMouseDoubleClickInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMouseDoubleClickInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setMouseDoubleClickInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMouseDoubleClickInterval(int)
            cppSelf->setMouseDoubleClickInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setMouseDoubleClickInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setMousePressAndHoldInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setMousePressAndHoldInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setMousePressAndHoldInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMousePressAndHoldInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setMousePressAndHoldInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMousePressAndHoldInterval(int)
            cppSelf->setMousePressAndHoldInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setMousePressAndHoldInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setMouseQuickSelectionThreshold(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setMouseQuickSelectionThreshold";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setMouseQuickSelectionThreshold(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMouseQuickSelectionThreshold(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setMouseQuickSelectionThreshold_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMouseQuickSelectionThreshold(int)
            cppSelf->setMouseQuickSelectionThreshold(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setMouseQuickSelectionThreshold_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setShowShortcutsInContextMenus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setShowShortcutsInContextMenus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setShowShortcutsInContextMenus(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowShortcutsInContextMenus(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setShowShortcutsInContextMenus_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShowShortcutsInContextMenus(bool)
            cppSelf->setShowShortcutsInContextMenus(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setShowShortcutsInContextMenus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setStartDragDistance(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setStartDragDistance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setStartDragDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStartDragDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setStartDragDistance_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartDragDistance(int)
            cppSelf->setStartDragDistance(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setStartDragDistance_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setStartDragTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setStartDragTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setStartDragTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStartDragTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setStartDragTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartDragTime(int)
            cppSelf->setStartDragTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setStartDragTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setTabFocusBehavior(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setTabFocusBehavior";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setTabFocusBehavior(Qt::TabFocusBehavior)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTabFocusBehavior(Qt::TabFocusBehavior)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setTabFocusBehavior_TypeError;

    // Call function/method
    {
        ::Qt::TabFocusBehavior cppArg0{Qt::NoTabFocus};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabFocusBehavior(Qt::TabFocusBehavior)
            cppSelf->setTabFocusBehavior(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setTabFocusBehavior_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setUseHoverEffects(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setUseHoverEffects";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setUseHoverEffects(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseHoverEffects(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setUseHoverEffects_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseHoverEffects(bool)
            cppSelf->setUseHoverEffects(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setUseHoverEffects_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_setWheelScrollLines(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.setWheelScrollLines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyleHints::setWheelScrollLines(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWheelScrollLines(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintsFunc_setWheelScrollLines_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWheelScrollLines(int)
            cppSelf->setWheelScrollLines(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleHintsFunc_setWheelScrollLines_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleHintsFunc_showIsFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.showIsFullScreen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showIsFullScreen()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->showIsFullScreen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_showIsMaximized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.showIsMaximized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showIsMaximized()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->showIsMaximized();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_showShortcutsInContextMenus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.showShortcutsInContextMenus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // showShortcutsInContextMenus()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->showShortcutsInContextMenus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_singleClickActivation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.singleClickActivation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // singleClickActivation()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->singleClickActivation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_startDragDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.startDragDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startDragDistance()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->startDragDistance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_startDragTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.startDragTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startDragTime()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->startDragTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_startDragVelocity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.startDragVelocity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startDragVelocity()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->startDragVelocity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_tabFocusBehavior(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.tabFocusBehavior";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabFocusBehavior()const
            Qt::TabFocusBehavior cppResult = const_cast<const ::QStyleHints *>(cppSelf)->tabFocusBehavior();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TABFOCUSBEHAVIOR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_touchDoubleTapDistance(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.touchDoubleTapDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // touchDoubleTapDistance()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->touchDoubleTapDistance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_useHoverEffects(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.useHoverEffects";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useHoverEffects()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->useHoverEffects();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_useRtlExtensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.useRtlExtensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // useRtlExtensions()const
            bool cppResult = const_cast<const ::QStyleHints *>(cppSelf)->useRtlExtensions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleHintsFunc_wheelScrollLines(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStyleHints.wheelScrollLines";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wheelScrollLines()const
            int cppResult = const_cast<const ::QStyleHints *>(cppSelf)->wheelScrollLines();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QStyleHints_PropertyStrings[] = {
    "cursorFlashTime:",
    "fontSmoothingGamma:",
    "keyboardAutoRepeatRate:",
    "keyboardInputInterval:",
    "mouseDoubleClickDistance:",
    "mouseDoubleClickInterval:",
    "mousePressAndHoldInterval:",
    "mouseQuickSelectionThreshold::",
    "passwordMaskCharacter:",
    "passwordMaskDelay:",
    "setFocusOnTouchRelease:",
    "showIsFullScreen:",
    "showIsMaximized:",
    "showShortcutsInContextMenus::",
    "singleClickActivation:",
    "startDragDistance:",
    "startDragTime:",
    "startDragVelocity:",
    "tabFocusBehavior:",
    "touchDoubleTapDistance:",
    "useHoverEffects::",
    "useRtlExtensions:",
    "wheelScrollLines:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleHints_methods[] = {
    {"cursorFlashTime", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_cursorFlashTime), METH_NOARGS},
    {"fontSmoothingGamma", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_fontSmoothingGamma), METH_NOARGS},
    {"keyboardAutoRepeatRate", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_keyboardAutoRepeatRate), METH_NOARGS},
    {"keyboardInputInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_keyboardInputInterval), METH_NOARGS},
    {"mouseDoubleClickDistance", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_mouseDoubleClickDistance), METH_NOARGS},
    {"mouseDoubleClickInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_mouseDoubleClickInterval), METH_NOARGS},
    {"mousePressAndHoldInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_mousePressAndHoldInterval), METH_NOARGS},
    {"mouseQuickSelectionThreshold", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_mouseQuickSelectionThreshold), METH_NOARGS},
    {"passwordMaskCharacter", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_passwordMaskCharacter), METH_NOARGS},
    {"passwordMaskDelay", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_passwordMaskDelay), METH_NOARGS},
    {"setCursorFlashTime", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setCursorFlashTime), METH_O},
    {"setFocusOnTouchRelease", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setFocusOnTouchRelease), METH_NOARGS},
    {"setKeyboardInputInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setKeyboardInputInterval), METH_O},
    {"setMouseDoubleClickInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setMouseDoubleClickInterval), METH_O},
    {"setMousePressAndHoldInterval", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setMousePressAndHoldInterval), METH_O},
    {"setMouseQuickSelectionThreshold", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setMouseQuickSelectionThreshold), METH_O},
    {"setShowShortcutsInContextMenus", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setShowShortcutsInContextMenus), METH_O},
    {"setStartDragDistance", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setStartDragDistance), METH_O},
    {"setStartDragTime", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setStartDragTime), METH_O},
    {"setTabFocusBehavior", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setTabFocusBehavior), METH_O},
    {"setUseHoverEffects", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setUseHoverEffects), METH_O},
    {"setWheelScrollLines", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_setWheelScrollLines), METH_O},
    {"showIsFullScreen", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_showIsFullScreen), METH_NOARGS},
    {"showIsMaximized", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_showIsMaximized), METH_NOARGS},
    {"showShortcutsInContextMenus", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_showShortcutsInContextMenus), METH_NOARGS},
    {"singleClickActivation", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_singleClickActivation), METH_NOARGS},
    {"startDragDistance", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_startDragDistance), METH_NOARGS},
    {"startDragTime", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_startDragTime), METH_NOARGS},
    {"startDragVelocity", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_startDragVelocity), METH_NOARGS},
    {"tabFocusBehavior", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_tabFocusBehavior), METH_NOARGS},
    {"touchDoubleTapDistance", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_touchDoubleTapDistance), METH_NOARGS},
    {"useHoverEffects", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_useHoverEffects), METH_NOARGS},
    {"useRtlExtensions", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_useRtlExtensions), METH_NOARGS},
    {"wheelScrollLines", reinterpret_cast<PyCFunction>(Sbk_QStyleHintsFunc_wheelScrollLines), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QStyleHints_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QStyleHints *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStyleHintsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QStyleHints_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleHints_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleHints_Type = nullptr;
static SbkObjectType *Sbk_QStyleHints_TypeF(void)
{
    return _Sbk_QStyleHints_Type;
}

static PyType_Slot Sbk_QStyleHints_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QStyleHints_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleHints_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleHints_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleHints_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleHints_spec = {
    "2:PySide2.QtGui.QStyleHints",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleHints_slots
};

} //extern "C"

static void *Sbk_QStyleHints_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QStyleHints *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleHints_PythonToCpp_QStyleHints_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleHints_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleHints_PythonToCpp_QStyleHints_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleHints_TypeF())))
        return QStyleHints_PythonToCpp_QStyleHints_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleHints_PTR_CppToPython_QStyleHints(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QStyleHints *>(const_cast<void *>(cppIn)), Sbk_QStyleHints_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleHints_SignatureStrings[] = {
    "PySide2.QtGui.QStyleHints.cursorFlashTime(self)->int",
    "PySide2.QtGui.QStyleHints.fontSmoothingGamma(self)->qreal",
    "PySide2.QtGui.QStyleHints.keyboardAutoRepeatRate(self)->int",
    "PySide2.QtGui.QStyleHints.keyboardInputInterval(self)->int",
    "PySide2.QtGui.QStyleHints.mouseDoubleClickDistance(self)->int",
    "PySide2.QtGui.QStyleHints.mouseDoubleClickInterval(self)->int",
    "PySide2.QtGui.QStyleHints.mousePressAndHoldInterval(self)->int",
    "PySide2.QtGui.QStyleHints.mouseQuickSelectionThreshold(self)->int",
    "PySide2.QtGui.QStyleHints.passwordMaskCharacter(self)->QChar",
    "PySide2.QtGui.QStyleHints.passwordMaskDelay(self)->int",
    "PySide2.QtGui.QStyleHints.setCursorFlashTime(self,cursorFlashTime:int)",
    "PySide2.QtGui.QStyleHints.setFocusOnTouchRelease(self)->bool",
    "PySide2.QtGui.QStyleHints.setKeyboardInputInterval(self,keyboardInputInterval:int)",
    "PySide2.QtGui.QStyleHints.setMouseDoubleClickInterval(self,mouseDoubleClickInterval:int)",
    "PySide2.QtGui.QStyleHints.setMousePressAndHoldInterval(self,mousePressAndHoldInterval:int)",
    "PySide2.QtGui.QStyleHints.setMouseQuickSelectionThreshold(self,threshold:int)",
    "PySide2.QtGui.QStyleHints.setShowShortcutsInContextMenus(self,showShortcutsInContextMenus:bool)",
    "PySide2.QtGui.QStyleHints.setStartDragDistance(self,startDragDistance:int)",
    "PySide2.QtGui.QStyleHints.setStartDragTime(self,startDragTime:int)",
    "PySide2.QtGui.QStyleHints.setTabFocusBehavior(self,tabFocusBehavior:PySide2.QtCore.Qt.TabFocusBehavior)",
    "PySide2.QtGui.QStyleHints.setUseHoverEffects(self,useHoverEffects:bool)",
    "PySide2.QtGui.QStyleHints.setWheelScrollLines(self,scrollLines:int)",
    "PySide2.QtGui.QStyleHints.showIsFullScreen(self)->bool",
    "PySide2.QtGui.QStyleHints.showIsMaximized(self)->bool",
    "PySide2.QtGui.QStyleHints.showShortcutsInContextMenus(self)->bool",
    "PySide2.QtGui.QStyleHints.singleClickActivation(self)->bool",
    "PySide2.QtGui.QStyleHints.startDragDistance(self)->int",
    "PySide2.QtGui.QStyleHints.startDragTime(self)->int",
    "PySide2.QtGui.QStyleHints.startDragVelocity(self)->int",
    "PySide2.QtGui.QStyleHints.tabFocusBehavior(self)->PySide2.QtCore.Qt.TabFocusBehavior",
    "PySide2.QtGui.QStyleHints.touchDoubleTapDistance(self)->int",
    "PySide2.QtGui.QStyleHints.useHoverEffects(self)->bool",
    "PySide2.QtGui.QStyleHints.useRtlExtensions(self)->bool",
    "PySide2.QtGui.QStyleHints.wheelScrollLines(self)->int",
    nullptr}; // Sentinel

void init_QStyleHints(PyObject *module)
{
    _Sbk_QStyleHints_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleHints",
        "QStyleHints*",
        &Sbk_QStyleHints_spec,
        &Shiboken::callCppDestructor< ::QStyleHints >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHints_Type);
    InitSignatureStrings(pyType, QStyleHints_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHints_Type), Sbk_QStyleHints_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSTYLEHINTS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleHints_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleHints_TypeF(),
        QStyleHints_PythonToCpp_QStyleHints_PTR,
        is_QStyleHints_PythonToCpp_QStyleHints_PTR_Convertible,
        QStyleHints_PTR_CppToPython_QStyleHints);

    Shiboken::Conversions::registerConverterName(converter, "QStyleHints");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHints*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHints&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleHints).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleHintsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QStyleHints_TypeF(), &Sbk_QStyleHints_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QStyleHints_TypeF(), &::QStyleHints::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QStyleHints_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QStyleHints_TypeF(), &::QStyleHints::staticMetaObject, sizeof(QStyleHintsWrapper));
}
