/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSTANDARDITEMWRAPPER_H
#define SBK_QSTANDARDITEMWRAPPER_H

#define protected public

#include <QtGui/qstandarditemmodel.h>


// Extra includes
#include <QtGui/qicon.h>
#include <qsize.h>
#include <QtGui/qfont.h>
#include <QtGui/qbrush.h>
#include <QtGui/qstandarditemmodel.h>
#include <qabstractitemmodel.h>
#include <QList>
#include <qdatastream.h>
class QStandardItemWrapper : public QStandardItem
{
public:
    QStandardItemWrapper();
    QStandardItemWrapper(const ::QIcon & icon, const ::QString & text);
    QStandardItemWrapper(const QStandardItem& self) : QStandardItem(self)
    {
    }

    QStandardItemWrapper(const ::QString & text);
    QStandardItemWrapper(int rows, int columns = 1);
    ::QStandardItem * clone() const override;
    ::QVariant data(int role = Qt::UserRole + 1) const override;
    void read(::QDataStream & in) override;
    void setData(const ::QVariant & value, int role = Qt::UserRole + 1) override;
    int type() const override;
    void write(::QDataStream & out) const override;
    ~QStandardItemWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[6];
};

#endif // SBK_QSTANDARDITEMWRAPPER_H

