/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpointingdeviceuniqueid_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qevent.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPointingDeviceUniqueId_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPointingDeviceUniqueId >()))
        return -1;

    ::QPointingDeviceUniqueId *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPointingDeviceUniqueId.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPointingDeviceUniqueId", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPointingDeviceUniqueId::QPointingDeviceUniqueId()
    // 1: QPointingDeviceUniqueId::QPointingDeviceUniqueId(QPointingDeviceUniqueId)
    if (numArgs == 0) {
        overloadId = 0; // QPointingDeviceUniqueId()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPointingDeviceUniqueId(QPointingDeviceUniqueId)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointingDeviceUniqueId_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPointingDeviceUniqueId()
        {

            if (!PyErr_Occurred()) {
                // QPointingDeviceUniqueId()
                cptr = new ::QPointingDeviceUniqueId();
            }
            break;
        }
        case 1: // QPointingDeviceUniqueId(const QPointingDeviceUniqueId & QPointingDeviceUniqueId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointingDeviceUniqueId cppArg0_local;
            ::QPointingDeviceUniqueId *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPointingDeviceUniqueId(QPointingDeviceUniqueId)
                cptr = new ::QPointingDeviceUniqueId(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPointingDeviceUniqueId >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPointingDeviceUniqueId_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPointingDeviceUniqueId_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPointingDeviceUniqueIdFunc_fromNumericId(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPointingDeviceUniqueId.fromNumericId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QPointingDeviceUniqueId::fromNumericId(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // fromNumericId(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPointingDeviceUniqueIdFunc_fromNumericId_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromNumericId(qint64)
            QPointingDeviceUniqueId cppResult = ::QPointingDeviceUniqueId::fromNumericId(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPointingDeviceUniqueIdFunc_fromNumericId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPointingDeviceUniqueIdFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPointingDeviceUniqueId *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPointingDeviceUniqueId.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QPointingDeviceUniqueId *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointingDeviceUniqueIdFunc_numericId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPointingDeviceUniqueId *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPointingDeviceUniqueId.numericId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numericId()const
            qint64 cppResult = const_cast<const ::QPointingDeviceUniqueId *>(cppSelf)->numericId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPointingDeviceUniqueId___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPointingDeviceUniqueId *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPointingDeviceUniqueId_PropertyStrings[] = {
    "numericId:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPointingDeviceUniqueId_methods[] = {
    {"fromNumericId", reinterpret_cast<PyCFunction>(Sbk_QPointingDeviceUniqueIdFunc_fromNumericId), METH_O|METH_STATIC},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QPointingDeviceUniqueIdFunc_isValid), METH_NOARGS},
    {"numericId", reinterpret_cast<PyCFunction>(Sbk_QPointingDeviceUniqueIdFunc_numericId), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPointingDeviceUniqueId___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QPointingDeviceUniqueId_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPointingDeviceUniqueId *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), (pyArg)))) {
                // operator!=(QPointingDeviceUniqueId rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPointingDeviceUniqueId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]), (pyArg)))) {
                // operator==(QPointingDeviceUniqueId rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPointingDeviceUniqueId cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPointingDeviceUniqueId_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPointingDeviceUniqueId_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPointingDeviceUniqueId_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPointingDeviceUniqueId_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPointingDeviceUniqueId_Type = nullptr;
static SbkObjectType *Sbk_QPointingDeviceUniqueId_TypeF(void)
{
    return _Sbk_QPointingDeviceUniqueId_Type;
}

static PyType_Slot Sbk_QPointingDeviceUniqueId_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPointingDeviceUniqueId_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPointingDeviceUniqueId_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPointingDeviceUniqueId_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPointingDeviceUniqueId_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPointingDeviceUniqueId_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPointingDeviceUniqueId_spec = {
    "2:PySide2.QtGui.QPointingDeviceUniqueId",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPointingDeviceUniqueId_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPointingDeviceUniqueId_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPointingDeviceUniqueId_TypeF())))
        return QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPointingDeviceUniqueId_PTR_CppToPython_QPointingDeviceUniqueId(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPointingDeviceUniqueId *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPointingDeviceUniqueId_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPointingDeviceUniqueId_COPY_CppToPython_QPointingDeviceUniqueId(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPointingDeviceUniqueId_TypeF(), new ::QPointingDeviceUniqueId(*reinterpret_cast<const ::QPointingDeviceUniqueId *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPointingDeviceUniqueId *>(cppOut) = *reinterpret_cast< ::QPointingDeviceUniqueId *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPointingDeviceUniqueId_TypeF())))
        return QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPointingDeviceUniqueId_SignatureStrings[] = {
    "1:PySide2.QtGui.QPointingDeviceUniqueId(self)",
    "0:PySide2.QtGui.QPointingDeviceUniqueId(self,QPointingDeviceUniqueId:PySide2.QtGui.QPointingDeviceUniqueId)",
    "PySide2.QtGui.QPointingDeviceUniqueId.fromNumericId(id:qint64)->PySide2.QtGui.QPointingDeviceUniqueId",
    "PySide2.QtGui.QPointingDeviceUniqueId.isValid(self)->bool",
    "PySide2.QtGui.QPointingDeviceUniqueId.numericId(self)->qint64",
    "PySide2.QtGui.QPointingDeviceUniqueId.__copy__()",
    nullptr}; // Sentinel

void init_QPointingDeviceUniqueId(PyObject *module)
{
    _Sbk_QPointingDeviceUniqueId_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPointingDeviceUniqueId",
        "QPointingDeviceUniqueId",
        &Sbk_QPointingDeviceUniqueId_spec,
        &Shiboken::callCppDestructor< ::QPointingDeviceUniqueId >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPointingDeviceUniqueId_Type);
    InitSignatureStrings(pyType, QPointingDeviceUniqueId_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPointingDeviceUniqueId_Type), Sbk_QPointingDeviceUniqueId_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPOINTINGDEVICEUNIQUEID_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPointingDeviceUniqueId_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPointingDeviceUniqueId_TypeF(),
        QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_PTR,
        is_QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_PTR_Convertible,
        QPointingDeviceUniqueId_PTR_CppToPython_QPointingDeviceUniqueId,
        QPointingDeviceUniqueId_COPY_CppToPython_QPointingDeviceUniqueId);

    Shiboken::Conversions::registerConverterName(converter, "QPointingDeviceUniqueId");
    Shiboken::Conversions::registerConverterName(converter, "QPointingDeviceUniqueId*");
    Shiboken::Conversions::registerConverterName(converter, "QPointingDeviceUniqueId&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPointingDeviceUniqueId).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_COPY,
        is_QPointingDeviceUniqueId_PythonToCpp_QPointingDeviceUniqueId_COPY_Convertible);

    qRegisterMetaType< ::QPointingDeviceUniqueId >("QPointingDeviceUniqueId");
}
